/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: drvs_io_sio.h
* File Mark:  	
* Description:  sio define.
* Others:  	
* Version:  1.4.9
* Author:   wangxia
* Date:      2010-04-2
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/
#include  "drvs_io_keys.h"
#ifndef    _DRVS_SIO_H_
#define    _DRVS_SIO_H_

/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/


/*************************************************************************
  *                                  Macro                                                                                  *
  *************************************************************************/

/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/

typedef struct _T_ZDrvSio_DataConfig
{
	UINT32	baudrate;				
	UINT32 flowControl;
	UINT8  dataBits;
	UINT8  stopBits;
	UINT8  parity;
	UINT8  workMode;
}T_ZDrvSio_DataConfig;


typedef enum
{
	ZDRV_DEV_UART_FCTL_OFF,
	ZDRV_DEV_UART_FCTL_SW,
	ZDRV_DEV_UART_FCTL_HW
}T_ZDrvSio_UartFlowCtrl_Types;

typedef enum
{
	ZDRV_DEV_UART_PARITY_EVEN,
	ZDRV_DEV_UART_PARITY_ODD,
	ZDRV_DEV_UART_PARITY_NULL
}T_ZDrvSio_UartParity_Types; 

typedef enum
{
	ZDRV_DEV_UART_MODE_CPU,
	ZDRV_DEV_UART_MODE_DMA,
	ZDRV_DEV_UART_MODE_NULL
}T_ZDrvSio_UartWorkMode_Types;

/*sio ioctl command*/
typedef enum
{
	IOCTL_SIO_SET_DATA, 				/*set data config command,set baudrate.param:T_ZDrvSio_DataConfig*/
	IOCTL_SIO_SET_BUFFER,			 /*set data buffer command,param:T_ZDrvSio_SetConfig */
	IOCTL_SIO_CLEAN_BLOCK,			/*clean the sio block read*/
	IOCTL_SIO_CALLBACK, 				/*set sio non block callback function.param:T_ZDrvSio_Read_CallBack*/
		  
	IOCTL_SIO_CMD_MAX
} T_ZDrvSio_IOCTL; /*sio ioctl command*/



typedef struct _T_ZDrvUsbSio_SetConfig
{
	
	UINT8					 endpoint;
	UINT32					txBufferSize;
	UINT32					rxBufferSize;
	BOOL					block;
	UINT32					  blocktime;

}T_ZDrvUsbSio_SetConfig; /*usbsio use to config the param*/

typedef struct _T_ZDrvSio_SetConfig
{
	
	UINT8					 endpoint;
	UINT32					txBufferSize;
	UINT32					rxBufferSize;
	BOOL					block;
	UINT32					  blocktime;
	T_ZDrvSio_DataConfig	dataconfig;
}T_ZDrvSio_SetConfig; /*usbsio use to config the param*/


typedef struct _T_Sio_Dev_Hw
{
    VOID * regs;
    T_ZDrvSio_DataConfig settings;
    VOID * upLayerSet;

}
T_Sio_Dev_Hw;


typedef struct _T_Sio_HalOpt
{
    SINT32 (*open)(UINT32 portNum,T_ZDrvSio_DataConfig * portConfig);
    SINT32 (*read)(UINT32 portNum, UINT8* pBuf, UINT32 len);
    SINT32 (*write)(UINT32 portNum, UINT8* pBuf, UINT32 len);
    SINT32 (*close)(UINT32 portNum);
    SINT32 (*ctrl)(UINT32 portNum,T_DRVIO_CTRL_KEY function, VOID* arg);
}
T_Sio_HalOpt;

/**************************************************************************
 *                           Global  Variable                                                                             *
 **************************************************************************/

/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
SINT32  zDrvSio_Install(UINT32 portNum, CHAR* name, T_Sio_HalOpt * pDevHalOpt);


#endif/*_DRVS_SIO_H_ */



