/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_iokeys.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2014-02-11
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_VOICE_H
#define _DRVS_IO_VOICE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define ZDRV_DEV_VOICE   "voice"  /*The device name of voice driver.*/
#define ZDRV_DEV_VOLTE   "volte"  /*The device name of voice driver.*/

/****************************************************************************
* 	                                        Types
****************************************************************************/
/*	Voice input channel selection. */
typedef enum
{
	CODEC_INPUT_MICPHONE	=0, 					/*input path in earphone mic*/
	CODEC_INPUT_HEADSET,							   /*input path in headset*/
	CODEC_INPUT_BLUETOOTH,							 /*input path in bluetooth*/
	CODEC_INPUT_HANDSFREE,							 /*input path in mic(handsfree)*/
	
	MAX_CODEC_INPUT_PATH			   
} T_ZDrv_CodecInputPath;

/*	Voice output channel selection. */
typedef enum
{
	CODEC_OUTPUT_RECEIVER	 =0,				/*output path in receiver*/
	CODEC_OUTPUT_SPEAKER,						  /*output path in speaker*/
	CODEC_OUTPUT_HEADSET,						  /*output path in headset*/
	CODEC_OUTPUT_BLUETOOTH, 					/*output path in bluetooth*/
	CODEC_OUTPUT_HSANDSPK,					   /*output path in both headset and speaker*/
	
	
	MAX_CODEC_OUTPUT_PATH			   
}T_ZDrv_CodecOutputPath;

#define T_ZDrv_AudioInputPath  T_ZDrv_CodecInputPath
#define T_ZDrv_VoiceInputPath  T_ZDrv_CodecInputPath
#define T_ZDrv_AudioOutputPath T_ZDrv_CodecOutputPath
#define T_ZDrv_VoiceOutputPath T_ZDrv_CodecOutputPath


typedef struct
{
	UINT16	uiStartX;
	UINT16	uiStartY;
	UINT16	uiWidth;
	UINT16	uiHeight;
} T_ZDrv_Rect;

/* Record data format. */
typedef enum
{
	 RECORD_DATA_FORMAT_AMR  = 0,
	 RECORD_DATA_FORMAT_FR,
	 RECORD_DATA_FORMAT_HR,
	 RECORD_DATA_FORMAT_EFR,
	 
	 MAX_RECORD_DATA_FORMAT
} T_ZDrvRcd_DataFormat;

/*add on the platform of 7502 for record the different of channel online voice*/
/* channel selection for voice record function */
typedef enum	 
{
	VOICE_RECORD_UPLINK = 0,
	VOICE_RECORD_DOWNLINK,
	VOICE_RECORD_UPLINK_AND_DOWNLINK,
	MAX_VOICE_RECORD_CHANNEL 
} T_ZDrvVoice_RecordChannel;

typedef struct
{
	 T_ZDrvRcd_DataFormat	dataformat;
	 UINT32 bufsize;
	 T_ZDrvVoice_RecordChannel channel;   /*add on the platform of 7502 for record the different of channel online voice*/
} T_ZDrvRcd_InfoParam;

/*  Voice input channel volum level selection.*/
typedef enum{
    VOICE_INPUT_VOL_LEVEL_0 = 0,
    VOICE_INPUT_VOL_LEVEL_1    ,
    VOICE_INPUT_VOL_LEVEL_2    ,
    VOICE_INPUT_VOL_LEVEL_3    ,
    VOICE_INPUT_VOL_LEVEL_4    ,
    VOICE_INPUT_VOL_LEVEL_5    ,

    MAX_VOICE_INPUT_VOL_LEVEL     
} T_ZDrvVoice_InputVolLevel;

/*  Audio output channel volum level selection.*/
typedef enum{
    VOICE_OUTPUT_VOL_LEVEL_0 = 0,
    VOICE_OUTPUT_VOL_LEVEL_1    ,
    VOICE_OUTPUT_VOL_LEVEL_2    ,
    VOICE_OUTPUT_VOL_LEVEL_3    ,
    VOICE_OUTPUT_VOL_LEVEL_4    ,
    VOICE_OUTPUT_VOL_LEVEL_5    ,
    VOICE_OUTPUT_VOL_LEVEL_6    ,
    VOICE_OUTPUT_VOL_LEVEL_7    ,
    VOICE_OUTPUT_VOL_LEVEL_8    ,
    VOICE_OUTPUT_VOL_LEVEL_9    ,
    VOICE_OUTPUT_VOL_LEVEL_10   ,
    VOICE_OUTPUT_VOL_LEVEL_11   ,

    MAX_VOICE_OUTPUT_VOL_LEVEL     
} T_ZDrvVoice_OutputVolLevel;

/* voice sample rate selection. */
typedef enum
{
    VOICE_SAMPLE_8K    =0,  /* voice sample rate 8K. */
    VOICE_SAMPLE_16K     ,  /* voice sample rate 16K. */

    MAX_VOICE_SAMPLE               
} T_ZDrvVoice_Sample;

/* voice codec format, which is not the codec of PCM format */
typedef enum
{
     VOICE_DATA_FORMAT_AMR  = 0,
     VOICE_DATA_FORMAT_FR,
     VOICE_DATA_FORMAT_HR,
     VOICE_DATA_FORMAT_EFR,
     MAX_VOICE_DATA_FORMAT
} T_ZDrvVoice_DataFormat;
/* channel selection for voice mute function */
typedef enum
{
    VOICE_UPLINK = 0,
    VOICE_DOWNLINK,
    VOICE_UPLINK_AND_DOWNLINK,
    MAX_VOICE_MUTE_CHANNEL 
} T_ZDrvVoice_MuteChannel;

/* voice mute switch */
typedef enum
{
    VOICE_MUTE_DISABLE = 0,
    VOICE_MUTE_ENABLE,
    MAX_VOICE_MUTE_SWITCH 
} T_ZDrvVoice_mute_Switch;

/* voice mute control information */
typedef struct
{
    T_ZDrvVoice_mute_Switch enable;  
    T_ZDrvVoice_MuteChannel channel;    /* input & output function */
} T_ZDrvVoice_MuteInfo;

/* voice switch */
typedef enum
{
    VOICE_DISABLE = 0,
    VOICE_ENABLE,
    MAX_VOICE_SWITCH 
} T_ZDrvVoice_Switch;

/* voice buffer information */
typedef struct
{
    VOID   *pBuf;         /* voice buffer */
    UINT32 bufferSize;    /* voice buffer size */
}T_ZDrvVoice_BufInfo;

/* The frame type of AMR */
typedef enum {
    VOICE_FRAME_MR475 = 0,
    VOICE_FRAME_MR515,
    VOICE_FRAME_MR59,
    VOICE_FRAME_MR67,
    VOICE_FRAME_MR74,
    VOICE_FRAME_MR795,
    VOICE_FRAME_MR102,
    VOICE_FRAME_MR122,

    MAX_VOICE_FRAME_TYPE 
}T_ZDrvVoice_FrameType;

/* The frame formate of AMR */
typedef enum {
    VOICE_AMR_IF2,
    VOICE_AMR_IF1,

    MAX_VOICE_AMR_IF
}T_ZDrvVoice_AmrIf;

/* The frame formate of AMR information*/
typedef struct 
{
    T_ZDrvVoice_FrameType frametype;   /* The frame type of AMR */
    T_ZDrvVoice_AmrIf amrif;           /* The frame formate of AMR */
}T_ZDrvVoice_AmrInfo, *T_ZDrvVoice_AmrInfoPtr;

/* Audio channel */
typedef enum
{
    AUDIO_MONO_CHANNEL,
    AUDIO_DUAL_CHANNEL
}T_ZDrvAudio_Channel;
#endif/*_DRVS_IO_VOICE_H*/

