/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
*
* File Name: 	drvs_dpram_td.h
* File Mark:
* Description:  dpram interface declaration.
* Others:
* Version:  v1.0
* Author:   yan junhua
* Date:      2007-10-19
* History 1:
*     Date:       2007-12-26
*     Version:  1.1v
*     Author:    yan junhua
*     Modification:  modify macro defines  according to IC's modification
*                           different address define for different project
*                           change parameter in macros sucn as IsSet_H2UINTSTAL from bit number to bitmap
*
*
* History 2:
*     Date:       2008-05-07
*     Version:  1.2v
*     Author:    yan junhua
*     Modification:  remove macro defines
*                           return base address by functions
*
* History 3:
*     Date:       2010-04-26
*     Version:  1.4.9
*     Author:    wangxia
*     Modification:  add function for HSPUA in CHIP ZX2963
**********************************************************************/
#ifndef	_DRVS_DPRAM_TD_H
#define	_DRVS_DPRAM_TD_H


/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/

#include "drvs_dpram.h"
/*************************************************************************
  *                                  Macro                                                                                  *
  *************************************************************************/

 /**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/

/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/

/*******************************************************************************
* Function: zDrvTDpram_GetTdSfn
* Description: get td sfn from dpram
* Parameters:
*   Input:
*       
*   Output:td sfn
*
* Returns:
*   
*   
*
*
* Others:
********************************************************************************/
UINT32 zDrvTDpram_GetTdSfn(void);

#if 0
/* error code define */
typedef enum
{
    DPRAM_RET_SUCCESS                             = 0,        /* successed */
    DPRAM_RET_ERROR                                = 1,        /* error occured */
    DPRAM_RET_ERR_INVALID_PARAM  = 2,        /* the input parameter is invalid */
    DPRAM_RET_ERR_NO_MEMORY         = 3,        /* no enough memory in dpram to store data of the required length */
    DPRAM_RET_ERR_NO_DATA                 = 4,        /* no data in ring */
    DPRAM_RET_ERR_NOT_INITIALIZED = 5,        /* not initialized yet */

    MAX_DPRAM_ERR_CODE
} T_ZDrvDpram_RetCode;

typedef enum
{
#if (((defined ( _CHIP_ZX297502)||defined ( _CHIP_ZX2975)||defined ( _CHIP_ZX2960_02B)) && defined (_USE_DPRAM_ADDR_NEWSW))||defined ( _CHIP_ZX2804))
	DPRAM_DATA_UL_PHY,
	DPRAM_DATA_HSUPA,
	DPRAM_DATA_BCH,
	DPRAM_DATA_DL_PHY,
	DPRAM_DATA_HSDPA,
	DPRAM_DATA_EAGCH,
#else
    DPRAM_DATA_UL_PHY,
    DPRAM_DATA_BCH,
    DPRAM_DATA_DL_PHY,
    DPRAM_DATA_HSDPA,

#endif

    MAX_DPRAM_DATA_ID
} T_ZDrvDpram_DataId;

/* will be invoked when command has been received
  uiCmdId: command id
  pData: command data
  uiLen: length of command data. unit: byte
  */
typedef UINT32 (*ZDRV_DPRAM_CMD_RECVFUNC)( UINT16 uiCmdId, VOID *pData, UINT16 uiLen );
typedef VOID (*ZDRV_DPRAM_ISR_CALLBACK)( VOID );    //for TD-DPRAM

typedef struct
{
    ZDRV_DPRAM_CMD_RECVFUNC      fCmdRecv;
} T_ZDrvDpram_CallbackFuncs;

typedef enum
{
    DPRAM_MSG_CFNSFN = 0xFF,
    DPRAM_MSG_EXCEPT = 0xFE,

    MAX_DPRAM_OTHER_MSG
} T_ZDrvDpram_OtherMsg;

typedef struct
{
    UINT32  uiCfn;
    UINT32  uiSfn;
} T_ZDrvDpram_CfnSfn;

typedef struct
{
    UINT32  uiMemBaseAddr;      /* base address of dpram memory */
    UINT32  uiRegBaseAddr;        /* base address of doram register */
    UINT32  uiMemSize;                /* memroy size of dpram */
    BOOL     bBigEndian;               /* big-endian if true, else little-endian */
} T_ZDrvDpram_Info;



typedef enum
{
    ARMTOZSP_INT1 =0, /*in order to let sleep time tell zsp ,е0bit÷֪ͨϵͳ˯ʱ */
    ARMTOZSP_INT2 =1, /*е1bit÷֪ͨϵͳ˯ʱ,ЭջϢsendcmd mailboxжϻzsp*/
    ARMTOZSP_INT3 = 2,/*used in HSUPA*/
    ARMTOZSP_INT4 = 3, //ps wakeup phy
    MAX_ARMTOZSPINT   = 100

}T_ZDrvIcp_IntType;
#ifdef _USE_PSM

#define DPRAM_BASE_ADDR                               0x19800
#define DPRAM_TDL1SLEEP_FLAG                        (DPRAM_BASE_ADDR + 0x63CE)
#define DPRAM_TDL1SLEEP_FC_ADDR                     (DPRAM_BASE_ADDR + 0x63D0)
#define DPRAM_TDL1SLEEP_CC_ADDR                     (DPRAM_BASE_ADDR + 0x63D2)
#define DPRAM_TDL1SLEEP_LEN_ADDR                    (DPRAM_BASE_ADDR + 0x63D4)
#define DPRAM_TDL1SLEEP_FC1_ADDR                    (DPRAM_BASE_ADDR + 0x63D6)
#define DPRAM_TDL1SLEEP_CC1_ADDR                    (DPRAM_BASE_ADDR + 0x63D8)
#define DPRAM_DRX_ADDR                              (DPRAM_BASE_ADDR + 0x63DA)
#define DPRAM_TDSLEEP_FORCE_GSM_WAKEUP_ADRR         (DPRAM_BASE_ADDR + 0x63DC)
#define DPRAM_TD_CAMPON_ADDR                        (DPRAM_BASE_ADDR + 0x63DE)
#define DPRAM_L1G_WAKEUPOK_FLAG_ADDR                (DPRAM_BASE_ADDR + 0x63E0)
#define DPRAM_L1T_QUEUE_FLAG_ADDR	                (DPRAM_BASE_ADDR + 0x63E2)
#define DPRAM_ZSP_CHANGE_FREQ_FLAG_ADDR             (DPRAM_BASE_ADDR + 0x63E8)
#define DPRAM_ZSP_TDT1_FLAG_ADDR                    (DPRAM_BASE_ADDR + 0x63EA)
#endif
/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
/**************************************************************************
* Functin: zDrvDpram_Init
* Description: This function is used to initialize dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others:
*       None.
**************************************************************************/
SINT32 zDrvDpram_Init( VOID );

/**************************************************************************
* Functin: zDrvDpram_RegISRCallback
* Description: This function is used to get the isr function. It just be used by TD Ret
* Parameters:
*       (IN)
*               fISRCallback: isr function pointer.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: failed.
* Others:
*       None.
**************************************************************************/
UINT32 zDrvDpram_RegISRCallback( ZDRV_DPRAM_ISR_CALLBACK fISRCallback );   //for TD-DPRAM

/**************************************************************************
* Functin: zDrvDpram_Exit
* Description: This function is used to uninitialize dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others:
*       None.
**************************************************************************/
SINT32 zDrvDpram_Exit( VOID );


/**************************************************************************
* Functin: zDrvTDpram_RegCallback
* Description: This function is used to register the interrupt callback function.
* Parameters:
*       (IN)
*               ptCallbackStruct: callback functions struct pointer.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: failed.
* Others:
*       None.
**************************************************************************/
UINT32 zDrvTDpram_RegCallback( T_ZDrvDpram_CallbackFuncs *ptCallbackStruct );


/**************************************************************************
* Functin: zDrvDpram_SendCmd
* Description: This function is used to send command.
* Parameters:
*       (IN)
*               uiCmdId: cmd id.
*               pData: cmd data pointer
*               uiLen: cmd data length. uint: byte. must be multiples of 4. maybe 0 for null command
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no enough space to send this command.
* Others:
*       None.
**************************************************************************/
UINT32  zDrvDpram_SendCmd( UINT16 uiCmdId, VOID *pData, UINT16 uiLen );


/**************************************************************************
* Functin: zDrvDpram_GetFreeData
* Description: This function is used to get the free block.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
*               puiBlockLen: pointer to store length of databuf in block. uint: byte
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no free data space.
* Others:
*       None.
**************************************************************************/
UINT32 zDrvDpram_GetFreeData ( UINT8 uiDataId, VOID **ppBlockAddr, UINT16 *puiBlockLen );


/**************************************************************************
* Functin: zDrvDpram_SendData
* Description: This function is used to send data.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*               ppBlockAddr: base address of databuf in block.
*               uiDataLen: data length. uint: byte
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no enough space to send this data.
* Others:
*       None.
**************************************************************************/
UINT32 zDrvDpram_SendData( UINT8 uiDataId, VOID *ppBlockAddr, UINT16 uiDataLen );


/**************************************************************************
* Functin: zDrvDpram_DataExist
* Description: This function is used to check if there is data.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*       (OUT)
*               None.
* Returns:
*               TRUE: have data; FALSE: no data.
* Others:
*       None.
**************************************************************************/
#if  0
#ifdef _USE_EVB2963
BOOL zDrvDpram_DataExist( UINT8 uiDataId );
#else
BOOL zDrvDpram_DataExist( VOID );
#endif
#endif


BOOL zDrvDpram_DataExist( UINT8 uiDataId );  /*zyj,20110330*/

/**************************************************************************
* Functin: zDrvDpram_GetData
* Description: This function is used to get data.
* Parameters:
*       (IN)
*               puiDataId: pointer to stord data id. T_ZDrvDpram_DataId.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
*               puiRealLen: pointer to store data length. uint: byte
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_DATA: no data.
* Others:
*       None.
**************************************************************************/
#if (((defined ( _CHIP_ZX297502)||defined ( _CHIP_ZX2975)||defined ( _CHIP_ZX2960_02B)) && defined (_USE_DPRAM_ADDR_NEWSW))||defined ( _CHIP_ZX2804))
UINT32 zDrvDpram_GetData( UINT8 uiDataId, VOID **ppBlockAddr, UINT16 *puiRealLen );
#else
UINT32 zDrvDpram_GetData( UINT8 *puiDataId, VOID **ppBlockAddr, UINT16 *puiRealLen );
#endif

/**************************************************************************
* Functin: zDrvDpram_FreeData
* Description: This function is used to free the data block.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*               pBlockAddr: base address of databuf in block.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
UINT32 zDrvDpram_FreeData( UINT8 uiDataId, VOID *pBlockAddr );


/**************************************************************************
* Functin: zDrvTDpram_GetInfo
* Description: This function is used to get the dpram information, such as base address.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               ptInfo: information pointer.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
UINT32 zDrvTDpram_GetInfo( T_ZDrvDpram_Info *ptInfo );



#if ((defined ( _CHIP_ZX297502)||defined ( _CHIP_ZX2975)||defined ( _CHIP_ZX2960_02B)||defined ( _CHIP_ZX2804)) && defined (_USE_DPRAM_ADDR_NEWSW))
/**************************************************************************
* Functin: zDrvTDpram_GetUPHValue
* Description: This function is used to get the UPH value in Dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       UINT16: 2 bytes UPH Value.
* Others:
*       None.
**************************************************************************/
UINT16 zDrvTDpram_GetUPHValue( VOID );


/**************************************************************************
* Functin: zDrvTDpram_GetSNPLValue
* Description: This function is used to get the SNPL value in Dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       UINT16: 2 bytes SNPL Value.
* Others:
*       None.
**************************************************************************/
UINT16 zDrvTDpram_GetSNPLValue( VOID );
#endif
/**************************************************************************
* Functin: zDrvDpram_IntGen
* Description: This function is used to send mailbox int to zsp
* Parameters:
*       (IN)
*               inttype
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
SINT32 zDrvDpram_IntGen(T_ZDrvIcp_IntType  inttype);

#ifdef _USE_PSM
/**************************************************************************
* Functin: zDrvDpram_GetDRXFlag
* Description: This function is used to get drx flag
* Parameters:
*       (IN)
*               pFlag :
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/

SINT32  zDrvDpram_GetDRXFlag (UINT16  *pFlag);
/**************************************************************************
* Functin: zDrvDpram_ClearDRXFlag
* Description: This function is used to clear drx flag
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/

SINT32  zDrvDpram_ClearDRXFlag (VOID );


/**************************************************************************
* Functin: zDrvDpram_WakeUpUphy
* Description: This function is used to wakeup phy for ps
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern VOID zDrvDpram_WakeUpUphy(VOID);//psphy

#endif


/**************************************************************************
* Functin: zDrvDpram_L1tqueueFlag
* Description: жzspǷΪУзmaibloxzspֱdpramΪ0xa
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/


VOID zDrvDpram_L1tqueueFlag(VOID); /*ж2963 l1tϢǷϢ*/
/**************************************************************************
* Functin: zDrvDpram_ClerrL1tqueueFlag
* Description: This function is used to clear drx flag
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/


VOID zDrvDpram_ClearL1tqueueFlag(VOID); /*l1tϢǷб־λ*/

#endif

#endif	/* _DRVSDPRAM_H */

