/*******************************************************************************
* Copyright (C) 2007, ZTE Corporation.
*
* File Name:    drvs_edcp.h
* File Mark:    
* Description:  
* Others:        
* Version:       0.5
* Author:        yangjupei
* Date:          2013-8-25
* History 1:      
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
********************************************************************************/
#ifndef _DRVS_EDCP_H
#define _DRVS_EDCP_H

/*************************************************************************
*                                  Include files                         *
*************************************************************************/
#include "drvs_general.h"

/*************************************************************************
*                                  Macro                                 *
*************************************************************************/

#define     Z_W_MAX_UL_EDCP_PDU_NUM           (WORD)2
#define     Z_W_MAX_UL_EDCP_CFG_NUM           (WORD)256           /*EDCP1ÿPDUӦ̬ĸ*/
#define     Z_W_MAX_DL_EDCP_CFG_NUM           (WORD)512           /*EDCP2жӦ̬ĸ*/
#define     Z_W_MAX_PDCP_EDCP_CFG_NUM         (WORD)512           /*EDCP3жӦ̬ĸ*/
#define     Z_W_MAX_EDCP_CK_NUM               (WORD)16
#define     Z_EDCP_CK_LEN                     (WORD)16

/*EDCP INT type*/
#define EDCP_INT_UL_ASYN           	(UINT32)0x1
#define EDCP_INT_EMAC             	(UINT32)0x2
#define EDCP_INT_DL                	(UINT32)0x4

/*ܷʽ걣㷨*/
#define 	EDCP_NOCIPHER			(WORD)0		   /**/
#define     EDCP_SNOW3G             (WORD)1        /*SNOW3G*/
#define     EDCP_AES                (WORD)2        /*AES*/
#define     EDCP_ZUC                (WORD)3        /*ZUC*/
#define     EDCP_KASUMI             (WORD)4        /*KSAUMI*/

/**************************************************************************
*                                  Types                                  *
**************************************************************************/

typedef struct T_ZDrvEdcp_StaticConfigInfo
{ 
    UINT8	  CtrlPaneCk[16];    /*EDPCP_CK_IĴ4*4bytes*/
    UINT8	  UserPaneCk[16];    /*EDPCP_CK_CĴ4*4bytes*/
    UINT8	  Ik[16];		     /*EDPCP_IK_IĴ4*4bytes*/
    UINT8     Direct;            /*01*/
    UINT8     CipherType;	     /*ָʾ:   0ܣ1 snow3g 2 aes 3 zuc*/
    UINT8     IntegType;         /*ָʾ: 0걣1 snow3g 2 aes 3 zuc*/ 
}  T_ZDrvEdcp_StaticConfigInfo; 


typedef struct T_ZDrvEdcp_ULDynamicCtrlInfo
{ 
    UINT8      CPInd;                 /*ָʾ:   0 ܣ1 */
    UINT8      IPInd;                 /*ָʾ: 0 걣1 걣*/ 
    UINT8      DataSourceType;        /*Դ  0 û棬1 */ 
    UINT8      BearerId;              /*ܲ*/
    UINT8      *pDataSrc;       	  /*Դַ*/
    UINT16     DateLen;               /*Դ*/
    UINT16     CompHeaderLen;         /*ѹͷ*/
    UINT8      *pDataCompHeaderSrc;   /*ѹͷַ*/  
    UINT8      *pDataDest;            /*Ŀַ*/     
    UINT32     Count;                 /*ܲ*/
} T_ZDrvEdcp_ULDynamicCtrlInfo;


/*EMAC ͬRAM*/
typedef struct T_ZDrvEdcp_BusCopyCtrlInfo
{ 
    UINT8   *pDataSrc;
    UINT16  DataLen;
    UINT8   *pDataDest;
} T_ZDrvEdcp_BusCopyCtrlInfo;

/*дRAM*/
typedef struct T_ZDrvEdcp_DLDynamicCtrlInfo
{ 
    UINT8      CPInd;              /*ָʾ:   0 ܣ1 */
    UINT8      IPInd;              /*ָʾ: 0 걣1 걣*/ 
    UINT8      DataSourceType;     /*Դ  0 û棬1 */   
    UINT8      *pDataSrc;          /*Դַ*/
    UINT16     DateLen;            /*Դ*/    
    UINT8      *pDataDest;         /*Ŀַ*/
    UINT8      BearerId;           /*ܲ*/
    UINT32     Count;    		   /*ܲ*/
    UINT16     DecipherLen;        /*ܳȲ*/
    UINT8      SegmentNum;         /*ֶ*/
} T_ZDrvEdcp_DLDynamicCtrlInfo;

/*UMTS 첽RAM*/
typedef struct T_ZDrvEdcp_ULDynamicCtrlInfo_umts
{ 
    UINT8                               bUea;//CPInd;          /*Ƿ bit0*/        
    UINT8                               *pDataSrc;   	/*Դַ*/
    UINT16                              wDataLen;       /*Դ bitλ bit15-0*/
    UINT8                               bSegNum;        /*ֶθ bit15-8*/
    UINT8                               BearerId;       /*ܲ bit20-16*/
    UINT8                               CkIndex;        /*ѡԿ bit7-4*/
    UINT32                              Count;          /*ܲ*/
} T_ZDrvEdcp_ULDynamicCtrlInfo_umts;


/*UMTS 첽RAM*/
typedef struct T_ZDrvEdcp_DLDynamicCtrlInfo_umts
{ 
    UINT8                               bUea;//CPInd;    /*Ƿ bit0*/  
    UINT8                               *pDataSrc;	   /*Դַ*/
    UINT16                              wDataLen;      /*Դ bitλ bit15-0*/
    UINT8                               bDataOffset;   /*ѡԿ bit10-8*/
    UINT8                               *pDataDes;     /*Ŀַ*/
    UINT8                               BearerId;      /*ܲ bit20-16*/
    UINT8                               CkIndex;       /*ѡԿ bit7-4*/
    UINT32                              Count;         /*ܲ*/
} T_ZDrvEdcp_DLDynamicCtrlInfo_umts;

/*UMTS ԿRAM*/
typedef struct T_ZDrvEdcp_KeyIndexInfo_umts
{ 
    UINT32    CK0;              /*Կ*/
    UINT32    CK1;              
    UINT32    CK2;             
    UINT32    CK3;            
} T_ZDrvEdcp_KeyIndexInfo_umts;


typedef VOID (*ZDRV_EDCP_CMD_RECVFUNC)(UINT32 intType);

typedef struct
{
    ZDRV_EDCP_CMD_RECVFUNC      fCmdRecv;
} T_ZDrvEdcp_CallbackFuncs;

typedef VOID (*ZDRV_PDCP_EDCP_ISR_CALLBACK)( VOID );

typedef struct
{
    ZDRV_PDCP_EDCP_ISR_CALLBACK      fCmdRecv;
} T_ZDrvEdcp_CallbackFuncs_ForW;

typedef struct
{
UINT32 DataSourceType:
    1; //ݿ
UINT32 IPInd:
    1; //Ա
UINT32 CPInd:
    1; //Ƿ
UINT32 Reserve0:
    1;    
UINT32 MultiSegFlag:
    1;  
UINT32 Reserve1:
    11;       
UINT32 Total_DateLen:
     14;
UINT32 Reserve2:
    2;
}
Edcp_Conf;//lte

//define Uplink/ downlink lte control structure
typedef struct
{
UINT32 DataLen:
    14;
UINT32 Reserve0:
    2;
UINT32 Bearer:
    5;
UINT32 Reserve1:
    11;    
}
Edcp_Length_Bearer;//lte

//define Uplink/ downlink control structure
typedef struct
{
    Edcp_Conf conf;
    UINT32 datain_addr;
    Edcp_Length_Bearer length_bearer;
    UINT32 dataout_addr;
    UINT32 count;
}
T_ZDrvEdcp_Ctrl_Index;


/*==============================================================================
ԭT_zDrvEdcp_UlCfg
˵: EDCP ULò
==============================================================================*/
typedef struct { 
    UINT8                               bUea;//CPInd;
    UINT8                               *pDataSrc;
    UINT16                              wDataLen; 
    UINT8                               bSegNum;
    UINT8                               BearerId;
    UINT8                               CkIndex;
    UINT32                              Count;
}T_zDrvEdcp_UlDynamicCtrlInfo; 


typedef struct {
    UINT16                              wCfgNum;
    UINT16                              wTotalLen;
    UINT8                               *pDataDes;
    UINT16                              wTruncatedDataLen;
    UINT8                               *pTruncatedDataSrc;
    UINT8                               *pTruncatedDataDes;
    T_zDrvEdcp_UlDynamicCtrlInfo        tUlDynamicCtrlInfo[Z_W_MAX_UL_EDCP_CFG_NUM];
}T_zDrvEdcp_PduCfg;


typedef struct {
    T_zDrvEdcp_PduCfg                   tPduCfg[Z_W_MAX_UL_EDCP_PDU_NUM];
}T_zDrvEdcp_UlCfg;


/*==============================================================================
ԭT_zDrvEdcp_DlCfg
˵: EDCP DLò
==============================================================================*/
typedef struct {
    UINT8                               bUea;        //CPInd;//7510 UMTS֧UEA1һּܷʽCPIndΪ1ʱĬΪUEA1ܡ
    UINT8                               *pDataSrc;
    UINT16                              wDataLen; 
    UINT8                               bDataOffset;
    UINT8                               *pDataDes;
    UINT8                               BearerId;
    UINT8                               CkIndex;
    UINT32                              Count;
}T_zDrvEdcp_DlDynamicCtrlInfo; 


typedef struct {
    UINT16                              wCfgNum;
    T_zDrvEdcp_DlDynamicCtrlInfo        tDlDynamicCtrlInfo[Z_W_MAX_DL_EDCP_CFG_NUM];
}T_zDrvEdcp_DlCfg;

/*==============================================================================
T_zDrvEdcp_PdcpCfg
˵: PDCP EDCPò
==============================================================================*/
typedef struct{
    UINT8                               *pDataSrc;
    UINT8                               *pDataDes;
    UINT16                              wDataLen;
}T_zDrvEdcp_PdcpDynamicCtrlInfo; 

typedef struct{ 
    UINT16                              wCfgNum;
    T_zDrvEdcp_PdcpDynamicCtrlInfo      tPdcpDynamicCtrlInfo[Z_W_MAX_PDCP_EDCP_CFG_NUM];
}T_zDrvEdcp_PdcpCfg;

/*==============================================================================
ԭT_zDrvEdcp_StaticCfgInfo
˵: static EDCPò
==============================================================================*/
typedef struct{
//    UINT8                               Uea;
    UINT8                               CK[Z_W_MAX_EDCP_CK_NUM][Z_EDCP_CK_LEN];
}T_zDrvEdcp_StaticCfgInfo;

/* error code define */
typedef enum
{
    EDCP_RET_SUCCESS		    = 0,        /* successed */
    EDCP_RET_BUSY 				= 1,        /* busy */
    EDCP_RET_ERR_INVALID_PARAM	= 2,        /* the input parameter is invalid */
    
    MAX_EDCP_ERR_CODE
} T_ZDrvEdcp_RetCode;

typedef enum
{
	EDCP_UL_MODULE,
	EDCP_DL_MODULE,
	EDCP_EMAC_MODULE
}T_ZDrvEdcp_ModuleSel;

//define Uplink syn ctrl index structure
typedef struct
{
    UINT32 datain_addr;
    UINT32 length_valid;
    UINT32 dataout_addr;
}
T_ZDrvEdcp_Emac_Index;

/**************************************************************************
*                           Function Prototypes                                                                        *
**************************************************************************/
/*******************************************************************************
* Function: zDrvEDCP_Initiate
* Description: initialize edcp module and globle Variables
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEDCP_Initiate(VOID);

/*******************************************************************************
* Function: zDrvEdcp_StartHWOp
* Description: start lte EDCP hardware
* Parameters: 
*	 Input:   
*	 HWSource  0: UL_ASYN
*			   1: DL
*			   2: UL_SYN
*	 EnableInt	 1:enable interrupt
*				 0:disable interrupt
*
*	 Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
SINT32 zDrvEdcp_StartHWOp(UINT8 HWSource, UINT8 EnableInt);

/*******************************************************************************
* Function: zDrvEdcp_InitULStaticPara
* Description: configure static parameters for up link 
* Parameters: 
*   Input:
*           StaticConfigInfo  :CK_I,CK_C,IK,direct
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
VOID zDrvEdcp_InitULStaticPara(T_ZDrvEdcp_StaticConfigInfo StaticConfigInfo);

/*******************************************************************************
* Function: zDrvEdcp_WriteULIndexRam
* Description: configure index for up link
* Parameters: 
*   Input:
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
SINT32 zDrvEdcp_WriteULIndexRam(T_ZDrvEdcp_ULDynamicCtrlInfo                           ULDynamicCtrlInfo);


/*******************************************************************************
* Function: zDrvEdcp_WriteEmacIndexRam
* Description: configure EMAC index for EMAC channel
* Parameters: 
*   Input:
*           BusCopyCtrlInfo:data source's address,data length,data des'address
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
SINT32 zDrvEdcp_WriteEmacIndexRam(T_ZDrvEdcp_Emac_Index *BusCopyCtrlInfo, WORD dwNum);

/*******************************************************************************
* Function: zDrvEdcp_InitDLStaticPara
* Description: configure static parameters for down link 
* Parameters: 
*   Input: StaticConfigInfo  :CK_I,CK_C,IK,direct
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
VOID zDrvEdcp_InitDLStaticPara(T_ZDrvEdcp_StaticConfigInfo StaticConfigInfo);

/*******************************************************************************
* Function: zDrvEdcp_WriteDLIndexRam
* Description: configure index for down link
* Parameters: 
*   Input:
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
SINT32 zDrvEdcp_WriteDLIndexRam(T_ZDrvEdcp_Ctrl_Index *DLDynamicCtrlInfo, DWORD dwNum);

/*******************************************************************************
* Function: zDrvEdcp_RegCallback
* Description: enable EDCP interrupt,register EDCP ISR callback function
* Parameters: 
*   Input:
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
SINT32 zDrvEdcp_RegCallback( T_ZDrvEdcp_CallbackFuncs *ptCallbackStruct );

/*******************************************************************************
* Function: zDrvEdcp_UnRegCallback
* Description: disable EDCP interrupt,release callback thread's source
* Parameters: 
*   Input:
*
*   Output:
*
* Returns: 
*
*
* Others: 
********************************************************************************/
VOID zDrvEdcp_UnRegCallback(VOID);

/*******************************************************************************
* Function: zDrvEdcp_GetFreeDlIndexRamNum
* Description: Get Free Dl Index Ram Num
* Parameters:
*   Input:
*
*   Output: the remain Num
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_GetFreeDlIndexRamNum(VOID);

/*******************************************************************************
* Function: zDrvEdcp_IsBusy
* Description: judge edcp hardware busy or idle
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT8 zDrvEdcp_IsBusy(T_ZDrvEdcp_ModuleSel EdcpNum);

/*******************************************************************************
* Function: zDrvEdcp_Reset
* Description: Reset Edcp
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_Reset( VOID);

/*******************************************************************************
* Function: zDrvEdcp_CleanEmacIndexCount
* Description: 
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_ClrUlSynEmacIndexCnt(VOID);

/*******************************************************************************
* Function: zDrvEdcp_UpDateEmacIndex
* Description: 
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_UpDateEmacIndexRam(UINT8 IndexNo,T_ZDrvEdcp_BusCopyCtrlInfo BusCopyCtrlInfo);

/*******************************************************************************
* Function: zDrvEdcp_EmacTotalIndex
* Description: 
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT8 zDrvEdcp_EmacTotalIndex(VOID);

/*******************************************************************************
*For Wcdma
*
********************************************************************************/
/*******************************************************************************
* Function: zDrvEdcp_CKCfgForW
* Description: EDCPԿ
* Parameters:
*   Input:T_zDrvEdcp_StaticCfgInfo
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_CKCfgForW(T_zDrvEdcp_StaticCfgInfo  *ptCK,T_ZDrvEdcp_ModuleSel EdcpNum);

/*******************************************************************************
* Function: zDrvEdcp_IsBusyForW
* Description: 
* Parameters:
*   Input:EdcpNum
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT8 zDrvEdcp_IsBusyForW(UINT8 EdcpNum);

/*******************************************************************************
* Function: zDrvEdcp_ResetForW
* Description: Reset Edcp for W
* Parameters:
*   Input:EdcpNum
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
VOID zDrvEdcp_ResetForW(T_ZDrvEdcp_ModuleSel EdcpNum);

/*******************************************************************************
* Function: zDrvEdcp_UlCfgForW
* Description: ģò
* Parameters:
*   Input:T_zDrvEdcp_UlCfg
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_UlCfgForW(T_zDrvEdcp_UlCfg *ptUlCfg);

/*******************************************************************************
* Function: zDrvEdcp_DlCfgForW
* Description: ģò
* Parameters:
*   Input:T_zDrvEdcp_DlCfg
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_DlCfgForW(T_zDrvEdcp_DlCfg *ptDlCfg);

/*******************************************************************************
* Function: zDrvEdcp_PdcpCfgForW
* Description: edcppdcp sduģò
* Parameters:
*   Input:T_zDrvEdcp_PdcpCfg
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_PdcpCfgForW(T_zDrvEdcp_PdcpCfg *ptPdcpCfg);

/*******************************************************************************
* Function: zDrvEdcp_RegCallback_ForW
* Description: register edcp isr callback function for wcdma
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_RegCallback_ForW(T_ZDrvEdcp_CallbackFuncs_ForW *ptCallbackStruct);

/*******************************************************************************
* Function: zDrvEdcp_UlCfgNormForW
* Description: Normal UL data
* Parameters:
*   Input:
*
*   Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
UINT32 zDrvEdcp_UlCfgNormForW(T_zDrvEdcp_UlCfg *ptUlCfg);

#ifdef _USE_PSM
/*******************************************************************************
* Function: zDrvEdcp_SaveConfiguration
* Description: ʡģϵǰֳ
* Parameters:
*	 Input:
*
*	 Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_SaveConfiguration(VOID);

/*******************************************************************************
* Function: zDrvEdcp_RestoreConfiguration
* Description: ʡģָʱֳָ
* Parameters:
*	 Input:
*
*	 Output: 
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvEdcp_RestoreConfiguration(VOID);
#endif

#endif/*_DRVS_EDCP_H*/

