/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.5
 * Author:        Zhenghong
 * Date:          2008-01-10
 * History 1:
 *     Date:      2012-07-16
 *     Version:   V1.0
 *     Author:    zhouqi
 *     Modification:    1.  T_ZDrvI2c_BusFreq ö 300KHZ 
                        2. ޸ T_ZDrvI2c_DevFlagType еһ I2C_DFLT_ADDR_DEV Ϊ I2C_10BIT_SLAVE_ADDR
                        3.  T_ZDrvI2c_DevFlagType   I2C_USE_INT 
                        4. Ӳע˵
 * History 2:
 ******************************************************************************/
#ifndef _DRVS_I2C_H
#define _DRVS_I2C_H



/**********************************************************/
/** @defgroup T_ZDrvI2c_BusNum 7520 3 I2Cӿ, 7520V2 ȥһI2C
  */
typedef enum
{
    //I2C_BUS_0 = 0,
    I2C_BUS_1 = 1,
    I2C_BUS_2 = 2,      /* pmic i2c */
    MAX_I2C_BUS_NUM
}T_ZDrvI2c_BusNum;


/**********************************************************/
/** @defgroup T_ZDrvI2c_BusFreq
  */
typedef enum{
    I2C_FREQ_ONE_HUNDRED_KILO_HZ    = 100*1000,
    I2C_FREQ_THREE_HUNDRED_KILO_HZ  = 300*1000,
    I2C_FREQ_FOUR_HUNDRED_KILO_HZ   = 400*1000,
    MAX_I2C_BUS_FREQ
}T_ZDrvI2c_BusFreq;


/**********************************************************/
/** @defgroup T_ZDrvI2c_DevFlagType
  */
typedef enum {
        I2C_10BIT_SLAVE_ADDR       = 0x0001 << 0,   /* ʶʹ --10λӻַ--      */
                                                    /* Ĭϲʹλ 7λӻַ       */

        I2C_MEM_DEV                = 0x0001 << 1,   /*  ʶʹ --16λĴַ--   */
        I2C_REG_DEV                = 0x0001 << 2,   /*  ʶʹ --8λĴַ--    */

        I2C_NACK_LAST_BYTE         = 0x0001 << 3,   /* NACK last byte read from slave   */
        I2C_NOP_LAST_BYTE          = 0x0001 << 4,   /* Let slave release SDA after last */
        I2C_M_COMBINE              = 0x0001 << 5,   /* ϶ģʽ */
        I2C_STOP_START_BEFORE_READ = 0x0001 << 6,   /* During a read transaction, gen.  */
                                                    /* a STOP & START after writing     */
                                                    /* the slave addr(just before read) */
        I2C_CLK_START_BEFORE_RW    = 0x0001 << 7,   /* Generate a clock and a START     */
                                                    /* before every I/O operation.      */
        I2C_USE_INT                = 0x0001 << 8    /* ʹжģʽ            */
                                                    /* Ϊ START 󣬻ȡź̹߳*/
                                                    /* ڴͶֽʱʹ           */
} T_ZDrvI2c_DevFlagType;

/**********************************************************************/
/*  ˵:

    1. Ĭ£ʹ  7λ ӻַ
                           8λ Ĵַ
                           ׼ʱ д 򵥶 ϶ģʽ--
                           ʹж

    2. ǰõ  ²ڲʹãǰõҲøģĬΪ --׼϶ʱ--
       ʱ֪

                           I2C_NACK_LAST_BYTE           U207ûзʹ
                           I2C_NOP_LAST_BYTE            U207ûзʹ
                           I2C_M_COMBINE                RDA5802\mt9d113ʹ
                           I2C_STOP_START_BEFORE_READ   PMIC\OV7670\0V9656ʹ
                           I2C_CLK_START_BEFORE_RW      U207ûзʹ

    3. ڿɸһ:

        static T_ZDrvI2c_Device s_mt9d113I2cDev =
        {
            I2C_BUS_0,
            EXAMPLE_SLAVE_ADDRESS,
            I2C_FREQ_THREE_HUNDRED_KILO_HZ,
            100,
            1,
     -----------------------------------------------------------
            I2C_10BIT_SLAVE_ADDR | I2C_REG_DEV | I2C_USE_INT,
          //  ʹ10ӻַ       8λĴַ  ʹжϷʽ

            I2C_MEM_DEV,
          // 16λĴַ, 8ӻַ ʹж
        ----------------------------------------------------------
            NULL,
        };
*********************************************************************/
/**********************************************************/
/** @defgroup T_ZDrvI2c_Device
  */
typedef struct _T_ZDrvI2c_Device
{

    T_ZDrvI2c_BusNum        bus_num;        /* indicate which i2c bus the device belongs to */
    UINT16                  slv_addr;       /* device addr on the i2c bus, 10bits for memory device and 7bits for registers */
    T_ZDrvI2c_BusFreq       bus_freq;       /* the i2c bus transfer freq according to the device require*/
    UINT32                  timeout;        /* time threshold waiting for bus idle */
    UINT8                   retries;        /* times we'll try again if the bus is busy */
    T_ZDrvI2c_DevFlagType   flags;          /* indicate the operation features */

    VOID                    *privData;
}T_ZDrvI2c_Device;


/*******************************************************************************
*                           Function Prototypes                                *
*******************************************************************************/


/*******************************************************************************
 * Function:    zDrvI2c_DevRead
 * Description: I2C߼򵥶
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C ϶ Э顣
            2. һζȡ --32-- ֽݡ
 ********************************************************************************/
SINT32 zDrvI2c_DevRead( T_ZDrvI2c_Device *i2c_dev, UINT16 regAddr, UINT8 *readBuf, UINT32 readNum );



/*******************************************************************************
 * Function:    zDrvI2c_DevWrite
 * Description: I2C߼д
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C д Э顣
            2. һд --30-- ֽݡ
 ********************************************************************************/
SINT32 zDrvI2c_DevWrite( T_ZDrvI2c_Device *i2c_dev, UINT16 regAddr, UINT8 *writeBuf, UINT32 writeNum );



/*******************************************************************************
 * Function:    zDrvI2c_DevLock_BeforePSM
 * Description: ڹжϲ PSM ӿǰȡ I2C 豸
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. жϲ PSM ӿʱI2C ڱ߳ʹá
 * 			   ʹô˽ӿڵȴ߳ʹϺ˳
 ********************************************************************************/
SINT32 zDrvI2c_DevLock_BeforePSM( T_ZDrvI2c_BusNum busNum);



/*******************************************************************************
 * Function:    zDrvI2c_DevUnlock_AfterPSM
 * Description: ʹ PSM ӿʱͷ I2C 豸
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. zDrvI2c_DevLock_BeforePSMʹá
 ********************************************************************************/
SINT32 zDrvI2c_DevUnlock_AfterPSM( T_ZDrvI2c_BusNum busNum);



/*******************************************************************************
 * Function:    zDrvI2c_DevRead
 * Description: I2C߼򵥶ʹʡģʽ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C ϶ Э顣
            2. һζȡ --32-- ֽݡ
            3. Ҫڲ --ȡ-- ̲߳ͬʱ
 ********************************************************************************/
SINT32 zDrvI2c_DevRead_PSM( T_ZDrvI2c_Device *i2c_dev, UINT16 regAddr, UINT8 *readBuf, UINT32 readNum );




/*******************************************************************************
 * Function:    zDrvI2c_DevWrite
 * Description: I2C߼дʹʡģʽ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C д Э顣
            2. һд --30-- ֽݡ
            3. Ҫڲ --ȡ-- ̲߳ͬʱ
 ********************************************************************************/
SINT32 zDrvI2c_DevWrite_PSM( T_ZDrvI2c_Device *i2c_dev, UINT16 regAddr, UINT8 *writeBuf, UINT32 writeNum );



/*******************************************************************************
 * Function:    zDrvI2c_DevRead_ByteStream
 * Description: I2Cֽ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C 򵥶 Э顣
            2. ֻд I2C ַ----------ʹüĴַ-----
            2. һζȡ 32 ֽݡ
 ********************************************************************************/
SINT32 zDrvI2c_DevRead_ByteStream( T_ZDrvI2c_Device *i2c_dev, UINT8 *readBuf, UINT32 readNum );




/*******************************************************************************
 * Function:    zDrvI2c_DevWrite_ByteStream
 * Description: I2Cֽд
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  1. ѭI2C д Э顣
            2. ֻд I2C ַ----------ʹüĴַ-----
            2. һд 30 ֽݡ
 ********************************************************************************/
SINT32 zDrvI2c_DevWrite_ByteStream( T_ZDrvI2c_Device *i2c_dev, UINT8 *writeBuf, UINT32 writeNum );





#endif /* _DRVS_I2C_H */


