/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:	drvs_led.h
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2014-07-07
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_LED_H
#define _DRVS_LED_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/

/****************************************************************************
* 	                                        Macros
****************************************************************************/
/*  */
#define SN3216_REG_MODE_CONFIG  0x00 /* D7=SSD, D6:D5=MODE, D4=AE */
#define SN3216_REG_OUT_STATUS1  0x01 /* out16:out9 led on/off, default all on */
#define SN3216_REG_OUT_STATUS2  0x02 /* out8:out1 led on/off, default all off */

#define SN3216_REG_CURRENT      0x03 /* D7=CM, D6:D4=CS, D3=AGCE, D2:D0=AGS */
#define SN3216_REG_GPIO_CONFIG  0x04 /*  */
#define SN3216_REG_GPIO_DIRECT  0x05 /*  */
#define SN3216_REG_GPIO_VALUE   0x06 /*  */

#define SN3216_REG_OUT16_PWM     0x10 /* out16~out1 pwm level 10h~1fh */

#define SN3216_REG_UPDATE_PWM   0xB0 /* update pwm regs */

/*00h*/
#define SN3216_REG_MODE_CONFIG_AE_LSH       (4)
#define SN3216_REG_MODE_CONFIG_MODE_LSH     (5)
#define SN3216_REG_MODE_CONFIG_SSD_LSH      (7)

/*03h*/
#define SN3216_REG_CURRENT_CS_LSH           (4)


#define SN3216_BITFVAL(var, lsh)   ( (var) << (lsh) )
#define SN3216_BITFMASK(wid, lsh)  ( ((1U << (wid)) - 1) << (lsh) )
#define SN3216_BITFEXT(var, wid, lsh)   ((var & SN3216_BITFMASK(wid, lsh)) >> (lsh))
/****************************************************************************
* 	                                        Types
****************************************************************************/
#if 1
typedef enum sn3216_channel {
    SN3216_LED1 =0x0,
    SN3216_LED2,
    SN3216_LED3,
    SN3216_LED4,
    SN3216_LED5,
    SN3216_LED6,
    SN3216_LED7,
    SN3216_LED8,

    SN3216_LED9,
    SN3216_LED10,
    SN3216_LED11,
    SN3216_LED12,
    SN3216_LED13,
    SN3216_LED14,
    SN3216_LED15,
    SN3216_LED16,

    SN3216_LED_MAX
}sn3216_channel;
#else

typedef enum sn3216_channel {

    SN3216_LED16 = 0x0,
    SN3216_LED15,
    SN3216_LED14,
    SN3216_LED13,
    SN3216_LED12,
    SN3216_LED11,
    SN3216_LED10,
    SN3216_LED9,

    SN3216_LED8,
    SN3216_LED7,
    SN3216_LED6,
    SN3216_LED5,
    SN3216_LED4,
    SN3216_LED3,
    SN3216_LED2,
    SN3216_LED1,

    SN3216_LED_MAX
}sn3216_channel;
#endif
typedef enum sn3216_current {
    SN3216_CURRENT_20 =0x0,
    SN3216_CURRENT_15,
    SN3216_CURRENT_10,
    SN3216_CURRENT_5,
    SN3216_CURRENT_40,
    SN3216_CURRENT_35,
    SN3216_CURRENT_30,
    SN3216_CURRENT_25,

    SN3216_CURRENT_MAX
}sn3216_current;

typedef enum sn3216_status {
	SN3216_LED_STATUS_OFF  = 0x0,
	SN3216_LED_STATUS_ON   = 0x1,

	SN3216_LED_STATUS_MAX,
}sn3216_status;

typedef enum sn3216_sleep {
	SN3216_SLEEP_OFF  = 0x0,
	SN3216_SLEEP_ON   = 0x1,
	SN3216_SLEEP_MAX,
}sn3216_sleep;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32 sn3216_I2cRead(UINT8 reg_addr, UINT8 *reg_val);
SINT32 sn3216_I2cRead(UINT8 reg_addr, UINT8 *reg_val);
SINT32 sn3216_GetRegister(UINT8 addr, UINT8* data);
SINT32 sn3216_SetRegister(UINT8 addr, UINT8 data, UINT8 mask);
SINT32 sn3216_SetStatus(sn3216_channel channel, sn3216_status status);
SINT32 sn3216_SetBlink(sn3216_channel channel,	UINT32 delay_on, UINT32 delay_off);
SINT32 sn3216_SetCurrent(sn3216_current sn_current);
SINT32 sn3216_SetPwm(sn3216_channel channel, UINT16 level);
SINT32 sn3216_SetSleep(sn3216_sleep sleep);
#endif/*_DRVS_LED_H*/

