/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	drvs_nand.h
* File Mark:  	
* Description:  tu hal interface declaration.
* Others:  	
* Version:  v1.0
* Author:   wangxia
* Date:      2008-08-28
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/

#ifndef    HAL_NAND_H
#define    HAL_NAND_H

#ifdef _OS_TOS
#include <cyg/fs/tos_yaffs_nand.h>
#endif
#include "drvs_io.h"
/*************************************************************************
  *                                  Include files                    *
  *************************************************************************/


/*************************************************************************
  *                                  Macro                               *
  *************************************************************************/
#define ZDRV_NAND_PART_NVRO "nvr"
#define ZDRV_NAND_PART_NVRW "nvrw"
#define ZDRV_NAND_PART_YAFFS "cpfs"
/**************************************************************************
 *                                  Types                                 *
 **************************************************************************/
typedef struct{
    UINT8 pbyManu;      /* id */
    UINT8 pbyDevice;    /* оƬid  */
    UINT8 pbyID3;       /* id */
    UINT8 pbyID4;       /* id */
    UINT8 pbyID5;       /* id */
}T_ZDrvNand_DeviceID;

typedef struct{
    UINT32 nvBase;      /* NVʼַ*/
    UINT32 nvSize;       /* NVС  */
}T_ZDrvNand_NVParam;

/**
 * NAND Flash part information
*/
typedef struct _T_Nand_Part_Info
{
		
	UINT32			PageSize;
	UINT32			PageSpareSize;
	UINT32			BlockSize;
	UINT32			PartOffset;
	UINT32			PartSize;
	UINT32			TotalSize;
	UINT8			*PartName;
	T_ZDrvIO_Handle pIoHnd;
}T_Nand_Part_Info;

typedef enum {
	
   ZFTL_PART_NVRO_NVRW=0,
   ZFTL_PART_NVFAC,
   ZFTL_PART_SMS,
   ZFTL_PART_SIMNV,
   ZFTL_PART_SIMNVFAC,
   ZFTL_PART_MAX
   	
} T_ZFTL_PART_NO;


/**************************************************************************
 *                           Global  Variable                           *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                        *
 **************************************************************************/
/**************************************************************************
* Function: zDrvNand_Initiate
* Description:initialize nand for hal_init.c
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_Initiate(VOID);

/**************************************************************************
* Function: zDrvNand_PartRead
* Description:read nand base partition.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PartRead(char* part_name,UINT32 offset,UINT32 size,UINT8* buffer);
/**************************************************************************
* Function: zDrvNand_PartGetSize
* Description:get nand partition size.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
UINT32 zDrvNand_PartGetSize(char* part_name);


/*******************************************************************************
 * Function:  zDrvNand_ReadBootflag
 * Description: read the bootflag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 0: open dl usb
 *          1: close dl usb
 *
 * Others: 0xffffffff_ffffffff: USB DL; 
 *         "ZTE7510\0"        : NO USB DL
 ********************************************************************************/
UINT32 zDrvNand_ReadBootflag( void );

/*******************************************************************************
 * Function:  zDrvNand_WriteBootflag
 * Description: write the bootflag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns:0 success
 *         1 fail
 *
 *
 * Others: 0xffffffff_ffffffff: USB DL; 
 *         "ZTE7510\0"        : NO USB DL
 ********************************************************************************/
UINT32 zDrvNand_WriteBootflag( UINT32 flag );

/*******************************************************************************
 * Function:  zDrvNand_ReadUsbtimeout
 * Description: read the usbtimeout flag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: flag:usb time out (1~10)
 *
 *
 * Others: 
 ********************************************************************************/
UINT32 zDrvNand_ReadUsbtimeout( void );

/*******************************************************************************
 * Function:  zDrvNand_WriteUsbtimeout
 * Description: write the usbtimeout flag of zx297510
 * Parameters: 
 *   Input:flag (1~10)
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
UINT32 zDrvNand_WriteUsbtimeout( UINT32 flag );


/**************************************************************************
* ƣ zDrvNand_GetNVParam
*  This function is used to get nv param 
             
* ˵ (IN)
                    none.
             (OUT)
                    nvParam:  nvʼַС.
                                
*   ֵ    0: ɹ
*               !=0: ʧ
                              
* ˵ none.
**************************************************************************/ 
extern SINT32 zDrvNand_GetNVParam(T_ZDrvNand_NVParam *nvParam); 

/**************************************************************************
* ƣ zDrvNand_ReadID
*  This function is used to identify the nand chip
             
* ˵ (IN)
                    none.
             (OUT)
                    pbyDevice:  id,оƬid,id,id.
                                
*   ֵ    0: ɹ
*               !=0: ʧ
                              
* ˵ none.
**************************************************************************/ 
extern SINT32 zDrvNand_ReadID(T_ZDrvNand_DeviceID *pbyDevice);

 
/**************************************************************************
* ƣ zDrvNand_Initialize
*  This function is used to initialize the nand chip
             
* ˵ (IN)
                    none.
             (OUT)
                    none.
                                
*   ֵ    none.
                              
* ˵ none.
***************************************************************************/ 
extern SINT32   zDrvNand_Initialize(void);
 
/**************************************************************************
* ƣ zDrvNand_Erase
*  This function is used to erase the nand blocks spcified by
             dwStart and dwEnd.

* ˵ (IN)
                    dwStart: start address to erase
                    dwEnd:   end address to erase
                        ַΧ( NAND_BASE ~ NAND_BASE + BYTES_IN_NAND )
             (OUT)
                    none.
                                
*   ֵ    0: ɹ
*               !=0: ʧ
                              
* ˵  ùܽ͸ʽʱʹá
              дʱд. 
              ʱdwStartdwEndĿ飨ÿ16K byteȫ
**************************************************************************/
extern SINT32 zDrvNand_Erase(UINT32 dwStart, UINT32 dwEnd);

extern SINT32 zDrvNand_Program_1(T_ZFTL_PART_NO partNo, UINT32 offset, UINT32 len, UINT8* from);
extern SINT32 zDrvNand_Read_1(T_ZFTL_PART_NO partNo, UINT32 offset, UINT32 len, UINT8* to);

#ifdef _OS_TOS
/**************************************************************************
* Function: zDrvNand_PartOpen
* Description:get nand parameters for ecos fs.
* Parameters:
*   Input:    part_name:partition name
* Output:    pNandPartInfo:part information
* Returns:0: success
*             other: error
**************************************************************************/
SINT32 zDrvNand_PartOpen(UINT8* part_name, T_zYaffs_PartInfo *pNandPartInfo);

/*******************************************************************************
 * Function:  zDrvNand_PartReadMain
 * Description: yaffs read nand main 
 * Parameters: 
 *   Input:pNandPartInfo:yaffs information;
 *            dwAddr:start addr;
 *            dwLen:read length;
 *            pbyBuf:read buffer;
 *   Output:
 *
 * Returns: 0:success;
 *              others:fail
 *
 *
 * Others: 
 ********************************************************************************/

SINT32 zDrvNand_PartReadMain(T_zYaffs_PartInfo *pNandPartInfo, UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);

/**************************************************************************
* Function: zDrvNand_PartReadSpare
* Description: read data from flash
* Parameters:
*   Input:   pNandPartInfo:yaffs information;
*              dwAddr: address
*              dwLen: length to read
*   Output: None
* Returns:
*	        0: success
*             other: error
* Others: ϲzDrvNand_PartReadSpare()ĺ dwLen ȡĳȶΪ OOB
                                        dwAddr ȡַΪ ҳַ
 
**************************************************************************/
SINT32 zDrvNand_PartReadSpare(T_zYaffs_PartInfo *pNandPartInfo,UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);

/**************************************************************************
* Function: zDrvNand_PartWriteMain
* Description: write data to flash of main area
* Parameters:
*   Input:   pNandPartInfo:yaffs information;
*              dwAddr: address
*              dwLen: length to read
*              pMBuf:  buffer in which data is stored
*   Output: None
* Returns:
*	        0: success
*             other: error
* Others: ϲzDrvNand_PartWriteMain()ĺ dwLen дĳ1 page,
                                        dwAddr дַΪ ҳַ

**************************************************************************/
SINT32 zDrvNand_PartWriteMain(T_zYaffs_PartInfo *pNandPartInfo, UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);

/**************************************************************************
* Function: zDrvNand_PartWriteSpare
* Description: write data to flash of spare area
* Parameters:
*   Input:   pNandPartInfo:yaffs information;
*              dwAddr: address
*              dwLen: length to read
*              pbyBuf:  buffer in which data is stored
*   Output: None
* Returns:
*	        0: success
*             other: error
* Others: ϲzDrvNand_PartWriteSpare()ĺ dwLen дĳȶΪOOB
                                        dwAddr дַΪ ҳַ

**************************************************************************/
SINT32  zDrvNand_PartWriteSpare(T_zYaffs_PartInfo *pNandPartInfo, UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);

/**************************************************************************
* Function: zDrvNand_PartErase
* Description: erase a block
* Parameters:
*   Input:  pNandPartInfo:yaffs information;
*              dwAddr: address,block aliagn
*   Output: None
* Returns:
*	        0: success
*             other: error
* Others:
**************************************************************************/
SINT32 zDrvNand_PartErase(T_zYaffs_PartInfo *pNandPartInfo, UINT32	dwAddr);

/**************************************************************************
* Function: zDrvNand_PartCheckBadBlock
* Description:check badblock for ecos fs.
* Parameters:
*   Input: pNandPartInfo:part information
*             dwAddr:start addrress
* Output: None
* Returns:DRV_SUCCESS: good block
*             DRV_ERROR: bad block
**************************************************************************/

SINT32 zDrvNand_PartCheckBadBlock(T_zYaffs_PartInfo *pNandPartInfo,UINT32	dwAddr);

/**************************************************************************
* Function: zDrvNand_PartMarkBadBlock
* Description:mark badblock for ecos fs.
* Parameters:
*   Input: pNandPartInfo:part information
*             dwAddr:start addrress
* Output: None
* Returns:DRV_SUCCESS: mark bad success
*             DRV_ERROR: mark bad fail
**************************************************************************/

SINT32 zDrvNand_PartMarkBadBlock(T_zYaffs_PartInfo *pNandPartInfo,UINT32	dwAddr);
#endif

/**************************************************************************
* Function: zDrvNand_PartMtdOpen
* Description:get nand parameters for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PartMtdOpen(UINT8* part_name, T_Nand_Part_Info *pNandPartInfo);

/**************************************************************************
* Function: zDrvNand_PartMtdRead
* Description:read data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PartMtdRead(T_Nand_Part_Info *pNandPartInfo,UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);
/**************************************************************************
* Function: zDrvNand_PartMtdWrite
* Description:read data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PartMtdWrite(T_Nand_Part_Info *pNandPartInfo,UINT32	dwAddr, UINT32	dwLen, UINT8 *pbyBuf);
/**************************************************************************
* Function: zDrvNand_PartMtdErase
* Description:erase data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PartMtdErase(T_Nand_Part_Info *pNandPartInfo,UINT32 dwAddr);

/**************************************************************************
* Function: zDrvNand_NvRwEccMake
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: 
**************************************************************************/
SINT32 zDrvNand_NvRwEccMake(UINT32 dwStart, UINT32 dwLen);



#endif    /* HAL_NAND_H */

