/* ==========================================================================
** Copyright (C) 1999 - 2007 COMNEON GmbH.  All rights reserved.
** ==========================================================================
**
** ==========================================================================
**
** This document contains proprietary information belonging to COMNEON.
** Passing on and copying of this document, use and communication of its
** contents is not permitted without prior written authorisation.
**
** ==========================================================================
** Revision Information :
**    File name: sio_scc.h
**    Version:   /main/sio_main/66
**    Date:   2007-05-09    15:43:50
**
** ==========================================================================
** Project:              Mobile Station (MS)
** Block:                -
** Process:              -
**
** ==========================================================================
** Contents:    DTE-AT adapter to receive at commands from the DTE
**
** ==========================================================================
** History:
**
** Date       Author  Comment
** --------------------------------------------------------------------------
** 04.11.03   ges   Added ata_control.
** 13.05.03   wein  Added TCP/IP over serial mode.
** 19.03.03   wein  Removed USB from ata_op1.c.
** 23.01.03   hwe   Merge: Added ata_linestate().
** 02.10.02   hwe   Added WAP DS.
** 04.12.01   ges   added ata_set_pec_size().
** 06.11.01   ges   added ATA_OFFLINE_PTEST and ATA_OFFLINE_END_PTEST
**                  (production test modes).
** 26.07.01   rha   added ata_free_tx_buf().
** 13.09.99   ges   created.
**
** ==========================================================================
*/

#ifndef SIO_MUX_ATA_H
#define SIO_MUX_ATA_H

/*
** =========================================================================
**                              GLOBAL DEFINES
** =========================================================================
*/
/* mux dev define begin */
#define  ZDRV_DEV_SIO_MUX_1    "/mux/1"
#define  ZDRV_DEV_SIO_MUX_2    "/mux/2"
#define  ZDRV_DEV_SIO_MUX_3    "/mux/3"
#define  ZDRV_DEV_SIO_MUX_4    "/mux/4"
#define  ZDRV_DEV_SIO_MUX_5    "/mux/5"
#define  ZDRV_DEV_SIO_MUX_6    "/mux/6"
#define  ZDRV_DEV_SIO_MUX_7    "/mux/7"
#define  ZDRV_DEV_SIO_MUX_8    "/mux/8"
#define  ZDRV_DEV_SIO_MUX_9    "/mux/9"
#define  ZDRV_DEV_SIO_MUX_10   "/mux/10"
#define  ZDRV_DEV_SIO_MUX_11   "/mux/11"
#define  ZDRV_DEV_SIO_MUX_12   "/mux/12"
#define  ZDRV_DEV_SIO_MUX_13   "/mux/13"
#define  ZDRV_DEV_SIO_MUX_14   "/mux/14"
#define  ZDRV_DEV_SIO_MUX_15   "/mux/15"
/* mux dev define end */
#define  SIO_USE_SOCKET_CONCEPT  0
#define  SIO_FBUS_AVAILABLE      0
/*
** =========================================================================
**                              GLOBAL TYPES
** =========================================================================
*/


/*
** =========================================================================
**                              GLOBAL FUNCTIONS
** =========================================================================
*/
/****************************************************************************
* Type:         cmux_cmd_par_t
*----------------------------------------------------------------------------
* Purpose:      the parameters of the at command AT+CMUX.
*
* Parameters:   None.
*
* Returns:      None - on error the function exits.
****************************************************************************/
typedef struct
{
    unsigned char mode;
    unsigned char subset;
    unsigned int port_speed;
    unsigned int n1;
    unsigned char t1;
    unsigned char n2;
    unsigned char t2;
    unsigned char t3;
    unsigned char k;
    
} cmux_cmd_par_t;

typedef enum ata_mode_e
{
    /*
    ** AT command mode
    */
    ATA_OFFLINE_CMD       = 0,  /* Single line mode */
    ATA_OFFLINE_SMS_TEXT  = 3,  /* Multi line mode */
    ATA_OFFLINE_SMS_PDU   = 7,  /* Multi line mode */
    ATA_OFFLINE_CHAR      = 1,  /* AT break-off mode */
    
    ATA_ONLINE            = 2,  /* No AT line mode, DS data transfer mode */
    ATA_ONLINE_CMD        = 4,  /* Interrupted DS mode, AT line mode */
    
    ATA_OFFLINE_BUSY      = 5,  /* AT command in progress */
    ATA_ONLINE_BUSY       = 6,  /* AT command in progress */

    ATA_ONLINE_PTP        = 10, /* Point to Point Protocol mode. */
    
    ATA_OFFLINE_PTEST     = 12, /* AT is ready to process productions
                                 * test commands.
                                 */
    ATA_OFFLINE_END_PTEST = 13, /* AT processing a production test command.
                                 */
    ATA_ONLINE_PTEST,           /* AT is in production test transfer mode. 
                                 */
    ATA_MUX,                    /* multiplexing mode */
    ATA_ONLINE_AP_AT,           /* application over AT/serial mode */
    ATA_ONLINE_AP_DS,           /* application over DS mode */
    ATA_ONLINE_TRACE,           /* FD is connected to the trace device. */
    ATA_ONLINE_TRACE_CHANGE,    /* The trace device change is ongoing. */
    
#if SIO_USE_SOCKET_CONCEPT > 0
    ATA_ONLINE_SOCKET,          /* Give the port control to another
                                 * application. */
#endif    
    ATA_ONLINE_DS_SYNC,         /* DS data transfer mode - waiting for sync. */
    ATA_ONLINE_DS,              /* DS data transfer mode */

    ATA_SMS_CHAR_MODE,          /* SMS char mode - SMS PDU or SMS Text mode. 
                                 * SMS is sent as ascii coded text PDU or hex coded binary PDU.
                                 */
#if SIO_FBUS_AVAILABLE == 1
    ATA_ONLINE_FBUS_BUSY,       /* An FBUS frame is processed. */
    ATA_ONLINE_FBUS_IDLE,       /* Enter the idle mode of the FBUS protocol. */
    ATA_ONLINE_FBUS_INIT,       /* Start the FBUS protocol. */
#endif
    
    ATA_NO_MODE
    
} ata_mode_t;

/****************************************************************************
* Type:         cmux_test_par_t
*----------------------------------------------------------------------------
* Purpose:      the parameters of the at test command AT+CMUX=?.
*
* Parameters:   None.
*
* Returns:      None - on error the function exits.
****************************************************************************/

typedef struct {
    char buf[64];
} cmux_test_par_t;

/**B**************************************************************************
* Function:     ata_mux_test
*-----------------------------------------------------------------------------
* Usage:        None
*
* Remarks:      None
***E*************************************************************************/
int ata_mux_test (int tid, cmux_test_par_t *cmux_test_rsp_p);

/**B**************************************************************************
* Function:     ata_mux_read
*-----------------------------------------------------------------------------
* Usage:        None
*
* Remarks:      None
***E*************************************************************************/
int ata_mux_read (int tid, cmux_cmd_par_t *cmux_cmd_par_p);

/**B**************************************************************************
* Function:     ata_mux_cmd
*-----------------------------------------------------------------------------
* Usage:        cmux_cmd_par_t еn1֧2047
*
* Remarks:      None
***E*************************************************************************/
int ata_mux_cmd (int tid, cmux_cmd_par_t *cmux_cmd_par);

/**B**************************************************************************
* Function:     ata_mux_release
*-----------------------------------------------------------------------------
* Usage:        None
*
* Remarks:      None
***E*************************************************************************/
int ata_mux_release (int tid);

#if 0 /* ͳһʹDD_SIOCTRL */
typedef enum
{
    IOCTL_SIO_MUX_SET_DATA,                 /*set data config command,set baudrate.param:T_ZDrvSio_DataConfig*/
    IOCTL_SIO_MUX_SET_BUFFER,            /*set data buffer command,param:T_ZDrvSio_SetConfig */
    IOCTL_SIO_MUX_SET_BLOCKTIME,              /*set sio block read*/
    IOCTL_SIO_MUX_SET_BLOCK,
    IOCTL_SIO_MUX_CLEAN_BLOCK,          /*clean the sio block read*/
    IOCTL_SIO_MUX_CALLBACK,                 /*set sio non block callback function.param:T_ZDrvSio_Read_CallBack*/
    #if 0 /* 617001655333 MUXŻҪIOCTLָ */
    IOCTL_SIO_MUX_ACTIVE_MUX,           /*active mux mode add by zqs*/
    IOCTL_SIO_MUX_DEACTIVE_MUX,         /*deactive mux mode,back to normal add by zqs*/
    IOCTL_SIO_MUX_GET_TX_FINISH,         /*get tx state for check send over zqs*/
    #endif
    IOCTL_SIO_MUX_CMD_MAX
} T_ZDrvSio_MUX_IOCTL; /*sio mux ioctl command*/
#endif

#endif /* SIO_MUX_ATA_H */

/* drvs_sio_mux_ata.h ends here. */
