/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_pmic_int.h
 * File Mark:
 * Description:  pmic int interface
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2016-01-27
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_PMIC_INT_H
#define _DRVS_PMIC_INT_H

/* pmic */
typedef enum _T_ZDrvPmic_IntId {
    /* 0x00 */
    ZX234290_INT_INVALID0 = 0,
    ZX234290_INT_INVALID1,
    ZX234290_INT_EOADC,			/* xxxx x100	*/
    ZX234290_INT_PWRON_SHORT,
    ZX234290_INT_PWRON_LONG,
    ZX234290_INT_PWRON,
    ZX234290_INT_INVALID2,
    ZX234290_INT_INVALID3,
    /* 0x01 */
    ZX234290_INT_RTC_ALRM = 8,
    ZX234290_INT_INVALID4,
    ZX234290_INT_INVALID8,
    ZX234290_INT_RTC_MIN,
    ZX234290_INT_RTC_HOUR,
    ZX234290_INT_INVALID5,
    ZX234290_INT_INVALID6,
    ZX234290_INT_INVALID7,

    PMIC_INT_MAX_ID
} T_ZDrvPmic_IntId;

typedef VOID(*T_PMIC_CALLBACK)(UINT8 reg_val);

SINT32 zDrvPmic_IsrMask(UINT8 nInt);
SINT32 zDrvPmic_IsrUnMask(UINT8 nInt);
SINT32 zDrvPmic_IntInit(VOID);
SINT32 zDrvPmic_RegisterCallback(T_ZDrvPmic_IntId nIntId, T_PMIC_CALLBACK callback);
SINT32 zDrvPmic_UnRegisterCallback(T_ZDrvPmic_IntId nIntId);
SINT32 zDrvPmic_CleanIrq(UINT8 slv_addr, UINT8 reg_addr);
SINT32 zDrvPmic_UnMaskIrq(T_ZDrvPmic_IntId nIntId);
SINT32 zDrvPmic_MaskIrq(T_ZDrvPmic_IntId nIntId);

#endif
