/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        weizhigang
 * Date:          2010-8-6
 * History 1:      
 *     Date: 
 *     Version: 
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_SSP_H
#define _DRVS_SSP_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_dma.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
//#define SSP_INT_ENABLE  0
//#define SSP_DMA_ENABLE  1

#define SSP_ASSERT() zOss_ASSERT(0)

#define SSP_ERROR(format,args...)     do {SSP_ASSERT();zOss_Printf(1,1,format,##args);} while(0)

#define SSP_DEBUG_RAMLOG	

#ifdef SSP_DEBUG_RAMLOG
#define zDrvSsp_RamLog(s...)	zDrvRamlog_PRINTF(RAMLOG_MOD_SPI,s)
#else
#define zDrvSsp_RamLog(s...)
#endif

#define SPI_PRINTF(cond, format, args...)                do { if(cond) zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, format, ##args);}while(0)
/****************************************************************************
* 	                                        Types
****************************************************************************/


//define ssp num --zhangpei add
typedef enum _T_SspDevNum
{
	SSP_DEV_0 = 0,
	SSP_DEV_1 = 1,
	SSP_DEV_NUM
}
T_SspDevNum;
typedef enum _T_SspMSMode
{
	SSP_MS_MASTER = 0x0,
	SSP_MS_SLAVE = 0x1,
}
T_SspMSMode;
//define ssp mode
typedef enum _T_SspMode
{
	SSP_AS_SPI = 0x0,
	SSP_AS_TISS = 0x1,
}
T_SspMode;

//define ssp mode
typedef enum _T_SspXferWidth
{
	SSP_8_BIT = 7,
	SSP_9_BIT = 8,
	SSP_16_BIT = 15,
	SSP_32_BIT = 31
}
T_SspXferWidth;

//define ssp mode
typedef enum _T_SspPolarity
{
	SPH_SPO_00 = 0x0,
	SPH_SPO_01 = 0x1,
	SPH_SPO_10 = 0x2,
	SPH_SPO_11 = 0x3
}
T_SspPolarity;


//defined for ssp frequency changing
typedef enum _T_SspFrequency
{
	SSP_FREQ_52M,
	SSP_FREQ_39M,
	SSP_FREQ_26M,
	SSP_FREQ_13M,
	SSP_FREQ_6M5,
	SSP_FREQ_3M2,
	SSP_FREQ_1M6,
	SSP_FREQ_812K5,
	SSP_FREQ_NUM,
}
T_SspFrequency;

typedef enum _T_SspCamMode
{
	SSP_NORMAL_MODE = 0x0,
	SSP_CAMERA_MODE = 0x1,
}
T_SspCamMode;


//define ssp cs level
typedef enum _T_SspCsLevel
{
	SSP_CS_LOW = 0,
	SSP_CS_HIGH = 1
}
T_SspCsLevel;


//define the status
#define RXFIFOFULL 		1
#define RXFIFONOTFULL 	0
#define RXFIFOEMPT 		0
#define RXFIFONOTEMPT 	1
#define TXFIFOFULL		0
#define TXFIFONOTFULL	1
#define TXFIFOEMPTY 	1
#define TXFIFONOTEMPTY 	0

//define register bit field segment
typedef volatile struct
{
	/*0x00*/
	UINT32 SSP_VER_REG;
  	/*0x04*/
	UINT32 SSP_COM_CTRL;   
	/*0x08*/
	UINT32 SSP_FMT_CTRL;
	/*0x0c*/
	UINT32 SSP_DR;	
	/*0x10*/
	UINT32 SSP_FIFO_CTRL;	
	/*0x14*/
	UINT32 SSP_FIFO_SR;
	/*0x18*/
	UINT32 SSP_INTR_EN;	
	//0x1c
	UINT32 SSP_ISR_OR_ICR;
	//0x20
	UINT32 SSP_TIMING;

}
T_SspReg;


typedef enum _T_SspStatus
{
	SSP_STA_INIT = 0,
	SSP_STA_OPENED,
	SSP_STA_XFER,
	SSP_STA_DMA_ERR,
	SSP_STA_DONE,
}
T_SspStatus;

typedef struct _T_SspDmaInfo
{
	UINT32 rxDmaChl;                        // ssp rx Dma channel number
	UINT32 txDmaChl;
	T_ZDrvDma_ChannelDef rxDmaChlDef;
	T_ZDrvDma_ChannelDef txDmaChlDef;
	zDrvDma_CallbackFunc rxDmaCbFunc;       // ssp rx callback function
	zDrvDma_CallbackFunc txDmaCbFunc;
	ZOSS_SEMAPHORE_ID 	TxDmaSema;
	ZOSS_SEMAPHORE_ID  RxDmaSema;
} T_SspDmaInfo;


typedef union _T_SspData
{
	UINT8 *Buf_8;
	UINT16 *Buf_16;
	UINT32 *Buf_32;
	VOID *Buf;
} T_SspData;


typedef struct
{
	T_SspDevNum devNum;				//indicate the ssp device num
	T_SspReg* regPtr;
	T_SspDmaInfo SspDmaInfo;
	T_SspStatus status;
	T_SspMSMode msMode;
	T_SspMode mode;
	T_SspPolarity polarity;
	T_SspXferWidth xferWidth;

	//NT32 SspWorkClock;				//the wanted freq
	//NT32 RealSspWorkClock;			//the actral freq
	UINT32 SspWorkClock;				//the wanted freq

	UINT32 tx_thres;
	UINT32 rx_thres;

	UINT32 Len_tx_remin;
	VOID* txBuf;		
	UINT32 Len_rx_remin;	
	VOID* rxBuf;		

	UINT32 bPrint;

	//ZOSS_SEMAPHORE_ID txSem;
	//	ZOSS_SEMAPHORE_ID rxSem;
		
}
T_SspDevHnd;


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32 zDrvSsp_Transfer(VOID* hnd, VOID* txBuf ,VOID* rxBuf,UINT32 Len);
//VOID* zDrvSsp_Open(T_SspDevNum devNum, T_SspMSMode msMode);
VOID* zDrvSsp_Open(T_SspDevNum devNum);
//VOID zDrvSsp_Reset(T_SspDevNum devNum);
SINT32 zDrvSsp_Set_XferWidth(VOID* hnd,T_SspXferWidth length);

SINT32 zDrvSsp_Xfer(VOID* hnd, VOID* txBuf ,VOID* rxBuf,UINT32 Len);

SINT32 zDrvSsp_DmaXfer(VOID* hnd, VOID* txBuf ,VOID* rxBuf,UINT32 Len);
//SINT32 zDrvSsp_DmaEnable(T_SspDevNum devNum);	
//SINT32 zDrvSsp_DmaDisable(T_SspDevNum devNum);
//NT32 zDrvSsp_ChangeFreq(VOID *hnd, T_SspFrequency Freq);
SINT32 zDrvSsp_SetMSMode(VOID *hnd, T_SspMSMode msMode);
SINT32 zDrvSsp_Initiate(VOID);
SINT32 zDrvSsp_Ioctl(VOID *hnd, T_DRVIO_CTRL_KEY function, VOID *arg);

#endif/*_FILENAME_H*/

