/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       v1.0
 * Author:
 * Date:          2015-09-11
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_TSC_H
#define _DRVS_TSC_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "ram_config.h"

/****************************************************************************
*                                           Types
****************************************************************************/
 typedef enum _T_TsCtrl_Probe
{
	PROBE_ADC1 = 0,
	PROBE_ADC2,
	PROBE_RESEV1,	
	PROBE_RESEV2,
	PROBE_RESEV3,
	PROBE_RESEV4,	
	PROBE_MAX,
} Ts_TsCtrl_Probe;

 typedef enum _T_Ts_Temp_interregional
 {
     TS_TEMP_INTERVAL_T0 = 0,
     TS_TEMP_INTERVAL_T1,
     TS_TEMP_INTERVAL_T2,
     TS_TEMP_INTERVAL_T3,
     TS_TEMP_INTERVAL_T4,
     TS_TEMP_INTERVAL_T5,
     TS_TEMP_INTERVAL_T6,
     TS_TEMP_INTERVAL_T7,
     TS_TEMP_INTERVAL_MAX
 }Ts_Temp_interregional;
 typedef enum
 {
	 TS_TEMP_VALUE_TABLE_NUMBER = 0,
	 TS_TEMP_VOLTAGE_TABLE_NUMBER = 1,
	 TS_TEMP_TABLE_NUMBER_MAX
 }TS_TEMP_TABLE_NUMBER;

 typedef enum _T_Ts_Member
 {
     TS_MEMBER_PROBE = 0,
     TS_MEMBER_TEMP,

     TS_MEMBER_MAX,
 } Ts_Member;


 typedef enum _T_TsCtrl_Strategy_Id
{
	PS_STRATEGY_RATE = 0,
	PS_STRATEGY_ANYRESIDENT,
	WIFI_STRATEGY,
	CHARGER_STRATEGY,
	AP_RATE,
	MAX_TSCTRL_STRATEGY_ID
} T_TsCtrl_Strategy_ModuleId;

/**************************************************
	0--STRTEGY_STOP:  ֹͣ
	1--STRTEGY_START: ʼ
	2--STRTEGY_HOLD:  HOLD֮ǰ
**************************************************/
 typedef enum _T_TsCtrl_Strategy
 {
	STRTEGY_STOP = 0,
	STRTEGY_START=1,
	STRTEGY_HOLD=2,

	STRTEGY_MAX,
 } Ts_TsCtrlStrategy; 
 /****************************************************************************
 *											   Global Function Prototypes
 ****************************************************************************/
typedef struct _T_ZDrvTsc_Opt
{
	VOID (*tsc_RefGetAdcvalue)(SINT32 adcValue, UINT32 *temp);
	VOID (*tsc_RefSetProbeStr)(UINT32 probe_num,UINT32 temperature );
	VOID (*tsc_RefStrategyDispatch)(VOID);
	
}T_ZDrvTsc_Opt;
/****************************************************************************
* 	                                           macro define
****************************************************************************/
#define tsc_SetRegBit(regName, bitAddr, bitValue)    \
		do{ 												 \
			if(bitValue == TRUE)							 \
				reg32(regName) |= (0x1<<bitAddr);			 \
			else											 \
				reg32(regName) &= ~(0x1<<bitAddr);			 \
		}while(0)
		
#define tsc_SetRegBits(regName, bitsAddr, bitsLen, bitsValue)   \
		do{ 															\
			reg32(regName) = (reg32(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);\
		}while(0)
		

/**/
#define  STRATEGY_PHY_NUM  					8
#define  BITS_FOR_PHYIRAM				    1
/*TSCTRL_PHY iram ÿһbitʾPHYһǷִ*/
#define  BIT_LIMIT_LTE_DOWNRATE1  			0
#define  BIT_LIMIT_LTE_DOWNRATE2  			1
#define  BIT_LIMIT_W_DOWNRATE1  			2
#define  BIT_LIMIT_W_DOWNRATE2  			3
#define  BIT_LIMIT_LTE_UPTRANSIMITPOWER1  	4
#define  BIT_LIMIT_LTE_UPTRANSIMITPOWER2  	5
#define  BIT_LIMIT_W_UPTRANSIMITPOWER1  	6
#define  BIT_LIMIT_W_UPTRANSIMITPOWER2  	7
/**/
//#define  STRATEGY_PS_NUM  	2
#define  BITS_FOR_PSIRAM				    4
/*TSCTRL_PS iram ÿbitʾPSһǷִ*/
#define  BIT_PS_RATE  						0
#define  BIT_PS_ANYRESIDENT  				4
#define  BIT_SHUTDOWN  						8
/**/
//#define  STRATEGY_PERIP_NUM  	2
#define  BITS_FOR_PEPIPIRAM				    4
/*TSCTRL_PERIP iram ÿbitʾTSCTRL_PERIPһǷִ*/
#define  BIT_WIFI  							0
#define  BIT_CHHRGER	 					4
#define  BIT_APRATE	 						8

/**/
//#define  STRATEGY_AP_NUM  	2
#define  BITS_FOR_APPIRAM				    4
/*TSCTRL_AP iram ÿbitʾAPһǷִ*/
		

/*TSCTRL_PHY iramInfo:ÿһbitʾPHYһǷִ
bit0:limit_ltedownrate1	  1:lte10:ֹͣlte1
bit1:limit_ltedownrate2	  1:lte20:ֹͣlte2
bit2:limit_wdownrate1	  1:w10:ֹͣw1
bit3:limit_wdownrate2	1:w20:ֹͣw2
bit4:limit_lteuptransmitrate1	1:lteз书10:ֹͣlteз书1
bit5:limit_lteuptransmitrate2	1:lteз书20:ֹͣlteз书2
bit6:limit_wuptransmitrate1		1:wз书10:ֹͣwз书1
bit7:limit_wuptransmitrate2		1:wз书20:ֹͣwз书2
*/
#define  TSCTRL_PHY							(IRAM_BASE_ADDR_TPC+0x00)/* 1KIRAM_BASE_ADDR_TPC++0x400--¿ݴ  */

/*TSCTRL_PHY+0x04--TSCTRL_PHY+0x44
ÿ4 bitʾÿ̽ǷҪִв1:ִ0:ִ;2 HOLD*/
#define  TSCTRL_PS							(TSCTRL_PHY+0x04)
#define  TSCTRL_AP							(TSCTRL_PHY+0x08)
#define  TSCTRL_PERIP						(TSCTRL_PHY+0x0C)

/*ÿ4 bitʾÿ̽ǷҪִв1:ִ0:ִ;2 HOLD*/
#define  TSCTRL_LIMIT_LTE_DOWNRATE1			(TSCTRL_PHY+0x10)  /*A*/
#define  TSCTRL_LIMIT_LTE_DOWNRATE2			(TSCTRL_PHY+0x14)  /*B*/
#define  TSCTRL_LIMIT_W_DOWNRATE1			(TSCTRL_PHY+0x18)  /*A*/
#define  TSCTRL_LIMIT_W_DOWNRATE2			(TSCTRL_PHY+0x1c)  /*B*/
#define  TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER1	(TSCTRL_PHY+0x20)  /*C*/
#define  TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2	(TSCTRL_PHY+0x24)  /*D*/
#define  TSCTRL_LIMIT_W_UPTRANSIMITPOWER1	(TSCTRL_PHY+0x28)  /*C*/
#define  TSCTRL_LIMIT_W_UPTRANSIMITPOWER2	(TSCTRL_PHY+0x2c)  /*D*/
#define  TSCTRL_PS_RATE						(TSCTRL_PHY+0x30)  /*E*/
#define  TSCTRL_PS_ANYRESIDENT				(TSCTRL_PHY+0x34)  /*F*/
#define  TSCTRL_SHUTDOWN					(TSCTRL_PHY+0x38)  /*G*/
#define  TSCTRL_WIFI						(TSCTRL_PHY+0x3c)  /*F*/
#define  TSCTRL_CHARGER						(TSCTRL_PHY+0x40)  /*F*/
#define  TSCTRL_APRATE						(TSCTRL_PHY+0x44)  /*F*/
#define  TSCTRL_DFS							(TSCTRL_PHY+0x48)  /*DFS*/

/*ÿ̽ԲԵĿϢڴ洢IRAMʼbitλ*/
#define  BITS_FOR_PROBES 				 4
#define  BIT_PROBE_ADC1  				(PROBE_ADC1*BITS_FOR_PROBES)
#define  BIT_PROBE_ADC2  				(PROBE_ADC2*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV1  				(PROBE_RESEV1*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV2  				(PROBE_RESEV2*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV3  				(PROBE_RESEV3*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV  				(PROBE_RESEV4*BITS_FOR_PROBES)


/*Ԥֿռ洢ҪR7ݵA9Ϣ,TSCTRL_PHY+0x100--TSCTRL_PHY+0x400*/
#define  TSCTRL_TEMPADC1					(TSCTRL_PHY+0x100)  /*temp adc1*/
#define  TSCTRL_TEMPADC2					(TSCTRL_PHY+0x104)  /*temp adc2*/
#define  TSCTRL_TEMPREV1					(TSCTRL_PHY+0x108)  /*temp rev1*/
#define  TSCTRL_TEMPREV2					(TSCTRL_PHY+0x10c)  /*temp rev2*/
#define  TSCTRL_TEMPREV3					(TSCTRL_PHY+0x110)  /*temp rev3*/
#define  TSCTRL_TEMPREV4					(TSCTRL_PHY+0x114)  /*temp rev3*/
#define  TSCTRL_DETECT_EN					(TSCTRL_PHY+0x118)  /*TsNvData.DetectEn*/
#define  TSCTRL_TEMP_PERCENT				(TSCTRL_PHY+0x11c)  /*APrate ,g_tempPercent*/

/**/
#define  PROBE_NUM  	PROBE_MAX
#define  PROBE_INFO 	2   //fixed value, probe num and temp
#define  TS_ADC_TEMP_NUMBER   2
#define  TS_ADC_TEMP_VOLTAGE_NUMBER  110
#define  TS_TEMP_NUMBER_SMALLEST   0
#define  TS_TEMP_NUMBER_BIGGEST  96

#define TSC_DEBUG_DEF

#ifdef TSC_DEBUG_DEF
#define TSC_DEBUG(s...)    zOss_Printf(1,1, ##s) /*ramlog_Printf(RAMLOG_MOD_CHARGER, ##s)*/
#else
#define TSC_DEBUG(s...)
#endif
 /****************************************************************************
*                                           fuction extern 
****************************************************************************/

typedef VOID (* T_TsCtrl_CallbackFunction)( UINT8 en ); /*en:   1,ԣ0,ֹͣ; 2: hold */
SINT32 zDrvTsc_SetOpt(T_ZDrvTsc_Opt* pTscOpt);

extern SINT32   zDrvTsCtrl_RegCallback(T_TsCtrl_Strategy_ModuleId  module,T_TsCtrl_CallbackFunction callback);
extern SINT32   zDrvTsc_SetTscEn(UINT8 val);  //val:0xB2,¿ش򿪣 ֵ¿عر
extern SINT32   zDrvTsc_GetTscEn(VOID);
VOID zDrvTsc_GetTscTempPercent(UINT32 *percent);
//UINT32   *zDrvTsc_GetTscDbbProbTemp(void);
#endif

