/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_hisr.h
 * File Mark:    
 * Description:  Provide the declaration of return types  for HAL
 * Others:        
 * Version:       V0.5
 * Author:        xiongquan
 * Date:          2008-12-01
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/
#ifndef _DRVS_HISR_H
#define _DRVS_HISR_H

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef struct _T_Drv_Hisr
{
    UINT8 active;
    UINT32 event;
    ZOSS_THREAD_ID   pid;
    ZOSS_SEMAPHORE_ID semid;
    VOID * devPtr;
}
T_Drv_Hisr;

typedef VOID(*FUNC_HISRENTRY)(SINT32 arg);

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32  zDrv_HisrCreate(T_Drv_Hisr * hisr, CHAR *name, SINT32 size,  SINT32 priority,  FUNC_HISRENTRY hisr_entry, VOID *hisr_device);
VOID  zDrv_HisrFree(T_Drv_Hisr * hisr);
VOID  zDrv_HisrStart(T_Drv_Hisr * hisr, UINT32 event);
VOID zDrv_HisrActivate(T_Drv_Hisr * hisr);
VOID zDrv_HisrWaitSem(T_Drv_Hisr * hisr);
VOID zDrv_HisrResetEvent (T_Drv_Hisr *hisr, UINT32 event);
SINT32 zDrv_HisrInitSem(T_Drv_Hisr * hisr);


#endif

