
/**************************************************************************
 *
 *Copyright (c) 2013 ZTE Corporation.
 *
 * ģ   : 
 *    : drvs_he43106.h
 * ļ : 
 * ʵֹ : HE43106оƬϢ
 * 	  : qihongfang
 * 	  : V1.0
 *  : 2014-12-23
 *							 
 * ˵ : 
 *
 * ޸ļ¼					޸				޸
* ---------------------------------------------------------------------
*		   1			 2014.12.23 		   췼 				   ½
 **************************************************************************/
 
#ifndef _DRVS_HE43106_H
#define _DRVS_HE43106_H

#include "drvs_general.h"

#define HE43106_I2C_SLAVE_ADDR0 0x3A
#define I2C_BUS_FREQ (2*1000*1000)
#define HE43106_ALL_BITS   0xFF


#define HE43106_BITFVAL(var, lsh)   ( (var) << (lsh) )
#define HE43106_BITFMASK(wid, lsh)  ( ((1U << (wid)) - 1) << (lsh) )

//#define BIT(n)  (UINT8)(1<<(n))
//#define CHARGER "zte_charger"
#define GPIOFUNC_FUNC 1

#define BOOST_REG            0x00
#define BLED_REG             0x01
#define FLASHLIGHT_REG       0x02
#define INTERRRUPT_MASK_REG  0x03
#define INTERRRUPT_REG       0x04
#define CHARGE_REG           0x05
#define CP_REG               0x06
#define TTC_TIMEOUT_REG      0x07
#define MCU_OPTION_0_REG     0x10
#define MCU_OPTION_1_REG     0x11


/*define for 0x00 BOOST_REG*/
#define OV_TEMP               (1<<7)
#define BOOST_OVERLOAD_LATCH  (1<<6)
#define LOWBAT_DETECT         (1<<5)
#define NOLOAD_DETECT         (1<<4)
#define BOOST_EN              (1<<3)
#define DISCHARGE_ON          2
#define MCU_DISCHARGE_ON      1
#define MCU_DISCHARGE_EN      0

/*define for 0x01 BLED_REG*/
#define MCU_BLED_EN         4
#define MCU_BLED4_ON        3
#define MCU_BLED3_ON        2
#define MCU_BLED2_ON        1
#define MCU_BLED1_ON        0


/*define for 0x03 INTERRRUPT_MASK_REG*/
#define MCU_INT_PIN_EN      7
#define MASK_ABNORMAL_INT   4
#define MASK_CP_INT         3
#define MASK_CHARGE_INT     2
#define MASK_NOLOAD_DET_INT 1
#define MASK_LOWBAT_INT     0
#define MASK_ALL_INT    0x9f

/*define for 0x04 INTERRRUPT_REG*/
#define ABNORMAL_INT      (1<<4)
#define CP_INT            (1<<3)
#define CHARGE_INT        (1<<2)
#define NOLOAD_DET_INT    (1<<1)
#define LOWBAT_INT        (1<<0)
#define CHG_INT_ALL       0x1f
 
/*define for 0x05 CHARGE_REG*/
#define CHARGE_DISABLE      6//(1<<6)
#define CHARGE_TIMEOUT      (1<<3)
#define CHARGE_DONE         (1<<2)
#define CHARGE_IN_PROGRESS  (1<<1)
#define CHARGE_VIN_GOOD     (1<<0)

/*define for 0x06 CP_REG*/
#define FORCE_CP_ENABLE  6
#define CP3_HIGH         3
#define CP2_HIGH         2
#define CP1_HIGH         1
#define CP0_HIGH         0

/*define for 0x07 TTC_TIMEOUT_REG*/
#define SW_RESET_CTRL1           7
#define CHARGE_TIMOUT_SEL        0/*bit 0~2*/

/*define for 0x10 MCU_OPTION_0_REG*/
#define MCU_OL_LED_BLANK_DIS     7
#define CP_OPTION                5
#define MCU_CABLE_CPS_EN         4
#define MCU_BES_OUT_SEL          3
#define MCU_VBAT_REGULATION      0

/*define for 0x11 MCU_OPTION_0_REG*/
#define SW_RESET_CTRL2         7
#define CHARGE_1A              5
#define MCU_SEL_0P1S           4
#define MCU_CHARGE_TIMEOUT_EN  3
#define CP_PROCESS_BYPASS      2
#define MCU_MODE               0

SINT32 led_Reset(VOID);
SINT32 chg_ChargerReset(VOID);

#endif/*END of _DRVS_HE43106_H*/

