/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2013-9-4
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_PM_H
#define _DRVS_PM_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/


/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum _T_ZDrvPmic_Enable{
    PM_DISABLE = 0,
    PM_ENABLE,
    PM_ENABLE_NOT_SUPPORT = -100,
    PM_ENABLE_MAX_STATUS = -255
} T_ZDrvPmic_Enable;

typedef enum _T_ZDrvPmic_NrmMode{
    PM_NRMMODE_AUTO = 0,
    PM_NRMMODE_PFM,
    PM_NRMMODE_PWM,
    PM_NRMMODE_NOT_SUPPORT = -100,
    PM_NRMMODE_MAX_STATUS = -255
}T_ZDrvPmic_NrmMode;

typedef enum _T_ZDrvPmic_SlpMode{
    PM_SLPMODE_AUTO_NORMAL = 0,    //auto in dcdc, normal in ldo
    PM_SLPMODE_ECO_NRMV,           //normal voltage
    PM_SLPMODE_ECO_SLPV,           //sleep voltage
    PM_SLPMODE_OFF,                //OFF
    PM_SLPMODE_NOT_SUPPORT = -100,
    PM_SLPMODE_MAX_STATUS = -255
}T_ZDrvPmic_SlpMode;

//consumer
typedef enum _T_ZDrvPmic_Regulator{
    VCORE0 = 0,
    VCORE1,
    VDDR,
    VMMC,
    VSD0,
    VSD1,
    VIO_LO,
    VIO_HI,
    VUSB_0V9,
    VUSB_3v3,
    VPLL_LO,
    VPLL_HI,
    VSIM1,
    VSIM2,
    VRF_LO,
    VRF_HI,
    VRF_SW,
    VPA,
    VCTCXO1,
    VCTCXO2,
    VSSBUF,
    VRTC,
} T_ZDrvPmic_Regulator;

typedef enum _T_ZDrvPmic_Vcore{
    PM_VOLT_0_800 = 0,
    PM_VOLT_0_850 ,   //output  V,
    PM_VOLT_0_875 ,   //output  V,
    PM_VOLT_0_900 ,   //output  V,
    PM_VOLT_0_925 ,   //output  V,
    PM_VOLT_0_950 ,   //output  V,
    PM_VOLT_1_100 ,   //output  V,
    PM_VOLT_1_150 ,   //output  V,
    PM_VOLT_1_200 ,   //output  V,
    PM_VOLT_1_250 ,   //output  V,
    PM_VOLT_1_600 ,   //output  V,
    PM_VOLT_1_800 ,   //output  V,
    PM_VOLT_2_750 ,   //output  V,
    PM_VOLT_2_800 ,   //output  V,
    PM_VOLT_2_850 ,   //output  V,
    PM_VOLT_3_000 ,   //output  V,
    PM_VOLT_3_300 ,   //output  V,
    PM_VOLT_3_600 ,   //output  V,
    PM_VOLT_NOT_SUPPORT = -100,
    PM_VOLT_MAX_STATUS = -255,
 } T_ZDrvPmic_Voltage;


typedef struct _T_ZDrvPmic_Opt
{
    SINT32 (*zDrvPmic_LdoInit)(VOID);
}T_ZDrvPmic_Opt;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
SINT32 zDrvPmic_Initiate(VOID);

SINT32 zDrvPmic_SetNormalOnOff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable);
SINT32 zDrvPmic_SetNormalVoltage(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Voltage voltage);
SINT32 zDrvPmic_SetNormalMode(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_NrmMode nrmMode);

SINT32 zDrvPmic_GetNormalOnOff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable* enable);
SINT32 zDrvPmic_GetNormalVoltage(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Voltage* voltage);
SINT32 zDrvPmic_GetNormalMode(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_NrmMode* nrmMode);

SINT32 zDrvPmic_SetSleepOnOff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable);
SINT32 zDrvPmic_SetSleepVoltage(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Voltage voltage);
SINT32 zDrvPmic_SetSleepMode(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_SlpMode slpMode);

SINT32 zDrvPmic_GetSleepOnOff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable* enable);
SINT32 zDrvPmic_GetSleepVoltage(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Voltage* voltage);
SINT32 zDrvPmic_GetSleepMode(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_SlpMode* slpMode);

SINT32 zDrvPmic_SetOpt(T_ZDrvPmic_Opt* pPmicOpt);

#endif

