/*******************************************************************************
 * Copyright (C) 2008, ZTE Corporation.
 *
 * File Name:    hal_audio.h
 * File Mark:    
 * Description:  Provide audio hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V0.5
 * Author:        dangmaochang
 * Date:          2008-07-02
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_AUDIO_H
#define _HAL_AUDIO_H

/****************************************************************************
*                                             Types
****************************************************************************/
typedef struct 
{
    SINT32 (*hal_audio_Open)(VOID);
    SINT32 (*hal_audio_Close)(VOID);
    SINT32 (*hal_Audio_PlayStart)( T_ZDrvAudio_PlayParam *playParam);
    SINT32 (*hal_Audio_PlayStop)(VOID);
    SINT32 (*hal_Audio_PlayPause)(VOID);
    SINT32 (*hal_Audio_PlayResume)(VOID);
    SINT32 (*hal_Audio_SetSample)(T_ZDrvAudio_SampleRate* pSampleRate);
    SINT32 (*hal_Audio_SetBanlance)(T_ZDrvAudio_Banlance* pBanlance);
    SINT32 (*hal_Audio_SetEQMODE)(T_ZDrvAUDIO_EQMODE* pEQMODE);
    SINT32 (*hal_Audio_Set3DEFFECT)(T_ZDrvAudio_3DEFFECT* p3DEFFECT);
    SINT32 (*hal_Audio_SetOutputPath)(T_ZDrv_AudioOutputPath* pOutputPath);
    SINT32 (*hal_Audio_SetOutputVol)(T_ZDrvAudio_OutputVolLevel* pOutputVol); 
    SINT32 (*hal_Audio_SetMute)(BOOL*BlMute);
    SINT32 (*hal_Audio_GetPlayInfo)(T_ZDrvAudio_PlayInfo* pPlayInfo);
    SINT32 (*hal_Audio_SetCallBackFunc)(T_ZDrvAudio_CallbackFunc pCallBcak);  
    SINT32 (*halAudio_Write)(UINT32* pDatabuff, UINT32 length);
    SINT32 (*hal_Audio_Enable3DEffect)(T_ZDrvAudio_3DEFFECT* pAudio3DEffect); 
    SINT32 (*halAudio_SetRecordPath)( T_ZDrv_CodecInputPath * pAudioBlock);
    SINT32 (*halAudio_SetRecordVol)( T_ZDrvAudio_InputVolLevel * pAudioBlock);
    SINT32 (*halAudio_GetBuf) (T_ZDrvAudio_BufInfo *pBufInfo);
    SINT32 (*halAudio_RcdStart)( T_ZDrvRcd_InfoParam*rcdParam);
    SINT32 (*halAudio_RcdStop)(VOID);
    SINT32 (*halAudio_GetRcdBuf) (T_ZDrvAudio_BufInfo *pBufInfo);
    SINT32 (*halAudio_FreeRcdBuf) (VOID *pBuf);
    SINT32 (*hal_Audio_SetRcdSample)(T_ZDrvAudio_SampleRate* pSampleRate);
    SINT32 (*vsersion)(VOID);
    VOID   (*exit)(VOID); 
    
} T_HalAudio_Opt;

/****************************************************************************
*                                             Function Prototypes
****************************************************************************/

SINT32 halAudio_Open(VOID);

SINT32 halAudio_Close(VOID);

SINT32 halAudio_PlayStart(T_ZDrvAudio_PlayParam *datainfo);

SINT32 halAudio_PlayStop(VOID);

SINT32 halAudio_PlayPause(VOID);

SINT32 halAudio_PlayResume(VOID);

SINT32 halAudio_SetSample(T_ZDrvAudio_SampleRate* pSampleRate);

SINT32 halAudio_SetRcdSample(T_ZDrvAudio_SampleRate* pSampleRate);

SINT32 halAudio_SetBanlance(T_ZDrvAudio_Banlance* pBanlance);

SINT32 halAudio_SetEqMode(T_ZDrvAUDIO_EQMODE* pEQMODE);

SINT32 halAudio_Set3DEffect(T_ZDrvAudio_3DEFFECT* p3DEFFECT);

SINT32 halAudio_SetOutputPath(T_ZDrv_AudioOutputPath* pOutputPath);

SINT32 halAudio_SetOutputVol(T_ZDrvAudio_OutputVolLevel* pOutputVol);

SINT32 halAudio_SetMute(BOOL *BlMute);

SINT32 halAudio_GetPlayInfo(T_ZDrvAudio_PlayInfo* play_info);

SINT32 halAudio_SetCallBackFunc(T_ZDrvAudio_CallbackFunc pCallBcak);

SINT32 halAudio_Write(UINT32 *dl_stream_data, UINT32 count);

SINT32 halAudio_GetBuf(T_ZDrvAudio_BufInfo *pBufInfo);

SINT32 halAudio_RcdStart(T_ZDrvRcd_InfoParam *rcdParam);

SINT32 halAudio_RcdStop(VOID);

SINT32 halAudio_GetRcdBuf(T_ZDrvAudio_BufInfo *pBufInfo);

SINT32 halAudio_FreeRcdBuf(VOID *pBuf);

SINT32 halAudio_Enable3DEffect(T_ZDrvAudio_3DEFFECT* pAudio3DEffect);

SINT32 halAudio_GetRcdData(T_ZDrvAudio_BufInfo *param);

SINT32 halAudio_SetRecordPath(T_ZDrv_CodecInputPath *param);

SINT32 halAudio_SetRecordVol(T_ZDrvAudio_InputVolLevel *param);

VOID zDrvAudio_SetOperations(T_HalAudio_Opt* AudioObjPtr);

SINT32 zDrvAudio_Init(VOID);

SINT32 zDrvAudio_Exit(VOID);

#endif/*_HAL_AUDIO_H*/

