/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#include "oscl_base_macros.h" 
#include "dec_if.h"
//#include <stdlib.h>
#include "oss_clib.h"
#include <linux/string.h>
#include <pvamrwbdecoder_api.h>
#include <pvamrwbdecoder.h>
#include <pvamrwbdecoder_cnst.h>
#include <dtx.h>
#include "drvs_general.h"

/* This is basically a C rewrite of decode_amr_wb.cpp */

struct state {
	void *st; /*   State structure  */
	unsigned char *pt_st;
	int16  *ScratchMem;

	uint8* iInputBuf;
	int16* iInputSampleBuf;
	int16* iOutputBuf;

	uint8 quality;
	int16 mode;
	int16 mode_old;
	int16 frame_type;

	int16 reset_flag;
	int16 reset_flag_old;
	int16 status;
	RX_State rx_state;
};

//int16 *amr_wb_memo = NULL;
//int16 *amr_wb_memo1 = NULL;
//int	s_amr_count = 0;
void* D_IF_init(void) { 
    struct state* state = (struct state*) malloc(sizeof(struct state));
    if(state == NULL)
		return NULL;
    memset(state, 0, sizeof(*state));
//	s_amr_count = 0;
//	if (amr_wb_memo1 == NULL)
//		amr_wb_memo1 = (int16 *)zOss_Malloc(0x60000);
//	zOss_Memset(amr_wb_memo1, 0, 0x60000);
//	amr_wb_memo = amr_wb_memo1;
//	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"D_IF_init amr_wb_memo1= %x\n",amr_wb_memo1);
    state->iInputSampleBuf = (int16*) malloc(sizeof(int16)*KAMRWB_NB_BITS_MAX);
    state->reset_flag = 0;
    state->reset_flag_old = 1;
    state->mode_old = 0;
    state->rx_state.prev_ft = RX_SPEECH_GOOD;
    state->rx_state.prev_mode = 0;
    state->pt_st = (unsigned char*) malloc(pvDecoder_AmrWbMemRequirements());
    if(state->pt_st != NULL)
    {
	pvDecoder_AmrWb_Init(&state->st, state->pt_st, &state->ScratchMem);
    }
    return state;
}

void D_IF_exit(void* s) {
	struct state* state = (struct state*) s;
	free(state->pt_st);
	free(state->iInputSampleBuf);
	free(state);
//	free(amr_wb_memo1);
//	amr_wb_memo1 = NULL;
}

long D_IF_decode(void* s, const unsigned char* in, short* out, long bfi) {
    struct state* state = (struct state*) s;
    int32 i;
    state->mode = (in[0] >> 3) & 0x0f;
    in++;
/*
	if (bfi) {
		state->mode = 15; // NO_DATA
	}
*/
	state->quality = 1; /* ? */
    /* 0*/

	mime_unsorting((uint8*) in, state->iInputSampleBuf, &state->frame_type, &state->mode, state->quality, &state->rx_state);
 //   zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"D_IF_decode frame_type=%d,bfi=%d,state->mode=%d!\n",state->frame_type,bfi,state->mode);
	if ((state->frame_type == RX_NO_DATA) | (state->frame_type == RX_SPEECH_LOST)) {
		state->mode = state->mode_old;
		state->reset_flag = 0;
	} else {
		state->mode_old = state->mode;

		/* if homed: check if this frame is another homing frame */
		if (state->reset_flag_old == 1) {
			/* only check until end of first subframe */
			state->reset_flag = pvDecoder_AmrWb_homing_frame_test_first(state->iInputSampleBuf, state->mode);
		}
	}

	/* produce encoder homing frame if homed & input=decoder homing frame */
	if ((state->reset_flag != 0) && (state->reset_flag_old != 0)) {
		/* set homing sequence ( no need to decode anything */
		//for (i = 0; i < AMR_WB_PCM_FRAME; i++) 
        i = 0;
        do
        {
            out[i++] = EHF_MASK;
            out[i++] = EHF_MASK;
            out[i++] = EHF_MASK;
            out[i]   = EHF_MASK;
        }while(++i < AMR_WB_PCM_FRAME);
	} else {
		int16 frameLength;
        /**/
       
		state->status = pvDecoder_AmrWb(state->mode,
						   state->iInputSampleBuf,
						   out,
						   &frameLength,
						   state->st,
						   state->frame_type,
						   state->ScratchMem);
 
	}
	//for (i = 0; i < AMR_WB_PCM_FRAME; i++) 
	i = 0;
	do
	{  /* Delete the 2 LSBs (14-bit output) */

            out[i++] &= 0xfffC;
            out[i++] &= 0xfffC;
            out[i++] &= 0xfffC;
            out[i] &= 0xfffC;
	}while(++i < AMR_WB_PCM_FRAME);

	/* if not homed: check whether current frame is a homing frame */
	if (state->reset_flag_old == 0) {
		/* check whole frame */
		state->reset_flag = pvDecoder_AmrWb_homing_frame_test(state->iInputSampleBuf, state->mode);
	}
	/* reset decoder if current frame is a homing frame */
	if (state->reset_flag != 0) {
		pvDecoder_AmrWb_Reset(state->st, 1);
	}
	state->reset_flag_old = state->reset_flag;
	return 320;

}

