/*
Word32 v_mac_self_40(Word16 *A)
: A[0]*A[0]+A[1]*A[1]+...+A[39]*A[39]
в
num8ı
A 8ֽڶ
*/


#include "oscl_base_macros.h"
#if (PV_CPU_ARCH_VERSION >= 6)
	.text
	.align	5
	.word	0
	.global mac_self_40_asm
	.type   mac_self_40_asm, function
	

@// Example 8.6
x      .req  r0    @ input array x[]
hi     .req  r1    @ accumulator
lo     .req  r2    @ accumulator

x_0    .req  r3  
x_1    .req  r4
x_2    .req  r5
x_3    .req  r6
x_4    .req  r7  
x_5    .req  r8
x_6    .req  r9
x_7    .req  r10
x_8    .req  r11
x_9    .req  r12

	
mac_self_40_asm:
        STMFD   sp!, {r4-r11}
        MOV     hi, #0
        MOV     lo, #0        

.rep 2
        LDMIA   x!, {x_0-x_9}
        SMLALD   lo, hi, x_0, x_0
        SMLALD   lo, hi, x_1, x_1
        SMLALD   lo, hi, x_2, x_2
        SMLALD   lo, hi, x_3, x_3
        SMLALD   lo, hi, x_4, x_4
        SMLALD   lo, hi, x_5, x_5
        SMLALD   lo, hi, x_6, x_6
        SMLALD   lo, hi, x_7, x_7
        SMLALD   lo, hi, x_8, x_8
        SMLALD   lo, hi, x_9, x_9

.endr

        LSL     hi, hi, #1
        LSLS    lo, lo, #1
        ADDCS   hi, hi, #1
        
        CMP     hi, lo, ASR #31
        MOVEQ   r0, lo
        LDRNE   r0, =0x7fffffff @ƽͣΪ
          
END:        
        LDMFD   sp!, {r4-r11}

        BX      lr  
#endif