/*
Word32 v_mac_self_40(Word16 *A)
: A[0]*A[0]+A[1]*A[1]+...+A[39]*A[39]
в
num8ı
A 8ֽڶ
*/

#include "oscl_base_macros.h"
#include "gsm_amr_typedefs.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
__asm Word32 mac_self_40_asm(Word16 *A)
{
        PRESERVE8
            
// Example 8.6
x   RN 0    // input array x[]
hi  RN 1    // accumulator
lo  RN 2    // accumulator

x_0 RN 3  
x_1 RN 4
x_2 RN 5
x_3 RN 6
x_4 RN 7  
x_5 RN 8
x_6 RN 9
x_7 RN 10
x_8 RN 11
x_9 RN 12


        STMFD   sp!, {r4-r11}
        MOV     hi, #0
        MOV     lo, #0        

//ѭ2
        LDMIA   x!, {x_0-x_9}
        SMLALD   lo, hi, x_0, x_0
        SMLALD   lo, hi, x_1, x_1
        SMLALD   lo, hi, x_2, x_2
        SMLALD   lo, hi, x_3, x_3
        SMLALD   lo, hi, x_4, x_4
        SMLALD   lo, hi, x_5, x_5
        SMLALD   lo, hi, x_6, x_6
        SMLALD   lo, hi, x_7, x_7
        SMLALD   lo, hi, x_8, x_8
        SMLALD   lo, hi, x_9, x_9


        LDMIA   x!, {x_0-x_9}
        SMLALD   lo, hi, x_0, x_0
        SMLALD   lo, hi, x_1, x_1
        SMLALD   lo, hi, x_2, x_2
        SMLALD   lo, hi, x_3, x_3
        SMLALD   lo, hi, x_4, x_4
        SMLALD   lo, hi, x_5, x_5
        SMLALD   lo, hi, x_6, x_6
        SMLALD   lo, hi, x_7, x_7
        SMLALD   lo, hi, x_8, x_8
        SMLALD   lo, hi, x_9, x_9




        LSL     hi, hi, #1
        LSLS    lo, lo, #1
        ADDCS   hi, hi, #1
        
        CMP     hi, lo, ASR #31
        MOVEQ   r0, lo
        LDRNE   r0, =0x7fffffff //ƽͣΪ
          
END        
        LDMFD   sp!, {r4-r11}

        BX      lr  
}
#endif
