// void cor_h_x(
//		Word16 h[],  /* (i) Q12 : impulse response of weighted synthesis filter */
//		Word16 x[],  /* (i) Q0  : target vector                                 */
//		Word16 dn[],  /* (o) <12bit : correlation between target and h[]         */
//       Word16 sf     /* (i): scaling factor: 2 for 12.2, 1 for others      */
//	    ) 
//  r0 --- h[]
//  r1 --- x[]
//  r2 --- dn[]
//  r3 --- sf

#include "oscl_base_macros.h"
#include "gsm_amr_typedefs.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)

__asm void cor_h_xnb_asm(Word16 h[],  Word16 x[], Word16 dn[],  Word16 sf)
{
    PRESERVE8
    IMPORT  zMmp_AmrNbLslRound
        
        STMFD     r13!, {r0 - r12, r14}
        SUB       r13, r13, #160        // ջռy32[40]40 * 4ֽڣ

        MOV       r11, #0               // r11 ڴi
        MOV       r4,  r1               // r4ڴ浱ǰʵxĵַ
        ADD       r6,  r1, #80          // r6ڴһxԪصһַõַܱ

        MOV       r12, r13              // r12Ϊy32׵ַ
//---------------		
// x0  x1  x2  x3
// h0  h1  h2  h3
//     h0  h1  h2
//         h0  h1
//             h0
//---------------
RollPre
        LDR     r1,  [r0], #4          // h[0], h[1]
        LDR     r5,  [r4], #4          // x[0], x[1]		
        LDR     r14, [r4], #4          // x[2], x[3]	
		
        SMULTB  r8, r5, r1
        SMUAD   r7, r5, r1  
		
        LDR     r2, [r0], #4          // h[2], h[3]	  @ ǰ
		
        SMUAD   r9, r14, r1
        SMLABT  r8, r14, r1, r8
        SMLAD   r7, r14, r2, r7
        
        SMULTB	r10,r14, r1
        SMLATB  r8, r14, r2, r8
        CMP     r4, r6
        BGE     Rolled               // XһԪأٹ
//---------------
// x4  x5  x6  x7
// h4  h5  h6  h7
// h3  h4  h5  h6
// h2  h3  h4  h5
// h1  h2  h3  h4
//----------------
        LDR     r5, [r4], #4          // x[4], x[5] ǰ 
Rolling 
        LDR     r3, [r0], #4          // h[4], h[5]	
        
		SMLATT  r10, r5, r1, r10
		SMLAD   r9,  r5, r2, r9
		SMLABT  r8,  r5, r2, r8
		SMLAD   r7,  r5, r3, r7
		
        SMLATB  r10, r5, r2, r10
        SMLATB  r8,  r5, r3, r8

        LDR     r14,[r4], #4          // x[6], x[7]
        LDR     r1, [r0], #4          // h[6], h[7]	
        SMLATT  r10, r14, r2, r10
        SMLAD   r9,  r14, r3, r9
        SMLABT  r8,  r14, r3, r8
        SMLAD   r7,  r14, r1, r7

        SMLATB  r10, r14, r3, r10
        SMLATB  r8,  r14, r1, r8
        
        MOV     r2, r1
        MOV     r1, r3
        CMP     r4, r6
        LDR     r5, [r4], #4         // x[8], x[9] ǰ 
        BLT     Rolling 

Rolled 
        // Ѿ4еĹͣݺ
		MOV     r7,  r7, LSL #1
		MOV     r8,  r8, LSL #1
		MOV     r9,  r9, LSL #1
		MOV     r10, r10, LSL #1
		
        STR     r7, [r12], #4         //save y32[0]  
        STR     r8, [r12], #4         //save y32[1] 
        STR     r9, [r12], #4         //save y32[2] 
        STR     r10,[r12], #4         //save y32[3] 
        
        // ѭ xʼλõ
        LDR     r4, [r13, #164]       //ȡxĳֵ    
        ADD     r11, r11, #1
        CMP     r11, #10              // ÿδ44 * 10 = 40
        ADDLT   r4, r4, r11, LSL #3   // XÿԪΪ2ֽڣÿμ4
        LDRLT   r0, [r13, #160]       // hĵַΪʼַ
        BLT     RollPre

        MOV     r12, r13              // ȡy׵ַ  
		MOV     r0, #0
		MOV     r1, #0
		MOV     r2, #0
		MOV     r3, #0
		MOV     r4, #0
		MOV     r11, #8               //Ϊ5 5 * 8 = 40

        LDR     r5, [r12], #4
GetTrackMax
		LDR     r6, [r12], #4
		LDR     r7, [r12], #4
		LDR     r8, [r12], #4
		LDR     r9, [r12], #4
		
		CMP     r5, #0
		RSBLT   r5, r5, #0           //ֵ
		CMP     r0, r5
		MOVLT   r0, r5
		
		CMP     r6, #0
		RSBLT   r6, r6, #0           //ֵ
		CMP     r1, r6
		MOVLT   r1, r6
		
		CMP     r7, #0
		RSBLT   r7, r7, #0           //ֵ
		CMP     r2, r7
		MOVLT   r2, r7

		CMP     r8, #0
		RSBLT   r8, r8, #0           //ֵ
		CMP     r3, r8
		MOVLT   r3, r8	

		CMP     r9, #0
		RSBLT   r9, r9, #0           //ֵ
		CMP     r4, r9
		MOVLT   r4, r9

        SUBS    r11, r11, #1
        LDR     r5, [r12], #4		
		BNE     GetTrackMax 

Gettot
        MOV r5, #5
        ADD r5, r5, r0, ASR #1
		ADD r5, r5, r1, ASR #1
		ADD r5, r5, r2, ASR #1
		ADD r5, r5, r3, ASR #1
		ADD r2, r5, r4, ASR #1
		
Normlize 
        LDR     r3, [r13, #172]
        EOR     r2, r2, r2, ASL #1
        CLZ     r1, r2
        SUB     r1, r1, r3            // j = norm_l(L_tot) - sf
        MOV     r0, r13
        LDR     r2, [r13, #168]       // dn 168 = 160 + 8
        BL      zMmp_AmrNbLslRound

cor_h_x_asm_end
        ADD     r13,  r13, #160
        LDMFD   r13!, {r0 - r12, r15}
}
#endif

