/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/****************************************************************************************
Portions of this file are derived from the following 3GPP standard:

    3GPP TS 26.173
    ANSI-C code for the Adaptive Multi-Rate - Wideband (AMR-WB) speech codec
    Available from http://www.3gpp.org

(C) 2007, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TTA, TTC)
Permission to distribute, modify and use this file under the standard license
terms listed above has been obtained from the copyright holder.
****************************************************************************************/
/*
------------------------------------------------------------------------------



 Pathname: ./src/pvamrwb_math_op.h

------------------------------------------------------------------------------
 INCLUDE DESCRIPTION

------------------------------------------------------------------------------
*/

#ifndef PVAMRWB_MATH_OP_H
#define PVAMRWB_MATH_OP_H


/*----------------------------------------------------------------------------
; INCLUDES
----------------------------------------------------------------------------*/

#include "pv_amr_wb_type_defs.h"
#include "pvamrwbdecoder_basic_op.h"

/*----------------------------------------------------------------------------
; DEFINES
----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------
; MACROS
; Define module specific macros here
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; EXTERNAL VARIABLES REFERENCES
----------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C"
{
#endif


    int32 one_ov_sqrt(      /* (o) Q31 : output value (range: 0<=val<1)         */
        int32 L_x          /* (i) Q0  : input value  (range: 0<=val<=7fffffff) */
    );

    //int32 power_of_2(       /* (o) Q0  : result       (range: 0<=val<=0x7fffffff) */
    //    int16 exponant,    /* (i) Q0  : Integer part.      (range: 0<=val<=30)   */
    //    int16 fraction     /* (i) Q15 : Fractionnal part.  (range: 0.0<=val<1.0) */
    //);
    extern const int16 table_pow2[];
    static_vo int32 power_of_2(                         /* (o) Q0  : result       (range: 0<=val<=0x7fffffff) */
        int16 exponant,    /* (i) Q0  : Integer part.      (range: 0<=val<=30)   */
        int16 fraction     /* (i) Q15 : Fractionnal part.  (range: 0.0<=val<1.0) */
    )
    {
        int16 exp, i, a, tmp;
        int32 L_x;

        L_x = fraction << 5;          /* L_x = fraction<<6           */
        i = (fraction >> 10);                  /* Extract b10-b16 of fraction */
        a = (int16)(L_x);                    /* Extract b0-b9   of fraction */
        a = (int16)(a & (int16) 0x7fff);

        L_x = ((int32)table_pow2[i]) << 15;    /* table[i] << 16        */
        //L_x = table_pow2_lsl[i];
        tmp = table_pow2[i] - table_pow2[i + 1];        /* table[i] - table[i+1] */
        //tmp = table_pow2_sub[i];
        L_x -= ((int32)tmp * a);             /* L_x -= tmp*a*2        */

        exp = 29 - exponant ;

        if (exp)
        {
            L_x = ((L_x >> exp) + ((L_x >> (exp - 1)) & 1));
        }

        return (L_x);
    }

    int32 Dot_product12(    /* (o) Q31: normalized result (1 < val <= -1) */
        int16 x[],         /* (i) 12bits: x vector                       */
        int16 y[],         /* (i) 12bits: y vector                       */
        int16 lg,          /* (i)    : vector length                     */
        int16 * exp        /* (o)    : exponent of result (0..+30)       */
    );

    int32 Dot_product12_asm(                      /* (o) Q31: normalized result (1 < val <= -1) */
		int16 x[],                           /* (i) 12bits: x vector                       */
		int16 y[],                           /* (i) 12bits: y vector                       */
		int16 lg,                            /* (i)    : vector length                     */
		int16 * exp                          /* (o)    : exponent of result (0..+30)       */
		);


    //int16 mult_int16_r(int16 var1, int16 var2);          /* Mult with round, 2 */
    static_vo int16 mult_int16_r(int16 var1, int16 var2)
    {
        int32 L_product_arr;

        L_product_arr = (int32) var1 * (int32) var2;      /* product */
        L_product_arr += (int32) 0x00004000L;      /* round */
        L_product_arr >>= 15;       /* shift */
        if ((L_product_arr >> 15) != (L_product_arr >> 31))
        {
            L_product_arr = (L_product_arr >> 31) ^ MAX_16;
        }

        return ((int16)L_product_arr);
    }

    int16 shr_rnd(int16 var1, int16 var2);         /* Shift right with round, 2  */

    int16 div_16by16(int16 var1, int16 var2);       /* Short division,       18  */


    //void int32_to_dpf(int32 L_32, int16 *hi, int16 *lo);
    static_vo void int32_to_dpf(int32 L_32, int16 *hi, int16 *lo)
    {
        *hi = (int16)(L_32 >> 16);
        *lo = (int16)((L_32 - (*hi << 16)) >> 1);
        return;
    }

    int32 mpy_dpf_32(int16 hi1, int16 lo1, int16 hi2, int16 lo2);


#define norm_s( x)    (normalize_amr_wb(  x) - 16)


#define extract_h( x)    (int16)(x>>16)
#define L_deposit_h( x)    (int32)(x<<16)

    //void one_ov_sqrt_norm(
    //    int32 * frac,      /* (i/o) Q31: normalized value (1.0 < frac <= 0.5) */
    //    int16 * exp        /* (i/o)    : exponent (value = frac x 2^exponent) */
    //);
extern const int16 table_isqrt[];
static_vo void one_ov_sqrt_norm(
                            int32 * frac,                        /* (i/o) Q31: normalized value (1.0 < frac <= 0.5) */
                            int16 * exp                          /* (i/o)    : exponent (value = frac x 2^exponent) */
)
{
    int16 i, a, tmp;


    if (*frac <= (int32) 0)
    {
        *exp = 0;
        *frac = 0x7fffffffL;
        return;
    }

    if ((*exp & 1) == 1)  /* If exponant odd -> shift right */
        *frac >>= 1;

    *exp = negate_int16((*exp -  1) >> 1);

    *frac >>= 9;
    i = extract_h(*frac);                  /* Extract b25-b31 */
    *frac >>= 1;
    a = (int16)(*frac);                  /* Extract b10-b24 */
    a = (int16)(a & (int16) 0x7fff);

    i -= 16;
    if ((i >= 0) && (i  <  49))
    {
	*frac = L_deposit_h(table_isqrt[i]);   /* table[i] << 16         */
	tmp = table_isqrt[i] - table_isqrt[i + 1];      /* table[i] - table[i+1]) */
	*frac = msu_16by16_from_int32(*frac, tmp, a);          /* frac -=  tmp*a*2       */
    }
    return;
}

    //void Lg2_normalized(
    //    int32 L_x,         /* (i) : input value (normalized)                    */
    //   int16 exp,         /* (i) : norm_l (L_x)                                */
    //    int16 *exponent,   /* (o) : Integer part of Log2.   (range: 0<=val<=30) */
    //    int16 *fraction    /* (o) : Fractional part of Log2. (range: 0<=val<1)  */
    //);
    extern const int16 Log2_norm_table[];
    static const int32 log2_tbl_lsl16[33] =
    {
        0,          0x5af0000,  0xb320000,  0x108c0000, 0x15c00000, 0x1acf0000, 
        0x1fbc0000, 0x24880000, 0x29350000, 0x2dc40000, 0x32370000, 0x368f0000,
        0x3ace0000, 0x3ef50000, 0x43040000, 0x46fc0000, 0x4adf0000, 0x4eae0000,
        0x52690000, 0x56110000, 0x59a70000, 0x5d2c0000, 0x609f0000, 0x64030000,
        0x67570000, 0x6a9b0000, 0x6dd10000, 0x70fa0000, 0x74140000, 0x77210000,
        0x7a220000, 0x7d170000, 0x7fff0000 
    };

    static const int16 log2_tbl_sub[32] =
    {
        -1455,    -1411,    -1370,    -1332,    -1295,    -1261,    -1228,    
        -1197,    -1167,    -1139,    -1112,    -1087,    -1063,    -1039, 
        -1016,    -995,     -975,     -955,     -936,     -918,     -901,
        -883,     -868,     -852,     -836,     -822,     -809,     -794,
        -781,     -769,     -757,     -744         
    };


    static_vo void Lg2_normalized(
        int32 L_x,         /* (i) : input value (normalized)                    */
        int16 exp,         /* (i) : norm_l (L_x)                                */
        int16 *exponent,   /* (o) : Integer part of Log2.   (range: 0<=val<=30) */
        int16 *fraction    /* (o) : Fractional part of Log2. (range: 0<=val<1)  */
    )
    {
        int16 i, a, tmp;
        int32 L_y;

        if (L_x <= (int32) 0)
        {
            *exponent = 0;
            *fraction = 0;;
            return;
        }

        *exponent = 30 - exp;

        L_x >>= 9;
        i = extract_h(L_x);                 /* Extract b25-b31 */
        L_x >>= 1;
        a = (int16)(L_x);                 /* Extract b10-b24 of fraction */
        a &= 0x7fff;

        i -= 32;
          if ((i >= 0) &&(i < sizeof(log2_tbl_sub) / sizeof(int16)))
        	{
	        //L_y = L_deposit_h(Log2_norm_table[i]);             /* table[i] << 16        */
	        L_y = log2_tbl_lsl16[i];
	        //tmp = Log2_norm_table[i] - Log2_norm_table[i + 1]; /* table[i] - table[i+1] */
	        tmp = log2_tbl_sub[i];

	        L_y = msu_16by16_from_int32(L_y, tmp, a);           /* L_y -= tmp*a*2        */

	        *fraction = extract_h(L_y);
        	}
        return;
    }

    //void amrwb_log_2(
    //   int32 L_x,        /* (i) : input value                                 */
    //    int16 *exponent,  /* (o) : Integer part of Log2.   (range: 0<=val<=30) */
    //    int16 *fraction   /* (o) : Fractional part of Log2. (range: 0<=val<1)*/
    //);
    static_vo void amrwb_log_2(
        int32 L_x,         /* (i) : input value                                 */
        int16 *exponent,   /* (o) : Integer part of Log2.   (range: 0<=val<=30) */
        int16 *fraction    /* (o) : Fractional part of Log2. (range: 0<=val<1) */
    )
    {
        int16 exp;

        exp = normalize_amr_wb(L_x);
        Lg2_normalized(shl_int32(L_x, exp), exp, exponent, fraction);
    }

#ifdef __cplusplus
}
#endif


#endif /*  PVAMRWB_MATH_OP_H */

