@/* Fractional interpolation of signal at position (frac/resol) *//* Fractional interpolation of signal at position (frac/resol) */
@static  int16 AmrWbInterpol(    /* return result of interpolation */
@    int16 * x,                  /* input vector                   */
@    const int16 *fir,           /* filter coefficient             */
@    int16 nb_coef               /* number of coefficients         */
@)
@****************************************************************
@ x         ---  r0
@ fir       ---  r1
@ nb_coef   ---  r2
#include "oscl_base_macros.h"
    .section  .text
    .type AmrWbInterpol_asm, %function
    .global   AmrWbInterpol_asm
#if (PV_CPU_ARCH_VERSION >= 6)
p_f     .req    r1
p_x     .req    r5
x_1     .req    r6    
x_2     .req    r7
f_1     .req    r8
f_2     .req    r9
s_1     .req    r10

AmrWbInterpol_asm:
        STMFD       r13!, {r4 - r12, r14}
        ADD         r3, r2, r2, LSL #1
        SUB         r3, r3, #1
        SUB         p_x, r0, r3, LSL #1

        MOV         s_1, #0x2000
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        LDR         x_2, [p_x], #4
        LDR         f_2, [p_f], #4
        SMLAD       s_1, x_1, f_1, s_1
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        SMLAD       s_1, x_2, f_2, s_1   @2
        LDR         x_2, [p_x], #4
        LDR         f_2, [p_f], #4
        SMLAD       s_1, x_1, f_1, s_1
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        SMLAD       s_1, x_2, f_2, s_1   @4
        LDR         x_2, [p_x], #4
        LDR         f_2, [p_f], #4
        SMLAD       s_1, x_1, f_1, s_1
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        SMLAD       s_1, x_2, f_2, s_1   @6
        LDR         x_2, [p_x], #4
        LDR         f_2, [p_f], #4
        SMLAD       s_1, x_1, f_1, s_1
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        SMLAD       s_1, x_2, f_2, s_1   @8
        LDR         x_2, [p_x], #4
        LDR         f_2, [p_f], #4
        SMLAD       s_1, x_1, f_1, s_1
        LDR         x_1, [p_x], #4
        LDR         f_1, [p_f], #4
        SMLAD       s_1, x_2, f_2, s_1   @10
        LDR         x_2, [p_x]
        LDR         f_2, [p_f]
        SMLAD       s_1, x_1, f_1, s_1
        SMLAD       s_1, x_2, f_2, s_1   @12

        SSAT        r0, #30, s_1
        MOV         r0, r0,  LSL #2

        MOV         r0, r0, ASR #16
        LDMFD       r13!, {r4 - r12, r15}
        
    @ENDFUNC
    .END
#endif

