//*****************************************************************/
//void band_pass_6k_7k(
//     Word16 signal[],        /* input:  signal                  */
//     Word16 lg,              /* input:  length of input         */
//     Word16 mem[],           /* in/out: memory (size=30)        */
//     Word16 x[]
//)
//*****************************************************************/
// r0    ---  signal[]   4ֽڶ
// r1    ---  lg         Ϊ4ı
// r2    ---  mem[]      4ֽڶ
// r3    ---  x[]        4ֽڶ
#include "oscl_base_macros.h"
#include "oscl_base.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
__asm  void band_pass_6k_7k_asm(
        int16 signal[],                      /* input:  signal                  */
        int16 lg,                            /* input:  length of input         */
        int16 mem[],                         /* in/out: memory (size=30)        */
        int16 x[]
    )
{
        PRESERVE8
        IMPORT  voAWB_Copy
        IMPORT  voAWB_fir_6k_7k


        STMFD         r13!, {r0 - r12, r14}
        MOV           r4, r0                      // copy signal[] address
        MOV           r5, r1                      // copy lg address
        MOV           r6, r2                      // copy mem[] address
        MOV           r7, r3                      // copy c[] address
         
        MOV           r0, r2                      // 1mem
        MOV           r1, r3                      // 2x
        MOV           r2, #30                     // 3L_FIR - 1
        BL            voAWB_Copy                  // copy(mem-r0, x-r1, 30-r2)
        
        MOV           r0, r4                      // ָr0 - r3
        MOV           r1, r5
        MOV           r2, r6
        MOV           r3, r7
        ADD           r7, r7, #60                 // |-----mem----|r7-----------|
        
        MOV           r5, r5, ASR #3              // ÿѭ8signal          		  
LOOP1
        LDRSH         r8,  [r4], #2
        LDRSH         r9,  [r4], #2
        MOV           r8,  r8, ASR #2
        MOV           r9,  r9, ASR #2
        LDRSH         r11, [r4], #2
        LDRSH         r12, [r4], #2
        MOV           r11, r11, ASR #2
        MOV           r12, r12, ASR #2
        STRH          r8,  [r7], #2
        STRH          r9,  [r7], #2
        STRH          r11, [r7], #2
        STRH          r12, [r7], #2
        LDRSH         r8,  [r4], #2
        LDRSH         r9,  [r4], #2
        MOV           r8,  r8, ASR #2
        MOV           r9,  r9, ASR #2
        LDRSH         r11, [r4], #2
        LDRSH         r12, [r4], #2
        MOV           r11, r11, ASR #2
        MOV           r12, r12, ASR #2
        STRH          r8,  [r7], #2
        STRH          r9,  [r7], #2
        STRH          r11, [r7], #2
        STRH          r12, [r7], #2
        ADD           r14, r14, #8
        SUBS          r5,  r5, #1
        BNE           LOOP1
        
        //ȫֱ
        LDR      r5, Lable1	         
        // r0 -- signal, r1 -- lg, r2 -- x, r3 -- xvaluer4 -- xvalue
        MOV      r1, r1, ASR #2
        MOV      r2, r3                    
LOOP2
        //1
        LDR      r3, [r2]
        LDR      r6, [r5]
        SMUAD    r10, r3, r6
		
        LDR      r4, [r2, #4]            //ǰ
		
        SMULTB   r11, r3, r6
        
        //2
        LDR      r7, [r5, #4]
        SMUAD    r12, r4, r6
        SMLABT   r11, r4, r6, r11
        SMLAD    r10, r4, r7, r10

		
        LDR      r3, [r2, #8]            //ǰ
        SMULTB   r14, r4, r6
        SMLATB   r11, r4, r7, r11
		  
        //3
        LDR      r8, [r5, #8]

        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
		
        LDR      r4, [r2, #12]           //ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        //4
        LDR      r9, [r5, #12]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
		
        LDR      r3, [r2, #16]            //ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
		  
        //5
        LDR      r6, [r5, #16]

        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
		LDR      r4, [r2, #20]            //ǰ
		
        SMLATB  r14, r3, r9, r14      
        SMLATB  r11, r3, r6, r11
		  
        //6
        LDR      r7, [r5, #20]
        
        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #24]            //ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        //7
        LDR      r8, [r5, #24]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #28]           //ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        //8
        LDR      r9, [r5, #28]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
	
        LDR      r3, [r2, #32]         // ǰ
        
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
        
        //9
        LDR      r6, [r5, #32]
        
        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
        LDR      r4, [r2, #36]         //ǰ

        SMLATB  r14, r3, r9, r14
        SMLATB  r11, r3, r6, r11
		  
        //10
        LDR      r7, [r5, #36]

        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #40]        //ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        //11
        LDR      r8, [r5, #40]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #44]        //ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        //12
        LDR      r9, [r5, #44]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
        
        LDR      r3, [r2, #48]       // ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
		  
        //13
        LDR      r6, [r5, #48]
        
        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
        LDR      r4, [r2, #52]        // ǰ
		
        SMLATB  r14, r3, r9, r14
        SMLATB  r11, r3, r6, r11
		  
        //14
        LDR      r7, [r5, #52]
        
        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #56]        //ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        //15
        LDR      r8, [r5, #56]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #60]           //ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        //16
        LDR      r9, [r5, #60]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLABB  r10, r4, r9, r10

        LDR     r3, [r2, #64]	          //ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11

  
        //β	  
        SMLABT  r14, r3, r8, r14
        SMLABB  r12, r3, r9, r12
        
        SMLATB  r14, r3, r9, r14

        ADD     r10, r10, #0x4000
        MOV     r10, r10, ASR #15
        STRH    r10, [r0], #2

        ADD     r11, r11, #0x4000
        MOV     r11, r11, ASR #15
        STRH    r11, [r0], #2

        ADD     r12, r12, #0x4000
        MOV     r12, r12, ASR #15
        STRH    r12, [r0], #2

        ADD     r14, r14, #0x4000
        MOV     r14, r14, ASR #15
        SUBS    r1, r1, #1               // ǰ
        STRH    r14, [r0], #2
        
        ADDNE   r2, r2, #8               // xʼַƶ8ֽ
        BNE     LOOP2
       
        LDR     r0, [r13, #12]           //ȡx׵ַ
        LDR     r1, [r13, #4]
        ADD     r0, r0, r1, LSL#1        // 1: x + lg
        LDR     r1, [r13, #8]            // 2mem address
        MOV     r2,  #30                 // 330
        BL      voAWB_Copy

Filt_6k_7k_end
        LDMFD   		r13!, {r0 - r12, r15}

Lable1
        DCD   		voAWB_fir_6k_7k
}

#endif
