@/*
@ ** Copyright 2003-2010, VisualOn, Inc.
@ **
@ ** Licensed under the Apache License, Version 2.0 (the "License");
@ ** you may not use this file except in compliance with the License.
@ ** You may obtain a copy of the License at
@ **
@ **     http://www.apache.org/licenses/LICENSE-2.0
@ **
@ ** Unless required by applicable law or agreed to in writing, software
@ ** distributed under the License is distributed on an "AS IS" BASIS,
@ ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@ ** See the License for the specific language governing permissions and
@ ** limitations under the License.
@ */

@**********************************************************************/
@void Filt_6k_7k(
@     Word16 signal[],                      /* input:  signal                  */
@     Word16 lg,                            /* input:  length of input         */
@     Word16 mem[]                          /* in/out: memory (size=30)        */
@)
@******************************************************************
@ r0    ---  signal[]
@ r1    ---  lg
@ r2    ---  mem[]

          .section  .text
          .type Filt_6k_7k_asm, %function
          .global  Filt_6k_7k_asm
          .extern  voAWB_Copy
          .extern  voAWB_fir_6k_7k
#include "oscl_base_macros.h"
Filt_6k_7k_asm:
#if (PV_CPU_ARCH_VERSION >= 6)
        STMFD   	  r13!, {r0 - r12, r14}
        SUB           r13,  r13, #240
        MOV           r3, r13
        MOV     	  r4, r0                      @ copy signal[] address
        MOV     	  r5, r1                      @ copy lg address
        MOV     	  r6, r2                      @ copy mem[] address
         
        MOV     	  r0, r2                      @ 1mem
        MOV     	  r1, r13                     @ 2x
        MOV     	  r2, #30                     @ 3L_FIR - 1
        LDR           r12, Lable_COPY
        BLX      	  r12                  @ copy(mem-r0, x-r1, 30-r2)
        
        MOV           r0, r4                      @ ָr0 - r3
        MOV           r1, r5
        MOV           r2, r6
        ADD           r7, r13, #60                 @ |-----mem----|r7-----------|
        
        MOV           r5, r5, ASR #3               @ ÿѭ8signal          		  
LOOP1:
        LDRSH         r8,  [r4], #2
        LDRSH         r9,  [r4], #2
        MOV           r8,  r8, ASR #2
        MOV           r9,  r9, ASR #2
        LDRSH         r11, [r4], #2
        LDRSH         r12, [r4], #2
        MOV           r11, r11, ASR #2
        MOV           r12, r12, ASR #2
        STRH          r8,  [r7], #2
        STRH          r9,  [r7], #2
        STRH          r11, [r7], #2
        STRH          r12, [r7], #2
        LDRSH         r8,  [r4], #2
        LDRSH         r9,  [r4], #2
        MOV           r8,  r8, ASR #2
        MOV           r9,  r9, ASR #2
        LDRSH         r11, [r4], #2
        LDRSH         r12, [r4], #2
        MOV           r11, r11, ASR #2
        MOV           r12, r12, ASR #2
        STRH          r8,  [r7], #2
        STRH          r9,  [r7], #2
        STRH          r11, [r7], #2
        STRH          r12, [r7], #2
        SUBS          r5,  r5, #1
        BNE           LOOP1
        
        @ȫֱ
        LDR      r5, Lable1	         
        @ r0 -- signal, r1 -- lg, r2 -- x, r3 -- xvaluer4 -- xvalue
        MOV      r1, r1, ASR #2
        MOV      r2, r13                    
LOOP2:
        @1
        LDR      r3, [r2]
        LDR      r6, [r5]
        SMUAD    r10, r3, r6
		
        LDR      r4, [r2, #4]            @ǰ
		
        SMULTB   r11, r3, r6
        
        @2
        LDR      r7, [r5, #4]
        SMUAD    r12, r4, r6
        SMLABT   r11, r4, r6, r11
        SMLAD    r10, r4, r7, r10

		
        LDR      r3, [r2, #8]            @ǰ
        SMULTB   r14, r4, r6
        SMLATB   r11, r4, r7, r11
		  
        @3
        LDR      r8, [r5, #8]

        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
		
        LDR      r4, [r2, #12]           @ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        @4
        LDR      r9, [r5, #12]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
		
        LDR      r3, [r2, #16]            @ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
		  
        @5
        LDR      r6, [r5, #16]

        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
		LDR      r4, [r2, #20]            @ǰ
		
        SMLATB  r14, r3, r9, r14      
        SMLATB  r11, r3, r6, r11
		  
        @6
        LDR      r7, [r5, #20]
        
        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #24]            @ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        @7
        LDR      r8, [r5, #24]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #28]           @ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        @8
        LDR      r9, [r5, #28]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
	
        LDR      r3, [r2, #32]         @ ǰ
        
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
        
        @9
        LDR      r6, [r5, #32]
        
        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
        LDR      r4, [r2, #36]         @ǰ

        SMLATB  r14, r3, r9, r14
        SMLATB  r11, r3, r6, r11
		  
        @10
        LDR      r7, [r5, #36]

        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #40]        @ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        @11
        LDR      r8, [r5, #40]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #44]        @ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        @12
        LDR      r9, [r5, #44]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLAD   r10, r4, r9, r10
        
        LDR      r3, [r2, #48]       @ ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11
		  
        @13
        LDR      r6, [r5, #48]
        
        SMLABT  r14, r3, r8, r14
        SMLAD   r12, r3, r9, r12
        SMLABT  r11, r3, r9, r11
        SMLAD   r10, r3, r6, r10
        
        LDR      r4, [r2, #52]        @ ǰ
		
        SMLATB  r14, r3, r9, r14
        SMLATB  r11, r3, r6, r11
		  
        @14
        LDR      r7, [r5, #52]
        
        SMLABT  r14, r4, r9, r14
        SMLAD   r12, r4, r6, r12
        SMLABT  r11, r4, r6, r11
        SMLAD   r10, r4, r7, r10
        
        LDR      r3, [r2, #56]        @ǰ
		
        SMLATB  r14, r4, r6, r14
        SMLATB  r11, r4, r7, r11
		  
        @15
        LDR      r8, [r5, #56]
        
        SMLABT  r14, r3, r6, r14
        SMLAD   r12, r3, r7, r12
        SMLABT  r11, r3, r7, r11
        SMLAD   r10, r3, r8, r10
        
        LDR      r4, [r2, #60]           @ǰ
		
        SMLATB  r14, r3, r7, r14
        SMLATB  r11, r3, r8, r11
		  
        @16
        LDR      r9, [r5, #60]
        
        SMLABT  r14, r4, r7, r14
        SMLAD   r12, r4, r8, r12
        SMLABT  r11, r4, r8, r11
        SMLABB  r10, r4, r9, r10

        LDR     r3, [r2, #64]	           @ǰ
		
        SMLATB  r14, r4, r8, r14
        SMLATB  r11, r4, r9, r11

  
        @β	  
        SMLABT  r14, r3, r8, r14
        SMLABB  r12, r3, r9, r12
        
        SMLATB  r14, r3, r9, r14

        ADD     r10, r10, #0x4000
        MOV     r10, r10, ASR #15
        STRH    r10, [r0], #2

        ADD     r11, r11, #0x4000
        MOV     r11, r11, ASR #15
        STRH    r11, [r0], #2

        ADD     r12, r12, #0x4000
        MOV     r12, r12, ASR #15
        STRH    r12, [r0], #2

        ADD     r14, r14, #0x4000
        MOV     r14, r14, ASR #15
        SUBS    r1, r1, #1               @ ǰ
        STRH    r14, [r0], #2
        
        ADDNE   r2, r2, #8               @ xʼַƶ8ֽ
        BNE     LOOP2
       
        LDR     r1, [r13, #244]
        ADD     r0, r13, r1, LSL#1       @ 1: x + lg
        LDR     r1, [r13, #248]          @ 2mem address
        MOV     r2,  #30                 @ 330
        LDR     r12, Lable_COPY
        BLX     r12

Filt_6k_7k_end:
        ADD     r13, r13, #240
        LDMFD   r13!, {r0 - r12, r15}

Lable1:
        .word   		voAWB_fir_6k_7k
#else
        STMFD   		r13!, {r4 - r12, r14}
        SUB    		r13, r13, #240              @ x[L_SUBFR16k + (L_FIR - 1)]
        MOV     		r8, r0                      @ copy signal[] address
        MOV     		r4, r1                      @ copy lg address
        MOV     		r5, r2                      @ copy mem[] address
        
        MOV     		r1, r13
        MOV     		r0, r2
        MOV     		r2, #30                     @ L_FIR - 1
        LDR             r12, Lable_COPY
        BLX      		r12                   @ memcpy(x, mem, (L_FIR - 1)<<1)
        
        LDR     		r10, Lable1                 @ get fir_7k address
        
        MOV           	r14, #0
        MOV                   r3, r8                      @ change myMemCopy to Copy, due to Copy will change r3 content
        ADD     	    	r6, r13, #60                @ get x[L_FIR - 1] address
        MOV           	r7, r3                      @ get signal[i]
LOOP1:
        LDRSH         	r8,  [r7], #2
        LDRSH         	r9,  [r7], #2
        MOV           	r8, r8, ASR #2
        MOV           	r9, r9, ASR #2
        LDRSH         	r11, [r7], #2
        LDRSH         	r12, [r7], #2
        MOV           	r11, r11, ASR #2
        MOV           	r12, r12, ASR #2
        STRH          	r8, [r6], #2
        STRH          	r9, [r6], #2
        STRH          	r11, [r6], #2
        STRH          	r12, [r6], #2
        LDRSH         	r8,  [r7], #2
        LDRSH         	r9,  [r7], #2
        MOV           	r8, r8, ASR #2
        MOV           	r9, r9, ASR #2
        LDRSH         	r11, [r7], #2
        LDRSH         	r12, [r7], #2
        MOV           	r11, r11, ASR #2
        MOV           	r12, r12, ASR #2
        STRH          	r8, [r6], #2
        STRH          	r9, [r6], #2
        STRH          	r11, [r6], #2
        STRH          	r12, [r6], #2
        ADD           	r14, r14, #8
        CMP           	r14, #80
        BLT           	LOOP1
        
        
        STR     		r5, [sp, #-4]               @ PUSH  r5 to stack
        
        @ not use registers: r4, r10, r12, r14, r5
        MOV     		r4, r13
        MOV     		r5, #0                      @ i = 0
LOOP2:
        LDR           	r0, [r10]
        
        LDRSH  	        r1, [r4]                   @ load x[i]
        LDRSH   	        r2, [r4, #60]              @ load x[i + 30]
        LDRSH                 r6, [r4, #2]               @ load x[i + 1]
        LDRSH                 r7, [r4, #58]              @ load x[i + 29]
        ADD                   r1, r1, r2                 @ x[i] + x[i + 30]
        ADD                   r6, r6, r7                 @ x[i + 1] + x[i + 29]
        LDRSH                 r8, [r4, #4]               @ load x[i + 2]
        LDRSH                 r9, [r4, #56]              @ load x[i + 28]
        
        SMULBB                r14, r1, r0                @ (x[i] + x[i + 30]) * fir_7k[0]
        ADD                   r8, r8, r9                 @ x[i + 2] + x[i + 28]
        SMLABT                r14, r6, r0, r14           @ (x[i + 1] + x[i + 29]) * fir_7k[1]
        
        LDR                   r0, [r10, #4]
        LDRSH                 r1, [r4, #6]               @ load x[i+3]
        LDRSH                 r2, [r4, #54]              @ load x[i+27]
        LDRSH                 r6, [r4, #8]               @ load x[i+4]
        LDRSH                 r7, [r4, #52]              @ load x[i+26]
        ADD                   r1, r1, r2                 @ x[i+3] + x[i+27]
        ADD                   r6, r6, r7                 @ x[i+4] + x[i+26]
        SMLABB                r14, r8, r0, r14           @ (x[i + 2] + x[i + 28]) * fir_7k[2]
        LDRSH                 r8, [r4, #10]              @ load x[i+5]
        LDRSH                 r9, [r4, #50]              @ load x[i+25]
        SMLABT                r14, r1, r0, r14           @ (x[i+3] + x[i+27]) * fir_7k[3]
        ADD                   r8, r8, r9                 @ x[i+5] + x[i+25]
        
        LDR                   r0, [r10, #8]
        LDRSH                 r1, [r4, #12]              @ x[i+6]
        LDRSH                 r2, [r4, #48]              @ x[i+24]
        SMLABB                r14, r6, r0, r14           @ (x[i+4] + x[i+26]) * fir_7k[4]
        LDRSH                 r6, [r4, #14]              @ x[i+7]
        LDRSH                 r7, [r4, #46]              @ x[i+23]
        SMLABT                r14, r8, r0, r14           @ (x[i+5] + x[i+25]) * fir_7k[5]
        LDR                   r0, [r10, #12]
        ADD                   r1, r1, r2                 @ (x[i+6] + x[i+24])
        ADD                   r6, r6, r7                 @ (x[i+7] + x[i+23])
        SMLABB                r14, r1, r0, r14           @ (x[i+6] + x[i+24]) * fir_7k[6]
        LDRSH                 r8, [r4, #16]              @ x[i+8]
        LDRSH                 r9, [r4, #44]              @ x[i+22]
        SMLABT                r14, r6, r0, r14           @ (x[i+7] + x[i+23]) * fir_7k[7]
        LDR                   r0, [r10, #16]
        LDRSH                 r1, [r4, #18]              @ x[i+9]
        LDRSH                 r2, [r4, #42]              @ x[i+21]
        LDRSH                 r6, [r4, #20]              @ x[i+10]
        LDRSH                 r7, [r4, #40]              @ x[i+20]
        ADD                   r8, r8, r9                 @ (x[i+8] + x[i+22])
        ADD                   r1, r1, r2                 @ (x[i+9] + x[i+21])
        ADD                   r6, r6, r7                 @ (x[i+10] + x[i+20])
        SMLABB                r14, r8, r0, r14           @ (x[i+8] + x[i+22]) * fir_7k[8]
        LDRSH                 r8, [r4, #22]              @ x[i+11]
        LDRSH                 r9, [r4, #38]              @ x[i+19]
        SMLABT                r14, r1, r0, r14           @ (x[i+9] + x[i+21]) * fir_7k[9]
        LDR                   r0, [r10, #20]
        LDRSH                 r1, [r4, #24]              @ x[i+12]
        LDRSH                 r2, [r4, #36]              @ x[i+18]
        SMLABB                r14, r6, r0, r14           @ (x[i+10] + x[i+20]) * fir_7k[10]
        LDRSH                 r6, [r4, #26]              @ x[i+13]
        ADD                   r8, r8, r9                 @ (x[i+11] + x[i+19])
        LDRSH                 r7, [r4, #34]              @ x[i+17]
        SMLABT                r14, r8, r0, r14           @ (x[i+11] + x[i+19]) * fir_7k[11]
        LDR                   r0, [r10, #24]
        ADD                   r1, r1, r2                 @ x[i+12] + x[i+18]
        LDRSH                 r8, [r4, #28]              @ x[i+14]
        SMLABB                r14, r1, r0, r14           @ (x[i+12] + x[i+18]) * fir_7k[12]
        ADD                   r6, r6, r7                 @ (x[i+13] + x[i+17])
        LDRSH                 r9, [r4, #32]              @ x[i+16]
        SMLABT                r14, r6, r0, r14           @ (x[i+13] + x[i+17]) * fir_7k[13]
        LDR                   r0, [r10, #28]
        ADD                   r8, r8, r9                 @ (x[i+14] + x[i+16])
        LDRSH                 r1, [r4, #30]              @ x[i+15]
        SMLABB                r14, r8, r0, r14           @ (x[i+14] + x[i+16]) * fir_7k[14]
        SMLABT                r14, r1, r0, r14           @ x[i+15] * fir_7k[15]
        
        ADD     		r5, r5, #1
        ADD     		r14, r14, #0x4000
        ADD     		r4, r4, #2
        MOV     		r1, r14, ASR #15
        CMP     		r5, #80
        STRH    		r1, [r3], #2               @signal[i] = (L_tmp + 0x4000) >> 15
        BLT     		LOOP2
        
        LDR     		r1, [sp, #-4]               @mem address
        ADD     		r0, r13, #160               @x + lg
        MOV     		r2, #30
        LDR             r12, Lable_COPY
        BLX      		r12
        
Filt_6k_7k_end:
        ADD     		r13, r13, #240
        LDMFD   		r13!, {r4 - r12, r15}
        
Lable1:
        .word   		voAWB_fir_6k_7k
        
#endif       

Lable_COPY:
    .word   voAWB_Copy
        @ENDFUNC
        .END
