//void LP_Decim2(
//		Word16 x[],                           /* in/out: signal to process         */
//		Word16 l,                             /* input : size of filtering         */
//		Word16 mem[]                          /* in/out: memory (size=3)           */
//	      );
// x --- r0
// l --- 256
// mem-- r2

#include "oscl_base_macros.h"
#include "gsm_amr_typedefs.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)

__asm void LP_Decim2_asm(
		Word16 x[],                           /* in/out: signal to process         */
		Word16 l,                             /* input : size of filtering         */
		Word16 mem[]                          /* in/out: memory (size=3)           */
	      )
{
    PRESERVE8
    IMPORT   h_fir
 
    STMFD    r13!, {r4 - r12, r14}	
    LDR      r4,  =520
    SUB      r13, r13, r4              // x_buf[256 + 3]
    
    //for (i = 0; i < L_MEM; i++)	
    MOV      r4, r13                   //r4 ָx_buf
    LDRSH    r5, [r2]
    LDRSH    r6, [r2, #2]
    LDRSH    r7, [r2, #4]
    STRH     r5, [r4], #2
    STRH     r6, [r4], #2
    STRH     r7, [r4], #2
    
    LDR      r8, =510
    ADD      r3, r0, r8
    LDRSH    r5, [r3, #-4]
    LDRSH    r6, [r3, #-2]
    LDRSH    r7, [r3]
    STRH     r5, [r2], #2
    STRH     r6, [r2], #2
    STRH     r7, [r2]
    
    //for (i = 0; i < 256; i++)
    MOV      r14, #32                       // iÿο832
    MOV      r3,  r0

MOV_X
    LDRSH   r5, [r3], #2
    LDRSH   r6, [r3], #2
    LDRSH   r7, [r3], #2
    LDRSH   r8, [r3], #2
    STRH    r5, [r4], #2
    STRH    r6, [r4], #2
    STRH    r7, [r4], #2
    STRH    r8, [r4], #2
    
    LDRSH   r5, [r3], #2
    LDRSH   r6, [r3], #2
    LDRSH   r7, [r3], #2
    LDRSH   r8, [r3], #2
    STRH    r5, [r4], #2
    STRH    r6, [r4], #2
    STRH    r7, [r4], #2
    STRH    r8, [r4], #2
    SUBS    r14, r14, #1
    BNE     MOV_X	
    
    MOV     r4, r13
    
    LDR     r12, Lable1               // r5-r7h_fir
    LDRSH   r5, [r12], #2
    LDRSH   r6, [r12], #2
    LDRSH   r7, [r12], #2
    LDRSH   r8, [r12], #2
    PKHBT   r5, r5, r6, LSL #16	
    PKHBT   r6, r7, r8, LSL #16	
    LDRSH   r7, [r12]
    
    //for (i = 0; i < l; i += 2)
    MOV     r14, #128                    // 
    MOV     r4, r13
    LDR     r2, =0x4000
    LDRSH   r8,  [r4], #2	
    LDRSH   r9,  [r4], #2
    LDRSH   r10, [r4], #2
    LDRSH   r11, [r4], #2
    LDRSH   r12, [r4], #2
    
Get_New_x
    SMULBB  r1,  r8,  r5
    MOV     r8,  r10
    SMLABT  r1,  r9,  r5, r1
    MOV     r9,  r11
    SMLABB  r1,  r10, r6, r1
    MOV     r10,  r12
    SMLABT  r1,  r11, r6, r1
    LDRSH   r11, [r4], #2
    SMLABB  r1,  r12, r7, r1
    LDRSH   r12, [r4], #2
    SUBS    r14, r14, #1
    ADD     r1, r1, r2
    MOV     r1, r1, ASR #15
    STRH    r1, [r0], #2
    BNE     Get_New_x

the_end
    LDR     r4,  =520
    ADD     r13, r13, r4 
    LDMFD   r13!, {r4 - r12, r15}
    
Lable1
    DCD   	h_fir
}
#endif




