/*
@ ** Copyright 2003-2010, VisualOn, Inc.
@ **
@ ** Licensed under the Apache License, Version 2.0 (the "License");
@ ** you may not use this file except in compliance with the License.
@ ** You may obtain a copy of the License at
@ **
@ **     http://www.apache.org/licenses/LICENSE-2.0
@ **
@ ** Unless required by applicable law or agreed to in writing, software
@ ** distributed under the License is distributed on an "AS IS" BASIS,
@ ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@ ** See the License for the specific language governing permissions and
@ ** limitations under the License.
@ */
//
//void Scale_sig(
//	       Word16 x[],                           /* (i/o) : signal to scale               */
//	       Word16 lg,                            /* (i)   : size of x[]                   */
//	       Word16 exp                            /* (i)   : exponent: x = round(x << exp) */
//	       )
//
//r0 --- x[]
//r1 --- lg
//r2 --- exp

#include "oscl_base_macros.h"
#include "gsm_amr_typedefs.h"

#if (PV_COMPILER == EPV_ARM_RVCT)

__asm void Scale_sig_opt(
     Word16 x[],                           /* (i/o) : signal to scale               */
     Word16 lg,                            /* (i)   : size of x[]                   */
     Word16 exp                            /* (i)   : exponent: x = round(x << exp) */
)
{
        PRESERVE8
            
#if (PV_CPU_ARCH_VERSION >= 6)
        STMFD       r13!, {r4 - r12, r14}
        CMP         r2, #0                      
        ADD         r4, r0, r1, LSL #1          
        MOV         r9, #0x8000
        BLE         LOOP2                       
LOOP1
        SUBS        r3, r1, #2                 
        ADD         r10, r2, #16               
        BLT         LOOP1_1
LOOP1_2
        LDRSH       r5, [r4,#-2]!                 
        LDRSH       r6, [r4,#-2]!
        MOV         r12, r5, LSL r10	
        TEQ         r5, r12, ASR r10	 
        EORNE       r12, r8, r5, ASR #31
        MOV         r7, r6, LSL r10	 
        TEQ         r6, r7, ASR r10	 
        EORNE       r7, r8, r6, ASR #31
        QADD        r11, r12, r9   
        QADD        r8,  r7, r9
        SUBS        r3, r3, #2       
        PKHTB       r14, r11, r8, ASR #16
        STR         r14,[r4]
        BGE         LOOP1_2
LOOP1_1
        ADD         r3, #2
        CMP         r3, #0
        BEQ         The_end
        LDRSH       r5, [r4,#-2]!                    
        MOV         r12, r5, LSL r10	 
        TEQ         r5, r12, ASR r10	 
        EORNE       r12, r8, r5, ASR #31
        SUBS        r3, r3, #1
        QADD        r11, r12, r9               
        MOV         r12, r11, ASR #16
        STRH        r12, [r4]
        BL          The_end
LOOP2
        SUBS        r3, r1, #2                 
        RSB         r7, r2, #0                 
        BLT         LOOP2_1
        MOV         r11, #0
LOOP2_2
        LDR         r5, [r4,#-4]!                    
        PKHTB       r6, r5, r11
        PKHBT       r10, r11, r5, LSL #16
        MOV         r12, r6, ASR r7             
        MOV         r10, r10, ASR r7
        QADD        r10, r10, r9
        QADD        r12, r12, r9
        SUBS        r3, r3, #2
        PKHTB       r10, r12, r10, ASR #16
        STR         r10,[r4]
        BGE         LOOP2_2
LOOP2_1
        ADD         r3, r3, #2                  
        CMP         r3, #0
        BEQ         The_end
        LDRSH       r5, [r4,#-2]!              
        MOV         r6, r5, LSL #16            
        MOV         r12, r6, ASR r7            
        QADD        r11, r12, r9
        MOV         r12, r11, ASR #16
        SUBS        r3, r3, #1
        STRH        r12, [r4]
The_end
        LDMFD       r13!, {r4 - r12, r15}
#else
        STMFD       r13!, {r4 - r12, r14}
	    SUB         r3, r1, #1                  //i = lg - 1
        CMP         r2, #0                      //Compare exp and 0
        RSB         r7, r2, #0                  //exp = -exp
        ADD         r10, r2, #16                //16 + exp
        ADD         r4, r0, r3, LSL #1          //x[i] address
        MOV         r8, #0x7fffffff
        MOV         r9, #0x8000
        BLE         LOOP2
LOOP1

        LDRSH       r5, [r4]                    //load x[i]
        MOV         r12, r5, LSL r10
	    TEQ         r5, r12, ASR r10
	    EORNE       r12, r8, r5, ASR #31
	    SUBS        r3, r3, #1
	    QADD        r11, r12, r9
	    MOV         r12, r11, ASR #16
	    STRH        r12, [r4], #-2
	    BGE         LOOP1
        BL          The_end
LOOP2

        LDRSH       r5, [r4]                   //load x[i]
	    MOV         r6, r5, LSL #16            //L_tmp = x[i] << 16
	    MOV         r5, r6, ASR r7             //L_tmp >>= exp
	    QADD        r11, r5, r9
	    MOV         r12, r11, ASR #16
	    SUBS        r3, r3, #1
	    STRH        r12, [r4], #-2
	    BGE         LOOP2
The_end
        LDMFD         r13!, {r4 - r12, r15}
#endif
}
#endif

