/* ------------------------------------------------------------------
 * Copyright (C) 2009 Martin Storsjo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */

#ifndef OSCL_BASE_H
#define OSCL_BASE_H

//#include <stdint.h>

typedef signed char    int8;
typedef signed short   int16;
typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned int   uint32;
typedef signed int     int32;

#ifndef _WIN32
typedef unsigned long long  int64;    /*!< 64-bit unsigned integer */
typedef   signed long long  uint64;    /*!< 64-bit signed integer */
#else
typedef unsigned __int64    int64;    /*!< 64-bit unsigned integer */
typedef   signed __int64    uint64;    /*!< 64-bit signed integer */
#endif


#define OSCL_IMPORT_REF
#define OSCL_EXPORT_REF
#define OSCL_UNUSED_ARG(x) (void)(x)

#endif
