/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/****************************************************************************************
Portions of this file are derived from the following 3GPP standard:

    3GPP TS 26.073
    ANSI-C code for the Adaptive Multi-Rate (AMR) speech codec
    Available from http://www.3gpp.org

(C) 2004, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TTA, TTC)
Permission to distribute, modify and use this file under the standard license
terms listed above has been obtained from the copyright holder.
****************************************************************************************/
/*

 Filename: sub.h

------------------------------------------------------------------------------
 INCLUDE DESCRIPTION

 This file contains all the constant definitions and prototype definitions
 needed by the sub function.

------------------------------------------------------------------------------
*/

/*----------------------------------------------------------------------------
; CONTINUE ONLY IF NOT ALREADY DEFINED
----------------------------------------------------------------------------*/
#ifndef SUB_H
#define SUB_H

/*----------------------------------------------------------------------------
; INCLUDES
----------------------------------------------------------------------------*/
#include    "basicop_malloc.h"

/*--------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C"
{
#endif

    /*----------------------------------------------------------------------------
    ; MACROS
    ; Define module specific macros here
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; DEFINES
    ; Include all pre-processor statements here.
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; EXTERNAL VARIABLES REFERENCES
    ; Declare variables used in this module but defined elsewhere
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; SIMPLE TYPEDEF'S
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; ENUMERATED TYPEDEF'S
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; STRUCTURES TYPEDEF'S
    ----------------------------------------------------------------------------*/

    /*----------------------------------------------------------------------------
    ; GLOBAL FUNCTION DEFINITIONS
    ; Function Prototype declaration
    ----------------------------------------------------------------------------*/
OSCL_EXPORT_REF static inline Word16 sub(Word16 var1, Word16 var2)
{
#if  ((PV_CPU_ARCH_VERSION >=6) && (PV_COMPILER == EPV_ARM_GNUC))
    register Word32 diff;
    register Word32 ra = var1;
    register Word32 rb = var2;

    asm volatile(
        "qsub16 %0, %1, %2"
        :"=r"(diff) :"r"(ra), "r"(rb)
    );
    return ((Word16)diff);
#elif ((PV_CPU_ARCH_VERSION >=6) && (PV_COMPILER == EPV_ARM_RVCT))
    register Word32 diff;
    register Word32 ra = var1;
    register Word32 rb = var2;

    __asm{qsub16 diff, ra, rb};
    return ((Word16)diff);
#else
    Word32 diff;

    diff = (Word32) var1 - var2;

    /* Saturate result (if necessary). */
    /* Replaced function call with in-line code             */
    /*  to conserve MIPS, i.e., var_out = saturate (diff)  */


    if ((UWord32)(diff + 32768) > 0x000FFFF)
    {
        if (diff > (Word32) 0x0007FFFL)
        {
            diff = MAX_16;
        }
        else
        {
            diff = MIN_16;
        }

    }


    return ((Word16) diff);
#endif
}


    /*----------------------------------------------------------------------------
    ; END
    ----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif  /* _SUB_H_ */
