/*
v_memmove( void *dest, void *src, size_t len);
src,dest 4ֽڶ
src>dest
len >=32
*/
#include "oscl_base_macros.h"
#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
#define size_t int
__asm void memmove_asm( void *dest, void *src, size_t len)
{
        PRESERVE8
            
dest  RN 0
src   RN 1
len   RN 2

s_0   RN 3
s_1   RN 4
s_2   RN 5
s_3   RN 6
s_4   RN 7
s_5   RN 8
s_6   RN 9
s_7   RN 10

        STMFD   sp!, {r4-r10, lr}      
        SUB     len, len, #32   
LOOP
        LDM     src!,  {s_0-s_7}
        SUBS    len, len, #32
        STM     dest!, {s_0-s_7}

//LOOP END
        BGE       LOOP
       
        ADDS      len, len, #32
        BEQ       END        
        
        TST       len, #16
        LDMNE     src!,  {s_0-s_3}
        STMNE     dest!, {s_0-s_3}        
        TST       len, #8
        LDMNE     src!,  {s_4-s_5}
        STMNE     dest!, {s_4-s_5}
        TST       len, #4
        LDMNE     src,  {s_6}
        STMNE     dest, {s_6}
END
        LDMFD   sp!, {r4-r10, pc}
}
#endif

