/*
void Pred_lt_3or6 (
    Word16 exc[],  
    Word16 T0,    
    Word16 frac,  
    Word16 L_subfr,  
    Word16 flag3     
)
{
    Word16 i, j, k;
    Word16 *x0, *x1, *x2;
    const Word16 *c1, *c2;
    Word32 s;

    x0 = &exc[-T0];             move16 (); 

    frac = negate (frac);
    test();
    if (flag3 != 0)
    {
      frac = shl (frac, 1);   
    }
    
    test (); 
    if (frac < 0)
    {
        frac = add (frac, UP_SAMP_MAX);
        x0--;
    }

    for (j = 0; j < L_subfr; j++)
    {
        x1 = x0++;              move16 (); 
        x2 = x0;                move16 (); 
        c1 = &inter_6[frac];
        c2 = &inter_6[sub (UP_SAMP_MAX, frac)];

        s = 0;                  move32 (); 
        for (i = 0, k = 0; i < L_INTER10; i++, k += UP_SAMP_MAX)
        {
            s = L_mac (s, x1[-i], c1[k]);
            s = L_mac (s, x2[i], c2[k]);
        }

        exc[j] = round (s);     move16 (); 
    }

    return;
}

*/
#include "oscl_base_macros.h"
#if (PV_CPU_ARCH_VERSION >= 6)
	.text
	.align	5
	.word	0
	.global Pred_lt_3or6_asm
	.type   Pred_lt_3or6_asm, function

#ֲƫ
.equ	P_C0, 0
.equ	P_C1, 4
.equ	P_EXC, 8
.equ  I, 12
.equ	LOC_SIZE, 16
.equ	FLAG3,  (LOC_SIZE+10*4)
.equ	INFO,   (LOC_SIZE+10*4 + 4)

c_0    .req  r0
c_1    .req  r1
c_2    .req  r2
c_3    .req  r3
c_4    .req  r4

x_0    .req  r5
x_1    .req  r6
x_2    .req  r7
x_3    .req  r8
x_4    .req  r9

s_0    .req  r10
s_1    .req  r11

p_x    .req  r12
p_exc  .req  r14


@¸ļĴ

p_c    .req  r14
i      .req  r5


	.macro LOAD reg, off
				LDR     \reg, [sp, #\off]
	.endm

	.macro STORE reg, off
				STR     \reg, [sp, #\off]
	.endm
	
	.macro LOG s1, s2
	      LOAD    r14, INFO
	      STM     r14!, {\s1, \s2}
	      STORE   r14, INFO
	.endm	

INTER_6_0:
  .hword 34, -120, 308, -634, 1099, -1666,  2259, -2783,  3143, 29443
  .hword 73, -163, 340, -602,  904, -1147,  1170, -672,  -1352, 28346
  .hword 91, -165, 296, -451,  550,  -464,     0,  1211, -4402, 25207
  .hword 89, -132, 198, -231,  135,   218, -1001,  2536, -5865, 20449
  .hword 70, -79,   78,    0, -245,   756, -1652,  3130, -5850, 14701
  .hword 38, -19,  -36,  191, -514,  1060, -1868,  2991, -4673,  8693
  .hword 0,   34, -120,  308, -634,  1099, -1666,  2259, -2783,  3143

INTER_6_1:
  .hword 29443,  3143, -2783,  2259, -1666, 1099, -634,  308, -120, 34
  .hword 28346, -1352,  -672,  1170, -1147,  904, -602,  340, -163, 73
  .hword 25207, -4402,  1211,     0,  -464,  550, -451,  296, -165, 91
  .hword 20449, -5865,  2536, -1001,   218,  135, -231,  198, -132, 89
  .hword 14701, -5850,  3130, -1652,   756, -245,    0,   78,  -79, 70
  .hword  8693, -4673,  2991, -1868,  1060, -514,  191,  -36,  -19, 38          
  .hword  3143, -2783,  2259, -1666,  1099, -634,  308, -120,   34,  0




Pred_lt_3or6_asm:
        STMFD   sp!, {r4-r12, lr}
        SUB     sp, sp, #LOC_SIZE   @ֲ

#ʼ
        STORE  r0, P_EXC

        MOV    r4, #20
        STORE  r4, I

//      x0 = &exc[-T0];             move16 ();
//      frac = negate (frac);        
//      if (flag3 != 0)
//      {
//          frac = shl (frac, 1);
//      }
        LOAD    r14, FLAG3
        RSB     r2, r2, #0
        SUB     r0, r0, r1, LSL #1
        CMP     r14, #0
        LSLNE   r2, r2, #1
        
//      if (frac < 0)
//      {
//          frac = add (frac, UP_SAMP_MAX);
//          x0--;
//      }        
        LDR       r14, =INTER_6_0
        
        CMP       r2, #0
        ADDLT     r2, r2, #6
        SUBLT     r0, r0, #2

        ADD       r4, r14, r2, LSL #4  @r14+r2*20
        ADD       r4, r4, r2, LSL #2 
        STORE     r4, P_C0
        PLD       [r4]
        
        LDR       r14, =INTER_6_1
        
        RSB       r2, r2, #6
        ADD       r5, r14, r2, LSL #4  @r14+r2*20
        ADD       r5, r5, r2, LSL #2 
        STORE     r5, P_C1
        PLD       [r5]
       
        SUB       p_x, r0, #18
        TST       p_x, #2
        BNE       X_NOT_ALIGN
        
        
LOOP1:
        LOAD      p_c, P_C0
        LDM       p_x!, {x_0-x_4}        
        LDM       p_c, {c_0-c_4}

        MOV       s_0, #0x4000
        MOV       s_1, #0x4000

        SMLAD     s_0, x_0, c_0, s_0
        SMLATB    s_1, x_0, c_0, s_1
        SMLABT    s_1, x_1, c_0, s_1
        SMLAD     s_0, x_1, c_1, s_0
        SMLATB    s_1, x_1, c_1, s_1
        SMLABT    s_1, x_2, c_1, s_1
        SMLAD     s_0, x_2, c_2, s_0
        SMLATB    s_1, x_2, c_2, s_1
        SMLABT    s_1, x_3, c_2, s_1
        SMLAD     s_0, x_3, c_3, s_0                
        SMLATB    s_1, x_3, c_3, s_1
        SMLABT    s_1, x_4, c_3, s_1
        SMLAD     s_0, x_4, c_4, s_0    
        SMLATB    s_1, x_4, c_4, s_1
        
        LOAD      p_c, P_C1        
        LDM       p_x!, {x_0-x_4}        
        SMLABT    s_1, x_0, c_4, s_1                    

        LDM       p_c, {c_0-c_4}

        SMLAD     s_0, x_0, c_0, s_0
        SMLATB    s_1, x_0, c_0, s_1
        SMLABT    s_1, x_1, c_0, s_1
        SMLAD     s_0, x_1, c_1, s_0
        SMLATB    s_1, x_1, c_1, s_1        
        SMLABT    s_1, x_2, c_1, s_1
        SMLAD     s_0, x_2, c_2, s_0
        SMLATB    s_1, x_2, c_2, s_1 
        SMLABT    s_1, x_3, c_2, s_1
        SMLAD     s_0, x_3, c_3, s_0                
        SMLATB    s_1, x_3, c_3, s_1         
        SMLABT    s_1, x_4, c_3, s_1
        SMLAD     s_0, x_4, c_4, s_0    
        LDRSH     x_0, [p_x]
        SMLATB    s_1, x_4, c_4, s_1    

        SUB       p_x, #36
        SMLABT    s_1, x_0, c_4, s_1

//LOG s_0, s_1

        LOAD      p_exc, P_EXC
        ASR       s_0, s_0, #15
        ASR       s_1, s_1, #15
        LOAD      i, I
        STRH      s_0, [p_exc], #2
        STRH      s_1, [p_exc], #2
        STORE     p_exc, P_EXC

        SUBS      i, #1
        STORE     i, I
        BNE       LOOP1

END:
        ADD     sp, sp, #(LOC_SIZE)   @ֲͷ
        LDMFD   sp!, {r4-r12, pc}
        
        
#xĴ        

X_NOT_ALIGN:

LOOP_2:
        LOAD      p_c, P_C0
        LDRSH     x_0, [p_x], #2        
        LDM       p_x!, {x_1-x_4}        
        LDM       p_c, {c_0-c_4}
        
        MOV       s_0, #0x4000
        MOV       s_1, #0x4000

        SMLAD     s_1, x_1, c_0, s_1

        SMLABB    s_0, x_0, c_0, s_0
        SMLABT    s_0, x_1, c_0, s_0        
        
        SMLAD     s_1, x_2, c_1, s_1 
        
        SMLATB    s_0, x_1, c_1, s_0      
        SMLABT    s_0, x_2, c_1, s_0        

        SMLAD     s_1, x_3, c_2, s_1                

        SMLATB    s_0, x_2, c_2, s_0
        SMLABT    s_0, x_3, c_2, s_0        

        SMLAD     s_1, x_4, c_3, s_1  

        SMLATB    s_0, x_3, c_3, s_0        
        SMLABT    s_0, x_4, c_3, s_0        
        SMLATB    s_0, x_4, c_4, s_0        
        
        
        LDM       p_x!, {x_0-x_4}        
        
        LOAD      p_c, P_C1
        
        SMLABT    s_0, x_0, c_4, s_0                
        SMLAD     s_1, x_0, c_4, s_1             


        LDM       p_c, {c_0-c_4}

        SMLATB    s_0, x_0, c_0, s_0
        SMLABT    s_0, x_1, c_0, s_0        

        SMLAD     s_1, x_1, c_0, s_1
         
        SMLATB    s_0, x_1, c_1, s_0      
        SMLABT    s_0, x_2, c_1, s_0        
        
        SMLAD     s_1, x_2, c_1, s_1        
        
        SMLATB    s_0, x_2, c_2, s_0
        SMLABT    s_0, x_3, c_2, s_0        

        SMLAD     s_1, x_3, c_2, s_1    

        SMLATB    s_0, x_3, c_3, s_0        
        SMLABT    s_0, x_4, c_3, s_0        

        LDM       p_x, {x_0}

        SMLAD     s_1, x_4, c_3, s_1   
        
        SMLATB    s_0, x_4, c_4, s_0        

        SMLABT    s_0, x_0, c_4, s_0        
        SMLAD     s_1, x_0, c_4, s_1   

//LOG s_0, s_1

        SUB       p_x, p_x, #34


        LOAD      p_exc, P_EXC
        ASR       s_0, s_0, #15
        ASR       s_1, s_1, #15

        LOAD      i, I
        STRH      s_0, [p_exc], #2
        STRH      s_1, [p_exc], #2
        STORE     p_exc, P_EXC


        SUBS      i, #1
        STORE     i, I
        BNE       LOOP_2


        B END
#endif
