@ amr-nb residu
@ 2013-05-08 By Myp
@ void Residu(
@	    Word16 a[],                           /* (i) Q12 : prediction coefficients */
@	    Word16 x[],                           /* (i)     : speech (values x[-m..-1] are needed */
@	    Word16 y[],                           /* (o) x2  : residual signal       */
@	    Word16 lg                             /* (i)     : size of filtering     */
@	   )
@a[] --- r0
@x[] --- r1
@y[] --- r2
@lg  --- r3
#include "oscl_base_macros.h"
    .section  .text
    .type Residu_asm, %function  
    .global   Residu_asm

Residu_asm:
#if (PV_CPU_ARCH_VERSION >= 6)
    STMFD   r13!, {r4 - r12, r14}
    
    LDRH    r5, [r0], #2
    LDRH    r6, [r0], #2
    ORR     r5, r6, r5, LSL #16                  @r5 --- a0, a1
    
    LDRH    r6, [r0], #2
    LDRH    r7, [r0], #2
    ORR     r6, r7, r6, LSL #16                  @r6 --- a2, a3
    
    LDRH    r7, [r0], #2
    LDRH    r8, [r0], #2
    ORR     r7, r8, r7, LSL #16                  @r7 --- a4, a5
    
    LDRH    r8, [r0], #2
    LDRH    r9, [r0], #2
    ORR     r8, r9, r8, LSL #16                  @r8 --- a6, a7
    
    LDRH    r9, [r0], #2
    LDRH    r10, [r0], #2
    ORR     r9, r10, r9, LSL #16                 @r9 --- a8, a9
    
    LDRH    r10, [r0], #2                        @r10 --- --a10
    
    MOV     r14, r3, ASR #2                      @one loop get 4 outputs
    ADD     r1, r1, #4
    MOV     r0, r2

residu_loop:
    LDR     r2, [r1], #-4               @r2  --- x[3], x[2]
    
    SMUAD   r12, r5, r2                 @i4 * a0 + i4 * a1	
    SMULTB  r11, r5, r2                 @i3 * a0
    
    LDR     r2,  [r1], #-4              @r2   --- x[1], x[0]
    
    SMUAD   r4,  r5, r2                 @i2 * a0 + i2 * a1
    SMLABT  r11, r5, r2, r11            @i3 * a1
    SMLAD   r12, r6, r2, r12            @i4 * a2 + i4 * a3	
    SMULTB  r3, r5, r2                  @i1 * a0
    SMLATB  r11, r6, r2, r11            @i3 * a2
    
    LDR     r2, [r1], #-4               @r2 ---- x[-1], x[-2]
    
    SMLABT  r3, r5, r2, r3              @i1 * a1
    SMLAD   r4, r6, r2, r4              @i2 * a2 + i2 * a3
    SMLABT  r11, r6, r2, r11            @i3 * a3
    SMLAD   r12, r7, r2, r12            @i4 * a4 + i4 * a5	
    SMLATB  r3, r6, r2, r3              @i1 * a2
    SMLATB  r11,r7, r2, r11				@i3 * a4
    
    LDR	    r2,[r1],#-4
    
    SMLABT	r3, r6, r2, r3				@ i1 * a3
    SMLAD	r4, r7, r2, r4				@ i2 * a4 + i2 * a5
    SMLABT	r11,r7, r2, r11				@ i3 * a5
    SMLAD	r12,r8, r2, r12				@ i4 * a6 + i4 * a7	
    SMLATB	r3, r7, r2, r3				@ i1 * a4
    SMLATB	r11,r8, r2, r11				@ i3 * a6
    
    LDR	    r2,[r1],#-4
    
    SMLABT	r3, r7, r2, r3				@ i1 * a5
    SMLAD	r4, r8, r2, r4				@ i2 * a6 + i2 * a7
    SMLABT	r11,r8, r2, r11				@ i3 * a7
    SMLAD	r12,r9, r2, r12				@ i4 * a8 + i4 * a9	
    SMLATB	r3, r8, r2, r3				@ i1 * a6
    SMLATB	r11,r9, r2, r11				@ i3 * a8
    
    LDR	    r2,[r1],#-4 
    
    SMLABT	r3, r8, r2, r3				@ i1 * a7
    SMLAD	r4, r9, r2, r4				@ i2 * a8 + i2 * a9
    SMLABT	r11,r9, r2, r11				@ i3 * a9
    SMLABT  r12,r10,r2, r12             @ i4 * a10
    
    SMLATB	r3, r9, r2, r3				@ i1 * a8
    SMLABB  r11,r10,r2, r11             @ i3 * a10
    
    LDR	    r2,[r1],#32
    
    SMLABT	r3, r9, r2, r3				@ i1 * a9
    SMLABT	r4, r10,r2, r4              @ i2 * a10
    
    SMLABB	r3, r10,r2, r3              @ i1 * a10
    
    MOV	    r2,#2048                    @ round,1000 0000 0000
    QADD    r3,r3,r2
    QADD    r4,r4,r2
    QADD    r11,r11,r2
    QADD    r12,r12,r2
    
    SSAT    r3,#16,r3,ASR #12
    SSAT    r4,#16,r4,ASR #12
    SSAT    r11,#16,r11,ASR #12
    SSAT    r12,#16,r12,ASR #12
    
    STRH	r3,[r0],#2
    STRH	r4,[r0],#2
    STRH	r11,[r0],#2
    STRH	r12,[r0],#2
    
    SUBS	r14,r14,#1                  @ lg = lg - 4, ֮ǰһr142λ
    BNE	    residu_loop
end:
    LDMFD	r13!, {r4 -r12,pc}
#endif
    @ENDFUNC
    .END





