/*******************************************************************************
* Ȩ (C)2012, ͨѶɷ޹˾
* 
* ļ:     wbt_pub.h
* ļʶ:     wbt_pub.h
* ժҪ:     ׺вԹģͷļ
* ʹ÷:     #include "wbt_pub.h"
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2012/11/05      V1.0        Create                    
* 
*******************************************************************************/

#ifndef _TEST_PUB_H
#define _TEST_PUB_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"


#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
//ecos_ramlog_printf(fmt, ##__VA_ARGS__);
#define wbt_printf(fmt, ...)  zOss_Printf(1, 1, fmt, ##__VA_ARGS__);      




/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef unsigned  long long int wbt_tick_t;
typedef double wbt_time_t;

typedef struct
{
    wbt_time_t max;
    wbt_time_t min;
    wbt_time_t mean;
    wbt_time_t sum;
} wbt_result_t;

typedef struct wbt_entry
{
    const char *name;
    void (*func)(struct wbt_entry *entry);
    int cnt;
    wbt_tick_t *buf;
    void *data;
} wbt_entry_t;

typedef void (*wbt_func_t)(wbt_entry_t *entry);


/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ȡǰtick
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰtick
* ˵:     void
*******************************************************************************/
static inline wbt_tick_t wbt_get_tick(void)
{
    //return *(volatile wbt_tick_t *)0xf4b00010;
    return (wbt_tick_t)(*(volatile unsigned int *)0xf4b00010) | ((wbt_tick_t)((*(volatile unsigned int *)0xf4b0002c)&0xFFFFFF) << 32);
}


/*******************************************************************************
* :     tickֵȡǰʱ
* ˵:     
*   ()  tick:   tickֵ
*   ()  void
*   ֵ:     ǰʱ
* ˵:     void
*******************************************************************************/
static inline wbt_time_t wbt_get_time(wbt_tick_t tick)
{
    return (wbt_time_t)((wbt_time_t)tick / (wbt_time_t)52);
}


/*******************************************************************************
* :     ׺вԹõıȽϺ
* ˵:     
*   ()  obj1:   1ָ
                obj2:   2ָ
*   ()  void
*   ֵ:     ֵıȽϽ
                *obj1 > *obj2:  ֵ
                *obj1 = *obj2:  ֵ
                *obj1 < *obj2:  ظֵ
* ˵:     Ϊ׼CqsortĲ
*******************************************************************************/
static inline int wbt_compare(const void *obj1, const void *obj2)
{
    return (int)(*(wbt_tick_t *)obj1 - *(wbt_tick_t *)obj2);
}

void wbt_calculate_result(wbt_entry_t *entry, wbt_result_t *result);
void wbt_print_result(wbt_entry_t *entry, wbt_result_t *result);
void wbt_oss_stdlib(void);

#ifdef __cplusplus
}
#endif

#endif	// #ifndef _TEST_PUB_H

