/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   :  efrģ
*    :  zmmp_efr_test.c
* ļ : 
* ʵֹ :  efrԴ
*      :  
*      : 
*  :  20140520
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "wavreader.h"
#include "wavwriter.h"
#include "mmp_efr_api.h"
#include "zmmp_efr_fnc.h"
#include "zmmp_efr_test.h"
#include "typedef.h"


#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#if defined (_OS_TOS)
#define ZMMP_LOCK(old_intr)         cyg_scheduler_lock();      
#define ZMMP_UNLOCK(old_intr)       cyg_scheduler_unlock(); 
#elif defined (_OS_OSE)
//#include "Osa_itrapi.h"
#define ZMMP_LOCK(old_intr)         ZOSS_SAVE_IRQ(old_intr);
#define ZMMP_UNLOCK(old_intr)       ZOSS_RESTORE_IRQ(old_intr);
#endif


#define ZEFR_MAX_CMD_PARAM_LENGTH   (15) 
#define ZEFR_STACK_SIZE             (1024 * 20)
#define ZEFR_MAX_FILE_NAME_LENGTH   (50)
#define ZEFR_PCM_FRAME_SIZE         (320)       /*λֽ                   */
#define ZEFR_PCM_SAMPLE_RATE        (8000)
#define ZEFR_PCM_SAMPLE_BIT         (16)
#define ZEFR_READ_MODE              "rb"
#define ZEFR_WRITE_MODE             "wb"
#define BIT_0                        0
#define BIT_1                        1
#define MAX_16                       (Word16)0x7fff
#define MIN_16                       (Word16)0x8000
UINT32  g_zEfr_funcTicks = 0;


/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*efr_TestFunc)(VOID); /* frԺָ */

/*ṹ*/
typedef struct 
{
	CHAR            *pCmd;  /*          */
	efr_TestFunc     func;   /*ú      */
	CHAR            *pDesc; /*  */
} T_zEfr_TestCmd;  


/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID efr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable);
static VOID efr_DecTest(char *pInFilePath, char *pOutFilePath);
static VOID efr_EncThreadEntry(SINT32 arg);
static VOID efr_DecThreadEntry(SINT32 arg);
static VOID efr_CodecThreadEntry(SINT32 arg);
static VOID   efr_PrintCmds(VOID);
static SINT32 efr_FindCmds(const CHAR *pMmpCmd);
static VOID   efr_ExcuteCmds(SINT32 iCmdIndex);
static VOID   efr_TestEntry(SINT32 arg);
static VOID   efr_TestEnc_1(VOID); 
static VOID   efr_TestEnc_2(VOID); 
static VOID   efr_TestEnc_3(VOID); 
static VOID   efr_TestEnc_4(VOID); 
static VOID   efr_TestEnc_5(VOID); 
static VOID   efr_TestEnc_6(VOID); 
static VOID   efr_TestEnc_7(VOID); 
static VOID   efr_TestEnc_8(VOID); 
static VOID   efr_TestEnc_9(VOID); 
static VOID   efr_TestEnc_10(VOID); 
static VOID   efr_TestEnc_11(VOID); 
static VOID   efr_TestEnc_12(VOID); 
static VOID   efr_TestEnc_13(VOID); 
static VOID   efr_TestEnc_14(VOID); 
static VOID   efr_TestEnc_15(VOID); 
static VOID   efr_TestEnc_16(VOID); 
static VOID   efr_TestEnc_17(VOID); 
static VOID   efr_TestEnc_18(VOID); 
static VOID   efr_TestEnc_19(VOID); 
static VOID   efr_TestEnc_20(VOID); 
static VOID   efr_TestEnc_21(VOID); 
static VOID   efr_TestEnc_22(VOID); 
static VOID   efr_TestEnc_23(VOID); 
static VOID   efr_TestEnc_24(VOID); 

static VOID   efr_TestDec_1(VOID); 
static VOID   efr_TestDec_2(VOID); 
static VOID   efr_TestDec_3(VOID); 
static VOID   efr_TestDec_4(VOID); 
static VOID   efr_TestDec_5(VOID); 
static VOID   efr_TestDec_6(VOID); 
static VOID   efr_TestDec_7(VOID); 
static VOID   efr_TestDec_8(VOID); 
static VOID   efr_TestDec_9(VOID); 
static VOID   efr_TestDec_10(VOID); 
static VOID   efr_TestDec_11(VOID); 
static VOID   efr_TestDec_12(VOID); 
static VOID   efr_TestDec_13(VOID); 
static VOID   efr_TestDec_14(VOID); 
static VOID   efr_TestDec_15(VOID); 
static VOID   efr_TestDec_16(VOID); 
static VOID   efr_TestDec_17(VOID); 
static VOID   efr_TestDec_18(VOID); 
static VOID   efr_TestDec_19(VOID); 
static VOID   efr_TestDec_20(VOID); 
static VOID   efr_TestDec_21(VOID); 
static VOID   efr_TestDec_22(VOID); 
static VOID   efr_TestDec_23(VOID); 
static VOID   efr_TestDec_24(VOID); 
static VOID   efr_TestAPIEnc(VOID);
static VOID   efr_TestAPIDec(VOID);
static VOID   efr_TestCodec(VOID); 
static BOOL efr_IsFileEqual(const char *strFileName1, const char *strFileName2);
static BOOL efr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler);

extern Word16 efr_shl (Word16 var1, Word16 var2);
/**************************************************************************
* ȫֳ/
**************************************************************************/

CHAR                *g_zEfr_Cmd                              = NULL;
ZOSS_SEMAPHORE_ID   g_zEfr_shellSemaphoreID                  = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zEfr_testSemaphoreID                   = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zEfr_ThreadSemaphoreID                 = ZOSS_NULL;

/* ý */
static T_zEfr_TestCmd g_zEfr_TestCmds[] = 
{     
    {"efrEnc1",   (efr_TestFunc)efr_TestEnc_1,   "efr1"                    },
    {"efrEnc2",   (efr_TestFunc)efr_TestEnc_2,   "efr2"                    },
    {"efrEnc3",   (efr_TestFunc)efr_TestEnc_3,   "efr3"                    },
    {"efrEnc4",   (efr_TestFunc)efr_TestEnc_4,   "efr4"                    },
    {"efrEnc5",   (efr_TestFunc)efr_TestEnc_5,   "efr5"                    },
    {"efrEnc6",   (efr_TestFunc)efr_TestEnc_6,   "efr6"                    },
    {"efrEnc7",   (efr_TestFunc)efr_TestEnc_7,   "efr7"                    },
    {"efrEnc8",   (efr_TestFunc)efr_TestEnc_8,   "efr8"                    },
    {"efrEnc9",   (efr_TestFunc)efr_TestEnc_9,   "efr9"                    },
    {"efrEnc10",  (efr_TestFunc)efr_TestEnc_10,  "efr10"                    },
    {"efrEnc11",  (efr_TestFunc)efr_TestEnc_11,  "efr11"                    },
    {"efrEnc12",  (efr_TestFunc)efr_TestEnc_12,  "efr12"                    },
    {"efrEnc13",  (efr_TestFunc)efr_TestEnc_13,  "efr13"                    },
    {"efrEnc14",  (efr_TestFunc)efr_TestEnc_14,  "efr14"                    },
    {"efrEnc15",  (efr_TestFunc)efr_TestEnc_15,  "efr15"                    },
    {"efrEnc16",  (efr_TestFunc)efr_TestEnc_16,  "efr16"                    },
    {"efrEnc17",  (efr_TestFunc)efr_TestEnc_17,  "efr17"                    },
    {"efrEnc18",  (efr_TestFunc)efr_TestEnc_18,  "efr18"                    },
    {"efrEnc19",  (efr_TestFunc)efr_TestEnc_19,  "efr19"                    },
    {"efrEnc20",  (efr_TestFunc)efr_TestEnc_20,  "efr20"                    },
    {"efrEnc21",  (efr_TestFunc)efr_TestEnc_21,  "efr21"                    },
    {"efrEnc22",  (efr_TestFunc)efr_TestEnc_22,  "efr22"                    },
    {"efrEnc23",  (efr_TestFunc)efr_TestEnc_23,  "efr23"                    },
    {"efrEnc24",  (efr_TestFunc)efr_TestEnc_24,  "efr24"                    },
      
    {"efrDec1",  (efr_TestFunc)efr_TestDec_1,  "efr1"                    },      
    {"efrDec2",  (efr_TestFunc)efr_TestDec_2,  "efr2"                    },      
    {"efrDec3",  (efr_TestFunc)efr_TestDec_3,  "efr3"                    },      
    {"efrDec4",  (efr_TestFunc)efr_TestDec_4,  "efr4"                    },      
    {"efrDec5",  (efr_TestFunc)efr_TestDec_5,  "efr5"                    },      
    {"efrDec6",  (efr_TestFunc)efr_TestDec_6,  "efr6"                    },      
    {"efrDec7",  (efr_TestFunc)efr_TestDec_7,  "efr7"                    },      
    {"efrDec8",  (efr_TestFunc)efr_TestDec_8,  "efr8"                    },      
    {"efrDec9",  (efr_TestFunc)efr_TestDec_9,  "efr9"                    },      
    {"efrDec10", (efr_TestFunc)efr_TestDec_10, "efr10"                   },      
    {"efrDec11", (efr_TestFunc)efr_TestDec_11, "efr11"                   },      
    {"efrDec12", (efr_TestFunc)efr_TestDec_12, "efr12"                   },
    {"efrDec13", (efr_TestFunc)efr_TestDec_13, "efr13"                    },      
    {"efrDec14", (efr_TestFunc)efr_TestDec_14, "efr14"                    },      
    {"efrDec15", (efr_TestFunc)efr_TestDec_15, "efr15"                    },      
    {"efrDec16", (efr_TestFunc)efr_TestDec_16, "efr16"                    },      
    {"efrDec17", (efr_TestFunc)efr_TestDec_17, "efr17"                    },      
    {"efrDec18", (efr_TestFunc)efr_TestDec_18, "efr18"                    },      
    {"efrDec19", (efr_TestFunc)efr_TestDec_19, "efr19"                    },      
    {"efrDec20", (efr_TestFunc)efr_TestDec_20, "efr20"                   },      
    {"efrDec21", (efr_TestFunc)efr_TestDec_21, "efr21"                   },      
    {"efrDec22", (efr_TestFunc)efr_TestDec_22, "efr22"                   },
    {"efrDec23", (efr_TestFunc)efr_TestDec_23, "efr23"                    },      
    {"efrDec24", (efr_TestFunc)efr_TestDec_24, "efr24"                    },
        
    {"efrAPIEnc", (efr_TestFunc)efr_TestAPIEnc, "ӿڣ"            },      
    {"efrAPIDec", (efr_TestFunc)efr_TestAPIDec, "ӿڣ"            },      

    {"efrCodec", (efr_TestFunc)efr_TestCodec, "efr"                    }

};

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* :  1,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_1(VOID) 
{

    zOss_Printf(1, 1, "zEfr_TestEnc_1 start");   
    efr_EncTest("C:/TEST0.wav","C:/TEST0.cod", 1);   
    zOss_Printf(1, 1, "zEfr_TestEnc_1 end");
}
/**************************************************************************
* :  2,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_2(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_2 start");   
    efr_EncTest("C:/TEST1.wav","C:/TEST1.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_2 end");
}
/**************************************************************************
* :  3,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_3(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_3 start");   
    efr_EncTest("C:/TEST2.wav","C:/TEST2.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_3 end");
}

/**************************************************************************
* :  4,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_4(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_4 start");   
    efr_EncTest("C:/TEST3.wav","C:/TEST3.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_4 end");
}

/**************************************************************************
* :  5,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_5(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_5 start");   
    efr_EncTest("C:/TEST4.wav","C:/TEST4.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_5 end");
}
/**************************************************************************
* :  6,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_6(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_6 start");   
    efr_EncTest("C:/TEST5.wav","C:/TEST5.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_6 end");
}
/**************************************************************************
* :  7,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_7(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_7 start");   
    efr_EncTest("C:/TEST6.wav","C:/TEST6.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_7 end");
}
/**************************************************************************
* :  8,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_8(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_8 start");   
    efr_EncTest("C:/TEST7.wav","C:/TEST7.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_8 end");
}
/**************************************************************************
* :  9,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_9(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_9 start");   
    efr_EncTest("C:/TEST8.wav","C:/TEST8.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_9 end");
}

/**************************************************************************
* :  10,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_10(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_10 start");   
    efr_EncTest("C:/TEST9.wav","C:/TEST9.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_10 end");
}
/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* :  11,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_11(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_11 start");   
    efr_EncTest("C:/TEST10.wav","C:/TEST10.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_11 end");
}
/**************************************************************************
* :  12,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_12(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_12 start");   
    efr_EncTest("C:/TEST11.wav","C:/TEST11.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_12 end");
}
/**************************************************************************
* :  13,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_13(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_13 start");   
    efr_EncTest("C:/TEST12.wav","C:/TEST12.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_13 end");
}

/**************************************************************************
* :  14,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_14(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_14 start");   
    efr_EncTest("C:/TEST13.wav","C:/TEST13.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_14 end");
}

/**************************************************************************
* :  15,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_15(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_15 start");   
    efr_EncTest("C:/TEST14.wav","C:/TEST14.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_15 end");
}
/**************************************************************************
* :  16,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_16(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_16 start");   
    efr_EncTest("C:/TEST15.wav","C:/TEST15.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_16 end");
}
/**************************************************************************
* :  17,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_17(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_17 start");   
    efr_EncTest("C:/TEST16.wav","C:/TEST16.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_17 end");
}
/**************************************************************************
* :  18,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_18(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_18 start");   
    efr_EncTest("C:/DTX01.wav","C:/DTX01.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_18 end");
}
/**************************************************************************
* :  19,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_19(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_19 start");   
    efr_EncTest("C:/DTX02.wav","C:/DTX02.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_19 end");
}

/**************************************************************************
* :  20,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_20(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_20 start");   
    efr_EncTest("C:/DTX03.wav","C:/DTX03.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_20 end");
}
/**************************************************************************
* :  21,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_21(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_21 start");   
    efr_EncTest("C:/DTX04.wav","C:/DTX04.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_21 end");
}
/**************************************************************************
* :  22,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_22(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_22 start");   
    efr_EncTest("C:/DTX05.wav","C:/DTX05.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_22 end");
}
/**************************************************************************
* :  23,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_23(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_23 start");   
    efr_EncTest("C:/DTX06.wav","C:/DTX06.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_23 end");
}
/**************************************************************************
* :  24,dtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestEnc_24(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestEnc_24 start");   
    efr_EncTest("C:/DTX07.wav","C:/DTX07.cod", 1);
    zOss_Printf(1, 1, "zEfr_TestEnc_24 end");
}

/**************************************************************************
* :  1
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_1(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_1 start");   
    efr_DecTest("C:/TEST0.DEC", "C:/TEST0_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_1 end");
}
/**************************************************************************
* :  2
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_2(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_2 start");   
    efr_DecTest("C:/TEST1.DEC", "C:/TEST1_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_2 end");

}
/**************************************************************************
* :  3
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_3(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_3 start");   
    efr_DecTest("C:/TEST2.DEC", "C:/TEST2_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_3 end");

}
/**************************************************************************
* :  4
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_4(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_4 start");   
    efr_DecTest("C:/TEST3.DEC", "C:/TEST3_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_4 end");
}
/**************************************************************************
* :  5
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_5(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_5 start");   
    efr_DecTest("C:/TEST4.DEC", "C:/TEST4_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_5 end");
}

/**************************************************************************
* :  6,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_6(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_6 start");   
    efr_DecTest("C:/TEST5.DEC", "C:/TEST5_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_6 end");
}
/**************************************************************************
* :  7,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_7(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_7 start");   
    efr_DecTest("C:/TEST6.DEC", "C:/TEST6_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_7 end");
}
/**************************************************************************
* :  8,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_8(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_8 start");   
    efr_DecTest("C:/TEST7.DEC", "C:/TEST7_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_8 end");
}
/**************************************************************************
* :  9,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_9(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_9 start");   
    efr_DecTest("C:/TEST8.DEC", "C:/TEST8_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_9 end");
}

/**************************************************************************
* :  10,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_10(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_10 start");   
    efr_DecTest("C:/TEST9.DEC", "C:/TEST9_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_10 end");
}

/**************************************************************************
* :  11,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_11(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_11 start");   
    efr_DecTest("C:/TEST10.DEC", "C:/TEST10_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_11 end");
}

/**************************************************************************
* :  12,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_12(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_12 start");   
    efr_DecTest("C:/TEST11.DEC", "C:/TEST11_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_12 end");
}
/**************************************************************************
* :  13,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_13(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_13 start");   
    efr_DecTest("C:/TEST12.DEC", "C:/TEST12_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_13 end");
}
/**************************************************************************
* :  14,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_14(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_14 start");   
    efr_DecTest("C:/TEST13.DEC", "C:/TEST13_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_14 end");
}
/**************************************************************************
* :  15,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_15(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_15 start");   
    efr_DecTest("C:/TEST14.DEC", "C:/TEST14_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_15 end");
}
/**************************************************************************
* :  16,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_16(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_16 start");   
    efr_DecTest("C:/TEST15.DEC", "C:/TEST15_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_16 end");
}
/**************************************************************************
* :  17,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_17(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_17 start");   
    efr_DecTest("C:/TEST16.DEC", "C:/TEST16_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_17 end");
}
/**************************************************************************
* :  18,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_18(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_18 start");   
    efr_DecTest("C:/DTX01.DEC", "C:/DTX01_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_18 end");
}
/**************************************************************************
* :  19,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_19(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_19 start");   
    efr_DecTest("C:/DTX02.DEC", "C:/DTX02_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_19 end");
}
/**************************************************************************
* :  20,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_20(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_20 start");   
    efr_DecTest("C:/DTX03.DEC", "C:/DTX03_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_20 end");
}
/**************************************************************************
* :  21,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_21(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_21 start");   
    efr_DecTest("C:/DTX04.DEC", "C:/DTX04_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_21 end");
}
/**************************************************************************
* :  22,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_22(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_22 start");   
    efr_DecTest("C:/DTX05.DEC", "C:/DTX05_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_22 end");
}
/**************************************************************************
* :  23,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_23(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_23 start");   
    efr_DecTest("C:/DTX06.DEC", "C:/DTX06_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_23 end");
}
/**************************************************************************
* :  24,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_TestDec_24(VOID) 
{
    zOss_Printf(1, 1, "zEfr_TestDec_24 start");   
    efr_DecTest("C:/DTX07.DEC", "C:/DTX07_OUT.wav");
    zOss_Printf(1, 1, "zEfr_TestDec_24 end");
}

/**************************************************************************
* :     ʵб
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/

static VOID efr_TestCodec(VOID) 
{
    ZOSS_THREAD_ID     mutiThreadID    = ZOSS_NULL;
    zOss_Printf(1, 1, "zEfr_TestCodec start");  
    mutiThreadID = zOss_CreateThread("codecThread",
                                     efr_CodecThreadEntry,
                                     0,
                                     ZEFR_STACK_SIZE,
                                     18,
                                     1,
                                     1);

    if(mutiThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "efr_TestCodec:zOss_CreateThread failed");
    }
    zOss_Printf(1, 1, "zEfr_TestCodec end");    
}

/**************************************************************************
* :     ȡpcm
* ˵:     
*   ()  pPcmHandle:  wavļ
*   ()  pcmSrc:      ȡpcmݴ洢buffer
*   ֵ:     ɹ1ʧܷ0
* ˵:    
**************************************************************************/
static UINT8 efr_EncReadDate(VOID *pPcmHandle, UINT16 pcmSrc[])
{
    
    UINT16 readSize     = 0;
    
    readSize = zOss_FRead(pcmSrc, 1, ZEFR_PCM_FRAME_SIZE, ((wav_reader *)pPcmHandle)->wav);  
    if(readSize != ZEFR_PCM_FRAME_SIZE)
    {
        if(zOss_FEof(((wav_reader *)pPcmHandle)->wav) == 0)
        {
            zOss_Printf(1, 1, "efr_EncReadDate: readfile error , error code: %d", readSize);
        }
        return 0;
    }
    return 1;    
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 efr_EncodeFrame(VOID *pPcmHandle, FILE *pGsmHandle, T_zEfr_OprElem *pOprElem)
{
    UINT16          pcmSrc[160]     = {0};
    UINT16	        gsmDst[250]      = {0};
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT32          old_intr;
    
    zOss_ASSERT(pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);
    
    if (!efr_EncReadDate(pPcmHandle, pcmSrc))
    {
            return 0;
    }

    ZMMP_LOCK(old_intr);
    beginTicks = zEfr_GetTick();
    mmp_EfrEncode(pcmSrc, gsmDst);
    endTicks   = zEfr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zEfr_AddTicks(pOprElem, endTicks - beginTicks);
    
    if(zOss_FWrite(gsmDst, 1, 246 * 2, pGsmHandle) !=  246 * 2)
    {
        zOss_Printf(1, 1,  "efr_EncodeFrame: writefile error");
        return 0;
    }
    return 1;
}
/**************************************************************************
* :     
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID efr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable)
{
    //CHAR  pInFilePath[ZEFR_MAX_FILE_NAME_LENGTH]     = "C:/hr.wav"; 
    //CHAR  pOutFilePath[ZEFR_MAX_FILE_NAME_LENGTH]    = "C:/hr.cod";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zEfr_OprElem   oprElem                         = {0};
    char  pRefFilePath[ZEFR_MAX_FILE_NAME_LENGTH]   = {0};

    g_zEfr_funcTicks = 0;
    mmp_EfrEncOpen(dtxEnable);

    pPcmHandle = wav_read_open(pInFilePath);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open");
        return ;
    }

    pGsmHandle = zOss_FOpen(pOutFilePath, ZEFR_WRITE_MODE);
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open");
        return ;
    } 
    
    zEfr_ResetOprElem(&oprElem);  
    while(efr_EncodeFrame(pPcmHandle, pGsmHandle, &oprElem));
    zEfr_PutoutOprElem(&oprElem);
    
    mmp_EfrEncClose();
    wav_read_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".ref");
    zOss_Printf(1, 1, "begin compare output encoded file with reference emcoded file!");  

    if(efr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "encode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "encode fail!!");  

    }
    zOss_Printf(1, 1, "end compare output encoded file with reference emcoded file!");  

    return;
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 efr_DecodeFrame(FILE *pGsmHandle, VOID *pPcmHandle, T_zEfr_OprElem *pOprElem)
{
    UINT16          pcmDst[160]     = {0};
    UINT16          gsmSrc[250]      = {0};
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT16          readSize        = 0;
    UINT32          old_intr        = 0;
        
    zOss_ASSERT(pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);
    
    readSize  = zOss_FRead(gsmSrc, sizeof (UINT16), 247, pGsmHandle);
    if (readSize != 247) /*ļȡʧ*/ 
    {   
        return 0;
    }

    ZMMP_LOCK(old_intr);
    beginTicks = zEfr_GetTick();
    mmp_EfrDecode(gsmSrc, pcmDst);
    endTicks   = zEfr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zEfr_AddTicks(pOprElem, endTicks - beginTicks);
    
    if(zOss_FWrite(pcmDst, 1, ZEFR_PCM_FRAME_SIZE , ((wav_writer *)pPcmHandle)->wav) !=  ZEFR_PCM_FRAME_SIZE)
    {
        zOss_Printf(1, 1,  "efr_DecodeFrame: writefile error");
        return 0;
    }
    ((wav_writer *)pPcmHandle)->data_length += ZEFR_PCM_FRAME_SIZE;
    return 1;
}
/**************************************************************************
* :     
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID efr_DecTest(char *pInFilePath, char *pOutFilePath)
{
   
    //CHAR  pInFilePath[ZEFR_MAX_FILE_NAME_LENGTH]     = "C:/hr.dec"; 
    //CHAR  pOutFilePath[ZEFR_MAX_FILE_NAME_LENGTH]    = "C:/efr_out.wav";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zEfr_OprElem   oprElem                        = {0};
    char  pRefFilePath[ZEFR_MAX_FILE_NAME_LENGTH]   = {0};
    g_zEfr_funcTicks = 0;

    mmp_EfrDecOpen(); 

    pGsmHandle = zOss_FOpen(pInFilePath, "rb");
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open\n");
        return ;
    }
    
    pPcmHandle= wav_write_open(pOutFilePath, ZEFR_PCM_SAMPLE_RATE, ZEFR_PCM_SAMPLE_BIT, 1);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open\n");
        return ;
    }
    
    zEfr_ResetOprElem(&oprElem);  
    while(efr_DecodeFrame(pGsmHandle, pPcmHandle, &oprElem));
    zEfr_PutoutOprElem(&oprElem);
    
    mmp_EfrDecClose();
    wav_write_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".ref");
    zOss_Printf(1, 1, "begin compare output encoded file with reference emcoded file!");  

    if(efr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "decode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "decode fail!!");  
    }
    zOss_Printf(1, 1, "end compare output encoded file with reference emcoded file!");  

    return;
}
/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID efr_EncThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "efr_EncThreadEntry start");
    efr_EncTest("C:/TEST2.wav","C:/TEST2_mutiThread.cod", 1);
    zOss_Printf(1, 1, "efr_EncThreadEntry end");
}
/**************************************************************************
* :    ߳ں
* ˵:     
*   ()  threadIndex: ̱߳
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID efr_DecThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "efr_DecThreadEntry start");
    efr_DecTest("C:/TEST5.dec","C:/TEST5_mutiThread_out.wav");
    zOss_Printf(1, 1, "efr_DecThreadEntry end");
}
/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg: ںδʹ
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID efr_CodecThreadEntry(SINT32 arg)
{
    
    ZOSS_THREAD_ID decThreadID    = ZOSS_NULL;
    ZOSS_THREAD_ID encThreadID    = ZOSS_NULL;
    
    zOss_Printf(1, 1, "efr_CodecThreadEntry start");  
    encThreadID = zOss_CreateThread("encThread3",
                                    efr_EncThreadEntry,
                                    0,
                                    ZEFR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(encThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create encThread failed");
        return;   
    }
    decThreadID = zOss_CreateThread("decThread4",
                                    efr_DecThreadEntry,
                                    0,
                                    ZEFR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(decThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create decThread failed");
        return;   
    }
    zOss_Printf(1, 1, "efr_CodecThreadEntry end");   
}
/**************************************************************************
* :     ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     ֡ͷʽ:01000000000SP0000,ȥ֡ͷ57ֵĲ
**************************************************************************/ 
static VOID efr_TestAPIEnc(VOID)
{
    CHAR  pInFilePath[ZEFR_MAX_FILE_NAME_LENGTH]     = "C:/efr_enc.wav"; 
    CHAR  pOutFilePath[ZEFR_MAX_FILE_NAME_LENGTH]    = "C:/efr_enc.cod";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zEfr_OprElem   oprElem                         = {0};

    zMmp_EfrEncOpen(TRUE);

    pPcmHandle = wav_read_open(pInFilePath);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open");
        return ;
    }

    pGsmHandle = zOss_FOpen(pOutFilePath, ZEFR_WRITE_MODE);
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open");
        return ;
    } 

    zEfr_ResetOprElem(&oprElem); 

    while(1)
    {
        UINT16          pcmSrc[160]     = {0};
        UINT16	        gsmDst[250]      = {0};
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT32          old_intr        = 0;
        
        if (!efr_EncReadDate(pPcmHandle, pcmSrc))
        {
           break;
        }

        ZMMP_LOCK(old_intr);
        beginTicks = zEfr_GetTick();
        zMmp_EfrEncode(pcmSrc, gsmDst);
        endTicks   = zEfr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zEfr_AddTicks(&oprElem, endTicks - beginTicks);
        
        if(zOss_FWrite(gsmDst, 1, 59 * 2, pGsmHandle) !=  59 * 2)
        {
            zOss_Printf(1, 1,  "efr_EncodeFrame: writefile error");
            break;
        }
    }

    zEfr_PutoutOprElem(&oprElem);
    zMmp_EfrEncClose();
    wav_read_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    return;
}
static  Word16 efr_extract_l (Word32 L_var1)
{
    Word16 var_out;

    var_out = (Word16) L_var1;
    return (var_out);
}
static  Word16 efr_saturate (Word32 L_var1)
{
    Word16 var_out;

    if (L_var1 > 0X00007fffL)
    {
        var_out = MAX_16;
    }
    else if (L_var1 < (Word32) 0xffff8000L)
    {
        var_out = MIN_16;
    }
    else
    {
        var_out = efr_extract_l (L_var1);
    }

    return (var_out);

}

static Word16 efr_add (Word16 var1, Word16 var2)
{
    Word16 var_out;
    Word32 L_sum;

    L_sum = (Word32) var1 + var2;
    var_out = efr_saturate (L_sum);
    return (var_out);
}
static  Word16 efr_Bin2int (        /* Reconstructed parameter                      */
    Word16 no_of_bits,  /* input : number of bits associated with value */
    Word16 *bitstream   /* output: address where bits are written       */
)
{
    Word16 value, i, bit;

    value = 0;                                   
    for (i = 0; i < no_of_bits; i++)
    {
        value = efr_shl (value, 1);
        bit = *bitstream++;                      
         
        if (bit == BIT_1)
            value = efr_add (value, 1);
    }
    return (value);
}
/**************************************************************************
* :     ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     ֡ͷʽ:010TAF00SIDSID000BFI0000ȥ֡ͷ57ֵĲ
**************************************************************************/ 
static VOID efr_TestAPIDec(VOID)
{
   
    CHAR  pInFilePath[ZEFR_MAX_FILE_NAME_LENGTH]     = "C:/efr_dec.cod"; /*DTX01ļ*/
    CHAR  pOutFilePath[ZEFR_MAX_FILE_NAME_LENGTH]    = "C:/efr_dec.wav";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zEfr_OprElem   oprElem                        = {0};
    char  pRefFilePath[ZEFR_MAX_FILE_NAME_LENGTH]   = {0};
    UINT16 tafFlag[29] = {23, 47, 71, 95, 119, 143, 167, 191, 215, 239, 263, 287, 311, 							335,359, 383,407, 431, 455, 479, 503, 527, 551, 575, 599, 623, 							647, 671, 695};

    UINT16 i;
    static const UINT16 bitno[57] =
    {
        7, 8, 9, 8, 6,                          /* LSP VQ          */
        9, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 5,  /* first subframe  */
        6, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 5,  /* second subframe */
        9, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 5,  /* third subframe  */
        6, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 5   /* fourth subframe */
    };

    zMmp_EfrDecOpen(); 

    pGsmHandle = zOss_FOpen(pInFilePath, "rb");
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open\n");
        return ;
    }
    
    pPcmHandle= wav_write_open(pOutFilePath, ZEFR_PCM_SAMPLE_RATE, ZEFR_PCM_SAMPLE_BIT, 1);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open\n");
        return ;
    }
    
    zEfr_ResetOprElem(&oprElem);  
    while(1)
    {
        UINT16          pcmDst[160]     = {0};
        UINT16          gsmSrc[250]     = {0};
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT16          readSize        = 0;
        UINT16          *pEfrBitStream  =  gsmSrc  + 3;
        UINT16          pEfrPara[57]    = {0};
        UINT32          old_intr        = 0;
        
        #if 0
        readSize  = zOss_FRead(gsmSrc, sizeof(UINT16), 59, pGsmHandle);
        if (readSize != 59) /*ļȡʧ*/ 
        {   
            break;
        }

        if(gsmSrc[1] & 0x10)
        {
            gsmSrc[1] = 0x4000;
        }
        else
        {
           gsmSrc[1] = 0x4200;
        }
        for(i = 0; i < 29; i++)
        {
            if(oprElem.count == tafFlag[i])
            {     
                gsmSrc[1] |=  0x1000;

            }
        }
        #else
        readSize  = zOss_FRead(gsmSrc + 2, sizeof(UINT16), 247, pGsmHandle);
        if (readSize != 247) /*ļȡʧ*/ 
        {   
            break;
        }

        gsmSrc[0] = 0x2;
        gsmSrc[1] |= gsmSrc[2] << 4;
        gsmSrc[1] |= gsmSrc[247] << 8;
        gsmSrc[1] |= gsmSrc[248] << 12;


        for (i = 0; i < 57; i++)
        {
            pEfrPara[i] = efr_Bin2int (bitno[i], pEfrBitStream);       
            pEfrBitStream += bitno[i];
            i++;
            pEfrPara[i] = efr_Bin2int (bitno[i], pEfrBitStream);       
            pEfrBitStream += bitno[i];
            i++;        
            pEfrPara[i] = efr_Bin2int (bitno[i], pEfrBitStream);       
            pEfrBitStream += bitno[i];
        
        }

        zOss_Memcpy(gsmSrc + 2, pEfrPara, 57 * sizeof(UINT16));
        #endif
        
        ZMMP_LOCK(old_intr);
        beginTicks = zEfr_GetTick();
        zMmp_EfrDecode(gsmSrc, pcmDst);
        endTicks   = zEfr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zEfr_AddTicks(&oprElem, endTicks - beginTicks);
        
        if(zOss_FWrite(pcmDst, 1, ZEFR_PCM_FRAME_SIZE , ((wav_writer *)pPcmHandle)->wav) !=  ZEFR_PCM_FRAME_SIZE)
        {
            zOss_Printf(1, 1,  "efr_DecodeFrame: writefile error");
            break;
        }
        ((wav_writer *)pPcmHandle)->data_length += ZEFR_PCM_FRAME_SIZE;
    }
    zEfr_PutoutOprElem(&oprElem);
    
    zMmp_EfrDecClose();
    wav_write_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    return;
}

static BOOL efr_IsFileEqual(const char *strFileName1, const char *strFileName2)
{
    FILE *pFile1Handler = zOss_FOpen(strFileName1, ZEFR_READ_MODE);
    FILE *pFile2Handler = zOss_FOpen(strFileName2, ZEFR_READ_MODE);
    BOOL isFileEqual    = FALSE;
    
    if(pFile1Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName1);
    }
    if(pFile2Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName2);
    }
    if(pFile1Handler != NULL && pFile2Handler != NULL)
    {
        isFileEqual = efr_IsFileContentEqual(pFile1Handler, pFile2Handler);
    }
    if(pFile1Handler != NULL)
    {
        zOss_FClose(pFile1Handler);
        pFile1Handler = NULL;
    }
    if(pFile2Handler != NULL)
    {
        zOss_FClose(pFile2Handler);
        pFile2Handler = NULL;
    }
    return isFileEqual;
}

static BOOL efr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler)
{
    UINT8  file1ReadBuf[100] = { 0 };
    UINT8  file2ReadBuf[100] = { 0 };
    UINT32 readFiel1Len                     = 0;
    UINT32 readFiel2Len                     = 0;
    
    zOss_ASSERT(pFile1Handler != NULL && pFile2Handler != NULL);
    while(1)
    {
        zOss_Memset(file1ReadBuf, 0, sizeof(file1ReadBuf));
        zOss_Memset(file2ReadBuf, 0, sizeof(file2ReadBuf));
        readFiel1Len = zOss_FRead(file1ReadBuf, 1, sizeof(file1ReadBuf), pFile1Handler);
        readFiel2Len = zOss_FRead(file2ReadBuf, 1, sizeof(file2ReadBuf), pFile2Handler);
        if(readFiel1Len != readFiel2Len)
        {
            zOss_Printf(1, 1, "readFiel1Len != readFiel2Len\r\n");
            return FALSE;
        }
        if(readFiel1Len == 0)
        {
            break;
        }
        if(zOss_Memcmp(file1ReadBuf, file2ReadBuf, readFiel1Len) != 0)
        {
            //zOss_Printf(1, 1, "zOss_Memcmp != 0\r\n");
            return FALSE;
        }
    }
    return (zOss_FEof(pFile1Handler) != 0 && zOss_FEof(pFile2Handler) != 0);  
}

/**************************************************************************
* :     ӡ˵
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID efr_PrintCmds()
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zEfr_TestCmds)/sizeof(g_zEfr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        zOss_Printf(1, 1, "frtest \t%-20s \t%s",g_zEfr_TestCmds[iCmdsIndex].pCmd,
                    g_zEfr_TestCmds[iCmdsIndex].pDesc);
    }
}
/**************************************************************************
* :     вѯĳе±
* ˵:     
*   ()  pMmpCmd:
*   ()  
*   ֵ:     е±꣬δҵ-1
* ˵:     
**************************************************************************/ 
static SINT32 efr_FindCmds(const CHAR *pMmpCmd)
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zEfr_TestCmds)/sizeof(g_zEfr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        if(0 == strcmp((const CHAR *)g_zEfr_Cmd,
                        (const CHAR *)g_zEfr_TestCmds[iCmdsIndex].pCmd))
        {
            return iCmdsIndex;
        }
    }   
    return -1;
}
/**************************************************************************
* :     ִв 
* ˵:     
*   ()  iCmdIndex:е±
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID efr_ExcuteCmds(SINT32 iCmdIndex)
{
    SINT32  iCmdsCount = sizeof(g_zEfr_TestCmds)/sizeof(g_zEfr_TestCmds[0]);
    
    if(0 <= iCmdIndex && iCmdIndex <= iCmdsCount)
    {
        g_zEfr_TestCmds[iCmdIndex].func();
    }
    else
    {
        zOss_Printf(1, 1, "\n");
        efr_PrintCmds();
    }
}

/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg:Ϊ˺̵߳ںָƥ䣬òʱδʹ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID efr_TestEntry(SINT32 arg)
{
    SINT32 iRet;
    UINT32 cpuCost = 2;
    while(1)
    {  
        zOss_GetSemaphore(g_zEfr_testSemaphoreID, ZOSS_WAIT_FOREVER);
        iRet = efr_FindCmds(g_zEfr_Cmd);
        efr_ExcuteCmds(iRet);
        //cpuCost = Osa_GetProcessCPU(g_zFr_testSemaphoreID);
        //zOss_Printf(1, 1, "%d", cpuCost);
        zOss_PutSemaphore(g_zEfr_shellSemaphoreID);
    }    
}
/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* :     shell Ϣպ
* ˵:     
*   ()  pCmdMsg:shellϢ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
VOID zMmp_EfrTest( T_Shell_CommandMessage *pCmdMsg )
{
    static ZOSS_THREAD_ID threadID = ZOSS_NULL;
    if(g_zEfr_shellSemaphoreID == ZOSS_NULL)
    {
        //pow_GetArmCoreFreq(&freq);
        //zOss_Printf(1, 1, "%d", freq);
        g_zEfr_shellSemaphoreID = zOss_CreateSemaphore("zEfr_ShellSemaphore", 1); 
        g_zEfr_testSemaphoreID  = zOss_CreateSemaphore("zEfr_testSemaphore", 0); 
        g_zEfr_Cmd = (CHAR *)zOss_Malloc(sizeof(CHAR) * ZEFR_MAX_CMD_PARAM_LENGTH);
    }
    zOss_GetSemaphore(g_zEfr_shellSemaphoreID, ZOSS_WAIT_FOREVER);
    
    if(1 > pCmdMsg->paraCount)
    {
        zOss_Printf(1, 1, ",: Efrtest help\n");
        zOss_PutSemaphore(g_zEfr_shellSemaphoreID);
        return;
    } 
    strcpy(g_zEfr_Cmd, (CHAR *)pCmdMsg->para[0]);
    
    if(threadID == ZOSS_NULL)
    {
        threadID  = zOss_CreateThread("zEfr_Test", efr_TestEntry, 0, ZEFR_STACK_SIZE, 19, 1, 1);    
    }
    zOss_PutSemaphore(g_zEfr_testSemaphoreID);	
}

#ifdef __cplusplus
}
#endif
