/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   :  hrģ
*    :  zmmp_hr_test.c
* ļ : 
* ʵֹ :  hrԴ
*      :  
*      : 
*  :  20140401
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "wavreader.h"
#include "wavwriter.h"
#include "zmmp_hr_fnc.h"
#include "zmmp_hr_test.h"
#include "mmp_hr_api.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#if defined (_OS_TOS)
#define ZMMP_LOCK(old_intr)         cyg_scheduler_lock();      
#define ZMMP_UNLOCK(old_intr)       cyg_scheduler_unlock(); 
#elif defined (_OS_OSE)
//#include "Osa_itrapi.h"
#define ZMMP_LOCK(old_intr)         ZOSS_SAVE_IRQ(old_intr);
#define ZMMP_UNLOCK(old_intr)       ZOSS_RESTORE_IRQ(old_intr);
#endif


#define ZHR_MAX_CMD_PARAM_LENGTH   (15) 
#define ZHR_STACK_SIZE             (1024 * 20)
#define ZHR_MAX_FILE_NAME_LENGTH   (50)
//#define ZHR_PCM_FRAME_SIZE         (320)       /*λֽ                   */
#define ZHR_PCM_SAMPLE_RATE        (8000)
#define ZHR_PCM_SAMPLE_BIT         (16)
#define ZHR_READ_MODE              "rb"
#define ZHR_WRITE_MODE             "wb"
UINT32  g_zHr_funcTicks = 0;


/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*hr_TestFunc)(VOID); /* frԺָ */

/*ṹ*/
typedef struct 
{
	CHAR            *pCmd;  /*          */
	hr_TestFunc     func;   /*ú      */
	CHAR            *pDesc; /*  */
} T_zHr_TestCmd;  


/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID hr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable);
static VOID hr_DecTest(char *pInFilePath, char *pOutFilePath);
static VOID hr_EncThreadEntry(SINT32 arg);
static VOID hr_DecThreadEntry(SINT32 arg);
static VOID hr_CodecThreadEntry(SINT32 arg);
static VOID   hr_PrintCmds(VOID);
static SINT32 hr_FindCmds(const CHAR *pMmpCmd);
static VOID   hr_ExcuteCmds(SINT32 iCmdIndex);
static VOID   hr_TestEntry(SINT32 arg);
static VOID   hr_TestEnc_1(VOID); 
static VOID   hr_TestEnc_2(VOID); 
static VOID   hr_TestEnc_3(VOID); 
static VOID   hr_TestEnc_4(VOID); 
static VOID   hr_TestEnc_5(VOID); 
static VOID   hr_TestEnc_6(VOID); 
static VOID   hr_TestEnc_7(VOID); 
static VOID   hr_TestEnc_8(VOID); 
static VOID   hr_TestEnc_9(VOID); 
static VOID   hr_TestEnc_10(VOID); 
static VOID   hr_TestEnc_11(VOID); 
static VOID   hr_TestEnc_12(VOID); 
static VOID   hr_TestEnc_13(VOID); 
static VOID   hr_TestEnc_14(VOID); 
static VOID   hr_TestEnc_15(VOID); 
static VOID   hr_TestEnc_16(VOID); 
static VOID   hr_TestEnc_17(VOID); 
static VOID   hr_TestEnc_18(VOID); 
static VOID   hr_TestEnc_19(VOID); 
static VOID   hr_TestEnc_20(VOID); 

static VOID   hr_TestDec_1(VOID); 
static VOID   hr_TestDec_2(VOID); 
static VOID   hr_TestDec_3(VOID); 
static VOID   hr_TestDec_4(VOID); 
static VOID   hr_TestDec_5(VOID); 
static VOID   hr_TestDec_6(VOID); 
static VOID   hr_TestDec_7(VOID); 
static VOID   hr_TestDec_8(VOID); 
static VOID   hr_TestDec_9(VOID); 
static VOID   hr_TestDec_10(VOID); 
static VOID   hr_TestDec_11(VOID); 
static VOID   hr_TestDec_12(VOID); 

static VOID hr_TestCodec(VOID); 

static VOID hr_APIEnc(VOID);
static VOID hr_APIDec(VOID);

static BOOL hr_IsFileEqual(const char *strFileName1, const char *strFileName2);
static BOOL hr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler);


/**************************************************************************
* ȫֳ/
**************************************************************************/

CHAR                *g_zHr_Cmd                              = NULL;
ZOSS_SEMAPHORE_ID   g_zHr_shellSemaphoreID                  = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zHr_testSemaphoreID                   = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zHr_ThreadSemaphoreID                 = ZOSS_NULL;

/* ý */
static T_zHr_TestCmd g_zHr_TestCmds[] = 
{     
    {"hrEnc1",   (hr_TestFunc)hr_TestEnc_1,   "hr1"                    },
    {"hrEnc2",   (hr_TestFunc)hr_TestEnc_2,   "hr2"                    },
    {"hrEnc3",   (hr_TestFunc)hr_TestEnc_3,   "hr3"                    },
    {"hrEnc4",   (hr_TestFunc)hr_TestEnc_4,   "hr4"                    },
    {"hrEnc5",   (hr_TestFunc)hr_TestEnc_5,   "hr5"                    },
    {"hrEnc6",   (hr_TestFunc)hr_TestEnc_6,   "hr6"                    },
    {"hrEnc7",   (hr_TestFunc)hr_TestEnc_7,   "hr7"                    },
    {"hrEnc8",   (hr_TestFunc)hr_TestEnc_8,   "hr8"                    },
    {"hrEnc9",   (hr_TestFunc)hr_TestEnc_9,   "hr9"                    },
    {"hrEnc10",  (hr_TestFunc)hr_TestEnc_10,  "hr10"                   },
    {"hrEnc11",  (hr_TestFunc)hr_TestEnc_11,  "hr11"                    },
    {"hrEnc12",  (hr_TestFunc)hr_TestEnc_12,  "hr12"                    },
    {"hrEnc13",  (hr_TestFunc)hr_TestEnc_13,  "hr13"                    },
    {"hrEnc14",  (hr_TestFunc)hr_TestEnc_14,  "hr14"                    },
    {"hrEnc15",  (hr_TestFunc)hr_TestEnc_15,  "hr15"                    },
    {"hrEnc16",  (hr_TestFunc)hr_TestEnc_16,  "hr16"                    },
    {"hrEnc17",  (hr_TestFunc)hr_TestEnc_17,  "hr17"                    },
    {"hrEnc18",  (hr_TestFunc)hr_TestEnc_18,  "hr18"                    },
    {"hrEnc19",  (hr_TestFunc)hr_TestEnc_19,  "hr19"                    },
    {"hrEnc20",  (hr_TestFunc)hr_TestEnc_20,  "hr20"                   },
      
    {"hrDec1",  (hr_TestFunc)hr_TestDec_1,  "hr1"                    },      
    {"hrDec2",  (hr_TestFunc)hr_TestDec_2,  "hr2"                    },      
    {"hrDec3",  (hr_TestFunc)hr_TestDec_3,  "hr3"                    },      
    {"hrDec4",  (hr_TestFunc)hr_TestDec_4,  "hr4"                    },      
    {"hrDec5",  (hr_TestFunc)hr_TestDec_5,  "hr5"                    },      
    {"hrDec6",  (hr_TestFunc)hr_TestDec_6,  "hr6"                    },      
    {"hrDec7",  (hr_TestFunc)hr_TestDec_7,  "hr7"                    },      
    {"hrDec8",  (hr_TestFunc)hr_TestDec_8,  "hr8"                    },      
    {"hrDec9",  (hr_TestFunc)hr_TestDec_9,  "hr9"                    },      
    {"hrDec10", (hr_TestFunc)hr_TestDec_10, "hr10"                   },      
    {"hrDec11", (hr_TestFunc)hr_TestDec_11, "hr11"                   },      
    {"hrDec12", (hr_TestFunc)hr_TestDec_12, "hr12"                   },
    {"hrCodec", (hr_TestFunc)hr_TestCodec, "hr"                    },
    {"hrAPIEnc", (hr_TestFunc)hr_APIEnc,   "װӿڣ"        },    
    {"hrAPIDec", (hr_TestFunc)hr_APIDec,   "װӿڣ"        }
 
};

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* :  1,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_1(VOID) 
{

    zOss_Printf(1, 1, "zHr_TestEnc_1 start");   
    hr_EncTest("C:/SEQ01.wav","C:/SEQ01.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_1 end");
}
/**************************************************************************
* :  2,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_2(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_2 start");   
    hr_EncTest("C:/SEQ02.wav","C:/SEQ02.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_2 end");
}
/**************************************************************************
* :  3,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_3(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_3 start");   
    hr_EncTest("C:/SEQ03.wav","C:/SEQ03.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_3 end");
}

/**************************************************************************
* :  4,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_4(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_4 start");   
    hr_EncTest("C:/DTX01.wav","C:/DTX01.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_4 end");
}

/**************************************************************************
* :  5,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_5(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_5 start");   
    hr_EncTest("C:/DTX02.wav","C:/DTX02.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_5 end");
}
/**************************************************************************
* :  6,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_6(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_6 start");   
    hr_EncTest("C:/DTX03.wav","C:/DTX03.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_6 end");
}
/**************************************************************************
* :  7,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_7(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_7 start");   
    hr_EncTest("C:/DTX04.wav","C:/DTX04.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_7 end");
}
/**************************************************************************
* :  8,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_8(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_8 start");   
    hr_EncTest("C:/DTX05.wav","C:/DTX05.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_8 end");
}
/**************************************************************************
* :  9,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_9(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_9 start");   
    hr_EncTest("C:/DTX06.wav","C:/DTX06.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_9 end");
}

/**************************************************************************
* :  10,DTX
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_10(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_10 start");   
    hr_EncTest("C:/DTX07.wav","C:/DTX07.cod", 1);
    zOss_Printf(1, 1, "zHr_TestEnc_10 end");
}
/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* :  11,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_11(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_11 start");   
    hr_EncTest("C:/SEQ01.wav","C:/SEQ01_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_11 end");
}
/**************************************************************************
* :  12,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_12(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_12 start");   
    hr_EncTest("C:/SEQ02.wav","C:/SEQ02_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_12 end");
}
/**************************************************************************
* :  13,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_13(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_13 start");   
    hr_EncTest("C:/SEQ03.wav","C:/SEQ03_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_13 end");
}

/**************************************************************************
* :  14,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_14(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_14 start");   
    hr_EncTest("C:/DTX01.wav","C:/DTX01_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_14 end");
}

/**************************************************************************
* :  15,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_15(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_15 start");   
    hr_EncTest("C:/DTX02.wav","C:/DTX02_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_15 end");
}
/**************************************************************************
* :  16,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_16(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_16 start");   
    hr_EncTest("C:/DTX03.wav","C:/DTX03_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_16 end");
}
/**************************************************************************
* :  17,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_17(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_17 start");   
    hr_EncTest("C:/DTX04.wav","C:/DTX04_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_17 end");
}
/**************************************************************************
* :  18,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_18(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_18 start");   
    hr_EncTest("C:/DTX05.wav","C:/DTX05_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_18 end");
}
/**************************************************************************
* :  19,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_19(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_19 start");   
    hr_EncTest("C:/DTX06.wav","C:/DTX06_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_19 end");
}

/**************************************************************************
* :  20,nodtx
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestEnc_20(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestEnc_20 start");   
    hr_EncTest("C:/DTX07.wav","C:/DTX07_nodtx.cod", 0);
    zOss_Printf(1, 1, "zHr_TestEnc_20 end");
}
/**************************************************************************
* :  1
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_1(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_1 start");   
    hr_DecTest("C:/SEQ01.DEC", "C:/SEQ01_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_1 end");
}
/**************************************************************************
* :  2
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_2(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_2 start");   
    hr_DecTest("C:/SEQ02.DEC", "C:/SEQ02_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_2 end");
}
/**************************************************************************
* :  3
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_3(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_3 start");   
    hr_DecTest("C:/SEQ03.DEC", "C:/SEQ03_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_3 end");
}
/**************************************************************************
* :  4
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_4(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_4 start");   
    hr_DecTest("C:/SEQ04.DEC", "C:/SEQ04_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_4 end");
}
/**************************************************************************
* :  5
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_5(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_5 start");   
    hr_DecTest("C:/SEQ05.DEC", "C:/SEQ05_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_5 end");
}

/**************************************************************************
* :  6,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_6(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_6 start");   
    hr_DecTest("C:/DTX01.DEC", "C:/DTX01_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_6 end");
}
/**************************************************************************
* :  7,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_7(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_7 start");   
    hr_DecTest("C:/DTX02.DEC", "C:/DTX02_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_7 end");
}
/**************************************************************************
* :  8,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_8(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_8 start");   
    hr_DecTest("C:/DTX03.DEC", "C:/DTX03_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_8 end");
}
/**************************************************************************
* :  9,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_9(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_9 start");   
    hr_DecTest("C:/DTX04.DEC", "C:/DTX04_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_9 end");
}

/**************************************************************************
* :  10,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_10(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_10 start");   
    hr_DecTest("C:/DTX05.DEC", "C:/DTX05_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_10 end");
}

/**************************************************************************
* :  11,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_11(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_11 start");   
    hr_DecTest("C:/DTX06.DEC", "C:/DTX06_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_11 end");
}

/**************************************************************************
* :  12,DTX
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_TestDec_12(VOID) 
{
    zOss_Printf(1, 1, "zHr_TestDec_12 start");   
    hr_DecTest("C:/DTX07.DEC", "C:/DTX07_DEC.wav");
    zOss_Printf(1, 1, "zHr_TestDec_12 end");
}
/**************************************************************************
* :     ʵб
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/

static VOID hr_TestCodec(VOID) 
{
    ZOSS_THREAD_ID     mutiThreadID    = ZOSS_NULL;
    zOss_Printf(1, 1, "zHr_TestCodec start");  
    mutiThreadID = zOss_CreateThread("codecThread",
                                     hr_CodecThreadEntry,
                                     0,
                                     ZHR_STACK_SIZE,
                                     18,
                                     1,
                                     1);

    if(mutiThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "hr_TestCodec:zOss_CreateThread failed");
    }
    zOss_Printf(1, 1, "zHr_TestCodec end");    
}
/**************************************************************************
* :     ȡpcm
* ˵:     
*   ()  pPcmHandle:  wavļ
*   ()  pcmSrc:      ȡpcmݴ洢buffer
*   ֵ:     ɹ1ʧܷ0
* ˵:    
**************************************************************************/
static UINT8 hr_EncReadDate(VOID *pPcmHandle, UINT16 pcmSrc[])
{
    
    UINT16 readSize     = 0;
    
    readSize = zOss_FRead(pcmSrc, 1, ZHR_PCM_FRAME_SIZE * 2, ((wav_reader *)pPcmHandle)->wav);  
    if(readSize != ZHR_PCM_FRAME_SIZE * 2)
    {
        if(zOss_FEof(((wav_reader *)pPcmHandle)->wav) == 0)
        {
            zOss_Printf(1, 1, "hr_EncReadDate: readfile error , error code: %d", readSize);
        }
        return 0;
    }
    return 1;    
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 hr_EncodeFrame(VOID *pPcmHandle, FILE *pGsmHandle, T_zHr_OprElem *pOprElem)
{
    UINT16          pcmSrc[160]     = {0};
    UINT16	        gsmDst[20]      = {0};
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT32          old_intr;
    
    zOss_ASSERT(pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);
    
    if (!hr_EncReadDate(pPcmHandle, pcmSrc))
    {
            return 0;
    }
    
    ZMMP_LOCK(old_intr);
    beginTicks = zHr_GetTick();
    mmp_HrEncode(pcmSrc, gsmDst);
    endTicks   = zHr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zHr_AddTicks(pOprElem, endTicks - beginTicks);
    
    if(zOss_FWrite(gsmDst, 1, 40, pGsmHandle) !=  40)
    {
        zOss_Printf(1, 1,  "hr_EncodeFrame: writefile error");
        return 0;
    }
    return 1;
}
/**************************************************************************
* :     
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable)
{
    //CHAR  pInFilePath[ZHR_MAX_FILE_NAME_LENGTH]     = "C:/hr.wav"; 
    //CHAR  pOutFilePath[ZHR_MAX_FILE_NAME_LENGTH]    = "C:/hr.cod";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zHr_OprElem   oprElem                         = {0};
    char  pRefFilePath[ZHR_MAX_FILE_NAME_LENGTH]   = {0};
   
    if (!mmp_HrEncOpen(dtxEnable)) 
    {           
        zOss_Printf(1, 1, "hr_EncTest: mmp_HrEncOpen failed");
        return;
    }

    pPcmHandle = wav_read_open(pInFilePath);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open");
        return ;
    }
    if (!wav_get_header(pPcmHandle, NULL, NULL, NULL, NULL, NULL)) 
    {
        zOss_Printf(1, 1, "Bad wav file %s", pInFilePath);
        return ;
    }
    
    pGsmHandle = zOss_FOpen(pOutFilePath, ZHR_WRITE_MODE);
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open");
        return ;
    } 
    
    zHr_ResetOprElem(&oprElem);  
    while(hr_EncodeFrame(pPcmHandle, pGsmHandle, &oprElem));
    zHr_PutoutOprElem(&oprElem);
    
    mmp_HrEncClose();
    wav_read_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    
    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".ref");
    zOss_Printf(1, 1, "begin compare output encoded file with reference encoded file!");  

    if(hr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "encode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "encode fail!!");  

    }
    zOss_Printf(1, 1, "end compare output encoded file with reference encoded file!");  
 
    return;
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 hr_DecodeFrame(FILE *pGsmHandle, VOID *pPcmHandle, T_zHr_OprElem *pOprElem)
{
    UINT16          pcmDst[160]     = {0};
    UINT16          gsmSrc[22]      = {0};
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT16          readSize        = 0;
    UINT32          old_intr;
    
    zOss_ASSERT(pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);
    
    readSize  = zOss_FRead((UINT8 *)gsmSrc, 1, 44, pGsmHandle);
    if (readSize != 44) /*ļȡʧ*/ 
    {   
        return 0;
    }

    ZMMP_LOCK(old_intr);
    beginTicks = zHr_GetTick();
    mmp_HrDecode(gsmSrc, pcmDst);
    endTicks   = zHr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zHr_AddTicks(pOprElem, endTicks - beginTicks);
    
    if(zOss_FWrite(pcmDst, 1, ZHR_PCM_FRAME_SIZE * 2, ((wav_writer *)pPcmHandle)->wav) !=  ZHR_PCM_FRAME_SIZE * 2)
    {
        zOss_Printf(1, 1,  "hr_DecodeFrame: writefile error");
        return 0;
    }
    ((wav_writer *)pPcmHandle)->data_length += ZHR_PCM_FRAME_SIZE * 2;
    return 1;
}
/**************************************************************************
* :     
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_DecTest(char *pInFilePath, char *pOutFilePath)
{
   
    //CHAR  pInFilePath[ZHR_MAX_FILE_NAME_LENGTH]     = "C:/hr.dec"; 
    //CHAR  pOutFilePath[ZHR_MAX_FILE_NAME_LENGTH]    = "C:/hr_out.wav";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zHr_OprElem   oprElem                         = {0};
    char  pRefFilePath[ZHR_MAX_FILE_NAME_LENGTH]    = {0};
  

    if (!mmp_HrDecOpen()) 
    {           
        zOss_Printf(1, 1, "mmp_HrDecOpen:  failed");
        return;
    }

    pGsmHandle = zOss_FOpen(pInFilePath, "rb");
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open\n");
        return ;
    }
    
    pPcmHandle= wav_write_open(pOutFilePath, ZHR_PCM_SAMPLE_RATE, ZHR_PCM_SAMPLE_BIT, 1);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open\n");
        return ;
    }
    
    zHr_ResetOprElem(&oprElem);  
    while(hr_DecodeFrame(pGsmHandle, pPcmHandle, &oprElem));
    zHr_PutoutOprElem(&oprElem);
    
    mmp_HrDecClose();
    wav_write_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".ref");
    zOss_Printf(1, 1, "begin compare output encoded file with reference emcoded file!");  

    if(hr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "decode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "decode fail!!");  
    }
    zOss_Printf(1, 1, "end compare output encoded file with reference emcoded file!");  

    return;
}
/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID hr_EncThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "hr_EncThreadEntry start");
    hr_EncTest("C:/DTX02.wav","C:/DTX02_mutiThread.cod", 1);
    zOss_Printf(1, 1, "hr_EncThreadEntry end");
}
/**************************************************************************
* :    ߳ں
* ˵:     
*   ()  threadIndex: ̱߳
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID hr_DecThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "hr_DecThreadEntry start");
    hr_DecTest("C:/DTX01.dec","C:/DTX01_mutiThread.wav");
    zOss_Printf(1, 1, "hr_DecThreadEntry end");
}
/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg: ںδʹ
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID hr_CodecThreadEntry(SINT32 arg)
{
    
    ZOSS_THREAD_ID decThreadID    = ZOSS_NULL;
    ZOSS_THREAD_ID encThreadID    = ZOSS_NULL;
    
    zOss_Printf(1, 1, "hr_CodecThreadEntry start");  
    encThreadID = zOss_CreateThread("encThread3",
                                    hr_EncThreadEntry,
                                    0,
                                    ZHR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(encThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create encThread failed");
        return;   
    }
    decThreadID = zOss_CreateThread("decThread4",
                                    hr_DecThreadEntry,
                                    0,
                                    ZHR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(decThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create decThread failed");
        return;   
    }
    zOss_Printf(1, 1, "hr_CodecThreadEntry end");   
}

/**************************************************************************
* :     ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_APIEnc()
{
    CHAR  pInFilePath[ZHR_MAX_FILE_NAME_LENGTH]     = "C:/hr_enc.wav"; 
    CHAR  pOutFilePath[ZHR_MAX_FILE_NAME_LENGTH]    = "C:/hr_enc.cod";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zHr_OprElem   oprElem                         = {0};
   
    if (!zMmp_HrEncOpen(TRUE)) 
    {           
        zOss_Printf(1, 1, "hr_EncTest: mmp_HrEncOpen failed");
        return;
    }

    pPcmHandle = wav_read_open(pInFilePath);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open");
        return ;
    }
    if (!wav_get_header(pPcmHandle, NULL, NULL, NULL, NULL, NULL)) 
    {
        zOss_Printf(1, 1, "Bad wav file %s", pInFilePath);
        return ;
    }
    
    pGsmHandle = zOss_FOpen(pOutFilePath, ZHR_WRITE_MODE);
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open");
        return ;
    } 
    
    zHr_ResetOprElem(&oprElem);  
    while(1)
    {
        UINT16          pcmSrc[160]     = {0};
        UINT16	        gsmDst[20]      = {0};
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT32          old_intr;
        
        if (!hr_EncReadDate(pPcmHandle, pcmSrc))
        {
           break;
        }
        
        ZMMP_LOCK(old_intr);
        beginTicks = zHr_GetTick();
        zMmp_HrEncode(pcmSrc, gsmDst);
        endTicks   = zHr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zHr_AddTicks(&oprElem, endTicks - beginTicks);
        
        if(zOss_FWrite(gsmDst, 1, 20 * 2, pGsmHandle) !=   20 * 2)
        {
            zOss_Printf(1, 1,  "hr_EncodeFrame: writefile error");
            break;
        }

    }
    zHr_PutoutOprElem(&oprElem);
    
    zMmp_HrEncClose();
    wav_read_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    
    return;
}

/**************************************************************************
* :     ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_APIDec(VOID)
{
   
    CHAR  pInFilePath[ZHR_MAX_FILE_NAME_LENGTH]     = "C:/hr_dec.cod"; 
    CHAR  pOutFilePath[ZHR_MAX_FILE_NAME_LENGTH]    = "C:/hr_dec.wav";
    VOID            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zHr_OprElem   oprElem                         = {0};
  

    if (!zMmp_HrDecOpen()) 
    {           
        zOss_Printf(1, 1, "mmp_HrDecOpen:  failed");
        return;
    }

    pGsmHandle = zOss_FOpen(pInFilePath, "rb");
    if (!pGsmHandle) 
    {
        zOss_Printf(1, 1, "inFile can not open\n");
        return ;
    }
    
    pPcmHandle= wav_write_open(pOutFilePath, ZHR_PCM_SAMPLE_RATE, ZHR_PCM_SAMPLE_BIT, 1);
    if (!pPcmHandle) 
    {
        zOss_Printf(1, 1, "outFile can not open\n");
        return ;
    }
    
    zHr_ResetOprElem(&oprElem);  
    while(1)
    {
        UINT16          pcmDst[160]     = {0};
        UINT16          gsmSrc[30]      = {0};
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT16          readSize        = 0;
        UINT32          old_intr;
        
        readSize  = zOss_FRead((UINT8 *)(gsmSrc + 2), 1, 22 * 2, pGsmHandle);
        if (readSize != 22 * 2) /*ļȡʧ*/ 
        {   
            break;
        }
        /*     18       1               BFI
         *     19       1               UFI
         *     20       2               SID
         *     21       1               TAF*/

        gsmSrc[0] = 0x2;
        gsmSrc[1] = 0;
        gsmSrc[1] |= gsmSrc[20] << 4;
        gsmSrc[1] |= gsmSrc[21] << 13;
        gsmSrc[1] |= gsmSrc[22] << 8;
        gsmSrc[1] |= gsmSrc[23] << 12;
        
        ZMMP_LOCK(old_intr);
        beginTicks = zHr_GetTick();
        zMmp_HrDecode(gsmSrc, pcmDst);
        endTicks   = zHr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zHr_AddTicks( &oprElem, endTicks - beginTicks);
        
        if(zOss_FWrite(pcmDst, 1, ZHR_PCM_FRAME_SIZE * 2, ((wav_writer *)pPcmHandle)->wav) !=  ZHR_PCM_FRAME_SIZE * 2)
        {
            zOss_Printf(1, 1,  "hr_DecodeFrame: writefile error");
            break;
        }
        ((wav_writer *)pPcmHandle)->data_length += ZHR_PCM_FRAME_SIZE * 2;

    }
    zHr_PutoutOprElem(&oprElem);
    
    zMmp_HrDecClose();
    wav_write_close(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    return;
}


static BOOL hr_IsFileEqual(const char *strFileName1, const char *strFileName2)
{
    FILE *pFile1Handler = zOss_FOpen(strFileName1, "rb");
    FILE *pFile2Handler = zOss_FOpen(strFileName2, "rb");
    BOOL isFileEqual    = FALSE;
    
    if(pFile1Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName1);
    }
    if(pFile2Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName2);
    }
    if(pFile1Handler != NULL && pFile2Handler != NULL)
    {
        isFileEqual = hr_IsFileContentEqual(pFile1Handler, pFile2Handler);
    }
    if(pFile1Handler != NULL)
    {
        zOss_FClose(pFile1Handler);
        pFile1Handler = NULL;
    }
    if(pFile2Handler != NULL)
    {
        zOss_FClose(pFile2Handler);
        pFile2Handler = NULL;
    }
    return isFileEqual;
}

static BOOL hr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler)
{
    UINT8  file1ReadBuf[100] = { 0 };
    UINT8  file2ReadBuf[100] = { 0 };
    UINT32 readFiel1Len                     = 0;
    UINT32 readFiel2Len                     = 0;
    
    zOss_ASSERT(pFile1Handler != NULL && pFile2Handler != NULL);
    while(1)
    {
        zOss_Memset(file1ReadBuf, 0, sizeof(file1ReadBuf));
        zOss_Memset(file2ReadBuf, 0, sizeof(file2ReadBuf));
        readFiel1Len = zOss_FRead(file1ReadBuf, 1, sizeof(file1ReadBuf), pFile1Handler);
        readFiel2Len = zOss_FRead(file2ReadBuf, 1, sizeof(file2ReadBuf), pFile2Handler);
        if(readFiel1Len != readFiel2Len)
        {
            zOss_Printf(1, 1, "readFiel1Len != readFiel2Len\r\n");
            return FALSE;
        }
        if(readFiel1Len == 0)
        {
            break;
        }
        if(zOss_Memcmp(file1ReadBuf, file2ReadBuf, readFiel1Len) != 0)
        {
            //zOss_Printf(1, 1, "zOss_Memcmp != 0\r\n");
            return FALSE;
        }
    }
    return (zOss_FEof(pFile1Handler) != 0 && zOss_FEof(pFile2Handler) != 0);  
}

/**************************************************************************
* :     ӡ˵
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_PrintCmds()
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zHr_TestCmds)/sizeof(g_zHr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        zOss_Printf(1, 1, "hrtest \t%-20s \t%s",g_zHr_TestCmds[iCmdsIndex].pCmd,
                    g_zHr_TestCmds[iCmdsIndex].pDesc);
    }
}
/**************************************************************************
* :     вѯĳе±
* ˵:     
*   ()  pMmpCmd:
*   ()  
*   ֵ:     е±꣬δҵ-1
* ˵:     
**************************************************************************/ 
static SINT32 hr_FindCmds(const CHAR *pMmpCmd)
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zHr_TestCmds)/sizeof(g_zHr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        if(0 == strcmp((const CHAR *)g_zHr_Cmd,
                        (const CHAR *)g_zHr_TestCmds[iCmdsIndex].pCmd))
        {
            return iCmdsIndex;
        }
    }   
    return -1;
}
/**************************************************************************
* :     ִв 
* ˵:     
*   ()  iCmdIndex:е±
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_ExcuteCmds(SINT32 iCmdIndex)
{
    SINT32  iCmdsCount = sizeof(g_zHr_TestCmds)/sizeof(g_zHr_TestCmds[0]);
    
    if(0 <= iCmdIndex && iCmdIndex <= iCmdsCount)
    {
        g_zHr_TestCmds[iCmdIndex].func();
    }
    else
    {
        zOss_Printf(1, 1, "\n");
        hr_PrintCmds();
    }
}

/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg:Ϊ˺̵߳ںָƥ䣬òʱδʹ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID hr_TestEntry(SINT32 arg)
{
    SINT32 iRet;
    UINT32 cpuCost = 2;
    while(1)
    {  
        zOss_GetSemaphore(g_zHr_testSemaphoreID, ZOSS_WAIT_FOREVER);
        iRet = hr_FindCmds(g_zHr_Cmd);
        hr_ExcuteCmds(iRet);
        //cpuCost = Osa_GetProcessCPU(g_zFr_testSemaphoreID);
        //zOss_Printf(1, 1, "%d", cpuCost);
        zOss_PutSemaphore(g_zHr_shellSemaphoreID);
    }    
}
/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* :     shell Ϣպ
* ˵:     
*   ()  pCmdMsg:shellϢ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
VOID zMmp_HrTest( T_Shell_CommandMessage *pCmdMsg )
{
    static ZOSS_THREAD_ID threadID = ZOSS_NULL;
    if(g_zHr_shellSemaphoreID == ZOSS_NULL)
    {
        //pow_GetArmCoreFreq(&freq);
        //zOss_Printf(1, 1, "%d", freq);
        g_zHr_shellSemaphoreID = zOss_CreateSemaphore("zHr_ShellSemaphore", 1); 
        g_zHr_testSemaphoreID  = zOss_CreateSemaphore("zHr_testSemaphore", 0); 
        g_zHr_Cmd = (CHAR *)zOss_Malloc(sizeof(CHAR) * ZHR_MAX_CMD_PARAM_LENGTH);
    }
    zOss_GetSemaphore(g_zHr_shellSemaphoreID, ZOSS_WAIT_FOREVER);
    
    if(1 > pCmdMsg->paraCount)
    {
        zOss_Printf(1, 1, ",: hrtest help\n");
        zOss_PutSemaphore(g_zHr_shellSemaphoreID);
        return;
    } 
    strcpy(g_zHr_Cmd, (CHAR *)pCmdMsg->para[0]);
    
    if(threadID == ZOSS_NULL)
    {
        threadID  = zOss_CreateThread("zHr_Test", hr_TestEntry, 0, ZHR_STACK_SIZE, 19, 1, 1);    
    }
    zOss_PutSemaphore(g_zHr_testSemaphoreID);	
}

#ifdef __cplusplus
}
#endif
