#ifndef OS_TYPE_H
#define OS_TYPE_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

typedef unsigned char   BYTE;
typedef void                VOID;
typedef unsigned char       UINT8;
typedef char                CHAR;
typedef signed char         SINT8;
typedef unsigned short      UINT16;
typedef signed short        SINT16;
typedef unsigned long int   UINT32;
typedef signed long int     SINT32;
typedef float               FLOAT32;
typedef double              FLOAT64;

typedef int 				sem_t;

#ifndef _TYPE_OS_STATUS
#define _TYPE_OS_STATUS
typedef UINT32 OS_STATUS;
#endif

#ifndef _TYPE_OS_THREAD_ID
#define _TYPE_OS_THREAD_ID
typedef UINT32 OS_THREAD_ID;
#endif

#ifndef BOOL
#define BOOL                int
#endif

#ifndef TRUE
#define TRUE (BOOL)1
#endif
#ifndef FALSE
#define FALSE (BOOL)0
#endif

typedef VOID (*OS_FUNC_ENTRY)(VOID *);

#endif
