/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_audiomanager.c
 * File Mark:
 * Description: manager audio device status.

 * Others:
 * Version:
 * Author:        lvwenhua
 * Date:          2016-7-7
 * History 1:
 *     Date: 2016-7-7
 *     Version:
 *     Author:kvwenhua
 *     Modification: add
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_ramlog.h"
#include "drvs_audiomanager.h"
#include "drvs_i2s.h"
#include "drvs_voiceprocess.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/


/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
static BOOL s_audioM_isUsing[MAX_AUDIO_MANAGER_RESOURCE] = {FALSE};
static ZOSS_MUTEX_ID s_audioM_mutex = NULL;
//extern UINT8 g_isUseSlicCodec;
extern T_zDrvVoice_GbVar g_voiceVar;
/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
static VOID audioM_create_mutex(VOID)
{
    s_audioM_mutex = zOss_CreateMutex("audio_manager", ZOSS_NO_INHERIT);
	/*klocwork 3 INVARIANT_CONDITION.UNREACH  delete*/
    /*if(s_audioM_mutex == NULL)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "audioM_create_mutex err \r\n");
    }*/
}

static VOID audioM_claim_mutex(VOID)
{
    if(s_audioM_mutex == NULL)
    {
        audioM_create_mutex();
    }

    if(s_audioM_mutex != NULL)
    {
        zOss_GetMutex(s_audioM_mutex, ZOSS_WAIT_FOREVER);
    }
}

static VOID audioM_release_mutex(VOID)
{
    if(s_audioM_mutex != NULL)
    {
        zOss_PutMutex(s_audioM_mutex);
    }
}


static SINT32 audioM_check_for_conflict(T_ZDrvAudioM_Resource res)
{
    UINT8 i = 0;
    SINT32 ret = DRV_SUCCESS;
    T_I2s_Status i2s1_state = I2S_IDLE;
	T_I2s_Status i2s2_state = I2S_IDLE;
    
    //if play tone, must be in calling
    if(res == AUDIO_MANAGER_RESOURCE_TONE_IN_SPEECH)
    {
        if( (s_audioM_isUsing[AUDIO_MANAGER_RESOURCE_VOICE] == TRUE)
            || (s_audioM_isUsing[AUDIO_MANAGER_RESOURCE_VOLTE] == TRUE) )
        {
            ret = DRV_SUCCESS;
        }
        else
        {
            ret = DRV_ERR_NOT_OPENED;
        }
    }
    else
    {
        if(TRUE == s_audioM_isUsing[res]) //except tone, all resource must not be openned times
        {
			if(res == AUDIO_MANAGER_RESOURCE_FM)
			{
				ret = DRV_SUCCESS;
			}
			else
			{
	            ret = DRV_ERR_OPEN_TIMES;
			}
        }
        else //except tone, all resource must not conflict
        {
            for (i=0;i<MAX_AUDIO_MANAGER_RESOURCE;i++)
            {
                if(s_audioM_isUsing[i] == TRUE)
                {
                    ret = DRV_ERR_BUSY;
                    break;
                }
            }

			if(ret == DRV_SUCCESS)
			{
				i2s1_state = zDrvI2s_GetI2sStatus(I2S_1);
				i2s2_state = zDrvI2s_GetI2sStatus(I2S_2);
                if((g_voiceVar.isUseSlicCodec !=1))
                {
				if((i2s1_state != I2S_IDLE)||(i2s2_state != I2S_IDLE))
				{
					ret = DRV_ERR_BUSY;
				}
			}
                else
                {
                    if(i2s2_state != I2S_IDLE)
                    {
                        ret = DRV_ERR_BUSY;
                    }
                }
            }
        }
    }

    // if no conflict was found, return DRV_SUCCESS 
    return ret;
} 

SINT32 zDrvAudioM_GetResource(T_ZDrvAudioM_Resource res)
{
    SINT32 ret = DRV_SUCCESS;

    audioM_claim_mutex(); 

    ret = audioM_check_for_conflict(res);
    if(ret == DRV_SUCCESS)
    {
        s_audioM_isUsing[res] = TRUE;
    }	
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAudioM_GetResource error res = %d!\n", res);
	}

    audioM_release_mutex();

    return ret;
}



SINT32 zDrvAudioM_FreeResource(T_ZDrvAudioM_Resource res)
{
    audioM_claim_mutex(); 

    s_audioM_isUsing[res] = FALSE;

    audioM_release_mutex();

    return DRV_SUCCESS;
}




