/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_extintf.c
 * File Mark:
 * Description: Loop voice data from teak to arm.
                    Settings: arm iis1->top iis1(connect to ap), arm iis2 loop to teak afe.

 * Others:
 * Version:
 * Author:        xuxinqiang
 * Date:          2015-8-29
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
//#include "drv_pub.h"
#include "drvs_i2s.h"
#include "oss_api.h"
#include "drvs_ramlog.h"
//#include "drvs_volte.h"
#include "drvs_voiceprocess.h"
#include "hal_voiceprocess.h"
#include "drvs_voice_config.h"
//#include "voice_api.h"
#include "hal_voice.h"
//#include "hal_pcmmixer.h"
#ifdef _USE_NXP_AUD
#include "hal_nxp.h"
#endif
#include "hal_audiointf.h"
#include "drvs_audiomanager.h"
//#include "math.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/* each time receive 320 BYTES*/
#define MIXER_DATA_SHIFT_BITS 2


/****************************************************************************
* 	                                           Local Types
****************************************************************************/
typedef struct
{
	DOUBLE freqValue;
	DOUBLE freqAmp;

}
zDrvVp_Freqfft;

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
SINT32 cal_freq_fft(SINT16 *data, zDrvVp_Freqfft *freqfft, UINT16 n, UINT32 fs);
SINT32 halVpCfg_GetMixerToneInfo(T_ZDrvVp_ToneNum toneNum, T_HalMixerToneInfo *toneInfo); //xiu gai chu sheng ming
SINT32 halVpCfg_SetOutputMute(BOOL onoff);//xiu gai chu
/****************************************************************************
* 	                                          Global Constants
****************************************************************************/



/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_HalMixerToneInfo mixerToneInfo =
{
	FALSE,
	FALSE,
	0,
	0,
	0,
	0,
	NULL,
	0//xiu
};



extern T_HalVpCfg_Opt*  gHalVpCfg_ObjPtr ;
extern T_zDrvVoice_GbVar g_voiceVar;

//dtmf
extern T_DrvDtmf_Detect_Opt gDrvDtmf_Detect_Obj;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
extern SINT32 zDrvVp_LoopStart(T_ZDrv_VpPath path);
extern SINT32 zDrvVp_LoopStop(VOID);//xiu gai chu tian jia void
#ifdef _USE_AUDEXT_CODEC_PATH_INTF
SINT32 halVpCfg_SetInputMute(BOOL onoff);//xiu gai chu sheng ming
#endif
SINT32 halVpCfg_GetAudioLoopInfo(T_HalAudioLoopTestInfo *audioInfo);//xiu gai chu sheng ming
SINT32 halVpCfg_SetOutputVol(T_ZDrv_VpVol vol);//xiu gai chu sheng ming
SINT32 halVpCfg_GetAudioLoopResult(T_HalAudioLoopTestPra *audioPra);//xiu gai chu sheng ming


SINT32 zDrvVp_GetTxVol(VOID);
SINT32 zDrvVp_SetTxVol(T_ZDrv_VpVol volume);
SINT32 zDrvVp_SetRxMute(UINT32 enable, UINT32 channel);
SINT32 zDrvVp_GetRxMute(UINT32 *enable, UINT32 channel);
extern SINT32 zDrvVp_Soft_Dtmf_Loop(T_ZDrv_VpPath path);
/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
SINT32 zDrv_Audio_Printf(VOID *pFormat, ...)
{
	char str[256] = {0};
	va_list tArg;
	va_start(tArg, pFormat);
	vsprintf(str, pFormat, tArg);
	va_end(tArg);
	return zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, str);
}

SINT32 zDrvVp_GetVol_Wrap(VOID)
{
	return g_voiceVar.vpVol;
}
SINT32 zDrvVp_SetVol_Wrap(int volume)
{
	return zDrvVp_SetVol(volume);
}

SINT32 zDrvVp_GetTxVol_Wrap(VOID)
{
	return zDrvVp_GetTxVol();
}
SINT32 zDrvVp_SetTxVol_Wrap(int volume)
{
	return zDrvVp_SetTxVol(volume);
}

SINT32 zDrvVp_GetPath_Wrap(VOID)
{
	return g_voiceVar.vpPath;
}
SINT32 zDrvVp_SetPath_Wrap(int path)
{
	return zDrvVp_SetPath(path);
}

SINT32 zDrvVp_SetMute_Wrap(BOOL enable)
{
	return zDrvVp_SetMute(enable, VOICE_UPLINK);
}

BOOL zDrvVp_GetMute_Wrap(VOID)
{
	return g_voiceVar.muteEn;
}
SINT32 zDrvVp_SetRxMute_Wrap(int enable)
{
	return zDrvVp_SetRxMute(enable, VOICE_DOWNLINK);
}

int zDrvVp_GetRxMute_Wrap(VOID)
{
	return g_voiceVar.rxMuteEn;
}

SINT32 zDrvVp_SetTone_Wrap(T_ZDrvVp_ToneNum toneNum)
{
	return zDrvVp_ToneMixerStart(toneNum);
}
SINT32 zDrvVp_SetVpLoop_Wrap(int path)
{
	return zDrvVp_Loop(path);
}
SINT32 zDrvVp_GetVpLoop_Wrap(VOID)
{
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:vpLoopBkRunning=%d.\n", __func__, g_voiceVar.vpLoopBkRunning);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,  "%s:vpLoopBkRunning=%d.\n", __func__, g_voiceVar.vpLoopBkRunning);
	return g_voiceVar.vpLoopBkRunning;
}

SINT32 zDrvVp_GetSlicFlag(VOID)
{

	return g_voiceVar.isUseSlicCodec;

}
SINT32 zDrvVp_SetEchoDelay_Wrap(int val)
{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_SetEchoDelay(val);
	return ret;
}

SINT32 zDrvVp_GetEchoDelay_Wrap(void)
{

	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_GetEchoDelay();
	return ret;

}

SINT32 zDrvVp_SetTxNsMode_Wrap(int val)
{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_SetTxNsMode(val);
	return ret;
}

SINT32 zDrvVp_GetTxNsMode_Wrap(void)
{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_GetTxNsMode();
	return ret;

}
SINT32 zDrvVp_SetRxNsMode_Wrap(int val)
{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_SetRxNsMode(val);
	return ret;
}

SINT32 zDrvVp_GetRxNsMode_Wrap(void)
{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_GetRxNsMode();
	return ret;

}


SINT32 zDrvVp_SetModuleState_Wrap(int *mod, int count)

{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_SetModuleState(mod, count);

	return ret;

}

SINT32 zDrvVp_GetModuleState_Wrap(int *mod, int count)

{
	SINT32  ret = DRV_SUCCESS;
	ret = VoiceProc_GetModuleState(mod, count);
	return ret;
}



SINT32 zDrvVp_SetPath(T_ZDrv_VpPath path)
{

	SINT32  ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath begin path=%d,vpI2sStatus=%d,vProcIsNormal=%d!", path, g_voiceVar.vpI2sStatus, g_voiceVar.vProcIsNormal);
	if (path >= MAX_VP_PATH)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath path not support!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath g_voiceVar.vpI2sStatus idle set path return!\r\n");
		g_voiceVar.vpPath = path;
		return DRV_SUCCESS;
	}

	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath vp_loop_on return !\r\n");
		return DRV_SUCCESS;
	}

	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath path=%d,vProcIsNormal=%d!", path, g_voiceVar.vProcIsNormal);
	if (g_voiceVar.vProcIsNormal == TRUE)
	{
#ifdef _USE_NXP_AUD
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol NXP set path!\r\n");
		ret = Vp_NxpGetParam(g_voiceVar.voiceMode, path);
		if (ret == DRV_SUCCESS)
		{
			ret = Vp_NxpSetParam(path, g_voiceVar.vpVol, FALSE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath Vp_NxpSetParam err ret=%x !\n", ret);
				return DRV_ERROR;
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath Vp_NxpGetParam err ret=%x !\n", ret);
			return DRV_ERROR;
		}
#elif defined _USE_WEBRTC_AUD
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "webrtc  set path!\r\n");

		ret = Webrtc_GetParam(g_voiceVar.voiceMode,  path);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath Webrtc_GetParam err ret=%x !\n", ret);
			return DRV_ERROR;

		}
		ret = Webrtc_SetParam(g_voiceVar.voiceMode,  path);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath Webrtc_SetParam err ret=%x !\n", ret);
			return DRV_ERROR;

		}

#endif
	}


	if ((path == VP_PATH_HANDSET) || (path == VP_PATH_HEADSET) || (path == VP_PATH_SPEAKER))
	{
		ret = halVpCfg_SetInputPath(path, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath halVpCfg_SetInputPath err ret=%x !\n", ret);
			return DRV_ERROR;
		}
		ret = halVpCfg_SetOutputPath(path, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath halVpCfg_SetOutputPath err ret=%d !\n", ret);
			return DRV_ERROR;
		}

	}

	g_voiceVar.vpPath = path;

	return DRV_SUCCESS;
}

SINT32 zDrvVp_GetPath(T_ZDrv_VpPath *path)
{

	SINT32  ret = DRV_SUCCESS;
	*path = g_voiceVar.vpPath;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath begin *path=%d,vpI2sStatus=%d,vProcIsNormal=%d!", *path, g_voiceVar.vpI2sStatus, g_voiceVar.vProcIsNormal);

	return DRV_SUCCESS;
}



#ifdef _USE_AUDEXT_CODEC_PATH_INTF

SINT32 zDrvVp_SetRxPath(T_ZDrv_CodecOutputPath path, BOOL isenable)
{
	SINT32  ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxPath is=%d", path);
	if (path >= MAX_CODEC_OUTPUT_PATH)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxPath path not support!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}
	T_ZDrv_VpPath temppath;
	switch (path)
	{
	case CODEC_OUTPUT_RECEIVER:
		temppath = VP_PATH_HANDSET;
		break;
	case  CODEC_OUTPUT_SPEAKER:
		temppath = VP_PATH_SPEAKER;
		break;
	case CODEC_OUTPUT_HEADSET:
		temppath = VP_PATH_HEADSET;
		break;
	case CODEC_OUTPUT_HSANDSPK:
		temppath = VP_PATH_HSANDSPK;
		break;
	case CODEC_OUTPUT_BLUETOOTH:
		temppath = VP_PATH_BLUETOOTH;
		break;
	default:
		return DRV_ERR_INVALID_PARAM;

	}
	ret = halVpCfg_SetOutputPath(temppath, isenable);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxPath  err ret=%d !\n", ret);
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}

SINT32 zDrvVp_SetTxPath(T_ZDrv_CodecInputPath path, BOOL isenable)
{
	SINT32  ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetTxPath is=%d", path);
	if (path >= MAX_CODEC_INPUT_PATH)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetTxPath path not support!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}
	T_ZDrv_VpPath temppath;
	switch (path)
	{
	case CODEC_INPUT_MICPHONE:
		temppath = VP_PATH_HANDSET;
		break;
	case  CODEC_INPUT_HEADSET:
		temppath = VP_PATH_HEADSET;
		break;
	case CODEC_INPUT_HANDSFREE:
		temppath = VP_PATH_SPEAKER;
		break;
	case CODEC_INPUT_BLUETOOTH:
		temppath = VP_PATH_BLUETOOTH;
		break;
	default:
		return DRV_ERR_INVALID_PARAM;
	}
	ret = halVpCfg_SetInputPath(temppath, isenable);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetTxPath  err ret=%d !\n", ret);
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}
#endif

SINT32 zDrvVp_SetVol(T_ZDrv_VpVol volume)
{
	SINT32  ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol begin volume=%d,g_voiceVar.vpI2sStatus=%d!", volume, g_voiceVar.vpI2sStatus);
	if (volume >= MAX_VP_VOL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol volume not support!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetPath g_voiceVar.vpI2sStatus idle set volume return!\r\n");
		g_voiceVar.vpVol = volume;
		return DRV_SUCCESS;
	}

	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol vp_loop_on return !\r\n");
		return DRV_SUCCESS;
	}
	if (volume >= VP_VOL_6)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol volume >=vol_6,set vol5 volume=%d!",volume);
		volume = VP_VOL_5;
	}
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol volume=%d,ret=%d!", volume, ret);

	if (g_voiceVar.vProcIsNormal == TRUE) /*klocwork 3 INVARIANT_CONDITION.UNREACH  delete*/
	{
#ifdef _USE_NXP_AUD
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol NXP set volume!\r\n");
		ret = Vp_NxpGetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath);
		ret += Vp_NxpSetParam(g_voiceVar.vpPath, volume, FALSE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol Vp_NxpSetParam err ret=%d !\n", ret);
			return DRV_ERROR;
		}
#elif defined _USE_WEBRTC_AUD
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol wetrtc vol=%d!\r\n", volume);

		//ret =Webrtc_SetRxVol(volume);
		ret = Webrtc_SetVol(g_voiceVar.voiceMode, g_voiceVar.vpPath, volume);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetVol Webrtc_SetRxVol err ret=%d !\n", ret);
			return DRV_ERROR;
		}
#endif

	}

	g_voiceVar.vpVol = volume;

	return DRV_SUCCESS;
}

SINT32 zDrvVp_GetVol(int *volume)
{
	SINT32  ret = DRV_SUCCESS;

	

	*volume = g_voiceVar.vpVol;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_GetVol  *volume=%d,g_voiceVar.vpI2sStatus=%d!", *volume, g_voiceVar.vpI2sStatus);

	return DRV_SUCCESS;
}


SINT32 zDrvVp_GetTxVol(VOID)
{
#ifdef  _USE_WEBRTC_AUD

	return Webrtc_GetTxVol();
#else
	return 0;
#endif
}
SINT32 zDrvVp_SetTxVol(T_ZDrv_VpVol volume)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef  _USE_WEBRTC_AUD
	ret = Webrtc_SetTxVol(volume);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetTxVol Webrtc_SetTxVol err ret=%d !\n", ret);
		return DRV_ERROR;
	}
#endif
	return DRV_SUCCESS;
}
SINT32 zDrvVp_SetMute(UINT32 enable, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;
#if 0
	T_ZDrvVoice_MuteInfo muteinfo;
	muteinfo.enable = enable;
	muteinfo.channel = channel;
	ret = voice_SetMute(&muteinfo);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute enable=%d,channel=%d,ret=%d!", enable, channel, ret);
#endif

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute g_voiceVar.vpI2sStatus idle not support set mute !\r\n");
		return DRV_ERROR;
	}
	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute vp_loop_on return !\r\n");
		return DRV_SUCCESS;
	}

	if (enable == 1)
	{
		g_voiceVar.muteEn = TRUE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute  set g_voiceVar.muteEn TRUE !\n");

	}
	else
	{
		g_voiceVar.muteEn = FALSE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute  set g_voiceVar.muteEn FASLE !\n");
	}

	if (g_voiceVar.vProcIsNormal == TRUE)
	{
#ifdef _USE_NXP_AUD
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute NXP set mute!\r\n");
		ret = Vp_NxpGetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath);
		ret += Vp_NxpSetParam(g_voiceVar.vpPath, g_voiceVar.vpVol, FALSE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute nxp set mute  err ret=%d !\n", ret);

			if (enable == 1)
			{
				g_voiceVar.muteEn = FALSE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute  NXP set mute fail,set g_voiceVar.muteEn FALSE !\n");

			}
			else
			{
				g_voiceVar.muteEn = TRUE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute  NXP set mute fail,set g_voiceVar.muteEn TRUE !\n");

			}
			return DRV_ERROR;
		}
#elif defined _USE_WEBRTC_AUD

		ret = Webrtc_SetMute(enable);
		if (ret != DRV_SUCCESS)
		{
			return DRV_ERROR;
		}

#endif
	}

	return DRV_SUCCESS;

}

SINT32 zDrvVp_GetMute(UINT32 *enable, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;


	*enable = g_voiceVar.muteEn;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_GetMute  Get g_voiceVar.muteEn=%d !\n",g_voiceVar.muteEn);



	return DRV_SUCCESS;

}

SINT32 zDrvVp_SetRxMute(UINT32 enable, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;
#if 0
	T_ZDrvVoice_MuteInfo muteinfo;
	muteinfo.enable = enable;
	muteinfo.channel = channel;
	ret = voice_SetMute(&muteinfo);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetMute enable=%d,channel=%d,ret=%d!", enable, channel, ret);
#endif

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute g_voiceVar.vpI2sStatus idle not support set mute !\r\n");
		return DRV_ERROR;
	}
	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute vp_loop_on return !\r\n");
		return DRV_SUCCESS;
	}

	if (enable == 1)
	{
		g_voiceVar.rxMuteEn = TRUE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute  set g_voiceVar.rxMuteEn TRUE !\n");

	}
	else
	{
		g_voiceVar.rxMuteEn = FALSE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute  set g_voiceVar.rxMuteEn FASLE !\n");
	}

	if (g_voiceVar.vProcIsNormal == TRUE)
	{
#ifdef _USE_NXP_AUD

#elif defined _USE_WEBRTC_AUD

		ret = Webrtc_SetRxMute(enable);
		if (ret != DRV_SUCCESS)
		{
			if (enable == 1)
			{
				g_voiceVar.rxMuteEn = FALSE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute  set rxMuteEn fail,set g_voiceVar.muteEn FALSE !\n");

			}
			else
			{
				g_voiceVar.rxMuteEn = TRUE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetRxMute   set rxMuteEn fail,set g_voiceVar.muteEn TRUE !\n");

			}
			return DRV_ERROR;		
		}

#endif
	}

	return DRV_SUCCESS;

}
SINT32 zDrvVp_GetRxMute(UINT32 *enable, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;


	*enable = g_voiceVar.rxMuteEn;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_GetRxMute  Get g_voiceVar.rxMuteEn=%d !\n",g_voiceVar.rxMuteEn);



	return DRV_SUCCESS;

}

#if 0
//dtmf-ػ
T_DrvDtmf_Detect_Opt dtmf_looptest;
void drv_dtmfrxloop_report(char *dtmf_string, unsigned char string_len)
{
    //printk("drv_dtmfrx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "drv_dtmfrxloop_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
}
void drv_dtmftxloop_report(char *dtmf_string, unsigned char string_len)
{
    //printk("drv_dtmftx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "drv_dtmftxloop_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
}
#endif
SINT32 zDrvVp_Soft_Dtmf_Loop(T_ZDrv_VpPath path)
{
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_Soft_Dtmf_Loop enter\n");
    SINT32 ret = DRV_SUCCESS;
    
    if((path == VP_PATH_HANDSET) || (path == VP_PATH_HEADSET) || (path == VP_PATH_SPEAKER))
    {
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_Soft_Dtmf_Loop g_voiceVar.useDtmfLoop = %d\n", g_voiceVar.useDtmfLoop);
#if 0  
        //dtmf-ػ
        dtmf_looptest.drv_dtmfrx_report_cb = drv_dtmfrxloop_report;
        dtmf_looptest.drv_dtmftx_report_cb = drv_dtmftxloop_report;
        zDrvDtmf_Detect_RegCallbacks(dtmf_looptest);
#endif        
        //dtmf-ػ
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStart enter\n");
        ret = zDrvVp_DtmfSoftwareStart(1, 8000);
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStart end, ret=%d\n", ret);  
        if(ret == 0)
            g_voiceVar.useDtmfLoop = 1;
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStart end, ret=%d,useDtmfLoop=%d\n", ret,g_voiceVar.useDtmfLoop);  
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStart end, ret=%d,useDtmfLoop=%d\n", ret,g_voiceVar.useDtmfLoop); 
    }
    else if(path == VP_PATH_OFF)
    {
        //dtmf-ػر
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_Soft_Dtmf_Loop g_voiceVar.useDtmfLoop = %d\n", g_voiceVar.useDtmfLoop);
        ret = zDrvVp_DtmfSoftwareStop();
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStop end, ret=%d\n", ret);  
        if(ret == 0)
            g_voiceVar.useDtmfLoop = 0;
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStop end, ret=%d,useDtmfLoop=%d\n", ret,g_voiceVar.useDtmfLoop);  
		
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_LoopProcessThreadEntry zDrvVp_DtmfSoftwareStop end, ret=%d,useDtmfLoop=%d\n", ret,g_voiceVar.useDtmfLoop); 
    }
    else 
    {
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_Soft_Dtmf_Loop path is error!\n");
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Soft_Dtmf_Loop path is error,useDtmfLoop=%d!\n",g_voiceVar.useDtmfLoop);
        return DRV_ERR_NOT_SUPPORTED;
    }
    
    ret = zDrvVp_Loop(path);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_Soft_Dtmf_Loop leave ret=%d\n",ret);

    return ret;
}

SINT32 zDrvVp_Loop(T_ZDrv_VpPath path)
{
	SINT32 ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Loop begin g_voiceVar.vpI2sStatus=%d,path=%d", g_voiceVar.vpI2sStatus, path);

	if (path == VP_PATH_OFF)
	{
		if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
		{
			ret = zDrvVp_LoopStop();
		}
		else
		{
			return DRV_SUCCESS;
		}
	}
	else if ((path == VP_PATH_HANDSET) || (path == VP_PATH_HEADSET) || (path == VP_PATH_SPEAKER))
	{
		if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
		{
			ret = halVpCfg_SetInputPath(path, TRUE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);
				return DRV_ERROR;
			}
			ret = halVpCfg_SetOutputPath(path, TRUE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);
				return DRV_ERROR;
			}
			g_voiceVar.vpLoopPath = path;

		}
		else
		{
			ret = zDrvVp_LoopStart(path);
		}

	}
	else
	{
		return DRV_ERR_NOT_SUPPORTED;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Loop end g_voiceVar.vpI2sStatus=%d,ret=%d", g_voiceVar.vpI2sStatus, ret);
	return ret;
}

//added by zhanglixia
SINT32 zDrvVp_NxpSetParam(zDrvVp_NxpParamsTool *NxpParamsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_NXP_AUD
//#ifdef _OS_TOS
	/* if((g_voiceVar.vProcIsNormal!=TRUE))

	  return DRV_ERR_INVALID_PARAM;	*/

	BOOL  isLoop = false;
	//UINT16 offset=0x19;
	//UINT16 volumeindex = 0;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_zDrvVp_SetParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((NxpParamsTool->pPresetRx == NULL) || (NxpParamsTool->PresetLengthRx <= 0))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Param is NULL!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}

	/* if(g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	 {
	         return DRV_ERROR;
	 }*/

	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		isLoop = TRUE;
		return DRV_SUCCESS;
	}
	//ret = Vp_NxpOpen();
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d vp Vp_NxpOpen",ret);
	//g_voiceVar.vpPath = VP_PATH_HANDSET;
	//g_voiceVar.vpVol = VP_VOL_3;

	/*klocwork 3 INVARIANT_CONDITION.UNREACH UNREACH.GEN delete if...else...*/
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool!\r\n");
	//volumeindex =* (NxpParamsTool->pPresetRx+offset);
	ret = Vp_NxpSetParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  NxpParamsTool, isLoop, g_voiceVar.voiceInVolteMode);

#endif
	return ret;
}
SINT32 zDrvVp_NxpGetParam(zDrvVp_NxpParamsTool *NxpParamsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_NXP_AUD
//#ifdef _OS_TOS

	/*if((g_voiceVar.vProcIsNormal!=TRUE))

	  return DRV_ERR_INVALID_PARAM;	*/
	BOOL   isLoop = false;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_zDrvVp_GetParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((NxpParamsTool->pPresetRx == NULL) || (NxpParamsTool->PresetLengthRx <= 0))
	{
		return DRV_ERR_INVALID_PARAM;
	}

	/* if(g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	 {
	         return DRV_ERROR;
	 }*/
	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		isLoop = TRUE;
		return DRV_SUCCESS;
	}

	//ret = Vp_NxpOpen();
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d vp Vp_NxpOpen",ret);
	//g_voiceVar.vpPath = VP_PATH_HANDSET;
	// g_voiceVar.vpVol = VP_VOL_3;

	/*klocwork 3 INVARIANT_CONDITION.UNREACH UNREACH.GEN  delete if...else...*/
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool!\r\n");
	ret = Vp_NxpGetParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  NxpParamsTool, isLoop, g_voiceVar.voiceInVolteMode);

#endif

	return ret;
}
//end added by zhanglixia



SINT32 zDrvVp_SetParam(zDrvVp_ParamsTool *paramsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD


	BOOL  isLoop = false;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((paramsTool->pPresetRx == NULL) || (paramsTool->PresetLengthRx <= 0))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Param is NULL!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}

	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		isLoop = TRUE;
		return DRV_SUCCESS;
	}


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_SetParamTool!\r\n");

	ret = Webrtc_SetParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  paramsTool, isLoop, g_voiceVar.voiceInVolteMode);
#endif
	return ret;
}

SINT32 zDrvVp_GetParam(zDrvVp_ParamsTool *paramsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD

	BOOL   isLoop = false;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_GetParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((paramsTool->pPresetRx == NULL) || (paramsTool->PresetLengthRx <= 0))
	{
		return DRV_ERR_INVALID_PARAM;
	}


	if (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
	{
		isLoop = TRUE;
		return DRV_SUCCESS;
	}


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_GetParamTool!\r\n");
	ret = Webrtc_GetParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  paramsTool, isLoop, g_voiceVar.voiceInVolteMode);

#endif

	return ret;
}

SINT32 zDrvVp_SetNvParam(zDrvVp_ParamsTool *paramsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD


	BOOL  isLoop = false;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetNvParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((paramsTool->pPresetRx == NULL) || (paramsTool->PresetLengthRx <= 0))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Param is NULL!\r\n");
		return DRV_ERR_INVALID_PARAM;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_SetNvParamTool!\r\n");
	ret = Webrtc_SetNvParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  paramsTool, isLoop, g_voiceVar.voiceInVolteMode);
#endif
	return ret;
}

SINT32 zDrvVp_GetNvParam(zDrvVp_ParamsTool *paramsTool)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD

	BOOL   isLoop = false;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_GetNvParam begin path=%d,volume=%d,g_voiceVar.vpI2sStatus=%d!", g_voiceVar.vpPath, g_voiceVar.vpVol, g_voiceVar.vpI2sStatus);
	if ((paramsTool->pPresetRx == NULL) || (paramsTool->PresetLengthRx <= 0))
	{
		return DRV_ERR_INVALID_PARAM;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_GetNvParamTool!\r\n");
	ret = Webrtc_GetNvParamTool(g_voiceVar.vpPath,  g_voiceVar.vpVol,  paramsTool, isLoop, g_voiceVar.voiceInVolteMode);

#endif

	return ret;
}

#ifdef VOICE_TONE_MIXER_FUNCTION


/*******************************************************************************
 * Function: zDrvVp_ToneMixerStart
 * Description: This function is used to start mixer tone.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/


SINT32 zDrvVp_ToneMixerStart(T_ZDrvVp_ToneNum toneNum)
{
	SINT32 ret = DRV_SUCCESS;

	ret = zDrvAudioM_GetResource(AUDIO_MANAGER_RESOURCE_TONE_IN_SPEECH);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVp_ToneMixerStart fail to get tone resource\n");
		return ret;
	}
	mixerToneInfo.cur_tone_fcount = 0;
	mixerToneInfo.StartMixer = TRUE;

	if ((g_voiceVar.voiceInVolteMode == 1) && (g_voiceVar.volteIsWb == 1))
	{
		mixerToneInfo.data_mixer_oncesize = 320;
		mixerToneInfo.dataIsWb = TRUE;

	}
	else
	{
		mixerToneInfo.data_mixer_oncesize = 160;
		mixerToneInfo.dataIsWb = FALSE;

	}
	ret = halVpCfg_GetMixerToneInfo(toneNum, &mixerToneInfo);
	/*

	    if(0 == toneNum)
	    {
	        mixerToneInfo.ptdata_mixer=(UINT16 *)lowPowerPcm;
	        //mixerToneInfo.tone_total_size=sizeof(lowPowerPcm)/sizeof(char);
	        mixerToneInfo.tone_total_size=sizeof(lowPowerPcm)/sizeof(UINT16);

	    }
	    {
	        mixerToneInfo.ptdata_mixer=(UINT16 *)smsPcm;
	        mixerToneInfo.tone_total_size=sizeof(smsPcm)/sizeof(UINT16);
	    }
	    else if(2 == toneNum)
	    {
	        mixerToneInfo.ptdata_mixer=(UINT16 *)callStandardPcm;
	        mixerToneInfo.tone_total_size=sizeof(callStandardPcm)/sizeof(UINT16);
	    }
	    else if(3 == toneNum)
	    {
	        mixerToneInfo.ptdata_mixer=(UINT16 *)alarmBeepPcm;
	        mixerToneInfo.tone_total_size=sizeof(alarmBeepPcm)/sizeof(UINT16);
	    }
	    else if(4 == toneNum)
	    {
	        mixerToneInfo.ptdata_mixer=(UINT16 *)callTimePcm;
	        mixerToneInfo.tone_total_size=sizeof(callTimePcm)/sizeof(UINT16);
	    }
	    else
	    {
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ToneMixerStart para is error!");
	        return DRV_ERROR;
	    }

	    mixerToneInfo.inter_mixer_fcount=mixerToneInfo.tone_total_size/VOICE_MIXER_DATA_SIZE;
	    mixerToneInfo.rem_mixer_count=mixerToneInfo.tone_total_size%VOICE_MIXER_DATA_SIZE;
	*/
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ToneMixerStart toneNum=%d,ret=%d!", toneNum, ret);

	return ret;
}
SINT32 voice_ToneMixerStop(VOID)   /*add for 7502 Online Record*/
{
	SINT32 ret = DRV_SUCCESS;
	mixerToneInfo.StartMixer = FALSE;
	mixerToneInfo.cur_tone_fcount = 0;
	mixerToneInfo.rem_mixer_count = 0;
	mixerToneInfo.inter_mixer_fcount = 0;
	//ptdata_mixer=toneArray;
	zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_TONE_IN_SPEECH);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_ToneMixerStop !");

	return ret;

}

SINT32 zDrvVp_ToneMixerStop(VOID)
{
	SINT32 ret = DRV_SUCCESS;
	ret = voice_ToneMixerStop();
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ToneMixerStop ret!", ret);
	return ret;
}

/*******************************************************************************
 * Function: voice_MixerData
 * Description: This function is used to mixer tone data.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/




int voice_MixerData(SINT16* input1, SINT16* input2, SINT32 mix_count, SINT16* output)
//static int voice_MixerData(SINT16* input1, SINT16* input2, SINT32 mix_count, SINT16* output)
{
	double f = 1;
	SINT32 i = 0;

	SINT32 const SINT16_MAX = (SINT32)(pow(2.0, 15) - 1);
	SINT32 const SINT16_MIN = (SINT32)(-pow(2.0, 15));

	//printf("SINT16_MAX: %d\n", SINT16_MAX);
	//printf("SINT16_MIN: %d\n", SINT16_MIN);

	if (input1 == NULL || input2 == NULL || output == NULL || mix_count < 0)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	for (i = 0; i < mix_count; i++)
	{
		SINT32 temp = 0;

		temp = *(input1 + i) + *(input2 + i);

		temp = (SINT32)(temp * f);
		if (temp > SINT16_MAX)
		{
			f = (double)SINT16_MAX / (double)(temp);
			temp = SINT16_MAX;
			//printf("MAX++\n");
			//printf( "%d = %d + %d \n", temp, *(input1+i), *(input2+i));
		}
		if (temp < SINT16_MIN)
		{
			f = (double)SINT16_MIN / (double)(temp);
			temp = SINT16_MIN;
			//printf("MIN--\n", f);
			//printf( "%d = %d + %d \n", temp, *(input1+i), *(input2+i));
		}
		if (f < 1.0)
		{
			f += ((double)1 - f) / (double)32;
		}

		*(output + i) = temp;
	}
	return DRV_SUCCESS;
}
/*******************************************************************************
 * Function: voice_ToneMixerData
 * Description: This function is used to deal with mixer  data.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/


//UINT32 tone_size=sizeof(toneArray)/sizeof(UINT16);





//cur_tone_fcount+=1;




//mixerToneInfo.StartMixer= FALSE;




SINT32 voice_ToneMixerData(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata)
{
	SINT32 ret = 0;
	UINT32 size16 = size / sizeof(SINT16);

	//printf("mixerToneInfo.cur_tone_fcount = %d\n", mixerToneInfo.cur_tone_fcount);

	if (mixerToneInfo.cur_tone_fcount < mixerToneInfo.inter_mixer_fcount)
	{
		ret = voice_MixerData((SINT16*)pvdata, (SINT16*)mixerToneInfo.ptdata_mixer, size16, (SINT16*)pmixdata);
		if (ret != 0)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_MixerData failed");
			return ret;
		}
		mixerToneInfo.ptdata_mixer += size16;
		mixerToneInfo.cur_tone_fcount += 1;

	}
	else if (mixerToneInfo.cur_tone_fcount == mixerToneInfo.inter_mixer_fcount)
	{
		if (mixerToneInfo.rem_mixer_count > 0)
		{
			UINT32 msize = mixerToneInfo.rem_mixer_count;
			ret = voice_MixerData((SINT16*)pvdata, (SINT16*)mixerToneInfo.ptdata_mixer, msize, (SINT16*)pmixdata);
			if (ret != 0)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_MixerData failed");
				return ret;
			}
			zOss_Memcpy(pmixdata + msize, pvdata + msize, size16 - msize);
		}

		//printf("voice_ToneMixerStop\n");
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_ToneMixerStop");
		voice_ToneMixerStop();
	}
	return DRV_SUCCESS;
}




#endif

#ifdef _USE_AUDEXT_CODEC_PATH_INTF
SINT32 zDrvVp_SetFmPath(T_ZDrv_VpPath path, BOOL enable)
{

	SINT32  ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetFmPath begin path=%d,g_voiceVar.vpI2sStatus=%d!", path, g_voiceVar.vpI2sStatus);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetFmPath begin enable=%d!", enable);
	if (path >= MAX_VP_PATH)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	if (enable)
	{

		ret = zDrvAudioM_GetResource(AUDIO_MANAGER_RESOURCE_FM);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVp_SetFmPath fail to get fm resource\n");
			return ret;
		}

		ret = halVpCfg_SetFmPath(path, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetFmPath  err ret=%x !\n", ret);
			zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_FM);
		}
	}
	else
	{
		ret = halVpCfg_SetFmPath(path, FALSE);
		if (ret != DRV_SUCCESS)
		{

			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetFmPath  err ret=%x !\n", ret);
		}
		else
		{
			zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_FM);
		}
	}

	return ret;
}

SINT32 zDrvVp_SetInputMute(BOOL onoff)
{
	SINT32 ret = DRV_SUCCESS;

	ret = halVpCfg_SetInputMute(onoff);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInputMute  err ret=%d !\n", ret);
		return DRV_ERROR;
	}

	return ret;

}

SINT32 zDrvVp_SetOutputMute(BOOL onoff)
{
	SINT32 ret = DRV_SUCCESS;

	ret = halVpCfg_SetOutputMute(onoff);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetOutputMute  err ret=%d !\n", ret);
		return DRV_ERROR;
	}

	return ret;

}
#endif

VOID zDrvDtmf_Detect_RegCallbacks(T_DrvDtmf_Detect_Opt dtmfObj)
{
    gDrvDtmf_Detect_Obj = dtmfObj;
}

#if 0
static ZOSS_THREAD_ID s_audioPbLoopThread = NULL;
static ZOSS_THREAD_ID s_audioCaLoopThread  = NULL;
static ZOSS_SEMAPHORE_ID s_caputerDoneSemaphore = NULL;

static T_ZDrvI2S_Id I2S_ID = I2S_1;
BOOL readRuning = FALSE;
BOOL writeRuning = FALSE;

UINT8 *pAudioPbbuffer = NULL;
UINT8 *pAudioCabuffer = NULL;
static UINT32 pbCount = 0;
const UINT32 caCount = 2250;
static VOID audioPbLoopThread(SINT32 UNDEF)//xiu gai chu
{
	SINT32 ret = DRV_SUCCESS;

	SINT32 count = 0;
	UINT8 *bufptr = pAudioPbbuffer;
	UINT32 aud_len = 320;
	UINT8 *aud_buf = NULL;
	UINT32 length = 0;
	T_ZDrvI2s_Params parameter = {0};
	T_ZDrvI2S_Cfg playI2sCfg;

	length = (pbCount / aud_len) * aud_len;
	parameter.channel = AUDIO_MONO_CHANNEL;
	parameter.buffersize = aud_len;//10240  for file,112;  112 just  for data
	parameter.p_cb = NULL;

	playI2sCfg.bMaster = TRUE;
	playI2sCfg.sample_rate = 8000;
	playI2sCfg.tDataFmt = I2S_DATA_16BIT;//I2S_DATA_16BIT;
	playI2sCfg.tTsWidth = I2S_TS_16CYCLE;//I2S_TS_16CYCLE;
	playI2sCfg.tTrackFmt = LEFT_TRACK;//RIGHT_TRACK;//LEFT_TRACK
	playI2sCfg.tTestMode = I2S_NORMAL_MODE;
	playI2sCfg.tTimingType = TIMING_I2S_MONO_LEFT;
	playI2sCfg.tPcmFsync = PCM_SHORT_FSYNC;
	playI2sCfg.tTdmExtCycle = TDM_NO_EXTRA_CYCLE;
	playI2sCfg.tClkMode = I2S_TIME_MODE;


	playI2sCfg.tTransMode = DATA_ALIGN_STD_I2S;
	playI2sCfg.tTansmit_edge = TRANS_NEGATIVE_POSITIVE;//for i2s mode;
	ret = zDrvI2S_Write_Start(I2S_ID, &parameter, &playI2sCfg);

	if (ret != DRV_SUCCESS)
	{
		return;
	}
	while (1)
	{
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "enter audioPbLoopThread while before\n");
		while (writeRuning == TRUE)
		{
			// zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "enter audioPbLoopThread while after\n");

			ret += zDrvI2S_GetBuf(I2S_ID, &aud_buf, &aud_len);
			zOss_Memcpy(aud_buf, bufptr, aud_len);

			ret += zDrvI2S_Write(I2S_ID, aud_buf, aud_len);
			bufptr += aud_len;
			count += aud_len;
			if (count >= length)
			{
				bufptr = pAudioPbbuffer;
				count = 0;
			}

		}
		//zOss_Sleep(20);
	}
}
BOOL testAudioStart = FALSE;
//static BOOL s_mutex_FirstUse = FALSE;//xiu gai chu
//static ZOSS_MUTEX_ID s_autoAudioTestMutexID = NULL;//xiu gai chu
static VOID audioCaLoopThread(SINT32 UNDEF)//xiu gai chu gai bian han sheng ming
{
	SINT32 ret = DRV_SUCCESS;
	T_ZDrvI2S_Cfg playI2sCfg = {0};
	T_ZDrvI2s_Params params = {0};
	BOOL firstFull = FALSE;
	UINT8 *read_buf = NULL;
	UINT32 read_len = 320;
	UINT32 count = 0;
	UINT8 *RxBuffer = pAudioCabuffer;
	UINT32 length = 0;
	length = (caCount / read_len) * read_len;
	params.channel = AUDIO_MONO_CHANNEL;
	params.buffersize = 320;
	params.p_cb = NULL;

	playI2sCfg.bMaster = TRUE;
	playI2sCfg.sample_rate = 8000;
	playI2sCfg.tDataFmt = I2S_DATA_16BIT;//I2S_DATA_16BIT;
	playI2sCfg.tTsWidth = I2S_TS_16CYCLE;//I2S_TS_16CYCLE;
	playI2sCfg.tTrackFmt = LEFT_TRACK;//RIGHT_TRACK;//LEFT_TRACK
	playI2sCfg.tTestMode = I2S_NORMAL_MODE;
	playI2sCfg.tClkMode = I2S_TIME_MODE;

	playI2sCfg.tTimingType = TIMING_I2S_MONO_LEFT;
	playI2sCfg.tPcmFsync = PCM_SHORT_FSYNC;
	playI2sCfg.tTdmExtCycle = TDM_NO_EXTRA_CYCLE;

	playI2sCfg.tTransMode = DATA_ALIGN_STD_I2S;
	playI2sCfg.tTansmit_edge = TRANS_NEGATIVE_POSITIVE;//for i2s mode;

	ret += zDrvI2S_Read_Start(I2S_ID, &params, &playI2sCfg);
	if (ret != DRV_SUCCESS)
	{
		return;
	}
	while (1)
	{

		while (readRuning == TRUE)
		{

			ret = zDrvI2S_Read(I2S_ID, &read_buf, &read_len);
			//zOss_GetMutex(s_autoAudioTestMutexID, ZOSS_WAIT_FOREVER);

			zOss_Memcpy(RxBuffer, read_buf, read_len);

			RxBuffer += read_len;
			count += read_len;
			//zOss_PutMutex(s_autoAudioTestMutexID);

			ret = zDrvI2S_FreeBuf(I2S_ID, read_buf);
			if (count >= length)
			{
				if (firstFull == FALSE)
				{
					if (ZOSS_SUCCESS != zOss_PutSemaphore(s_caputerDoneSemaphore))
					{
						zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "audioCaLoopThread put sema error.\n");
						continue;
					}
					firstFull = TRUE;
				}
				count = 0;
				//recordFileFlag = 0;
				RxBuffer = pAudioCabuffer;
			}
		}
		//zOss_Sleep(20);

	}
}


SINT32 zDrvVp_TestAudioLoopPath(T_ZDrv_VpPath path)
{
	SINT32 ret = DRV_SUCCESS;
	SINT32 audioLoopRet = DRV_SUCCESS;
	T_HalAudioLoopTestInfo info = {0};
	T_ZDrv_VpVol outpathvol[4];

	T_ZDrv_VpFs codecfs;
	UINT32 sampfs = 0;
	UINT8 *pbuffer = NULL;
	T_HalAudioLoopTestPra audioPra = {0};
	if (testAudioStart == TRUE) return DRV_ERR_BUSY;
	testAudioStart = TRUE;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath  open!\n");
	readRuning = FALSE;
	writeRuning = FALSE;
	/*if (FALSE == s_mutex_FirstUse)
	{
	    s_autoAudioTestMutexID = zOss_CreateMutex("autoAudioTestMutex",  ZOSS_INHERIT);   //create mutex
	    s_mutex_FirstUse=TRUE;
	}*/

	ret = halVpCfg_GetAudioLoopInfo(&info);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath halVpCfg_GetAudioLoopInfo err ret=%d !\n", ret);
		testAudioStart = FALSE;
		return DRV_ERROR;
	}

	pAudioPbbuffer = info.ptdata;
	pbCount = info.totalSize;
	sampfs = info.sampFs;
	outpathvol[0] = info.outpathvol[0];
	outpathvol[1] = info.outpathvol[1];
	outpathvol[2] = info.outpathvol[2];
	outpathvol[3] = info.outpathvol[3];

	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "sampfs=%d!\n", sampfs);

	if (sampfs == 8000)
	{
		codecfs = VP_FS_8000;
	}
	else if (sampfs == 16000)
	{
		codecfs = VP_FS_16000;

	}
	else
	{
		testAudioStart = FALSE;
		return DRV_ERR_NOT_SUPPORTED;
	}

	//temp = cal_freq_fft( pAudioPbbuffer,1024,16000);
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"temp=%f!\n",temp);


	ret = halVpCfg_Open(VP_VOICE_SOURCE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath halVpCfg_Open err ret=%d !\n", ret);
		testAudioStart = FALSE;
		return DRV_ERROR;

	}

	ret = halVpCfg_SetFs(codecfs);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath halVpCfg_SetFs err ret=%d !\n", ret);
		halVpCfg_Close();
		testAudioStart = FALSE;

		return DRV_ERROR;

	}

	ret = halVpCfg_SetInputPath(path, TRUE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath  halVpCfg_SetInputPath err ret=%d !\n", ret);
		halVpCfg_Close();
		testAudioStart = FALSE;

		return DRV_ERROR;

	}

	ret = halVpCfg_SetOutputPath(path, TRUE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vzDrvVp_TestAudioLoopPath halVpCfg_SetOutputPath err ret=%d !\n", ret);
		halVpCfg_Close();
		testAudioStart = FALSE;

		return DRV_ERROR;

	}
	if (path == VP_PATH_SPEAKER)
	{
		ret = halVpCfg_SetOutputVol(outpathvol[0]);

	}
	else if (path == VP_PATH_HANDSET)
	{
		ret = halVpCfg_SetOutputVol(outpathvol[1]);
	}
	else if (path == VP_PATH_HEADSET)
	{
		ret = halVpCfg_SetOutputVol(outpathvol[2]);
	}
	else
	{
		ret = halVpCfg_SetOutputVol(outpathvol[3]);
	}

	ret = zDrvI2S_Open(I2S_ID, TRANS_DMA_MODE);
	if (ret != DRV_SUCCESS)
	{
		zOss_Printf(1, 1, "zDrvI2S_Open fail ret=%x\n", ret);
		halVpCfg_Close();
		testAudioStart = FALSE;

		return DRV_ERROR;
	}
	pAudioCabuffer = (UINT8*)zOss_Malloc(caCount);
	pbuffer = (UINT8*)zOss_Malloc(caCount);

	ret = halVpCfg_Enable();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath halVpCfg_Enable err ret=%x !\n", ret);
		halVpCfg_Close();
		zDrvI2S_Close(I2S_1);
		testAudioStart = FALSE;

		return DRV_ERROR;

	}

	s_caputerDoneSemaphore = zOss_CreateSemaphore("CaputerDoneSemaphore", 0);
	s_audioPbLoopThread = zOss_CreateThread("audioPbLoopThread", audioPbLoopThread, 0, 1024 * 2, 20, 1, 1);
	if (s_audioPbLoopThread == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "creat audioPbLoopThread fail\n");
	}


	s_audioCaLoopThread = zOss_CreateThread("audioCaLoopThread", audioCaLoopThread, 0, 1024 * 2, 20, 1, 1);

	if (s_audioCaLoopThread == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "creat audioCaLoopThread fail\n");
	}

	readRuning = TRUE;
	writeRuning = TRUE;

	zOss_GetSemaphore(s_caputerDoneSemaphore, ZOSS_WAIT_FOREVER);

	//zOss_GetMutex(s_autoAudioTestMutexID, ZOSS_WAIT_FOREVER);
	audioPra.src = pAudioCabuffer;
	audioPra.dest = pbuffer;
	audioPra.sampfs = sampfs;
	audioLoopRet = halVpCfg_GetAudioLoopResult(&audioPra);
	//zOss_PutMutex(s_autoAudioTestMutexID);


	readRuning = FALSE;
	writeRuning = FALSE;
	ret = zDrvI2S_Read_Stop(I2S_ID);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath zDrvI2S_Read_Stop err ret=%d !\n", ret);

	}
	ret += zDrvI2S_Write_Stop(I2S_ID);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath zDrvI2S_Write_Stop err ret=%d !\n", ret);

	}

	ret = halVpCfg_Close();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath halVpCfg_Close err ret=%d !\n", ret);

	}

	zOss_DeleteThread(s_audioPbLoopThread);
	s_audioPbLoopThread = NULL;

	zOss_DeleteThread(s_audioCaLoopThread);
	s_audioCaLoopThread = NULL;

	zOss_DeleteSemaphore(s_caputerDoneSemaphore);
	s_caputerDoneSemaphore = NULL;

	ret = zDrvI2S_Close(I2S_1);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath error: zDrvI2S_Close I2S1  ret=%d", ret);
	}

	zOss_Free(pAudioCabuffer);
	pAudioCabuffer = NULL;

	zOss_Free(pbuffer);
	pbuffer = NULL;

	//close process

	testAudioStart = FALSE;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath end!\n");

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath audioLoopRet=%d", audioLoopRet);
	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "audioLoopRet=%d!\n", audioLoopRet);

	return audioLoopRet;

}
static void fft(SINT16 *data, DOUBLE *x, DOUBLE *y, UINT16 n, SINT16 sign)
{
	UINT16 i, j, k, l, m, n1, n2;
	DOUBLE c, c1, e, s, s1, t, tr, ti;
	//Calculate i = log2N
	for (i = 0; i < n; i++)
	{
		x[i] = data[i];
		//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"cal_freq_fft x[%d]=%f,data=%d!\n",i,x[i],data[i]);

	}
	for (j = 1, i = 1; i < 20; i++)
	{
		m = i;
		j = 2 * j;
		if (j == n)
			break;
	}

	//ͼ±꣨λ
	n1 = n - 1;
	for (j = 0, i = 0; i < n1; i++)
	{
		if (i < j)
		{
			tr = x[j];
			ti = y[j];
			x[j] = x[i];
			y[j] = y[i];
			x[i] = tr;
			y[i] = ti;
		}
		k = n / 2;
		while (k < (j + 1))
		{
			j = j - k;
			k = k / 2;
		}
		j = j + k;
	}
	//ÿһlΪĳһiΪͬһĲͬȺʹͬһڴ棨λ㣩
	n1 = 1;
	for (l = 1; l <= m; l++)
	{
		n1 = 2 * n1;
		n2 = n1 / 2;
		e = 3.1415926 / n2;
		c = 1.0;
		s = 0.0;
		c1 = cos(e);
		s1 = -sign * sin(e);
		for (j = 0; j < n2; j++)
		{
			for (i = j; i < n; i += n1)
			{
				k = i + n2;
				tr = c * x[k] - s * y[k];
				ti = c * y[k] + s * x[k];
				x[k] = x[i] - tr;
				y[k] = y[i] - ti;
				x[i] = x[i] + tr;
				y[i] = y[i] + ti;
			}
			t = c;
			c = c * c1 - s * s1;
			s = t * s1 + s * c1;
		}
	}
	//IFFTٳN
	if (sign == -1)
	{
		for (i = 0; i < n; i++)
		{
			x[i] /= n;
			y[i] /= n;
		}
	}
}
static void max_fft(DOUBLE *a, UINT16 n, UINT16 *h)
{
	UINT16 i = 0;
	*h = 5;
	for (i = 5; i < n; i++)
	{
		if (a[i] > a[*h])
			*h = i;
	}

}

static void abs_fft(DOUBLE *x, DOUBLE *y, UINT16 n, DOUBLE *z)
{
	UINT16 i = 0;

	for (i = 0; i < n; i++)
	{
		z[i] = sqrt(x[i] * x[i] + y[i] * y[i]);
	}



}
SINT32 cal_freq_fft(SINT16 *data, zDrvVp_Freqfft *freqfft, UINT16 n, UINT32 fs)
{
	UINT16 h = 0;
	DOUBLE *x, *xi, *xvalue;
	if (data == NULL || freqfft == NULL || n < 0 || fs < 0)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	x = (DOUBLE*)calloc(n, sizeof(DOUBLE));
	xi = (DOUBLE*)calloc(n, sizeof(DOUBLE));
	xvalue = (DOUBLE*)calloc(n, sizeof(DOUBLE));

	fft(data, x, xi, n, 1);
	/*for(i=0;i<1024;i++)
	{
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"cal_freq_fft x[%d]=%f,xi[%d]=%f!\n",i,x[i],i,xi[i]);
	}*/

	abs_fft(x, xi, n / 2, xvalue);
	max_fft(xvalue, n / 2, &h);
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"h=%d!\n",h);
	freqfft->freqValue = (h - 1) * fs / ((n) * 1.0);
	freqfft->freqAmp = xvalue[h] / (n / 2);
	//*freqValue = (h-1)*fs/((n)*1.0);
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"n=%d!\n",n);
	// freq = freqfft->freqValue;
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"fs=%d!\n",fs);
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"freq=%f!\n",freq);
	//zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"freqfft->freqAmp=%f!\n",freqfft->freqAmp);


	free(x);
	free(xi);
	free(xvalue);
	return DRV_SUCCESS;

}

#endif

