/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_extintf.c    
 * File Mark:    
 * Description: Loop voice data from teak to arm. 
                    Settings: arm iis1->top iis1(connect to ap), arm iis2 loop to teak afe.

 * Others:        
 * Version:        
 * Author:        xuxinqiang     
 * Date:          2016-2-15
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/

#include "drvs_general.h"
#include "drvs_ramlog.h"
#include "drvs_voice_config.h"
#include "drvs_codec.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/





/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/


/****************************************************************************
* 	                                          Global Constants
****************************************************************************/



/****************************************************************************
* 	                                          Global Variables
****************************************************************************/

T_HalVpCfg_Opt*  gHalVpCfg_ObjPtr = NULL;





/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/



/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
* Function: zDrvVpcfg_SetOperations
* Description: This function is used to set the voice config  interface pointer.
* Parameters: 
*   Input:
*           VoiceObjPtr:The pointer to voice config function block 
*   Output:None
*
* Returns: none
*
* Others: 
********************************************************************************/
VOID zDrvVpCfg_SetOperations(T_HalVpCfg_Opt* VpCfg_ObjPtr)
{
    gHalVpCfg_ObjPtr = VpCfg_ObjPtr;
}



/*******************************************************************************
* Function: halVpCfg_Open
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_Open(T_ZDrvVp_SourceType srctype)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_Open))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Open hal_VpCfg_Open is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_Open(srctype);
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Open hal_VpCfg_Open is null ! \n");    
        return DRV_SUCCESS;
    }
}





/*******************************************************************************
* Function: halVpCfg_Close
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_Close(VOID)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_Close))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Close hal_VpCfg_Close is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_Close();
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Close hal_VpCfg_Close is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_Enable
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_Enable(VOID)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_Enable))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Enable hal_VpCfg_Enable is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_Enable();
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Enable hal_VpCfg_Enable is null ! \n");    
        return DRV_SUCCESS;
    }
	
}


/*******************************************************************************
* Function: halVpCfg_Disable
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_Disable(VOID)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_Disable))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Disable hal_VpCfg_Disable is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_Disable();
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_Disable hal_VpCfg_Disable is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetFs
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetFs(T_ZDrv_VpFs fs)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetFs))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetFs hal_VpCfg_SetFs is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetFs(fs); 
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetFs hal_VpCfg_SetFs is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetInputPath
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetInputPath(T_ZDrv_VpPath path,BOOL enable)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetInputPath))
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetInputPath hal_VpCfg_SetInputPath is init ! \n");
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetInputPath( path,enable); 
    }
    else
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetInputPath hal_VpCfg_SetInputPath is null ! \n");
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetOutputPath
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetOutputPath(T_ZDrv_VpPath path,BOOL enable)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputPath))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetOutputPath hal_VpCfg_SetOutputPath is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputPath( path,enable); 
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetOutputPath hal_VpCfg_SetOutputPath is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetMute
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetMute(T_ZDrv_VpPath path,BOOL mute)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetMute))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetMute hal_VpCfg_SetMute is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetMute(path, mute); 
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetMute hal_VpCfg_SetMute is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetFmPath
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetFmPath(T_ZDrv_VpPath path,BOOL enable)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetFmPath))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetFmPath hal_VpCfg_SetFmPath is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetFmPath( path,enable); 
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetFmPath hal_VpCfg_SetFmPath is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetLoopback
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetLoopback(T_ZDrv_VpPath path,BOOL enable)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetLoopback))
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetLoopback hal_VpCfg_SetLoopback is init ! \n");   
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetLoopback(enable); 
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetLoopback hal_VpCfg_SetLoopback is null ! \n");    
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetInputVol
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetInputVol(T_ZDrv_VpVol vol)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetInputVol))
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetInputVol hal_VpCfg_SetInputVol is init ! \n");
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetInputVol(vol); 
    }
    else
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetInputVol hal_VpCfg_SetInputVol is null ! \n");
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetOutputVol
* Description: This function is used to.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVpCfg_SetOutputVol(T_ZDrv_VpVol vol)
{    
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputVol))
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetOutputVol hal_VpCfg_SetOutputVol is init ! \n");
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputVol(vol); 
    }
    else
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetOutputVol hal_VpCfg_SetOutputVol is null ! \n");
        return DRV_SUCCESS;
    }
	
}

/*******************************************************************************
* Function: halVpCfg_SetUseProtocol
* Description: This function is used to.
* Parameters:
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:
********************************************************************************/
SINT32 halVpCfg_SetUseProtocol(T_ZDrvCodec_UseProtocol usePortocol)
{
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetUseProtocol))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetUseProtocol hal_VpCfg_SetUseProtocol is init ! \n");
        return gHalVpCfg_ObjPtr->hal_VpCfg_SetUseProtocol(usePortocol);
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_SetUseProtocol hal_VpCfg_SetUseProtocol is null ! \n");
        return DRV_SUCCESS;
    }
  
}

/*******************************************************************************
* Function: halVpCfg_GetMixerToneInfo
* Description: This function is used to.
* Parameters:
*   Input:None
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:
********************************************************************************/
SINT32 halVpCfg_GetMixerToneInfo(T_ZDrvVp_ToneNum toneNum,T_HalMixerToneInfo *toneInfo)
{
    if ((NULL != gHalVpCfg_ObjPtr) && (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_GetMixerToneInfo))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetMixerToneInfo hal_VpCfg_GetMixerToneInfo is init ! \n");
        return gHalVpCfg_ObjPtr->hal_VpCfg_GetMixerToneInfo(toneNum,toneInfo);
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetMixerToneInfo hal_VpCfg_GetMixerToneInfo is null ! \n");
        return DRV_SUCCESS;
    }

}

/*******************************************************************************
* Function: halVpCfg_SetMute
* Description: This function is used to configure mute state in input path.
* Parameters:
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:

********************************************************************************/
SINT32 halVpCfg_SetInputMute(BOOL onoff)
{
	SINT32 ret = DRV_SUCCESS;

    if (NULL == gHalVpCfg_ObjPtr)
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hal_VpCfg_SetInputMute gHalVpCfg_ObjPtr pointer is NULL ! \n");
		return DRV_ERROR;
    }

    if (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetInputMute)
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hal_VpCfg_SetInputMute mute is %d\n", onoff);
		ret = gHalVpCfg_ObjPtr->hal_VpCfg_SetInputMute(onoff);
    }
	return ret;
}

/*******************************************************************************
* Function: halVpCfg_SetMute
* Description: This function is used to configure mute state in output path.
* Parameters:
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:

********************************************************************************/
SINT32 halVpCfg_SetOutputMute(BOOL onoff)
{
    SINT32 ret = DRV_SUCCESS;
	
    if (NULL == gHalVpCfg_ObjPtr)
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hal_VpCfg_SetOutputMute gHalVpCfg_ObjPtr pointer is NULL ! \n");
		return DRV_ERROR;
    }

    if (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputMute)
    {
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hal_VpCfg_SetOutputMute mute is %d\n", onoff);
		ret = gHalVpCfg_ObjPtr->hal_VpCfg_SetOutputMute(onoff);
    }
	return ret;
}


/*******************************************************************************
* Function: halVpCfg_GetAudioLoopInfo
* Description: This function is used to configure mute state in output path.
* Parameters:
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:

********************************************************************************/
SINT32 halVpCfg_GetAudioLoopInfo(T_HalAudioLoopTestInfo *audioInfo)
{
    SINT32 ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetAudioLoopInfo\n");
    if (NULL == gHalVpCfg_ObjPtr)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetAudioLoopInfo gHalVpCfg_ObjPtr pointer is NULL ! \n");
		return DRV_ERROR;
    }

    if (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_GetAudioLoopInfo)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_TestAudioLoopPath\n");
		ret = gHalVpCfg_ObjPtr->hal_VpCfg_GetAudioLoopInfo(audioInfo);
    }
	return ret;
}
/*******************************************************************************
* Function: halVpCfg_GetAudioLoopResult
* Description: This function is used to configure mute state in output path.
* Parameters:
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others:

********************************************************************************/
SINT32 halVpCfg_GetAudioLoopResult(T_HalAudioLoopTestPra *audioPra)
{
    SINT32 ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetAudioLoopResult\n");
    if (NULL == gHalVpCfg_ObjPtr)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_GetAudioLoopResult gHalVpCfg_ObjPtr pointer is NULL ! \n");
		return DRV_ERROR;
    }

    if (NULL != gHalVpCfg_ObjPtr->hal_VpCfg_GetAudioLoopResult)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halVpCfg_TestAudioLoopPath\n");
		ret = gHalVpCfg_ObjPtr->hal_VpCfg_GetAudioLoopResult(audioPra);
    }
	return ret;
}


