/*
 *  Copyright (C) 2017 Sanechips Technology Co., Ltd.
*
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */



/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_ramlog.h"
#include <oss_clib.h>
#include <oss_kernel.h>
#include "NvParam_drv.h"
#include "RWNvConfig.h"
#ifdef _USE_NXP_AUD
#include "hal_nxp.h"
#endif
#ifdef _USE_WEBRTC_AUD
#include "webrtc_intf.h"
#endif
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/


/****************************************************************************
* 	                                          Global Constants
****************************************************************************/


/****************************************************************************
* 	                                          Global Variables
****************************************************************************/



extern T_zDrvVoice_GbVar g_voiceVar;



/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/




/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
SINT32 VoiceProc_InitNvParam(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	ret = zOss_NvItemRead(OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR, ((UINT8 *)(&g_voiceVar.audio_ctrlFlag)),  sizeof(g_voiceVar.audio_ctrlFlag));
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_InitNvParam voice  flag baseAdd=0x%x, ret =%d ,isVpParamInNv= %d \n", (OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR), \
	                  ret, g_voiceVar.audio_ctrlFlag.isVpParamInNv);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_InitNvParam voiceflag isVpParamInNv=%d,isUseSlicCodec=%d,isUseVoiceProc=%d,isUseCodecDsp=%d,isUseNvWrite=%d \n", \
	                  g_voiceVar.audio_ctrlFlag.isVpParamInNv, g_voiceVar.audio_ctrlFlag.isUseSlicCodec, g_voiceVar.audio_ctrlFlag.isUseVoiceProc, \
	                  g_voiceVar.audio_ctrlFlag.isUseCodecDsp, g_voiceVar.audio_ctrlFlag.isUseNvWrite);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_InitNvParam the g_audioNvParam size=%d,audio_ctrlFlag size=%d \n", sizeof(g_voiceVar), sizeof(g_voiceVar.audio_ctrlFlag));


	g_voiceVar.isUseSlicCodec = g_voiceVar.audio_ctrlFlag.isUseSlicCodec;
	g_voiceVar.g_isUseTdm = g_voiceVar.audio_ctrlFlag.isUseTdm;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " VoiceProc_InitNvParam isUseVoiceProc=%d,isUseSlicCodec=%d,isUseTdm=%d!\n", g_voiceVar.audio_ctrlFlag.isUseVoiceProc, g_voiceVar.isUseSlicCodec, g_voiceVar.audio_ctrlFlag.isUseTdm);
	if (g_voiceVar.audio_ctrlFlag.isUseVoiceProc == 1)
	{
#ifdef _USE_NXP_AUD

	ret = Vp_NxpInitNvParam();

	testnxp_init();
#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_InitParam();
#endif
	}


	return ret;
}


SINT32 VoiceProc_Open(UINT32 fs)
{

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_Open isUseVoiceProc=%d \n", g_voiceVar.audio_ctrlFlag.isUseVoiceProc);

	SINT32 ret = DRV_SUCCESS;
	if (g_voiceVar.audio_ctrlFlag.isUseVoiceProc != 1)
	{
		return DRV_ERR_NOT_SUPPORTED;
	}
#ifdef _USE_NXP_AUD
	ret = Vp_NxpOpen(fs);
#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_Open(fs);

#endif





	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_Open end !\r\n");


	return ret;
}



SINT32 VoiceProc_Close(VOID)
{

	SINT32 ret = DRV_SUCCESS;
#ifdef _USE_NXP_AUD
	ret = Vp_NxpClose();
#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_Close();
#endif
	return ret;
}
SINT32 VoiceProc_GetParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path)
{


	SINT32 ret = DRV_SUCCESS;
#ifdef _USE_NXP_AUD
	ret = Vp_NxpGetParam(voiceMode, path);

#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_GetParam(voiceMode,path);

#endif


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_GetParam end!\r\n");

	return ret;
}

SINT32 VoiceProc_SetParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path, T_ZDrv_VpVol volume, BOOL isLoop)
{


	SINT32 ret = DRV_SUCCESS;
#ifdef _USE_NXP_AUD
	ret = Vp_NxpSetParam(path, volume, isLoop);

#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_SetParam(voiceMode, path);
#endif

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_SetConfig end!\r\n");

	return ret;
}

#if 0
SINT32 VoiceProc_SetGain(SINT32 vgain, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _USE_NXP_AUD

	ret = Vp_NxpSetGain(vgain, channel, g_voiceVar.vpPath);

#elif defined _USE_WEBRTC_AUD

#endif

	return ret;


}
#endif

SINT32 VoiceProc_RxProcess(UINT8 **pinBuffer, UINT8 **poutBuffer, UINT16 sampleNums)
{

	SINT32 ret = DRV_SUCCESS;



#ifdef _USE_NXP_AUD
	ret = Vp_NxpRxProcess(pinBuffer, poutBuffer, sampleNums);

#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_RxProcess(pinBuffer, poutBuffer, sampleNums);
#endif



	return ret;
}

SINT32 VoiceProc_TxProcess(UINT8 **pinBuffer_MAIN, UINT8 **pinBuffer_AUX, UINT8 **poutBuffer, UINT16 sampleNums)
{
	SINT32 ret = DRV_SUCCESS;

#ifdef _USE_NXP_AUD
	ret = Vp_NxpTxProcess(pinBuffer_MAIN, NULL, poutBuffer, sampleNums);

#elif defined _USE_WEBRTC_AUD
	ret = Webrtc_TxProcess(pinBuffer_MAIN, NULL, poutBuffer, sampleNums);

#endif



	return ret;
}

#if 0
SINT32 VoiceProc_GetParam(void *apInst, T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path)
{
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_GetParam  voiceMode=%d,path=%d \n", voiceMode, path);


	return DRV_SUCCESS;

}

SINT32 VoiceProc_SetParam(void *apInst, T_ZDrv_VpPath path, T_ZDrv_VpVol volume, BOOL isLoop)
{

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "VoiceProc_SetParam  start!\n");

	return DRV_SUCCESS;
}

SINT32 VoiceProc_SetParamTool(void *apInst, T_ZDrv_VpPath path, T_ZDrv_VpVol volume)
{
	return DRV_SUCCESS;
}

SINT32 VoiceProc_GetParamTool(void *apInst, T_ZDrv_VpPath path, T_ZDrv_VpVol volume)
{
	return DRV_SUCCESS;
}

SINT32 VoiceProc_SetGain(void *apInst, SINT32 gain, UINT32 channel, T_ZDrv_VpPath path)
{

	return DRV_SUCCESS;
}
#endif
SINT32 VoiceProc_SetEchoDelay(int val)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_SetEchoDelay(val);
#endif
	return ret;
}

SINT32 VoiceProc_GetEchoDelay(void)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_GetEchoDelay();
#endif
	return ret;
}

SINT32 VoiceProc_SetTxNsMode(int val)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_SetTxNsMode(val);
#endif
	return ret;
}

SINT32 VoiceProc_GetTxNsMode(void)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_GetTxNsMode();
#endif
	return ret;

}
SINT32 VoiceProc_SetRxNsMode(int val)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_SetRxNsMode(val);
#endif
	return ret;
}

SINT32 VoiceProc_GetRxNsMode(void)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_GetRxNsMode();
#endif
	return ret;

}


SINT32 VoiceProc_SetModuleState(int *mod, int count)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_SetMoudleState(mod, count);
#endif
	return ret;
}

SINT32 VoiceProc_GetModuleState(int *mod, int count)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _USE_WEBRTC_AUD
	ret = Webrtc_GetMoudleState(mod, count);
#endif
	return ret;

}

