/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       v0.1
 * Author:
 * Date:
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ******************************************************************************/

/****************************************************************************
* 	                              Include files
****************************************************************************/

#include "drvs_codec_alc5672.h"

/****************************************************************************
*                                             Local Variables
****************************************************************************/
static BOOL s_mutex_FirstUse = FALSE;
static ZOSS_MUTEX_ID s_codecMutexID = NULL;
static T_ZDrvCodec_Rt5672_Priv rt5672;
//static T_ZDrvCodec_SourceType s_codecSrcType = SOURCE_MAX;
static BOOL isEarpDetect = 0;
extern T_ZDrvI2c_Device s_codecI2CDev;

static T_Codec_UseInfo codecUseInfo=
{
    0,
    HANDLE_FREE,
    AUDIO_I2S0,
    I2S_SLAVE_MODE,
    AUDIO_SAMPLE_8K,
    CODEC_CLKIN_MCLK,//26MHZ
    CODEC_IDLE,
    CODEC_BUS_I2S,
    AUDIO_INPUT_MAX,
    AUDIO_OUTPUT_MAX
};


/****************************************************************************
* 	                               Function Definitions
****************************************************************************/
extern SINT32 zDrvI2S_setCodecClk(VOID);
SINT32 zDrvCodec_GetOutPathParaInfo(T_CodecPathParaInfo *pathinfo,T_ZDrvCodec_OutDevice dev,T_ZDrvCodec_SourceType sourcetype,BOOL onoff);//xiu
SINT32 zDrvCodec_GetInPathParaInfo(T_CodecPathParaInfo *pathinfo,T_ZDrvCodec_InDevice dev,BOOL onoff);//xiu
/******************************************************************************
 * Function: codec_Claim_Mutex
 * Description: init mutex and get mutex
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ******************************************************************************/
void codec_Claim_Mutex(void)
{
    if (FALSE == s_mutex_FirstUse) {
        s_codecMutexID = zOss_CreateMutex("codecMutex", ZOSS_INHERIT);   /*create mutex*/
        s_mutex_FirstUse = TRUE;
    }
	
    zOss_GetMutex(s_codecMutexID, ZOSS_WAIT_FOREVER);
}

/******************************************************************************
 * Function: codec_Release_Mutex
 * Description: release mutex
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ******************************************************************************/
void codec_Release_Mutex(void)
{
    zOss_PutMutex(s_codecMutexID);
}

/******************************************************************************
 * Function: codec_I2CWrite
 * Description: write data to codec
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_I2CWrite(UINT8 regAddress, UINT16 regMask, UINT16 regValue)
{
    SINT32 halRet = DRV_ERROR;
    UINT8 regTempValue[2] = {0x0, 0x0};
    UINT8 regTempValueread[2] = {0x0, 0x0};
    UINT16 regTempValue16 = 0;

    halRet = zDrvI2c_DevRead(&s_codecI2CDev, regAddress, regTempValueread, 2);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2c_DevRead register 0x%x read error ret=%d.\n", regAddress,halRet);   
        return DRV_ERROR;
    }
	
    regTempValue16 =(((UINT16)regTempValueread[0]) << 8) | ((UINT16)regTempValueread[1]);
    regTempValue16 = regTempValue16 & (~regMask);
    regTempValue16 |= (regValue & regMask);
    regTempValue[0] = (UINT8)(regTempValue16 >> 8);
    regTempValue[1] = (UINT8)(regTempValue16 & 0xff);

    halRet = zDrvI2c_DevWrite(&s_codecI2CDev, regAddress, regTempValue, 2);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2c_DevWrite register 0x%x write error ret=%d.\n", regAddress,halRet);   
        return DRV_ERROR;
    }

    return halRet;
}

/******************************************************************************
 * Function: codec_I2CWrite
 * Description: write data to codec
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_I2CWrite_Nomask(UINT8 regAddress, UINT16 regValue)
{
    SINT32 halRet = DRV_SUCCESS;
    UINT8 regTempValue[2] = {0x0,0x0};

    regTempValue[0] = (UINT8)(regValue >> 8);
    regTempValue[1] = (UINT8)(regValue & 0xff);
	
    halRet = zDrvI2c_DevWrite(&s_codecI2CDev, (UINT16)regAddress, regTempValue, 2);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_I2CWrite_Nomask register 0x%x write error ret=%d.\n", regAddress, halRet);   
        return DRV_ERROR;
    }
	
    return halRet;
}

/******************************************************************************
 * Function: codec_I2CRead16
 * Description: read data to codec
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_I2CRead16(UINT8 regAddress, UINT16 *regValue)
{
    SINT32 halRet = DRV_SUCCESS;
    UINT8 regTempValueread[2]= {0x0, 0x0};

    halRet = zDrvI2c_DevRead(&s_codecI2CDev, (UINT16)regAddress, regTempValueread, 2);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_I2CRead16 register 0x%x write error ret=%d.\n", regAddress, halRet);   
        return DRV_ERROR;
    }

    *regValue =(((UINT16)regTempValueread[0]) << 8) | ((UINT16)regTempValueread[1]);
    return halRet;
}

/******************************************************************************
* Function: codec_WritePrvReg
* Description: Write private register
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
* Modify private register for advanced setting. It can be written through
* private index (0x6a) and data (0x6c) register.
******************************************************************************/
static SINT32 codec_WritePrvReg(UINT8 reg, UINT16 value)
{
    SINT32 halRet = DRV_SUCCESS;

    halRet = codec_I2CWrite_Nomask(RT5672_PRIV_INDEX, (UINT16)reg);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_WritePrvReg Failed to set private addr: 0x%x\n", reg);
        return halRet;
    }

    halRet = codec_I2CWrite_Nomask(RT5672_PRIV_DATA, value);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_WritePrvReg Failed to set private value: 0x%x\n", value);
        return halRet;
    }

    return halRet;
}

/******************************************************************************
* Function: codec_ReadPrvReg
* Description: Read private register
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
* Read advanced setting from private register. It can be read through
* private index (0x6a) and data (0x6c) register.
******************************************************************************/
static SINT32 codec_ReadPrvReg(UINT8 reg, UINT16* regvalue)
{
    SINT32 halRet = DRV_SUCCESS;
    UINT16 tmpval = 0;

    halRet = codec_I2CWrite_Nomask(RT5672_PRIV_INDEX, reg);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_ReadPrvReg Failed to set private addr: 0x%x\n", reg);
        return DRV_ERROR;
    }

    halRet = codec_I2CRead16(RT5672_PRIV_DATA, &tmpval);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_ReadPrvReg  Failed to set private value: 0x%x\n", tmpval);
        return DRV_ERROR;
    }
	
    *regvalue = tmpval;
    return halRet;

}

/******************************************************************************
* Function: codec_UpdatePrvRegBits
* Description: Writes new register value.
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
* @reg: Private register index.
* @mask: register mask
* @value: new value
******************************************************************************/
static SINT32 codec_UpdatePrivateRegBits(UINT8 reg , UINT16 mask, UINT16 value)
{
    SINT32 halRet = DRV_SUCCESS, change = 0;
    UINT16 valueindx = 0;
    UINT16 oldvalue = 0, newvalue = 0;
	
    halRet = codec_ReadPrvReg(reg, &valueindx);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_UpdatePrivateRegBits Failed to read private reg: 0x%x\n", reg);
        return DRV_ERROR;
    }

    oldvalue = valueindx;
    newvalue = (oldvalue & ~mask) | (value & mask);
    change = (oldvalue != newvalue);
    if (change) {
        halRet = codec_WritePrvReg(reg, newvalue);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_UpdatePrivateRegBits Failed to write private reg: 0x%x\n", valueindx);
            return DRV_ERROR;
        }
    }

    return halRet;

}

/******************************************************************************
 * Function: rt5672_readable_register
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ******************************************************************************/
static SINT32 rt5672_readable_register(UINT8 reg)
{
    switch (reg) {
	    case RT5672_RESET:
	    case RT5672_HP_VOL:
	    case RT5672_LOUT1:
	    case RT5672_CJ_CTRL1:
	    case RT5672_CJ_CTRL2:
	    case RT5672_CJ_CTRL3:
	    case RT5672_IN2:
	    case RT5672_INL1_INR1_VOL:
	    case RT5672_DAC1_DIG_VOL:
	    case RT5672_DAC2_DIG_VOL:
	    case RT5672_DAC_CTRL:
	    case RT5672_STO1_ADC_DIG_VOL:
	    case RT5672_MONO_ADC_DIG_VOL:
	    case RT5672_STO2_ADC_DIG_VOL:
	    case RT5672_ADC_BST_VOL1:
	    case RT5672_ADC_BST_VOL2:
	    case RT5672_STO2_ADC_MIXER:
	    case RT5672_STO1_ADC_MIXER:
	    case RT5672_MONO_ADC_MIXER:
	    case RT5672_AD_DA_MIXER:
	    case RT5672_STO_DAC_MIXER:
	    case RT5672_MONO_DAC_MIXER:
	    case RT5672_DIG_MIXER:
	    case RT5672_DSP_PATH1:
	    case RT5672_DSP_PATH2:
	    case RT5672_DIG_INF1_DATA:
	    case RT5672_DIG_INF2_DATA:
	    case RT5672_PDM_OUT_CTRL:
	    case RT5672_PDM_DATA_CTRL1:
	    case RT5672_PDM1_DATA_CTRL2:
	    case RT5672_PDM1_DATA_CTRL3:
	    case RT5672_PDM1_DATA_CTRL4:
	    case RT5672_PDM2_DATA_CTRL2:
	    case RT5672_PDM2_DATA_CTRL3:
	    case RT5672_PDM2_DATA_CTRL4:
	    case RT5672_REC_L1_MIXER:
	    case RT5672_REC_L2_MIXER:
	    case RT5672_REC_R1_MIXER:
	    case RT5672_REC_R2_MIXER:
	    case RT5672_HPO_MIXER:
	    case RT5672_MONO_MIXER:
	    case RT5672_OUT_L1_MIXER:
	    case RT5672_OUT_R1_MIXER:
	    case RT5672_LOUT_MIXER:
	    case RT5672_PWR_DIG1:
	    case RT5672_PWR_DIG2:
	    case RT5672_PWR_ANLG1:
	    case RT5672_PWR_ANLG2:
	    case RT5672_PWR_MIXER:
	    case RT5672_PWR_VOL:
	    case RT5672_PRIV_INDEX:
	    case RT5672_PRIV_DATA:
	    case RT5672_I2S4_SDP:
	    case RT5672_I2S1_SDP:
	    case RT5672_I2S2_SDP:
	    case RT5672_I2S3_SDP:
	    case RT5672_ADDA_CLK1:
	    case RT5672_ADDA_CLK2:
	    case RT5672_DMIC_CTRL1:
	    case RT5672_DMIC_CTRL2:
	    case RT5672_TDM_CTRL_1:
	    case RT5672_TDM_CTRL_2:
	    case RT5672_TDM_CTRL_3:
	    case RT5672_DSP_CLK:
	    case RT5672_GLB_CLK:
	    case RT5672_PLL_CTRL1:
	    case RT5672_PLL_CTRL2:
	    case RT5672_ASRC_1:
	    case RT5672_ASRC_2:
	    case RT5672_ASRC_3:
	    case RT5672_ASRC_4:
	    case RT5672_ASRC_5:
	    case RT5672_ASRC_7:
	    case RT5672_ASRC_8:
	    case RT5672_ASRC_9:
	    case RT5672_ASRC_10:
	    case RT5672_ASRC_11:
	    case RT5672_ASRC_12:
	    case RT5672_ASRC_13:
	    case RT5672_ASRC_14:
	    case RT5672_DEPOP_M1:
	    case RT5672_DEPOP_M2:
	    case RT5672_DEPOP_M3:
	    case RT5672_CHARGE_PUMP:
	    case RT5672_MICBIAS:
	    case RT5672_A_JD_CTRL1:
	    case RT5672_A_JD_CTRL2:
	    case RT5672_VAD_CTRL1:
	    case RT5672_VAD_CTRL2:
	    case RT5672_VAD_CTRL3:
	    case RT5672_VAD_CTRL4:
	    case RT5672_VAD_CTRL5:
	    case RT5672_ADC_EQ_CTRL1:
	    case RT5672_ADC_EQ_CTRL2:
	    case RT5672_EQ_CTRL1:
	    case RT5672_EQ_CTRL2:
	    case RT5672_ALC_DRC_CTRL1:
	    case RT5672_ALC_DRC_CTRL2:
	    case RT5672_ALC_CTRL_1:
	    case RT5672_ALC_CTRL_2:
	    case RT5672_ALC_CTRL_3:
	    case RT5672_ALC_CTRL_4:
	    case RT5672_JD_CTRL:
	    case RT5672_IRQ_CTRL1:
	    case RT5672_IRQ_CTRL2:
	    case RT5672_IRQ_CTRL3:
	    case RT5672_GPIO_CTRL1:
	    case RT5672_GPIO_CTRL2:
	    case RT5672_GPIO_CTRL3:
	    case RT5672_SCRABBLE_FUN:
	    case RT5672_SCRABBLE_CTRL:
	    case RT5672_BASE_BACK:
	    case RT5672_MP3_PLUS1:
	    case RT5672_MP3_PLUS2:
	    case RT5672_ADJ_HPF1:
	    case RT5672_ADJ_HPF2:
	    case RT5672_HP_CALIB_AMP_DET:
	    case RT5672_SV_ZCD1:
	    case RT5672_SV_ZCD2:
	    case RT5672_IL_CMD:
	    case RT5672_IL_CMD2:
	    case RT5672_IL_CMD3:
	    case RT5672_DRC_HL_CTRL1:
	    case RT5672_DRC_HL_CTRL2:
	    case RT5672_ADC_MONO_HP_CTRL1:
	    case RT5672_ADC_MONO_HP_CTRL2:
	    case RT5672_ADC_STO2_HP_CTRL1:
	    case RT5672_ADC_STO2_HP_CTRL2:
	    case RT5672_JD_CTRL3:
	    case RT5672_JD_CTRL4:
	    case RT5672_GEN_CTRL1:
	    case RT5672_DSP_CTRL1:
	    case RT5672_DSP_CTRL2:
	    case RT5672_DSP_CTRL3:
	    case RT5672_DSP_CTRL4:
	    case RT5672_DSP_CTRL5:
	    case RT5672_GEN_CTRL2:
	    case RT5672_GEN_CTRL3:
	    case RT5672_VENDOR_ID:
	    case RT5672_VENDOR_ID1:
	    case RT5672_VENDOR_ID2:
        return TRUE;
    default:
        return FALSE;
    }
}

/******************************************************************************
* Function: codec_ShowCodecReg
* Description: print all register value(0-0xFF).
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
******************************************************************************/
SINT32 codec_ShowCodecReg(UINT8 regFirst, UINT8 regEnd)
{
    UINT16 val = 0, i = 0;
    SINT32 halRet = DRV_SUCCESS;

    for (i = 0; i <= RT5672_VENDOR_ID2; i++) {
        if (rt5672_readable_register(i)) {
            if ((i >= regFirst) && (i <= regEnd)) {
                halRet = codec_I2CRead16(i, &val);	
                if (halRet != DRV_SUCCESS) {
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_ShowCodecReg 0x%02x error! \n", i);
                    break;
                }		
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_ShowCodecReg 0x%02x: 0x%04x\n", i ,val);
            }
        }
    }

    return halRet;
}

/******************************************************************************
 * Function: codec_CalSampleRate
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   return freq
 *
 * Others:
 ******************************************************************************/
static UINT32 codec_CalSampleRate(T_ZDrvCodec_AudioSample sample, int isSysclk)
{
    UINT32 freq = 8000;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_CalSampleRate sample:%d, isSysclk: %d.\n", sample, isSysclk);
	
    switch(sample) {
        case AUDIO_SAMPLE_8K:
            freq = 8000;
            break;
        case AUDIO_SAMPLE_16K:
            freq = 16000;
            break;
        case AUDIO_SAMPLE_32K:
            freq = 32000;
            break;
        case AUDIO_SAMPLE_44_1K:
            freq = 44100;
            break;
        case AUDIO_SAMPLE_48K:
            freq = 48000;
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid sample:%d.\n", sample);
            return -EINVAL; 
    }

    return isSysclk ? (256 * freq) : freq;
}

/******************************************************************************
 * Function: codec_SetCodecPowerSwitch
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
static SINT32 codec_SetCodecPowerSwitch(BOOL onOff)
{
    SINT32 halRet = DRV_SUCCESS;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_SetCodecPowSwitch onOff:%d.\n", onOff);
	
    if (onOff) {
        halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_VREF1 | RT5672_PWR_FV1 | RT5672_PWR_MB | RT5672_PWR_BG | \
                                 RT5672_PWR_VREF2 | RT5672_PWR_FV2 | RT5672_LDO_SEL_MASK, \
                                 RT5672_PWR_VREF1 | RT5672_PWR_FV1 | RT5672_PWR_MB | RT5672_PWR_BG | \
                                 RT5672_PWR_VREF2 | RT5672_PWR_FV2 | RT5672_LDO_1_35V);       
		
        halRet += codec_I2CWrite(RT5672_GEN_CTRL1, RT5672_DIG_GATE_CTRL_SEL, RT5672_DIG_GATE_CTRL_SEL);
    } else {
        halRet += codec_I2CWrite(RT5672_PWR_DIG1, 0xffff, 0x0);
        halRet += codec_I2CWrite(RT5672_PWR_DIG2, 0xffff, 0x0);
        halRet += codec_I2CWrite(RT5672_PWR_ANLG2, 0xffff, 0x4);
        halRet += codec_I2CWrite(RT5672_PWR_MIXER, 0xffff,0x0);
        halRet += codec_I2CWrite(RT5672_PWR_VOL, 0xffff, 0x0);
        halRet += codec_I2CWrite(RT5672_PWR_ANLG1, 0xffff, 0xA810);
        /*SET THE i2s2*/
        halRet += codec_I2CWrite(RT5672_GPIO_CTRL1, RT5672_I2S2_PIN_MASK, RT5672_I2S2_PIN_GPIO);
    }

    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_SetCodecPowerSwitch codec_I2CWrite return error %d.\n", halRet);
        return halRet;
    }

    return halRet ;
}

/******************************************************************************
 * Function:codec_EarpieceDetectEnable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_EarpieceDetectEnable( BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
    //UINT8 reg_write = 0;
    //UINT8 reg_mask = 0;
    //UINT8 *reg_val;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_EarpieceDetectEnable set status is %d !\n",onoff);

    if (onoff) {
        halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_HP_L | RT5672_PWR_HP_R | RT5672_PWR_VREF2, RT5672_PWR_VREF2);
        halRet += codec_I2CWrite_Nomask(RT5672_GEN_CTRL1, 0x8019);
        halRet += codec_I2CWrite_Nomask(RT5672_IL_CMD, 0x0000);
        halRet += codec_I2CWrite_Nomask(RT5672_IL_CMD2, 0x0010);
        halRet += codec_I2CWrite_Nomask(RT5672_IL_CMD3, 0x0014);
        halRet += codec_I2CWrite(RT5672_GPIO_CTRL1, RT5672_GP1_PIN_MASK, RT5672_GP1_PIN_IRQ);
        halRet += codec_I2CWrite(RT5672_GPIO_CTRL2, RT5672_GP1_PF_MASK, RT5672_GP1_PF_OUT);
        halRet += codec_I2CWrite(RT5672_GLB_CLK, RT5672_SCLK_SRC_MASK, RT5672_SCLK_SRC_RCCLK);
        halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_MB | RT5672_PWR_BG, RT5672_PWR_MB | RT5672_PWR_BG);
        halRet += codec_I2CWrite(RT5672_PWR_ANLG2, RT5672_PWR_JD1, RT5672_PWR_JD1);
        halRet += codec_I2CWrite(RT5672_IRQ_CTRL1, RT5672_JD1_1_EN_MASK, RT5672_JD1_1_EN);
        halRet += codec_I2CWrite(RT5672_JD_CTRL3, RT5672_JD_TRI_CBJ_SEL_MASK | RT5672_JD_TRI_HPO_SEL_MASK, RT5672_JD_CBJ_JD1_1 | RT5672_JD_F_JD1_1);
        halRet += codec_I2CWrite(RT5672_A_JD_CTRL1, RT5672_JD1_MODE_MASK, RT5672_JD1_MODE_1);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_EarpieceDetectEnable on failed,halRet=%d !\n", halRet);
        }
    } else {
        halRet += codec_I2CWrite(RT5672_GLB_CLK, RT5672_SCLK_SRC_MASK, RT5672_SCLK_SRC_PLL1);
        halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_MB | RT5672_PWR_BG, (0x0 << RT5672_PWR_MB_BIT)  |  (0x0 << RT5672_PWR_BG_BIT));
        halRet += codec_I2CWrite(RT5672_PWR_ANLG2, RT5672_PWR_JD1, 0x0 << RT5672_PWR_JD1_BIT);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_EarpieceDetectEnable off failed,halRet=%d !\n", halRet);
        }
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec_EarpieceDetectEnable onoff halRet is %d !\n",halRet);
    return  halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetMicBias
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetMicBias(T_ZDrvCodec_Handle handle, T_ZDrvMicBias_Ctrl micBiasCtrl)
{
    SINT32 halRet =DRV_SUCCESS;
    UINT8 reg_write = 0;
    T_Codec_UseInfo *codec_info;
    T_ZDrvMicBias_Vol micbias_vol = MICBIAS_OUT_0_9_MICVDD;
    T_ZDrvMicBias_Cur micbias_cur = MICBIAS_OUT_1280u_CURRENT;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetMicBias micBiasCtrl.micbias_vol =%x !\n", micbias_vol);
	
    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Open handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    switch (micbias_vol) {
        case MICBIAS_OUT_0_9_MICVDD:
            reg_write |= RT5672_MIC1_BS_9AV;
            break;
        case MICBIAS_OUT_0_75_MICVDD:
            reg_write |= RT5672_MIC1_BS_75AV;
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid mic bias voltage %d \n", micbias_vol);
            codec_Release_Mutex();
            return -EINVAL;
    }

    switch (micbias_cur) {
        case MICBIAS_OUT_640u_CURRENT:
            reg_write |= RT5672_MIC1_OVTH_640UA;
            break;
        case MICBIAS_OUT_1280u_CURRENT:
            reg_write |= RT5672_MIC1_OVTH_1280UA;
            break;
        case MICBIAS_OUT_1920u_CURRENT:
            reg_write |= RT5672_MIC1_OVTH_1920UA;
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid mic bias current %d \n", micbias_cur);
            codec_Release_Mutex();
            return -EINVAL;
    }

    halRet = codec_I2CWrite(RT5672_MICBIAS, RT5672_MIC1_BS_MASK | RT5672_MIC1_OVTH_MASK, reg_write);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetMicBias codec_I2CWrite register RT5672_MICBIAS error:%d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }
  
    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetProt
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetProt(T_ZDrvCodec_Handle handle, T_ZDrvCodec_UseProtocol useProtocol)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info = NULL;
    UINT16 regVal = 0;
    T_ZDrvCodec_I2SClkEdgeSel isinvert = I2S_TRANS_POSITIVE_NEGATIVE;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetProt:i2schannel:%d, busmode:%d!\n", useProtocol.audI2SChannel, useProtocol.busMode);
    codec_Claim_Mutex();

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetProt handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;

    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return -EINVAL;
    }

    if (useProtocol.masterSlave == I2S_SLAVE_MODE) {
        regVal |= RT5672_I2S_MS_S;
    } else {
        regVal |= RT5672_I2S_MS_M;
    }
	
    switch (isinvert) {
        case I2S_TRANS_POSITIVE_NEGATIVE:
            regVal |= RT5672_I2S_BP_NOR;  
            break;
        case I2S_TRANS_NEGATIVE_POSITIVE:
            regVal |= RT5672_I2S_BP_INV;
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid isinvert value %d \n", isinvert);
            codec_Release_Mutex();
            return -EINVAL;
    }

    switch (useProtocol.busMode) {
        case CODEC_BUS_I2S:
            regVal |= RT5672_I2S_DF_I2S;  
            break;
        case CODEC_BUS_LJF:
            regVal |= RT5672_I2S_DF_LEFT;
            break;
        case CODEC_BUS_DSP:
            regVal |= RT5672_I2S_DF_PCM_A;  
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid busmode %d \n", useProtocol.busMode);
            codec_Release_Mutex();
            return -EINVAL;
    }

    switch (useProtocol.audI2SChannel) {
        case AUDIO_I2S0:
            halRet += codec_I2CWrite(RT5672_PWR_DIG1, RT5672_PWR_I2S1, 1 << RT5672_PWR_I2S1_BIT);
            halRet += codec_I2CWrite(RT5672_I2S1_SDP, RT5672_I2S_MS_MASK | RT5672_I2S_BP_MASK | RT5672_I2S_DF_MASK, regVal);
            break;
        case AUDIO_I2S1:
            halRet += codec_I2CWrite(RT5672_PWR_DIG1, RT5672_PWR_I2S2, 1 << RT5672_PWR_I2S2_BIT);
            halRet += codec_I2CWrite(RT5672_I2S2_SDP, RT5672_I2S_MS_MASK | RT5672_I2S_BP_MASK | RT5672_I2S_DF_MASK, regVal);
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid channel %d \n", useProtocol.audI2SChannel);
            codec_Release_Mutex();
            return -EINVAL;
    }

    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetProtocal codec_I2CWrite failed : %d!\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }

    codec_info->audI2SChannel = useProtocol.audI2SChannel;
    codec_info->busMode = useProtocol.busMode;
    codec_info->masterSlave = useProtocol.masterSlave;

    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetProtocal
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetProtocal (T_ZDrvCodec_Handle handle, T_ZDrvCodec_AudioI2SChannel channel, T_ZDrvCodec_AudioI2SMode masterSlave)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info = NULL;
    UINT16 regVal = 0;
    T_ZDrvCodec_I2SClkEdgeSel isinvert = I2S_TRANS_POSITIVE_NEGATIVE;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec Set protocal !\n");

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Open handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    if (masterSlave == I2S_SLAVE_MODE) {
        regVal |= RT5672_I2S_MS_S;
    } else {
        regVal |= RT5672_I2S_MS_M;
    }
	
    switch (isinvert) {
        case I2S_TRANS_POSITIVE_NEGATIVE:
            regVal |= RT5672_I2S_BP_NOR;  
            break;
        case I2S_TRANS_NEGATIVE_POSITIVE:
            regVal |= RT5672_I2S_BP_INV;
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid isinvert value %d \n", isinvert);
            codec_Release_Mutex();
            return -EINVAL;
    }

    switch (codec_info->busMode) {
        case CODEC_BUS_I2S:
            regVal |= RT5672_I2S_DF_I2S;  
            break;
        case CODEC_BUS_LJF:
            regVal |= RT5672_I2S_DF_LEFT;
            break;
        case CODEC_BUS_DSP:
            regVal |= RT5672_I2S_DF_PCM_A;  
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid busmode %d \n", codec_info->busMode);
            codec_Release_Mutex();
            return -EINVAL;
    }	

    switch(channel) {
        case AUDIO_I2S0:
            halRet += codec_I2CWrite(RT5672_PWR_DIG1, RT5672_PWR_I2S1, 1 << RT5672_PWR_I2S1_BIT);
            halRet += codec_I2CWrite(RT5672_I2S1_SDP, RT5672_I2S_MS_MASK | RT5672_I2S_BP_MASK | RT5672_I2S_DF_MASK, regVal);
            break;
        case AUDIO_I2S1:
            halRet += codec_I2CWrite(RT5672_PWR_DIG1, RT5672_PWR_I2S2, 1 << RT5672_PWR_I2S2_BIT);
            halRet += codec_I2CWrite(RT5672_I2S2_SDP, RT5672_I2S_MS_MASK | RT5672_I2S_BP_MASK | RT5672_I2S_DF_MASK, regVal);
            break;
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid channel %d \n", channel);
            codec_Release_Mutex();
            return -EINVAL;
    }

    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetProtocal codec_I2CWrite failed : %d!\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }
  
    codec_Release_Mutex();
    return halRet;
}
/******************************************************************************
 * Function: zDrvCodec_Open
 * Description: open codec, set parameters.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Open(T_ZDrvCodec_Handle *handle, T_ZDrvCodec_SourceType srcType)
{
    SINT32 halRet = DRV_SUCCESS;
    rt5672.codecSrcType = srcType;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Open srcType=%d !\n", srcType);

    if (handle == NULL) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Open handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }
    // open 26mhz CLK  for codec
    halRet = zDrvI2S_setCodecClk();	
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set refclk err halRet:%d !\n", halRet);
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    if (codecUseInfo.handleState == HANDLE_FREE) {
        codecUseInfo.handle = (T_ZDrvCodec_Handle)(&codecUseInfo);
        codecUseInfo.useState = CODEC_OPEN;
        codecUseInfo.handleState = HANDLE_IN_USE;
        codecUseInfo.inDev = AUDIO_INPUT_MAX;
        codecUseInfo.outDev = AUDIO_OUTPUT_MAX;		
        *handle = codecUseInfo.handle;
    } else {
        *handle = (T_ZDrvCodec_Handle )NULL;
        halRet = DRV_ERROR;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec open handleState is busy! \n");
    }

    codec_Release_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec open end handle=%d, srcType=%d !\n", *handle, srcType);
    return halRet;

}

/******************************************************************************
 * Function: zDrvCodec_Close
 * Description: close codec, set parameters.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Close(T_ZDrvCodec_Handle *handle)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Close *handle=%d.\n", *handle);
    codec_Claim_Mutex();
	
    if ((*handle == 0) || (handle == NULL)) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Close handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info=(T_Codec_UseInfo *)*handle;
    if ((codec_info->handleState == HANDLE_IN_USE) && (codec_info->handle == codecUseInfo.handle)) {
        halRet = rt5672_dsp_switch(FALSE);	
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_dsp_switch error halRet:%d.\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
		
        halRet = codec_SetCodecPowerSwitch(FALSE);	
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_SetCodecPowerSwitch error halRet:%d.\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }		
    } else {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Close codec isn't in use of state:%d.\n", codec_info->handleState);
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info->handle = (T_ZDrvCodec_Handle)NULL;
    codec_info->useState = CODEC_IDLE;
    codec_info->handleState = HANDLE_FREE;
    codec_info->inDev = AUDIO_INPUT_MAX;
    codec_info->outDev = AUDIO_OUTPUT_MAX;
	
    codec_Release_Mutex();	
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_Reset
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Reset (T_ZDrvCodec_Handle handle)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info;
    UINT8 i = 0;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Reset.\n");

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Reset handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }
	
    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }
#ifdef _CONFIG_USE_CODEC_EARPIECE_DETECT
    zDrvInt_MaskIrq(EX1_INT);
#endif

    for (i = 0; i < 100; i++) {
        halRet = codec_I2CWrite_Nomask(RT5672_RESET, 0x0);
        if (halRet == DRV_SUCCESS) {
            break;
        }
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Reset try %d times and halRet=%d !\n", i, halRet);

#ifdef _CONFIG_USE_CODEC_EARPIECE_DETECT
    halRet = codec_EarpieceDetectEnable(isEarpDetect);

    zDrvInt_ClearInt(EX1_INT);
    zDrvInt_UnmaskIrq(EX1_INT);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_EarpieceDetectEnable off failed,halRet=%d !\n", halRet);
    }
#endif

    codec_Release_Mutex();
    return halRet;

}

/******************************************************************************
 * Function:zDrvCodec_SetClock
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetClock (T_ZDrvCodec_Handle handle, T_ZDrvCodec_AudioSample sample)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info; 
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetClock codec Set sample:%d !\n", sample);

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetClock handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }
	
    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    halRet = codec_SetCodecPowerSwitch(TRUE);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_SetCodecPowerSwitch error: %d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }

    switch(sample) {
        case AUDIO_SAMPLE_8K:
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL1, 0xbf16);  //1011 1111 0001 0110  K=22, N=382 
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL2, 0x0800);  //0000 1000 0000 0000 bypass M
            halRet += codec_I2CWrite_Nomask(RT5672_ADDA_CLK1, 0x1000);  //1000 0000 0000 0000  i2s pre-divider:2;adc/dac sample rate select:128fs
            break;
			
        case AUDIO_SAMPLE_16K:
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL1, 0x5f16);  //0101 1111 0001 0110  K=22, N=190 
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL2, 0x0800);  //0000 1000 0000 0000 bypass M
            halRet += codec_I2CWrite_Nomask(RT5672_ADDA_CLK1, 0x0110);
            break;

        case AUDIO_SAMPLE_44_1K:
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL1, 0xb307);  //1011 0011 0000 0111  K=7, N=358 
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL2, 0x3000);  //0011 0000 0000 0000  M = 3
            halRet += codec_I2CWrite_Nomask(RT5672_ADDA_CLK1, 0x0110);
            break;
			
        case AUDIO_SAMPLE_48K:
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL1, 0x1f06);  //0001 1111 0000 0110  K=6, N=62  
            halRet += codec_I2CWrite_Nomask(RT5672_PLL_CTRL2, 0x0800);  //0000 1000 0000 0000  bypass M
            halRet += codec_I2CWrite_Nomask(RT5672_ADDA_CLK1, 0x0110); 
            break;
			
        default:
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Invalid sample %d \n", sample);
            codec_Release_Mutex();
            return -EINVAL;
    }

    halRet += codec_I2CWrite_Nomask(RT5672_GLB_CLK, 0x4800); // system clock souce mux control choose PLL,pll source from bclk
    halRet += codec_I2CWrite(RT5672_PWR_ANLG2, RT5672_PWR_PLL, RT5672_PWR_PLL); // PLL power on
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetClock codec_I2CWrite error: %d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }

    rt5672.sysclk = codec_CalSampleRate(sample, 1);
    rt5672.sample = sample;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetClock sysclk:%d \n", rt5672.sysclk);
    codec_Release_Mutex();
    return  halRet;

}

/******************************************************************************
 * Function:zDrvCodec_SetInPath
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInPath (T_ZDrvCodec_Handle handle, T_ZDrvCodec_InDevice dev, BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info = NULL;
	T_CodecPathParaInfo inpathinfo;
    UINT8 i = 0, reg_index = 0;
    UINT16 reg_write = 0, reg_mask = 0;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetInPath dev=%d,onoff=%d !\n", dev, onoff);
	
    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetInPath handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }
  
	halRet = zDrvCodec_GetInPathParaInfo(&inpathinfo,dev,onoff);
	if (halRet != DRV_SUCCESS) {
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    for (i = 0; i < inpathinfo.arraySize; i++) {
        reg_index = (inpathinfo.pRegPara + i)->reg_index;
        reg_write = (inpathinfo.pRegPara + i)->reg_bits;
        reg_mask = (inpathinfo.pRegPara + i)->reg_bitsmask;
		
        halRet = codec_I2CWrite(reg_index, reg_mask, reg_write);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInputPath new i=%d,halRet=%d !\n",i,halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
    }

    if (onoff) {
        //en_ckgen_adc
        halRet = codec_UpdatePrivateRegBits(RT5672_CHOP_DAC_ADC, 0x1000, 0x1000);
    } else {
        //Disable adc clkgen
        halRet = codec_UpdatePrivateRegBits(RT5672_CHOP_DAC_ADC, 0x1000, 0x0000);
    }
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_UpdatePrivateRegBits register RT5672_CHOP_DAC_ADC failed: %d !\n", halRet);
	codec_Release_Mutex();
	return DRV_ERROR;
    }

    if (rt5672.codecSrcType == AUDIO_SOURCE) {
        rt5672.device = dev;
        rt5672.dsp_bypass = TRUE;
        halRet += rt5672_dsp_setpara(&rt5672);
        halRet += rt5672_dsp_switch(onoff);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetInPath rt5672_dsp_switch failed: %d.\n", halRet);
            codec_Release_Mutex();
            return halRet;
        }
    }

    codec_info->inDev = onoff ? dev : AUDIO_INPUT_MAX;
    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetOutPath
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOutPath (T_ZDrvCodec_Handle handle,  T_ZDrvCodec_OutDevice dev, BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
	T_CodecPathParaInfo outpathinfo;
    UINT8 i = 0, reg_index = 0;
    UINT16 reg_write = 0, reg_mask = 0;
    T_Codec_UseInfo *codec_info = 0;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetOutPath dev=%d,onoff=%d !\n", dev, onoff);
	
    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetOutPath handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }
	
    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    
	halRet = zDrvCodec_GetOutPathParaInfo(&outpathinfo,dev,rt5672.codecSrcType,onoff);
	if (halRet != DRV_SUCCESS) {
        codec_Release_Mutex();
        return DRV_ERROR;
    }
   

    for (i = 0; i < outpathinfo.arraySize; i++) {
        reg_index = (outpathinfo.pRegPara + i)->reg_index;
        reg_write = (outpathinfo.pRegPara + i)->reg_bits;
        reg_mask = (outpathinfo.pRegPara + i)->reg_bitsmask;
		
        halRet = codec_I2CWrite(reg_index, reg_mask, reg_write);  
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutputPath new i=%d,halRet=%d !\n", i, halRet);
            codec_Release_Mutex();
            return halRet;
        }
    }
	
    if (onoff) {
        if (dev == AUDIO_OUTPUT_HEADSET || dev == AUDIO_OUTPUT_RECEIVER) {
            halRet += codec_WritePrvReg(RT5672_HP_DCC_INT1, 0x9f00);
        }
        //en_ckgen_dac
        halRet += codec_UpdatePrivateRegBits(RT5672_CHOP_DAC_ADC, 0x200, 0x200);
        //set dsp parameter into 5672 dsp modules according to current device
        rt5672.dsp_mode = RT5672_DSP_AEC;
        rt5672.device = dev;
        rt5672.dsp_bypass = TRUE;
        halRet += rt5672_dsp_setpara(&rt5672);
    } else {
        //disable dac clkgen
        halRet += codec_UpdatePrivateRegBits(RT5672_CHOP_DAC_ADC, 0x200, 0x000);
    }

    halRet += rt5672_dsp_switch(onoff);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_dsp_switch error: %d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }

    codec_info->outDev = onoff ? dev : AUDIO_INPUT_MAX;
    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetInpathMute
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInpathMute (T_ZDrvCodec_Handle handle, BOOL onoff )
{
    SINT32 halRet = DRV_SUCCESS;
    UINT8 reg_write = 0;
    T_Codec_UseInfo *codec_info;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvCodec_SetInpathMute,onoff %d\n", onoff);
	
    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetInpathMute handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    reg_write = onoff ? 0x1 : 0x0;	
    halRet = codec_I2CWrite(RT5672_STO1_ADC_DIG_VOL, RT5672_L_MUTE, reg_write << RT5672_L_MUTE_SFT);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_I2CWrite register RT5672_STO1_ADC_DIG_VOL error %d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }	

    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetOutpathMute
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOutpathMute(T_ZDrvCodec_Handle handle, BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
    UINT8 reg_write = 0;
    T_Codec_UseInfo *codec_info;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvCodec_SetOutPathMute,onoff %d\n", onoff);

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetOutpathMute handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    reg_write = onoff ? 0x1 : 0x0;	
    halRet += codec_I2CWrite(RT5672_DAC_CTRL,RT5672_M_DAC_L2_VOL | RT5672_M_DAC_R2_VOL, \
                              reg_write << RT5672_M_DAC_L2_VOL_SFT | reg_write << RT5672_M_DAC_R2_VOL_SFT);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec_I2CWrite register RT5672_DAC_CTRL error %d.\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }	
	
    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_Read
 * Description:
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Read(UINT8 regPage, UINT8 regAddress, UINT16 *regValue)
{
    SINT32 halRet = DRV_SUCCESS;

    halRet = codec_I2CRead16(regAddress, regValue);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Read error %d.\n", halRet);
    }

     return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_Write
 * Description:
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Write(UINT8 regPage, UINT8 regAddress, UINT16 regValue, UINT16 regMask)
{
    SINT32 halRet = DRV_SUCCESS;

    halRet =  codec_I2CWrite(regAddress,  regMask,  regValue);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Write error %d.\n", halRet);
    }

    return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_DumpReg
 * Description:
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_DumpReg(VOID)
{
    SINT32 halRet = DRV_SUCCESS;

    halRet = codec_ShowCodecReg(0, 0xff);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_DumpReg error %d.\n", halRet);
    }

    return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_SetOut_Hpf
 * Description:
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOut_Hpf (T_ZDrvCodec_Handle handle,T_ZDrvCodec_AudioSample fs,BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
	/*TODO...*/
    return  halRet;
}

/******************************************************************************
 * Function: zDrvCodec_Set_Inpath_Ana_Vol
 * Description:
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Inpath_Ana_Vol(T_ZDrvCodec_Handle handle,  SINT8 vol)
{
    SINT32 halRet = DRV_SUCCESS;
	/*TODO...*/
    return  halRet;

}

/******************************************************************************
 * Function: zDrvCodec_Set_Inpath_Dig_Vol
 * Description:
 * Parameters:
 *   Input: Vol 0~127(-17.625~30dB)
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Inpath_Dig_Vol(T_ZDrvCodec_Handle handle,  T_ZDrv_VpVol vol)
{
    SINT32 halRet = DRV_SUCCESS;
	/*TODO...*/
    return  halRet;

}

/******************************************************************************
 * Function: zDrvCodec_Set_Outpath_Ana_Vol
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Outpath_Ana_Vol(T_ZDrvCodec_Handle handle,  SINT8 vol)
{
    return DRV_SUCCESS;
}

/******************************************************************************
 * Function: zDrvCodec_Set_Outpath_Dig_Vol
 * Description:
 * Parameters:
 *   Input: Vol 0~39(12~-46.5dB)
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Outpath_Dig_Vol (T_ZDrvCodec_Handle handle,  T_ZDrv_VpVol outvol)
{
    SINT32 halRet = DRV_SUCCESS;
    T_ZDrvCodec_OutPath_Digital_Gain gain;
    T_Codec_UseInfo *codec_info;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvCodec_Set_Outpath_Dig_Vol output_vol: %d\n", outvol);

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_Open handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    switch(outvol) {
        case VP_VOL_0:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_65DB;
            break;
        case VP_VOL_1:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_36DB;
            break;
        case VP_VOL_2:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_33DB;
            break;
        case VP_VOL_3:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_30DB;
            break;
        case VP_VOL_4:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_24DB;
            break;
        case VP_VOL_5:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_21DB;
            break;
        case VP_VOL_6:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_18DB;
            break;
        case VP_VOL_7:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_15DB;
            break;
        case VP_VOL_8:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_12DB;
            break;
        case VP_VOL_9:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_6DB;
            break;
        case VP_VOL_10:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_MINUS_3DB;
            break;
        case VP_VOL_11:
            gain = CODEC_OUTPATH_DIGITAL_GAIN_0DB;
            break;
        default:
	    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetOutputVol the vol not support outvol=%d !\n", outvol);
            return -EINVAL;
    }
	
    halRet = codec_I2CWrite(RT5672_DAC2_DIG_VOL, RT5672_DAC_L2_VOL_MASK | RT5672_DAC_R2_VOL_MASK, (gain << RT5672_DAC_L2_VOL_SFT) | gain);
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Set_Outpath_Dig_Vol set register RT5672_DAC2_DIG_VOL error halRet=%d !\n", halRet);
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_AudioEnable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_AudioEnable(T_ZDrvCodec_Handle handle)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_AudioEnable handle=%d !\n",handle);
    codec_Claim_Mutex();

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_AudioEnable handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }

    if (codec_info->useState == CODEC_ENABLE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioEnable had already enabled !\n");
        codec_Release_Mutex();
        return DRV_ERR_START_TIMES;
    }

    if (codec_info->inDev != AUDIO_INPUT_MAX) {
        halRet = codec_I2CWrite(RT5672_STO1_ADC_DIG_VOL, RT5672_L_MUTE, 0x0 << RT5672_L_MUTE_SFT);	
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioEnable set register RT5672_STO1_ADC_DIG_VOL error halRet=%d !\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
    }

    if (codec_info->outDev != AUDIO_OUTPUT_MAX)  {
        halRet = codec_I2CWrite(RT5672_DAC_CTRL, RT5672_M_DAC_L2_VOL | RT5672_M_DAC_R2_VOL, \
			                   0x0 << RT5672_M_DAC_L2_VOL_SFT | 0x0 << RT5672_M_DAC_R2_VOL_SFT);
        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioEnable set register RT5672_DAC_CTRL error halRet=%d !\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
    }

    halRet += codec_I2CWrite_Nomask(RT5672_GEN_CTRL1, 0x8011);
    halRet += codec_I2CWrite_Nomask(RT5672_SCRABBLE_FUN, 0x0010);
    //set ASRC
    halRet += codec_I2CWrite_Nomask(RT5672_DSP_CLK, 0x1100);
	
    if (halRet != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvCodec_AudioEnable set register ASRC error, halRet=%d !\n", halRet);
        codec_Release_Mutex();
        return halRet;
    }

    codec_info->useState = CODEC_ENABLE;
    codec_Release_Mutex();
    return halRet;
}
/******************************************************************************
 * Function: zDrvCodec_AudioDisable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_AudioDisable(T_ZDrvCodec_Handle handle)
{
    SINT32 halRet = DRV_SUCCESS;
    T_Codec_UseInfo *codec_info;
    codec_Claim_Mutex();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_AudioDisable handle=%d !\n",handle);

    if (handle == 0) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_AudioDisable handle is null !\n");
        codec_Release_Mutex();
        return DRV_ERROR;
    }

    codec_info = (T_Codec_UseInfo*)handle;
    if (codec_info->handleState != HANDLE_IN_USE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Codec isn't in use yet!\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_OPENED;
    }
	
    if (codec_info->useState == CODEC_DISABLE) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioDisable had already disabled.\n");
        codec_Release_Mutex();
        return DRV_ERR_NOT_STARTED;
    }
	
    if (codec_info->inDev != AUDIO_INPUT_MAX) {
        //input path power down the micbias1
        halRet += codec_I2CWrite(RT5672_PWR_ANLG2, RT5672_PWR_MB1, 0x0 << RT5672_PWR_MB1_BIT);
        halRet += codec_I2CWrite(RT5672_PWR_VOL, RT5672_PWR_MB2, 0x0 << RT5672_PWR_MB2_BIT);
        //mute the 1c[15]
        halRet += codec_I2CWrite(RT5672_STO1_ADC_DIG_VOL, RT5672_L_MUTE, 0x0 << RT5672_L_MUTE_SFT);

        if (halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioDisable write register micbias error: %d.\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
    }
	
    if (codec_info->outDev != AUDIO_OUTPUT_MAX) {
        //output path
        halRet = codec_I2CWrite(RT5672_DAC_CTRL,RT5672_M_DAC_L2_VOL | RT5672_M_DAC_R2_VOL, \
                                 0x1 << RT5672_M_DAC_L2_VOL_SFT | 0x1<<RT5672_M_DAC_R2_VOL_SFT);
        if(halRet != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioDisable write register RT5672_DAC_CTRL error: %d.\n", halRet);
            codec_Release_Mutex();
            return DRV_ERROR;
        }
    }

    codec_info->useState = CODEC_DISABLE;
    codec_Release_Mutex();
    return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_SetLoopBack
 * Description: traverse full inpath and part outpath(no pass I2S)
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetLoopBack(T_ZDrvCodec_Handle handle,BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
	/*TODO...*/
    return  halRet;

}

/******************************************************************************
 * Function: zDrvCodec_SetLoopBack_down
 * Description: traverse part inpath and full outpath(no pass I2S)
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetLoopBack_down(T_ZDrvCodec_Handle handle,BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
	/*TODO...*/
    return  halRet;

}

/******************************************************************************
 * Function: zDrvCodec_SetLoopBack_down
 * Description: traverse part inpath and full outpath(no pass I2S)
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_EarpieceDetectEnable( BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_EarpieceDetectEnable onoff=%d !\n", onoff);

    halRet = codec_EarpieceDetectEnable(onoff);
    if (halRet != DRV_SUCCESS)  {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_EarpieceDetectEnable error: %d.\n", halRet);
        return DRV_ERROR;
    }

    isEarpDetect = onoff;
    return	halRet;
}

