/**
 * @file Hal_codec_tlv3100.h
 * @brief Implementation of Sanechips Audio Codec Function
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author Author: Xinqiang Xu <xu.xinqiang@sanechips.com.cn>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifndef _HAL_CODEC_TLV3100_H
#define _HAL_CODEC_TLV3100_H
/*******************************************************************************
 *							 Include header files							   *
 ******************************************************************************/


/*******************************************************************************
 *							   Macro definitions							   *
 ******************************************************************************/
#define CODEC_RESET_PIN           0x9
#define TLV3100_I2C_SADD            0x18
#define CODEC_P0_REG1_RESET_VAL    0x1
#define CODEC_P0_REG1_RESET_MASK    0x1

/*Page 0 / Register 5: PLL P and R-VAL */
#define CODEC_P0_REG5_PLL_PUP_VAL  0x80
#define CODEC_P0_REG5_PLL_PDOWN_VAL  0x00
#define CODEC_P0_REG5_PLL_PWCTRL_MASK  0x80
#define CODEC_P0_REG5_PLL_PDIV_MASK  0x70
#define CODEC_P0_REG5_PLL_RMULTI_MASK  0x0F
#define CODEC_P0_REG6_PLL_JMULTI_MASK  0x3F
#define CODEC_P0_REG7_PLL_DVAL_MSB_MASK  0x3F
#define CODEC_P0_REG8_PLL_DVAL_LSB_MASK  0xFF

/*codec interface control*/
#define CODEC_P0_REG27_BUS_I2S_VAL  0x00
#define CODEC_P0_REG27_BUS_DSP_VAL  0x40
#define CODEC_P0_REG27_BUS_RJF_VAL  0x80
#define CODEC_P0_REG27_BUS_LJF_VAL  0xC0
#define CODEC_P0_REG27_BUS_MODE_MASK  0xC0
#define CODEC_P0_REG27_BUS_WORD_16BIT_VAL  0x00
#define CODEC_P0_REG27_BUS_WORD_20BIT_VAL  0x10
#define CODEC_P0_REG27_BUS_WORD_24BIT_VAL  0x20
#define CODEC_P0_REG27_BUS_WORD_32BIT_VAL  0x30
#define CODEC_P0_REG27_BUS_WORD_LENGTH_MASK  0x30
#define CODEC_P0_REG27_BCLK_INPUT_VAL  0x00
#define CODEC_P0_REG27_BCLK_OUTPUT_VAL  0x08
#define CODEC_P0_REG27_BCLK_PIN_MASK  0x08
#define CODEC_P0_REG27_WCLK_INPUT_VAL  0x00
#define CODEC_P0_REG27_WCLK_OUTPUT_VAL  0x04
#define CODEC_P0_REG27_WCLK_PIN_MASK  0x04

/*Page 0 / Register 28: Data-Slot Offset Programmability */
#define CODEC_P0_REG28_DATASLOT_OFFSET_VAL  0x00	/*unit bclk */
#define CODEC_P0_REG28_DATASLOT_OFFSET_0BCLK_VAL  0x00	/*unit bclk */
#define CODEC_P0_REG28_DATASLOT_OFFSET_MASK 0xff

/*Page 0 / Register 29: Codec Interface Control 2*/
#define CODEC_P0_REG29_DIN_TO_DOUT_EN_VAL  0x20
#define CODEC_P0_REG29_DIN_TO_DOUT_DIS_VAL  0x00
#define CODEC_P0_REG29_DIN_TO_DOUT_CTRL_MASK  0x20
#define CODEC_P0_REG29_ADC_TO_DAC_LPBACK_EN_VAL  0x10
#define CODEC_P0_REG29_ADC_TO_DAC_LPBACK_DIS_VAL  0x00
#define CODEC_P0_REG29_ADC_TO_DAC_LPBACK_CTRL_MASK  0x10
#define CODEC_P0_REG29_BCLK_INVERTED_EN_VAL  0x08
#define CODEC_P0_REG29_BCLK_INVERTED_DIS_VAL  0x00
#define CODEC_P0_REG29_BCLK_INVERTED_CTRL_MASK  0x08
#define CODEC_P0_REG29_BWCLK_ACTIVE_PD_VAL  0x04
#define CODEC_P0_REG29_BWCLK_UNACTIVE_PD_VAL  0x00
#define CODEC_P0_REG29_BWCLK_ACTIVE_CTRL_MASK  0x04
#define CODEC_P0_REG29_BDIVCLKIN_EQUAL_DACCLK_VAL  0x00
#define CODEC_P0_REG29_BDIVCLKIN_EQUAL_DACMODCLK_VAL  0x01
#define CODEC_P0_REG29_BDIVCLKIN_EQUAL_ADCCLK_VAL  0x02
#define CODEC_P0_REG29_BDIVCLKIN_EQUAL_ADCMODCLK_VAL  0x03
#define CODEC_P0_REG29_BDIVCLKIN_EQUAL_CTRL_MASK  0x03

/*Page 0 / Register 30: BCLK N_VAL*/
#define CODEC_P0_REG30_BCLK_NDIV_PD_VAL  0x00
#define CODEC_P0_REG30_BCLK_NDIV_PU_VAL  0x80
#define CODEC_P0_REG30_BCLK_NDIV_POWER_CTRL_MASK  0x80
#define CODEC_P0_REG30_BCLK_NDIV_VAL  0x04
#define CODEC_P0_REG30_BCLK_NDIV_VAL_MASK  0x7F

/*Page 0 / Register 32: Codec Secondary Interface Control 2*/
#define CODEC_P0_REG32_PRIMBCLK_FDTO_SERINTER_VAL  0x00
#define CODEC_P0_REG32_SECBCLK_FDTO_SERINTER_VAL   0x08
#define CODEC_P0_REG32_BCLK_FDTO_SERINTER_CTRL_MASK   0x08
#define CODEC_P0_REG32_PRIMWBCLK_FDTO_SERINTER_VAL  0x00
#define CODEC_P0_REG32_SECWCLK_FDTO_SERINTER_VAL   0x04
#define CODEC_P0_REG32_WCLK_FDTO_SERINTER_CTRL_MASK   0x04
#define CODEC_P0_REG32_PRIMDIN_FDTO_SERINTER_VAL  0x00
#define CODEC_P0_REG32_SECDIN_FDTO_SERINTER_VAL   0x01
#define CODEC_P0_REG32_DIN_FDTO_SERINTER_CTRL_MASK   0x01

/*Page 0 / Register 33: Codec Secondary Interface Control 3*/
#define CODEC_P0_REG33_PRIMBCLK_EQ_INTERBCLK_VAL  0x00
#define CODEC_P0_REG33_PRIMBCLK_EQ_SECBCLK_VAL   0x80
#define CODEC_P0_REG33_PRIMBCLK_EQ_CTRL_MASK   0x80
#define CODEC_P0_REG33_SECBCLK_EQ_PRIMBCLK_VAL  0x00
#define CODEC_P0_REG33_SECBCLK_EQ_INTERBCLK_VAL   0x40
#define CODEC_P0_REG33_SECBCLK_EQ_CTRL_MASK   0x40
#define CODEC_P0_REG33_PRIMWCLK_EQ_INTERDACFS_VAL   0x00
#define CODEC_P0_REG33_PRIMWCLK_EQ_INTERADCFS_VAL   0x10
#define CODEC_P0_REG33_PRIMWCLK_EQ_SECWCLK_VAL   0x20
#define CODEC_P0_REG33_PRIMWCLK_EQ_CTRL_MASK   0x30
#define CODEC_P0_REG33_SECWCLK_EQ_INTERDACFS_VAL   0x04
#define CODEC_P0_REG33_SECWCLK_EQ_INTERADCFS_VAL   0x08
#define CODEC_P0_REG33_SECWCLK_EQ_PRIMWCLK_VAL   0x00
#define CODEC_P0_REG33_SECWCLK_EQ_CTRL_MASK   0x0C
#define CODEC_P0_REG33_PRIMDOUT_EQ_INTERDOUT_VAL  0x00
#define CODEC_P0_REG33_PRIMDOUT_EQ_SECDIN_VAL  0x02
#define CODEC_P0_REG33_PRIMDOUT_EQ_CTRL_MASK  0x02
#define CODEC_P0_REG33_SECDOUT_EQ_INTERDOUT_VAL  0x01
#define CODEC_P0_REG33_SECDOUT_EQ_PRIMDIN_VAL  0x00
#define CODEC_P0_REG33_SECDOUT_EQ_CTRL_MASK  0x01

/* DOUT control */
#define CODEC_P0_REG53_DOUT_KEEP_DIS_VAL  0x10
#define CODEC_P0_REG53_DOUT_KEEP_EN_VAL  0x00
#define CODEC_P0_REG53_DOUT_KEEP_MASK 0x10
#define CODEC_P0_REG53_DOUT_POUT_VAL  0x02 	/* primary DOUT output for codec interface */
#define CODEC_P0_REG53_DOUT_DIS_VAL  0x00
#define CODEC_P0_REG53_DOUT_GPO_VAL  0x04
#define CODEC_P0_REG53_DOUT_CLKO_VAL  0x06
#define CODEC_P0_REG53_DOUT_INT1_VAL  0x08
#define CODEC_P0_REG53_DOUT_INT2_VAL  0x0A
#define CODEC_P0_REG53_DOUT_CTRL_MASK  0x0E
#define CODEC_P0_REG53_DOUT_GPOUT_LOW_VAL  0x00
#define CODEC_P0_REG53_DOUT_GPOUT_HIGH_VAL  0x01
#define CODEC_P0_REG53_DOUT_GPOUT_MASK 0x01

/* DIN control */
#define CODEC_P0_REG54_DIN_DIS_VAL  0x00
#define CODEC_P0_REG54_DIN_EN_VAL  0x02
#define CODEC_P0_REG54_DIN_GPI_VAL  0x04
#define CODEC_P0_REG54_DIN_CTRL_MASK  0x06

/* clk parameters */
#define CODEC_P0_REG4_PLL_CLKIN_MCLK_VAL  0x00
#define CODEC_P0_REG4_PLL_CLKIN_EQCLK_MASK  0x0C
#define CODEC_P0_REG4_CODEC_CLKIN_MCLK_VAL  0x00
#define CODEC_P0_REG4_CODEC_CLKIN_BCLK_VAL  0x01
#define CODEC_P0_REG4_CODEC_CLKIN_GPIO1_VAL  0x02
#define CODEC_P0_REG4_CODEC_CLKIN_PLLCLK_VAL  0x03
#define CODEC_P0_REG4_CODEC_CLKIN_EQCLK_MASK  0x03

/* DAC NDAC_VAL */
#define CODEC_P0_REG11_NDAC_PWON_VAL  0x80
#define CODEC_P0_REG11_NDAC_PWOFF_VAL  0x00
#define CODEC_P0_REG11_NDAC_PW_MASK 0x80
#define CODEC_P0_REG11_NDAC_VAL_MASK  0x7F

/* DAC MDAC_VAL */
#define CODEC_P0_REG12_MDAC_PWON_VAL  0x80
#define CODEC_P0_REG12_MDAC_PWOFF_VAL  0x00
#define CODEC_P0_REG12_MDAC_PW_MASK 0x80
#define CODEC_P0_REG12_MDAC_VAL_MASK  0x7F

/* DAC DOSR_VAL  MSB */
#define CODEC_P0_REG13_DOSR_MSB_VAL_MASK  0x03

/* DAC DOSR_VAL  LSB */
#define CODEC_P0_REG14_DOSR_LSB_VAL_MASK  0xFF

/* ADC NADC_VAL */
#define CODEC_P0_REG18_NADC_PWON_VAL  0x80
#define CODEC_P0_REG18_NADC_PWOFF_VAL  0x00
#define CODEC_P0_REG18_NADC_PW_MASK 0x80
#define CODEC_P0_REG18_NADC_VAL_MASK  0x7F

/* ADC MADC_VAL */
#define CODEC_P0_REG19_MADC_PWON_VAL  0x80
#define CODEC_P0_REG19_MADC_PWOFF_VAL  0x00
#define CODEC_P0_REG19_MADC_PW_MASK 0x80
#define CODEC_P0_REG19_MADC_VAL_MASK  0x7F

/* ADC AOSR_VAL */
#define CODEC_P0_REG13_AOSR_VAL_MASK  0xFF

/* Page 0 / Registers 25: CLKOUT MUX */
#define CODEC_P0_REG25_CDIV_CLKIN_EQ_MCLK_VAL  0x00
#define CODEC_P0_REG25_CDIV_CLKIN_EQ_BCLK_VAL  0x01
#define CODEC_P0_REG25_CDIV_CLKIN_EQ_DACCLK_VAL  0x04
#define CODEC_P0_REG25_CDIV_CLKIN_EQ_CTRL_MASK 0x07

/* Page 0 / Registers 26: CLKOUT M_VAL */
#define CODEC_P0_REG26_CCLKOUT_MDIV_PON_VAL  0x80
#define CODEC_P0_REG26_CCLKOUT_MDIV_POFF_VAL  0x00
#define CODEC_P0_REG26_CCLKOUT_MDIV_PW_CTRL_MASK 0x80
#define CODEC_P0_REG26_CCLKOUT_MDIV_VAL  0x01
#define CODEC_P0_REG26_CCLKOUT_MDIV_VAL_MASK 0x7F

/* input path parameters */
/* Page 1 / Register 46: MICBIAS */
#define CODEC_P1_REG46_DEV_SOFT_PWOFF_ENABLE_VAL      0x80
#define CODEC_P1_REG46_DEV_SOFT_PWOFF_DISABLE_VAL    0x00
#define CODEC_P1_REG46_DEV_SOFT_PWOFF_CTRL_MASK       0x80

/* Programmed MICBIAS is not powered up if headset detection is enabled but headset is not inserted */
#define CODEC_P1_REG46_MICBIAS_PWON_CTRL1_VAL   0x00
/* Programmed MICBIAS is powered up even if headset is not inserted. */
#define CODEC_P1_REG46_MICBIAS_PWON_CTRL2_VAL   0x08
#define CODEC_P1_REG46_MICBIAS_PWON_CTRL_MASK   0x08
#define CODEC_P1_REG46_MICBIAS_OUT_PWOFF_VAL    0x00
#define CODEC_P1_REG46_MICBIAS_OUT_PW2V_VAL      0x01
#define CODEC_P1_REG46_MICBIAS_OUT_PW2_5V_VAL  0x02
#define CODEC_P1_REG46_MICBIAS_OUT_PWAVDD_VAL 0x03
#define CODEC_P1_REG46_MICBIAS_OUT_CTRL_MASK    0x03

/* Page 1 / Register 47: MIC PGA */
#define CODEC_P1_REG47_MICPGA_CTRL_BY_D06_VAL   0x00
#define CODEC_P1_REG47_MICPGA_UNCTRL_BY_D06_VAL  0x80
#define CODEC_P1_REG47_MICPGA_CTRL_MASK 0x80
#define CODEC_P1_REG47_MICPGA_0DB_VAL 0x00
#define CODEC_P1_REG47_MICPGA_1DB_VAL 0x02
#define CODEC_P1_REG47_MICPGA_2DB_VAL 0x04
#define CODEC_P1_REG47_MICPGA_3DB_VAL 0x06
#define CODEC_P1_REG47_MICPGA_6DB_VAL 0x0c
#define CODEC_P1_REG47_MICPGA_9DB_VAL 0x12
#define CODEC_P1_REG47_MICPGA_10DB_VAL 0x14
#define CODEC_P1_REG47_MICPGA_12DB_VAL 0x18
#define CODEC_P1_REG47_MICPGA_13DB_VAL 0x1a
#define CODEC_P1_REG47_MICPGA_15DB_VAL 0x1e
#define CODEC_P1_REG47_MICPGA_16DB_VAL 0x20
#define CODEC_P1_REG47_MICPGA_18DB_VAL 0x24
#define CODEC_P1_REG47_MICPGA_20DB_VAL 0x28
#define CODEC_P1_REG47_MICPGA_21DB_VAL 0x2a
#define CODEC_P1_REG47_MICPGA_22DB_VAL 0x2c
#define CODEC_P1_REG47_MICPGA_23DB_VAL 0x2e
#define CODEC_P1_REG47_MICPGA_24DB_VAL 0x30
#define CODEC_P1_REG47_MICPGA_25DB_VAL 0x32
#define CODEC_P1_REG47_MICPGA_26DB_VAL 0x34
#define CODEC_P1_REG47_MICPGA_30DB_VAL 0x3c
#define CODEC_P1_REG47_MICPGA_33DB_VAL 0x42
#define CODEC_P1_REG47_MICPGA_36DB_VAL 0x48
#define CODEC_P1_REG47_MICPGA_40DB_VAL 0x50
#define CODEC_P1_REG47_MICPGA_50DB_VAL 0x64
#define CODEC_P1_REG47_MICPGA_53DB_VAL 0x6a
#define CODEC_P1_REG47_MICPGA_56DB_VAL 0x70
#define CODEC_P1_REG47_MICPGA_60DB_VAL 0x78
#define CODEC_P1_REG47_MICPGA_GAIN_MASK 0x7F

/* page1 reg48 */
#define CODEC_P1_REG48_MIC1LP_UNSEL_VAL 0x00
#define CODEC_P1_REG48_MIC1LP_SEL_10KR_VAL 0x40
#define CODEC_P1_REG48_MIC1LP_SEL_20KR_VAL 0x80
#define CODEC_P1_REG48_MIC1LP_SEL_40KR_VAL 0xC0
#define CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK 0xC0
#define CODEC_P1_REG48_MIC1RP_UNSEL_VAL 0x00
#define CODEC_P1_REG48_MIC1RP_SEL_10KR_VAL 0x10
#define CODEC_P1_REG48_MIC1RP_SEL_20KR_VAL 0x20
#define CODEC_P1_REG48_MIC1RP_SEL_40KR_VAL 0x30
#define CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK 0x30
#define CODEC_P1_REG48_MIC1LM_UNSEL_VAL 0x00
#define CODEC_P1_REG48_MIC1LM_SEL_10KR_VAL 0x04
#define CODEC_P1_REG48_MIC1LM_SEL_20KR_VAL 0x08
#define CODEC_P1_REG48_MIC1LM_SEL_40KR_VAL 0x0C
#define CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK 0x0C

/* page1 reg49 */
#define CODEC_P1_REG49_CM_UNSEL_VAL 0x00
#define CODEC_P1_REG49_CM_SEL_10KR_VAL 0x40
#define CODEC_P1_REG49_CM_SEL_20KR_VAL 0x80
#define CODEC_P1_REG49_CM_SEL_40KR_VAL 0xC0
#define CODEC_P1_REG49_ADC_CM_SEL_MASK 0xC0
#define CODEC_P1_REG49_MIC1LM_UNSEL_VAL 0x00
#define CODEC_P1_REG49_MIC1LM_SEL_10KR_VAL 0x10
#define CODEC_P1_REG49_MIC1LM_SEL_20KR_VAL 0x20
#define CODEC_P1_REG49_MIC1LM_SEL_40KR_VAL 0x30
#define CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK 0x30

/* page1 reg50 */
#define CODEC_P1_REG50_MIC1PIN_TO_FLOAT_VAL 0x00
#define CODEC_P1_REG50_MIC1LP_TO_CM_VAL 0x80
#define CODEC_P1_REG50_MIC1RP_TO_CM_VAL 0x40
#define CODEC_P1_REG50_MIC1LM_TO_CM_VAL 0x20
#define CODEC_P1_REG50_MIC1_TO_CM_MASK 0xE0

/* Page 0 / Register 81: ADC Digital Mic */
#define CODEC_P0_REG81_ADC_PWON_VAL 0x80
#define CODEC_P0_REG81_ADC_PWOFF_VAL 0x00
#define CODEC_P0_REG81_ADC_PW_MASK 0x80
#define CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_1FS_VAL 0x00 /* ADC channel volume control soft-stepping is enabled for one step per sample period. */
#define CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_2FS_VAL 0x01 /* ADC channel volume control soft-stepping is enabled for one step per 2sample period. */
#define CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_OFF_VAL  0x02
#define CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_CTRL_MASK 0x03

/* Page 0 / Register 82: ADC Digital Volume Control Fine Adjust */
#define CODEC_P0_REG82_ADC_MUTE_VAL  0x80
#define CODEC_P0_REG82_ADC_UNMUTE_VAL  0x00
#define CODEC_P0_REG82_ADC_MUTE_CTRL_MASK 0x80
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_0DB_VAL 0x00
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_MINUS_0_1DB_VAL 0x10
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_MINUS_0_2DB_VAL 0x20
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_MINUS_0_3DB_VAL 0x30
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_MINUS_0_4DB_VAL 0x40
#define CODEC_P0_REG82_ADC_DIGVOL_FINE_MASK 0x70

/* Page 0 / Register 83: ADC Digital Volume Control Coarse Adjust */
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK 0x7f
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_MINUS_12DB_VAL 0x68
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_0DB_VAL 0x00
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_3DB_VAL 0x06
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_6DB_VAL 0x0c
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_9DB_VAL 0x12
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_12DB_VAL 0x18
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_15DB_VAL 0x1E
#define CODEC_P0_REG83_ADC_DIGVOL_COARSE_18DB_VAL 0x24

/* output path parameters */
/* Page 0 / Register 63: DAC Data-Path Setup */
#define CODEC_P0_REG63_LDAC_PWON_VAL    0x80
#define CODEC_P0_REG63_LDAC_PWOFF_VAL    0x0
#define CODEC_P0_REG63_LDAC_PW_MASK  0x80
#define CODEC_P0_REG63_RDAC_PWON_VAL    0x40
#define CODEC_P0_REG63_RDAC_PWOFF_VAL    0x0
#define CODEC_P0_REG63_RDAC_PW_MASK  0x40
#define CODEC_P0_REG63_LDAC_EQU_OFF_VAL    0x00
#define CODEC_P0_REG63_LDAC_EQU_LDATA_VAL    0x10
#define CODEC_P0_REG63_LDAC_EQU_RDATA_VAL    0x20
#define CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL    0x30
#define CODEC_P0_REG63_LDAC_EQU_CTRL_MASK    0x30
#define CODEC_P0_REG63_RDAC_EQU_OFF_VAL    0x00
#define CODEC_P0_REG63_RDAC_EQU_LDATA_VAL    0x08
#define CODEC_P0_REG63_RDAC_EQU_RDATA_VAL    0x04
#define CODEC_P0_REG63_RDAC_EQU_LRMIXER_VAL    0x0C
#define CODEC_P0_REG63_RDAC_EQU_CTRL_MASK    0x0C
#define CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL    0x00
#define CODEC_P0_REG63_DAC_VOLCTR_SSTEP_2FS_VAL    0x01
#define CODEC_P0_REG63_DAC_VOLCTR_SSTEP_DIS_VAL    0x02
#define CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK    0x03

/* Page 0 / Register 64: DAC VOLUME CONTROL */
#define CODEC_P0_REG64_DAC_LCHN_MUTE_VAL    0x08
#define CODEC_P0_REG64_DAC_LCHN_UNMUTE_VAL    0x00
#define CODEC_P0_REG64_DAC_LCHN_MUTE_CTRL_MASK    0x08
#define CODEC_P0_REG64_DAC_RCHN_MUTE_VAL    0x04
#define CODEC_P0_REG64_DAC_RCHN_UNMUTE_VAL    0x00
#define CODEC_P0_REG64_DAC_RCHN_MUTE_CTRL_MASK    0x04

/* Left and right channels have independent volume control. */
#define CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL    0x00
#define CODEC_P0_REG64_DAC_LCHN_VOLCTRL_BYRCHN_VAL    0x01
#define CODEC_P0_REG64_DAC_RCHN_VOLCTRL_BYLCHN_VAL    0x02
#define CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK    0x03

/* Page 0 / Register 65: DAC Left Volume Control */
#define CODEC_P0_REG65_DAC_LCHN_VOL_15DB_VAL    0x1E
#define CODEC_P0_REG65_DAC_LCHN_VOL_12DB_VAL    0x18
#define CODEC_P0_REG65_DAC_LCHN_VOL_6DB_VAL    0x0C
#define CODEC_P0_REG65_DAC_LCHN_VOL_3DB_VAL    0x06
#define CODEC_P0_REG65_DAC_LCHN_VOL_2DB_VAL    0x04
#define CODEC_P0_REG65_DAC_LCHN_VOL_1DB_VAL    0x02
#define CODEC_P0_REG65_DAC_LCHN_VOL_0DB_VAL    0x00
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_1DB5_VAL    253
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_3DB_VAL    250
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_5DB_VAL   246
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_6DB_VAL   244
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_9DB_VAL    238
#define CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_12DB_VAL    232
#define CODEC_P0_REG65_DAC_LCHN_VOL_MASK    0xff

/* Page 0 / Register 66: DAC Right Volume Control */
#define CODEC_P0_REG66_DAC_RCHN_VOL_15DB_VAL    0x1E
#define CODEC_P0_REG66_DAC_RCHN_VOL_12DB_VAL    0x18
#define CODEC_P0_REG66_DAC_RCHN_VOL_6DB_VAL    0x0C
#define CODEC_P0_REG66_DAC_RCHN_VOL_3DB_VAL    0x06
#define CODEC_P0_REG66_DAC_RCHN_VOL_2DB_VAL    0x04
#define CODEC_P0_REG66_DAC_RCHN_VOL_1DB_VAL    0x02
#define CODEC_P0_REG66_DAC_RCHN_VOL_0DB_VAL    0x00
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_1DB5_VAL    253
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_3DB_VAL    250
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_5DB_VAL   246
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_6DB_VAL   244
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_9DB_VAL    238
#define CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_12DB_VAL    232
#define CODEC_P0_REG66_DAC_RCHN_VOL_MASK    0xff

/* Page 1 / Register 31: Headphone Drivers */
#define CODEC_P1_REG31_HPL_PWON_VAL    0x80
#define CODEC_P1_REG31_HPL_PWOFF_VAL    0x0
#define CODEC_P1_REG31_HPL_PW_MASK  0x80
#define CODEC_P1_REG31_HPR_PWON_VAL    0x40
#define CODEC_P1_REG31_HPR_PWOFF_VAL    0x0
#define CODEC_P1_REG31_HPR_PW_MASK  0x40
#define CODEC_P1_REG31_HP_OUT_1_35V_VAL 0x00
#define CODEC_P1_REG31_HP_OUT_1_5V_VAL    0x08
#define CODEC_P1_REG31_HP_OUT_1_65V_VAL 0x10
#define CODEC_P1_REG31_HP_OUT_1_8V_VAL  0x18
#define CODEC_P1_REG31_HP_OUT_VOL_MASK 0x18
#define CODEC_P1_REG31_WRITE_ONLY_VAL 0x04
#define CODEC_P1_REG31_WRITE_ONLY_VAL_MASK 0x04

/* Page 1 / Register 32: Class-D Speaker Amplifier */
#define CODEC_P1_REG32_SPKPM_PWON_VAL    0x80
#define CODEC_P1_REG32_SPKPM_PWOFF_VAL    0x0
#define CODEC_P1_REG32_SPKPM_PW_MASK  0x80
#define CODEC_P1_REG32_WRITE_ONLY_VAL 0x06
#define CODEC_P1_REG32_WRITE_ONLY_VAL_MASK 0x3E

/* Page 1 / Register 33: HP Output Drivers POP Removal Settings */
#define CODEC_P1_REG33_HPDRI_REVSEQ_SIMU_VAL    0x00 	 /* simultaneously with the HP and SP amplifiers */
#define CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL    0x80 	/* after HP and SP amplifiers */
#define CODEC_P1_REG33_HPDRI_REVSEQ_MASK  0x80
#define CODEC_P1_REG33_HPDRI_PWON_0US_VAL    0x0		/* HP Driver power-on time */
#define CODEC_P1_REG33_HPDRI_PWON_15_3US_VAL    0x08	/* HP Driver power-on time */
#define CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL    0x20	/* HP Driver power-on time */
#define CODEC_P1_REG33_HPDRI_PWON_76_2MS_VAL    0x28	/* HP Driver power-on time */
#define CODEC_P1_REG33_HPDRI_PWON_304MS_VAL    0x38		/* HP Driver power-on time */
#define CODEC_P1_REG33_HPDRI_PWON_TIME_MASK 0x78
#define CODEC_P1_REG33_HPDRI_RAMPUP_0MS_VAL    0x00		/* HP Driver ramp-up step time */
#define CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL    0x06 	/* HP Driver ramp-up step time */
#define CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK    0x06

/* Page 1 / Register 34: Output Driver PGA Ramp-Down Period Control */
#define CODEC_P1_REG34_SPK_PWON_WAIT_0MS_VAL    0x00
#define CODEC_P1_REG34_SPK_PWON_WAIT_3_04MS_VAL    0x10
#define CODEC_P1_REG34_SPK_PWON_WAIT_7_62MS_VAL    0x20
#define CODEC_P1_REG34_SPK_PWON_WAIT_12_2MS_VAL   0x30
#define CODEC_P1_REG34_SPK_PWON_WAIT_15_3MS_VAL   0x40
#define CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL  0x50
#define CODEC_P1_REG34_SPK_PWON_WAIT_24_4MS_VAL  0x60
#define CODEC_P1_REG34_SPK_PWON_WAIT_30_5MS_VAL  0x70
#define CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK    0x70

/* Page 1 / Register 35: DAC_L and DAC_R Output Mixer Routing */
#define CODEC_P1_REG35_DACL_ROUTE_NONE_VAL    0x00
#define CODEC_P1_REG35_DACL_ROUTE_LCHN_MIXER_VAL    0x40
#define CODEC_P1_REG35_DACL_ROUTE_HPL_DRV_VAL    0x80
#define CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK    0xC0
#define CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL    0x20
#define CODEC_P1_REG35_MIC1LP_INPUT_UNROUTE_LCHN_VAL    0x00
#define CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK 0x20
#define CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_LCHN_MIXER_VAL    0x10
#define CODEC_P1_REG35_MIC1RP_INPUT_UNROUTE_LCHN_VAL    0x00
#define CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_LCHN_MIXER_MASK 0x10
#define CODEC_P1_REG35_DACR_ROUTE_NONE_VAL    0x00
#define CODEC_P1_REG35_DACR_ROUTE_RCHN_MIXER_VAL    0x04
#define CODEC_P1_REG35_DACR_ROUTE_HPR_DRV_VAL    0x08
#define CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK    0x0C
#define CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_VAL    0x02
#define CODEC_P1_REG35_MIC1RP_INPUT_UNROUTE_RCHN_VAL    0x00
#define CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK 0x02
#define CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL    0x00
#define CODEC_P1_REG35_HPL_OUTUT_ROUTE_HPR_DRV_VAL    0x01
#define CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK    0x01

/* Page 1 / Register 36: Left Analog Vol to HPL */
#define CODEC_P1_REG36_LAVOL_TO_HPL_VAL    0x80
#define CODEC_P1_REG36_LAVOL_UNTO_HPL_VAL    0x00
#define CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK    0x80
#define CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL    0x00
#define CODEC_P1_REG36_LAVOL_CTRL_FORHPL_N12DB_VAL    0x18
#define CODEC_P1_REG36_LAVOL_CTRL_FORHPL_MUTE_VAL    0x7F
#define CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK 0x7f

/*Page 1 / Register 37: Right Analog Vol to HPR */
#define CODEC_P1_REG37_RAVOL_TO_HPR_VAL    0x80
#define CODEC_P1_REG37_RAVOL_UNTO_HPR_VAL    0x00
#define CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK    0x80
#define CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL    0x00
#define CODEC_P1_REG37_RAVOL_CTRL_FORHPR_N12DB_VAL    0x18
#define CODEC_P1_REG37_RAVOL_CTRL_FORHPR_MUTE_VAL    0x7F
#define CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK 0x7f

/* Page 1 / Register 38: Left Analog Vol to SPK */
#define CODEC_P1_REG38_LAVOL_TO_SPK_VAL    0x80
#define CODEC_P1_REG38_LAVOL_UNTO_SPK_VAL    0x00
#define CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK    0x80
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_0DB_VAL    0x00
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MINUS_5DB_VAL    0x0a
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MINUS_7DB_VAL    0x0E
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MINUS_10DB_VAL    0x14
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MINUS_15DB_VAL    0x1E
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MINUS_20DB_VAL    0x28
#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MUTE_VAL    0x7F
//#define CODEC_P1_REG38_LAVOL_CTRL_FORSPK_DB_MASK    0x7F
#define CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK 0x7f

/* Page 1 / Register 40: HPL Driver */
#define CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL    0x00
#define CODEC_P1_REG40_HPL_DRV_PGA_3DB_VAL    0x18
#define CODEC_P1_REG40_HPL_DRV_PGA_5DB_VAL    0x28
#define CODEC_P1_REG40_HPL_DRV_PGA_6DB_VAL    0x30
#define CODEC_P1_REG40_HPL_DRV_PGA_7DB_VAL    0x38
#define CODEC_P1_REG40_HPL_DRV_PGA_9DB_VAL    0x48
#define CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK 0x78
#define CODEC_P1_REG40_HPL_DRV_MUTE_VAL    0x00
#define CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL    0x04
#define CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK    0x04
#define CODEC_P1_REG40_HPL_DRV_PWOFF_WEAKDRV_VAL    0x00
#define CODEC_P1_REG40_HPL_DRV_PWOFF_HIMPEDANCE_VAL    0x02
#define CODEC_P1_REG40_HPL_DRV_PWOFF_CTRL_MASK    0x02

/* Page 1 / Register 41: HPR Driver */
#define CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL    0x00
#define CODEC_P1_REG41_HPR_DRV_PGA_3DB_VAL    0x18
#define CODEC_P1_REG41_HPR_DRV_PGA_5DB_VAL    0x28
#define CODEC_P1_REG41_HPR_DRV_PGA_6DB_VAL    0x30
#define CODEC_P1_REG41_HPR_DRV_PGA_7DB_VAL    0x38
#define CODEC_P1_REG41_HPR_DRV_PGA_9DB_VAL    0x48
#define CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK 0x78
#define CODEC_P1_REG41_HPR_DRV_MUTE_VAL    0x00
#define CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL    0x04
#define CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK    0x04
#define CODEC_P1_REG41_HPR_DRV_PWOFF_WEAKDRV_VAL    0x00
#define CODEC_P1_REG41_HPR_DRV_PWOFF_HIMPEDANCE_VAL    0x02
#define CODEC_P1_REG41_HPR_DRV_PWOFF_CTRL_MASK    0x02

/* Page 1 / Register 42: SPK Driver */
#define CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL    0x00
#define CODEC_P1_REG42_SPK_DRV_SGAIN_12DB_VAL    0x08
#define CODEC_P1_REG42_SPK_DRV_SGAIN_18DB_VAL    0x10
#define CODEC_P1_REG42_SPK_DRV_SGAIN_24DB_VAL    0x18
#define CODEC_P1_REG42_SPK_DRV_SGAIN_MASK 0x18
#define CODEC_P1_REG42_SPK_DRV_MUTE_VAL    0x00
#define CODEC_P1_REG42_SPK_DRV_UNMUTE_VAL    0x04
#define CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK    0x04

/* Page 1 / Register 44: HP Driver Control */
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL    0x00
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_8US_VAL    0x20
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_16US_VAL    0x40
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_32US_VAL    0x60
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_64US_VAL    0x80
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_128US_VAL    0xA0
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_256US_VAL    0xC0
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_512US_VAL    0xE0
#define CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK    0xE0
#define CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL    0x00
#define CODEC_P1_REG44_HPL_DRV_AS_LINEOUT_VAL    0x04
#define CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK    0x04
#define CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL    0x00
#define CODEC_P1_REG44_HPR_DRV_AS_LINEOUT_VAL    0x02
#define CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK    0x02

/* agc parameters  */
/* Page 0 / Register 86: AGC Control 1  */
#define CODEC_P0_REG86_AGC_DISABLED_VAL    0x00
#define CODEC_P0_REG86_AGC_ENABLED_VAL    0x80
#define CODEC_P0_REG86_AGC_ABLED_MASK 0x80
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_5_5DB_VAL    0x00
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_8DB_VAL    0x10
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_10DB_VAL    0x20
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_12DB_VAL    0x30
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_14DB_VAL    0x40
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_17DB_VAL    0x50
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_20DB_VAL    0x60
#define CODEC_P0_REG86_AGC_TARLVEL_MINUS_24DB_VAL    0x70
#define CODEC_P0_REG86_AGC_TARLVEL_MASK 0x70

/* Page 0 / Register 87: AGC Control 2  */
#define CODEC_P0_REG87_AGC_HYST_SET_1DB_VAL    0x00
#define CODEC_P0_REG87_AGC_HYST_SET_2DB_VAL    0x04
#define CODEC_P0_REG87_AGC_HYST_SET_4DB_VAL    0x80
#define CODEC_P0_REG87_AGC_HYST_SET_DISABLED_VAL    0xc0
#define CODEC_P0_REG87_AGC_HYST_SET_MASK 0xc0
#define CODEC_P0_REG87_AGC_NOISE_THOLD_DIS_VAL    0x00
#define AGC_NOISE_THRESHOLD(value)     (((0-(value+30))/2 +1)<<1)&0x3e
#define CODEC_P0_REG87_AGC_NOISE_THOLD_MASK 0x3e

/* Page 0 / Register 88: AGC Maximum Gain  */
#define CODEC_P0_REG88_AGC_MAX_GAIN_VAL    0x00
#define AGC_MAX_GAIN(value)     (value*2<<1)&0x7f
#define CODEC_P0_REG88_AGC_MAX_GAIN_MASK 0x7f

/* Page 0 / Register 89: AGC Attack Time  */
#define AGC_ATTACK_TIME(value)     (((value-1)/2)<<3)&0xf8
#define CODEC_P0_REG89_AGC_ATTACK_TIME_MASK 0xf8

/* Page 0 / Register 90: AGC Decay Time  */
#define AGC_DECAY_TIME(value)     (((value-1)/2)<<3)&0xf8
#define CODEC_P0_REG90_AGC_DECAY_TIME_MASK 0xf8

/* Page 0 / Register 91: AGC Noise Debounce  */
#define CODEC_P0_REG91_AGC_NOISE_DEBOUNCE_MASK 0x1F

/* Page 0 / Register 92: AGC Signal Debounce  */
#define CODEC_P0_REG92_AGC_SIGNAL_DEBOUNCE_MASK 0x0F

/* Page 0 / Register 93: AGC Gain-Applied Reading  */

/* drc parameters  
* Page 0 / Register 68: DRC Control 1 
*/
#define CODEC_P0_REG68_DRC_DIS_LCHN_VAL    0x00
#define CODEC_P0_REG68_DRC_EN_LCHN_VAL    0x40
#define CODEC_P0_REG68_DRC_DIS_RCHN_VAL    0x00
#define CODEC_P0_REG68_DRC_EN_RCHN_VAL    0x20
#define CODEC_P0_REG68_DRC_THOLD_MINUS_3DB_VAL    0x00
#define CODEC_P0_REG68_DRC_THOLD_MINUS_6DB_VAL    0x04
#define CODEC_P0_REG68_DRC_THOLD_MINUS_9DB_VAL    0x08
#define CODEC_P0_REG68_DRC_THOLD_MINUS_12DB_VAL    0x0C
#define CODEC_P0_REG68_DRC_THOLD_MINUS_15DB_VAL    0x10
#define CODEC_P0_REG68_DRC_THOLD_MINUS_18DB_VAL    0x14
#define CODEC_P0_REG68_DRC_THOLD_MINUS_21DB_VAL    0x18
#define CODEC_P0_REG68_DRC_THOLD_MINUS_24DB_VAL    0x1C
#define CODEC_P0_REG68_DRC_HYST_0DB_VAL    0x00
#define CODEC_P0_REG68_DRC_HYST_1DB_VAL    0x01
#define CODEC_P0_REG68_DRC_HYST_2DB_VAL    0x02
#define CODEC_P0_REG68_DRC_HYST_3DB_VAL    0x03

/* Page 0 / Register 69: DRC Control 2  */
#define CODEC_P0_REG69_DRC_HOLD_TIME_MASK    0x38

/* Page 0 / Register 70: DRC Control 3  */
#define CODEC_P0_REG70_DRC_ATTACK_RATE_MASK    0xF0
#define CODEC_P0_REG70_DRC_DECAY_RATE_MASK     0x0F

/** 
* gpio1 ctrl parameters  
* Page 0 / Register 51: GPIO1 In/Out Pin Control 
*/
#define CODEC_P0_REG51_GPIO1_FUN_GPO_VAL    0x0C
#define CODEC_P0_REG51_GPIO1_FUN_CLKOUT_VAL    0x10
#define CODEC_P0_REG51_GPIO1_FUN_MASK    0x3C
#define CODEC_P0_REG51_GPIO1_OUTHIGH_VAL    0x01
#define CODEC_P0_REG51_GPIO1_OUTLOW_VAL    0x00
#define CODEC_P0_REG51_GPIO1_OUT_MASK    0x01

/* headset detect ctrl parameters  */
#define CODEC_P0_REG67_HEADSET_DETECT_EN_VAL    0x1<<7
#define CODEC_P0_REG67_HEADSET_DETECT_EN_MASK    0x1<<7
#define CODEC_P0_REG67_HEADSET_DETECT_TYPE_MASK    0x3<<5
#define CODEC_P0_REG67_HEADSET_DETECT_TYPE_NO_HEADSET_VAL    0x0<<5
#define CODEC_P0_REG67_HEADSET_DETECT_TYPE_HEADSET_NO_MIC_VAL    0x1<<5
#define CODEC_P0_REG67_HEADSET_DETECT_TYPE_HEADSET_MIC_VAL    0x3<<5
#define CODEC_P0_REG67_HEADSET_DETECT_HEADSET_DEBOUNCE_MASK    0x7<<2
#define CODEC_P0_REG67_HEADSET_DETECT_HEADSET_DEBOUNCE_256    0x4<<2
#define CODEC_P0_REG67_HEADSET_DETECT_HEADSET_DEBOUNCE_512    0x5<<2
#define CODEC_P0_REG67_HEADSET_DETECT_BTN_DEBOUNCE_MASK    0x3<<0
#define CODEC_P0_REG67_HEADSET_DETECT_BTN_DEBOUNCE_32    0x3<<0

#define CODEC_P0_REG48_HEADSET_IRQ_INT1_VAL  0x1<<7
#define CODEC_P0_REG48_BTN_IRQ_INT1_VAL  0x1<<6

#define CODEC_P0_REG51_GPIO_CTR_INT1_VAL  0x5<<2
#define CODEC_P0_REG51_GPIO_CTR_MASK  0xF<<2

#define CODEC_P1_REG46_MICBIAS_VOLUME_MASK    0x3<<0
#define CODEC_P1_REG46_MICBIAS_VOLUME_VAL_OFF    0x0<<0
#define CODEC_P1_REG46_MICBIAS_VOLUME_VAL_2V    0x1<<0
#define CODEC_P1_REG46_MICBIAS_VOLUME_VAL_2V5    0x2<<0
#define CODEC_P1_REG46_MICBIAS_VOLUME_VAL_AVDD    0x3<<0
#define CODEC_P1_REG46_MICBIAS_HEADSET_MASK    0x1<<3
#define CODEC_P1_REG46_MICBIAS_AFTER_HEADSET_DETECTED    0x0<<3
#define CODEC_P1_REG46_MICBIAS_BEFORE_HEADSET_DETECTED    0x1<<3

typedef struct _T_Codec_Reg_Para {
	UINT8 reg_book;
	UINT8 reg_page;
	UINT8 reg_index;
	UINT8 reg_bits;
	UINT8 reg_bitsmask;
} T_Codec_Reg_Para;
typedef struct _T_CodecPathParaInfo
{
	 T_Codec_Reg_Para * pRegPara;
     UINT32 arraySize ;
	 
} T_CodecPathParaInfo; 

#endif /* __TLV3100_H__ */

