/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.5
 * Author:        miaolin
 * Date:          2013-04-10
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/

/****************************************************************************
* 	                              Include files
****************************************************************************/
#include "drv_pub.h"
#include "drvs_ramlog.h"
#include "drvs_i2c.h"
#include "drvs_gpio.h"
#include "drvs_pm.h"
#include "drvs_codec.h"
#include "oss_api.h"
#include "Drvs_ret.h"

/****************************************************************************
* 	                              Local Macros
****************************************************************************/
//#define CODEC_TEST   /*define for codec test*/
#define CODEC_RESET_PIN           70

#define TLV3212_I2C_SADD            0x18

/*Book 0 / Page 0 / Register 1 : Software Reset Register*/
#define CODEC_B0_P0_REG1_RESET_VAL	0x1
#define CODEC_B0_P0_REG1_RESET_MASK	0x1

/*codec interface control*/
/*Book 0 / Page 4 / Register 1 : ASI1, Audio Bus Format Control Register*/
#define CODEC_B0_P4_REG1_ASI1_BUS_I2S_VAL  0x00
#define CODEC_B0_P4_REG1_ASI1_BUS_DSP_VAL  0x20
#define CODEC_B0_P4_REG1_ASI1_BUS_RJF_VAL  0x40
#define CODEC_B0_P4_REG1_ASI1_BUS_LJF_VAL  0x50
#define CODEC_B0_P4_REG1_ASI1_BUS_MONO_PCM_VAL  0x80
#define CODEC_B0_P4_REG1_ASI1_BUS_MODE_MASK  0xE0

#define CODEC_B0_P4_REG1_ASI1_BUS_WORD_16BIT_VAL  0x00
#define CODEC_B0_P4_REG1_ASI1_BUS_WORD_20BIT_VAL  0x08
#define CODEC_B0_P4_REG1_ASI1_BUS_WORD_24BIT_VAL  0x10
#define CODEC_B0_P4_REG1_ASI1_BUS_WORD_32BIT_VAL  0x18
#define CODEC_B0_P4_REG1_ASI1_BUS_WORD_LENGTH_MASK  0x18

#define CODEC_B0_P4_REG1_ASI1_DOUT1_NOT_HIGH_IMP_VAL  0x00
#define CODEC_B0_P4_REG1_ASI1_DOUT1_HIGH_IMP_VAL  0x01
#define CODEC_B0_P4_REG1_ASI1_BCLK_PIN_MASK  0x01

/*Book 0 / Page 4 / Register 2 : ASI1, Left Ch_Offset_1 Control Register*/
#define CODEC_B0_P4_REG2_ASI1L_DATASLOT_OFFSET_VAL  0x01//unit bclk

/*Book 0 / Page 4 / Register 3 : ASI1, Right Ch_Offset_2 Control Register*/
#define CODEC_B0_P4_REG3_ASI1R_DATASLOT_OFFSET_VAL  0x01//unit bclk

/*Book 0 / Page 4 / Register 4 : ASI1, Channel Setup Register*/
#define CODEC_B0_P4_REG4_DAC_LEFT_RIGHT_CHA_ENABLE_VAL  0x00
#define CODEC_B0_P4_REG4_DAC_LEFT_CHA_DISABLE_VAL  0x04
#define CODEC_B0_P4_REG4_DAC_RIGHT_CHA_DISABLE_VAL  0x08
#define CODEC_B0_P4_REG4_DAC_LEFT_RIGHT_CHA_DISABLE_VAL  0x0C
#define CODEC_B0_P4_REG4_DAC_LEFT_RIGHT_CHA_ENABLE_MASK  0x0C

#define CODEC_B0_P4_REG4_ADC_LEFT_RIGHT_CHA_ENABLE_VAL  0x00
#define CODEC_B0_P4_REG4_ADC_LEFT_CHA_DISABLE_VAL  0x01
#define CODEC_B0_P4_REG4_ADC_RIGHT_CHA_DISABLE_VAL  0x02
#define CODEC_B0_P4_REG4_ADC_LEFT_RIGHT_CHA_DISABLE_VAL  0x03
#define CODEC_B0_P4_REG4_ADC_LEFT_RIGHT_CHA_ENABLE_MASK  0x03

/*Book 0 / Page 4 / Register 7 : ASI1, ADC Input Control Register*/
#define CODEC_B0_P4_REG7_ASI1_ADC_INPUT_CTRL_MASK  0x07

/*Book 0 / Page 4 / Register 8 : ASI1, DAC Output Control Register*/
#define CODEC_B0_P4_REG8_ASI1_LEFT_DAC_DATAPATH_OFF_VAL  0x00
#define CODEC_B0_P4_REG8_ASI1_LEFT_DAC_DATAPATH_LEFTDATA_VAL  0x40
#define CODEC_B0_P4_REG8_ASI1_LEFT_DAC_DATAPATH_RIGHTDATA_VAL  0x80
#define CODEC_B0_P4_REG8_ASI1_LEFT_DAC_DATAPATH_MONOMIX_VAL  0xC0
#define CODEC_B0_P4_REG8_ASI1_LEFT_DAC_DATAPATH_CTRL_MASK  0xC0

#define CODEC_B0_P4_REG8_ASI1_RIGHT_DAC_DATAPATH_OFF_VAL  0x00
#define CODEC_B0_P4_REG8_ASI1_RIGHT_DAC_DATAPATH_LEFTDATA_VAL  0x10
#define CODEC_B0_P4_REG8_ASI1_RIGHT_DAC_DATAPATH_RIGHTDATA_VAL  0x20
#define CODEC_B0_P4_REG8_ASI1_RIGHT_DAC_DATAPATH_MONOMIX_VAL  0x30
#define CODEC_B0_P4_REG8_ASI1_RIGHT_DAC_DATAPATH_CTRL_MASK  0x30

#define CODEC_B0_P4_REG8_ASI1_LRCHA_SLOT_SWAP_DISABLE_VAL  0x00
#define CODEC_B0_P4_REG8_ASI1_LRCHA_SLOT_SWAP_ENABLE_VAL  0x20
#define CODEC_B0_P4_REG8_ASI1_LRCHA_SLOT_SWAP_ENABLE_MASK  0x20

#define CODEC_B0_P4_REG8_ASI1_TIME_SLOT_DISABLE_VAL  0x00
#define CODEC_B0_P4_REG8_ASI1_TIME_SLOT_ENABLE_VAL  0x10
#define CODEC_B0_P4_REG8_ASI1_TIME_SLOT_ENABLE_MASK  0x10

/*Book 0 / Page 4 / Register 9 : ASI1, Control Register*/
#define CODEC_B0_P4_REG9_ADC_LEFT_CHA_SLOT_NOT_TRISTATED_VAL  0x00
#define CODEC_B0_P4_REG9_ADC_LEFT_CHA_SLOT_TRISTATED_VAL  0x10
#define CODEC_B0_P4_REG9_ADC_LEFT_CHA_SLOT_TRISTATED_MASK  0x10

#define CODEC_B0_P4_REG9_ADC_RIGHT_CHA_SLOT_NOT_TRISTATED_VAL  0x00
#define CODEC_B0_P4_REG9_ADC_RIGHT_CHA_SLOT_TRISTATED_VAL  0x01
#define CODEC_B0_P4_REG9_ADC_RIGHT_CHA_SLOT_TRISTATED_MASK  0x01

/*Book 0 / Page 4 / Register 10 : ASI1, ADC WCLK and BCLK Control Register*/
#define CODEC_B0_P4_REG10_WCLK1_INPUT_TO_ASI1_VAL  0x00
#define CODEC_B0_P4_REG10_WCLK1_OUTPUT_FROM_ASI1_VAL  0x20
#define CODEC_B0_P4_REG10_GPIO1_INPUT_TO_ASI1_VAL  0x40
#define CODEC_B0_P4_REG10_GPIO1_OUTPUT_FROM_ASI1_VAL  0x60
#define CODEC_B0_P4_REG10_DOUT3_OUTPUT_FROM_ASI1_VAL  0x80
#define CODEC_B0_P4_REG10_ASI1_WCLK_DIR_CTRL_MASK  0xE0

#define CODEC_B0_P4_REG10_BCLK1_INPUT_TO_ASI1_VAL  0x00
#define CODEC_B0_P4_REG10_BCLK1_OUTPUT_FROM_ASI1_VAL  0x04
#define CODEC_B0_P4_REG10_GPIO2_INPUT_TO_ASI1_VAL  0x08
#define CODEC_B0_P4_REG10_GPIO2_OUTPUT_FROM_ASI1_VAL  0x0C
#define CODEC_B0_P4_REG10_ASI1_BCLK_DIR_CTRL_MASK  0x1C

#define CODEC_B0_P4_REG10_PRI_AUDIO_BCLK_PLOARITY_CTRL_MASK  0x02

#define CODEC_B0_P4_REG10_PRI_BCLK_WCLK_PDOWN_VAL 0x00
#define CODEC_B0_P4_REG10_PRI_BCLK_WCLK_PUP_VAL 0x01
#define CODEC_B0_P4_REG10_PRI_BCLK_WCLK_PW_CTRL_MASK  0x01

/*Book 0 / Page 4 / Register 11 : ASI1, BCLK N Divder Input Control Register*/
#define CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_DAC_CLK_VAL 0x00
#define CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_DAC_MOD_CLK_VAL 0x01
#define CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_ADC_CLK_VAL 0x02
#define CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_ADC_MOD_CLK_VAL 0x03
#define CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_VAL_MASK  0x03

/*Book 0 / Page 4 / Register 12 : ASI1, BCLK N Divder Register*/
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_PDOWN_VAL 0x00
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_PUP_VAL 0x80
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_PW_CTRL_MASK 0x80

#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_128_VAL 0x00
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_2_VAL  0x02
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_4_VAL  0x04
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_126_VAL 0xFE
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_127_VAL 0xFF
#define CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_MASK 0x7F

/*Book 0 / Page 4 / Register 13 : ASI1, WCLK N Divder Register*/
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_PDOWN_VAL 0x00
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_PUP_VAL 0x80
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_PW_CTRL_MASK 0x80

#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_128_VAL 0x00
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_32_VAL  0x20
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_33_VAL  0x21
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_126_VAL 0xFE
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_127_VAL 0xFF
#define CODEC_B0_P4_REG13_ASI1_WCLK_NDIV_EQ_MASK 0x7F

/*Book 0 / Page 4 / Register 14 : ASI1, BCLK and WCLK Output Register*/
#define CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI1_BCLK_OUTPUT_VAL 0x00
#define CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI2_BCLK_OUTPUT_VAL 0x20
#define CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI2_BCLK_INPUT_VAL 0x30
#define CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI3_BCLK_OUTPUT_VAL 0x40
#define CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI3_BCLK_INPUT_VAL 0x50
#define CODEC_B0_P4_REG14_ASI1_BCLK_OUTPUT_MUX_MASK 0x70

#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_GDAC_FS_VAL 0x00
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_GADC_FS_VAL 0x01
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI1_WCLK_OUTPUT_VAL 0x0
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI2_WCLK_OUTPUT_VAL 0x04
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI2_WCLK_INPUT_VAL 0x05
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI3_WCLK_OUTPUT_VAL 0x06
#define CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI3_WCLK_INPUT_VAL 0x07
#define CODEC_B0_P4_REG14_ASI1_WCLK_OUTPUT_MUX_MASK 0x07

/*Book 0 / Page 4 / Register 15 : ASI1, Data Output Register*/
#define CODEC_B0_P4_REG15_DOUT1_ASI1_OUTPUT_LOOPBACK_VAL 0x00
#define CODEC_B0_P4_REG15_DOUT1_ASI1_INPUT_LOOPBACK_VAL 0x01
#define CODEC_B0_P4_REG15_DOUT1_ASI2_INPUT_LOOPBACK_VAL 0x02
#define CODEC_B0_P4_REG15_DOUT1_ASI3_INPUT_LOOPBACK_VAL 0x03

#define CODEC_B0_P4_REG15_ASI1_DATA_OUTPUT_CTRL_MASK 0x03

/*Book 0 / Page 4 / Register 16 : ASI1, ADC WCLK and BCLK Control Register*/
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_DAC_WCLK_VAL 0x00
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPIO1_VAL 0x10
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPIO2_VAL 0x20
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPI1_VAL 0x30
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPI2_VAL 0x40
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPI3_VAL 0x50
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_GPI4_VAL 0x60
#define CODEC_B0_P4_REG16_ASI1_ADC_WCLK_EQ_CTRL_MASK 0x70

#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_DAC_BCLK_VAL 0x00
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPIO1_VAL 0x10
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPIO2_VAL 0x20
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPI1_VAL 0x30
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPI2_VAL 0x40
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPI3_VAL 0x50
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_GPI4_VAL 0x60
#define CODEC_B0_P4_REG16_ASI1_ADC_BCLK_EQ_CTRL_MASK 0x70

/*Book 0 / Page 4 / Register 67 :DOUT1 control*/
#define CODEC_B0_P4_REG67_DOUT1_KEEP_DIS_VAL  0x20
#define CODEC_B0_P4_REG67_DOUT1_KEEP_EN_VAL  0x00
#define CODEC_B0_P4_REG67_DOUT1_KEEP_MASK 0x20

#define CODEC_B0_P4_REG67_DOUT1_DIS_VAL  0x00
#define CODEC_B0_P4_REG67_DOUT1_ADO_OUT_VAL  0x02 /*ASI1 Data Output*/ 
#define CODEC_B0_P4_REG67_DOUT1_GPO_VAL  0x04 /*General Purpose Output*/ 
#define CODEC_B0_P4_REG67_DOUT1_CLKOUT_VAL  0x06
#define CODEC_B0_P4_REG67_DOUT1_INT1_VAL  0x08
#define CODEC_B0_P4_REG67_DOUT1_INT2_VAL  0x0A
#define CODEC_B0_P4_REG67_DOUT1_CTRL_MASK  0x1E

#define CODEC_B0_P4_REG67_DOUT1_GPOUT_LOW_VAL  0x00
#define CODEC_B0_P4_REG67_DOUT1_GPOUT_HIGH_VAL  0x01
#define CODEC_B0_P4_REG67_DOUT1_GPOUT_MASK 0x01

/*Book 0 / Page 4 / Register 68 :DIN1 control*/
#define CODEC_B0_P4_REG68_DIN1_DIS_VAL  0x00
#define CODEC_B0_P4_REG68_DIN1_EN_VAL  0x20 /*DIN1 is enabled for Primary Data Input or Digital Microphone Input,*/ 
											/*General Purpose Clock input or as General Purpose Input*/
#define CODEC_B0_P4_REG68_DIN1_CTRL_MASK  0x60

/*Book 0 / Page 4 / Register 118 :ADC/DAC Data Port control*/

#define CODEC_B0_P4_REG118_ADC_DATA_OUTPUT_LANDR_INDEP_VAL  0x40

#define CODEC_B0_P4_REG118_ADC_DATA_OUTPUT_CONFIG_CTRL_MASK  0x40

#define CODEC_B0_P4_REG118_DAC_ASI1_OUTPUT_VAL 0x00
#define CODEC_B0_P4_REG118_DAC_ASI2_OUTPUT_VAL 0x10
#define CODEC_B0_P4_REG118_DAC_ASI3_OUTPUT_VAL 0x20
#define CODEC_B0_P4_REG118_DAC_ADC_LOOPBACK_VAL 0x30
#define CODEC_B0_P4_REG118_DAC_DATA_INPUT_CONFIG_CTRL_MASK 0x30

#define CODEC_B0_P4_REG118_WRITE_ONLY_VAL  0x06
#define CODEC_B0_P4_REG118_WRITE_ONLY_MASK 0x0F

/**************clk parameters*******************/
/*Book 0 / Page 0 / Register 4 : Clock Input Multiplexers Register*/
#define CODEC_B0_P0_REG4_DAC_CLKIN_MCLK1_VAL  0x00
#define CODEC_B0_P0_REG4_DAC_CLKIN_BCLK1_VAL  0x10
#define CODEC_B0_P0_REG4_DAC_CLKIN_GPIO1_VAL  0x20
#define CODEC_B0_P0_REG4_DAC_CLKIN_PLL_CLK_VAL  0x30
#define CODEC_B0_P0_REG4_DAC_CLKIN_BCLK2_VAL  0x40
#define CODEC_B0_P0_REG4_DAC_CLKIN_GPI1_VAL  0x50
#define CODEC_B0_P0_REG4_DAC_CLKIN_HF_REF_CLK_VAL  0x60
#define CODEC_B0_P0_REG4_DAC_CLKIN_HF_OSC_CLK_VAL  0x70
#define CODEC_B0_P0_REG4_DAC_CLKIN_MCLK2_VAL  0x80
#define CODEC_B0_P0_REG4_DAC_CLKIN_GPIO2_VAL  0x90
#define CODEC_B0_P0_REG4_DAC_CLKIN_GPI2_VAL  0xA0
#define CODEC_B0_P0_REG4_DAC_CLKIN_MASK 0xF0

#define CODEC_B0_P0_REG4_ADC_CLKIN_MCLK1_VAL  0x00
#define CODEC_B0_P0_REG4_ADC_CLKIN_BCLK1_VAL  0x01
#define CODEC_B0_P0_REG4_ADC_CLKIN_GPIO1_VAL  0x02
#define CODEC_B0_P0_REG4_ADC_CLKIN_PLL_CLK_VAL  0x03
#define CODEC_B0_P0_REG4_ADC_CLKIN_BCLK2_VAL  0x04
#define CODEC_B0_P0_REG4_ADC_CLKIN_GPI1_VAL  0x05
#define CODEC_B0_P0_REG4_ADC_CLKIN_HF_REF_CLK_VAL  0x06
#define CODEC_B0_P0_REG4_ADC_CLKIN_HF_OSC_CLK_VAL  0x07
#define CODEC_B0_P0_REG4_ADC_CLKIN_MCLK2_VAL  0x08
#define CODEC_B0_P0_REG4_ADC_CLKIN_GPIO2_VAL  0x09
#define CODEC_B0_P0_REG4_ADC_CLKIN_GPI2_VAL  0x0A
#define CODEC_B0_P0_REG4_ADC_CLKIN_MASK 0x0F

/*Book 0 / Page 0 / Register 5 : PLL Input Multiplexers Register*/
#define CODEC_B0_P0_REG5_PLL_CLKRANGE_HIGH_VAL 0x40
#define CODEC_B0_P0_REG5_PLL_CLKRANGE_LOW_VAL 0x00
#define CODEC_B0_P0_REG5_PLL_CLKRANGE_MASK 0x40
#define CODEC_B0_P0_REG5_PLL_CLKIN_MCLK1_VAL 0x00
#define CODEC_B0_P0_REG5_PLL_CLKIN_BCLK1_VAL 0x04
#define CODEC_B0_P0_REG5_PLL_CLKIN_GPIO1_VAL 0x08
#define CODEC_B0_P0_REG5_PLL_CLKIN_DIN1_VAL 0x0C
#define CODEC_B0_P0_REG5_PLL_CLKIN_BCLK2_VAL 0x10
#define CODEC_B0_P0_REG5_PLL_CLKIN_GPI1_VAL 0x14
#define CODEC_B0_P0_REG5_PLL_CLKIN_HF_REF_CLK_VAL 0x18
#define CODEC_B0_P0_REG5_PLL_CLKIN_GPIO2_VAL 0x1C
#define CODEC_B0_P0_REG5_PLL_CLKIN_GPI2_VAL 0x20
#define CODEC_B0_P0_REG5_PLL_CLKIN_MCLK2_VAL 0x24
#define CODEC_B0_P0_REG5_PLL_CLKIN_MASK 0x3C

/*Book 0 / Page 0 / Register 6 : PLL P and R VAL Register*/
#define CODEC_B0_P0_REG6_PLL_PUP_VAL  0x80
#define CODEC_B0_P0_REG6_PLL_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG6_PLL_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG6_PLL_PDIV_MASK  0x70
#define CODEC_B0_P0_REG6_PLL_RMULTI_MASK  0x0F

/*Book 0 / Page 0 / Register 7 : PLL J VAL Register*/
#define CODEC_B0_P0_REG7_PLL_JMULTI_MASK  0x3F

/*Book 0 / Page 0 / Register 8 : PLL D VAL (MSB) Register*/
#define CODEC_B0_P0_REG8_PLL_DVAL_MSB_MASK  0x3F

/*Book 0 / Page 0 / Register 9 : PLL D VAL (LSB) Register*/
#define CODEC_B0_P0_REG9_PLL_DVAL_LSB_MASK  0xFF

/*Book 0 / Page 0 / Register 10 : PLL CLKIN Divider Register*/
#define CODEC_B0_P0_REG10_PLL_CLKIN_DIV_MASK  0x7F

/*Book 0 / Page 0 / Register 11 : NDAC Divider Value Register*/
#define CODEC_B0_P0_REG11_NDAC_PUP_VAL  0x80
#define CODEC_B0_P0_REG11_NDAC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG11_NDAC_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG11_NDAC_MASK  0x7F

/*Book 0 / Page 0 / Register 12 : MDAC Divider Value Register*/
#define CODEC_B0_P0_REG12_MDAC_PUP_VAL  0x80
#define CODEC_B0_P0_REG12_MDAC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG12_MDAC_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG12_MDAC_MASK  0x7F

/*Book 0 / Page 0 / Register 13 : DAC OSR Control Register : MSB Value*/
#define CODEC_B0_P0_REG13_DOSR_MSB_MASK  0x7F

/*Book 0 / Page 0 / Register 14 : DAC OSR Control Register : LSB Value*/
#define CODEC_B0_P0_REG14_DOSR_LSB_MASK  0xFF

/*Book 0 / Page 0 / Register 18 : NADC Divider Value Register*/
#define CODEC_B0_P0_REG18_NADC_PUP_VAL  0x80
#define CODEC_B0_P0_REG18_NADC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG18_NADC_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG18_NADC_MASK  0x7F

/*Book 0 / Page 0 / Register 19 : MADC Divider Value Register*/
#define CODEC_B0_P0_REG19_MADC_PUP_VAL  0x80
#define CODEC_B0_P0_REG19_MADC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG19_MADC_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG19_MADC_MASK  0x7F

/*Book 0 / Page 0 / Register 20 : ADC OSR Control Register : LSB Value*/
#define CODEC_B0_P0_REG20_AOSR_MASK  0xFF

/*Book 0 / Page 0 / Register 21 : CLKOUT MUX Register*/
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_MCLK1_VAL  0x00
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_BCLK1_VAL  0x01
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_DIN1_VAL  0x02
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_PLLCLK_VAL  0x03
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_DACCLK_VAL  0x04
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_DACMODCLK_VAL  0x05
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_ADCCLK_VAL  0x06
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_ADCMODCLK_VAL  0x07
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_BCLK2_VAL  0x08
#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_GPI1_VAL  0x09

#define CODEC_B0_P0_REG21_CDIV_CLKIN_EQUAL_CTRL_MASK  0x0F

/*Book 0 / Page 0 / Register 22 : CLKOUT M Divider Register*/
#define CODEC_B0_P0_REG22_CLKOUT_MDIV_PUP_VAL  0x80
#define CODEC_B0_P0_REG22_CLKOUT_MDIV_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG22_CLKOUT_MDIV_PWCTRL_MASK  0x80
#define CODEC_B0_P0_REG22_CLKOUT_MDIV_MASK  0x7F


/**************input path parameters*******************/
/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
/*D7: 0: MICBIAS_EXT Powered Down if Jack is not inserted*/
#define CODEC_B0_P1_REG51_MICBIAS_EXT_PUP_INSERT_CTRL1_VAL 0x00
/*D7: 1: MICBIAS_EXT Powered On and Off based only on P1_R51_D6, even if Jack is not inserted*/
#define CODEC_B0_P1_REG51_MICBIAS_EXT_PUP_INSERT_CTRL2_VAL 0x80
#define CODEC_B0_P1_REG51_MICBIAS_EXT_PW_INSERT_CTRL_MASK  0x80

#define CODEC_B0_P1_REG51_MICBIAS_EXT_PUP_VAL  0x40
#define CODEC_B0_P1_REG51_MICBIAS_EXT_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG51_MICBIAS_EXT_PWCTRL_MASK  0x40

#define CODEC_B0_P1_REG51_MICBIAS_EXT_OUT_PW1_35V_VAL  0x00
#define CODEC_B0_P1_REG51_MICBIAS_EXT_OUT_PW2V_VAL  0x10
#define CODEC_B0_P1_REG51_MICBIAS_EXT_OUT_PW2_5V_VAL  0x20
#define CODEC_B0_P1_REG51_MICBIAS_EXT_OUT_PW3_3V_VAL  0x30
#define CODEC_B0_P1_REG51_MICBIAS_EXT_OUT_CTRL_MASK  0x30

/*D3: 0: MICBIAS_EXT is not powered up upon insertion if microphone is not detected on inserted jack*/
#define CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL1_VAL 0x00
/*D3: 1: MICBIAS_EXT is powered up upon jack detect irrespective of whether microphone is detected or not*/
#define CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL 0x08
#define CODEC_B0_P1_REG51_MICBIAS_PW_INSERT_CTRL_MASK  0x08

#define CODEC_B0_P1_REG51_MICBIAS_PUP_VAL  0x04
#define CODEC_B0_P1_REG51_MICBIAS_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG51_MICBIAS_PWCTRL_MASK  0x04

#define CODEC_B0_P1_REG51_MICBIAS_OUT_PW1_35V_VAL  0x00
#define CODEC_B0_P1_REG51_MICBIAS_OUT_PW2V_VAL  0x01
#define CODEC_B0_P1_REG51_MICBIAS_OUT_PW2_5V_VAL  0x02
#define CODEC_B0_P1_REG51_MICBIAS_OUT_PW3_3V_VAL  0x03
#define CODEC_B0_P1_REG51_MICBIAS_OUT_CTRL_MASK  0x03

/*Book 0 / Page 1 / Register 52/53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
#define CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_10KR_VAL  0x40
#define CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_20KR_VAL  0x80
#define CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_40KR_VAL  0xC0
#define CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_MASK  0xC0

#define CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_10KR_VAL  0x10
#define CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_40KR_VAL  0x30
#define CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_MASK  0x30

#define CODEC_B0_P1_REG52_IN3L_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG52_IN3L_TO_LEFTMIC_SEL_10KR_VAL  0x04
#define CODEC_B0_P1_REG52_IN3L_TO_LEFTMIC_SEL_20KR_VAL  0x08
#define CODEC_B0_P1_REG52_IN3L_TO_LEFTMIC_SEL_40KR_VAL  0x0C
#define CODEC_B0_P1_REG52_IN3L_TO_LEFTMIC_SEL_MASK  0x0C

#define CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_SEL_10KR_VAL  0x01
#define CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_SEL_20KR_VAL  0x02
#define CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_SEL_40KR_VAL  0x03
#define CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_SEL_MASK  0x03

#define CODEC_B0_P1_REG53_IN4L_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG53_IN4L_TO_LEFTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG53_IN4L_TO_LEFTMIC_SEL_MASK  0x20

#define CODEC_B0_P1_REG53_IN4R_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG53_IN4R_TO_LEFTMIC_SEL_20KR_VAL  0x10
#define CODEC_B0_P1_REG53_IN4R_TO_LEFTMIC_SEL_MASK  0x10

/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
#define CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_10KR_VAL  0x40
#define CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_20KR_VAL  0x80
#define CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_40KR_VAL  0xC0
#define CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_MASK  0xC0

#define CODEC_B0_P1_REG54_IN2R_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG54_IN2R_TO_LEFTMIC_SEL_10KR_VAL  0x10
#define CODEC_B0_P1_REG54_IN2R_TO_LEFTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG54_IN2R_TO_LEFTMIC_SEL_40KR_VAL  0x30
#define CODEC_B0_P1_REG54_IN2R_TO_LEFTMIC_SEL_MASK  0x30

#define CODEC_B0_P1_REG54_IN3R_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG54_IN3R_TO_LEFTMIC_SEL_10KR_VAL  0x04
#define CODEC_B0_P1_REG54_IN3R_TO_LEFTMIC_SEL_20KR_VAL  0x08
#define CODEC_B0_P1_REG54_IN3R_TO_LEFTMIC_SEL_40KR_VAL  0x0C
#define CODEC_B0_P1_REG54_IN3R_TO_LEFTMIC_SEL_MASK  0x0C

#define CODEC_B0_P1_REG54_CM2_TO_LEFTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG54_CM2_TO_LEFTMIC_SEL_10KR_VAL  0x01
#define CODEC_B0_P1_REG54_CM2_TO_LEFTMIC_SEL_20KR_VAL  0x02
#define CODEC_B0_P1_REG54_CM2_TO_LEFTMIC_SEL_40KR_VAL  0x03
#define CODEC_B0_P1_REG54_CM2_TO_LEFTMIC_SEL_MASK  0x03

/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
#define CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_10KR_VAL  0x40
#define CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_20KR_VAL  0x80
#define CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_40KR_VAL  0xC0
#define CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_MASK  0xC0

#define CODEC_B0_P1_REG55_IN2R_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG55_IN2R_TO_RIGHTMIC_SEL_10KR_VAL  0x10
#define CODEC_B0_P1_REG55_IN2R_TO_RIGHTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG55_IN2R_TO_RIGHTMIC_SEL_40KR_VAL  0x30
#define CODEC_B0_P1_REG55_IN2R_TO_RIGHTMIC_SEL_MASK  0x30

#define CODEC_B0_P1_REG55_IN3R_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG55_IN3R_TO_RIGHTMIC_SEL_10KR_VAL  0x04
#define CODEC_B0_P1_REG55_IN3R_TO_RIGHTMIC_SEL_20KR_VAL  0x08
#define CODEC_B0_P1_REG55_IN3R_TO_RIGHTMIC_SEL_40KR_VAL  0x0C
#define CODEC_B0_P1_REG55_IN3R_TO_RIGHTMIC_SEL_MASK  0x0C

#define CODEC_B0_P1_REG55_IN2L_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG55_IN2L_TO_RIGHTMIC_SEL_10KR_VAL  0x01
#define CODEC_B0_P1_REG55_IN2L_TO_RIGHTMIC_SEL_20KR_VAL  0x02
#define CODEC_B0_P1_REG55_IN2L_TO_RIGHTMIC_SEL_40KR_VAL  0x03
#define CODEC_B0_P1_REG55_IN2L_TO_RIGHTMIC_SEL_MASK  0x03

/*Book 0 / Page 1 / Register 56 : Input Select 2 for Right Microphone PGA P-Terminal Register*/
#define CODEC_B0_P1_REG56_IN2R_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG56_IN2R_TO_RIGHTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG56_IN2R_TO_RIGHTMIC_SEL_MASK  0x20

#define CODEC_B0_P1_REG56_IN3R_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG56_IN3R_TO_RIGHTMIC_SEL_20KR_VAL  0x10
#define CODEC_B0_P1_REG56_IN3R_TO_RIGHTMIC_SEL_MASK  0x10

/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
#define CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_10KR_VAL  0x40
#define CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_20KR_VAL  0x80
#define CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_40KR_VAL  0xC0
#define CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_MASK  0xC0

#define CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_SEL_10KR_VAL  0x10
#define CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_SEL_20KR_VAL  0x20
#define CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_SEL_40KR_VAL  0x30
#define CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_SEL_MASK  0x30

#define CODEC_B0_P1_REG57_IN3L_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG57_IN3L_TO_RIGHTMIC_SEL_10KR_VAL  0x04
#define CODEC_B0_P1_REG57_IN3L_TO_RIGHTMIC_SEL_20KR_VAL  0x08
#define CODEC_B0_P1_REG57_IN3L_TO_RIGHTMIC_SEL_40KR_VAL  0x0C
#define CODEC_B0_P1_REG57_IN3L_TO_RIGHTMIC_SEL_MASK  0x0C

#define CODEC_B0_P1_REG57_CM2_TO_RIGHTMIC_UNSEL_VAL  0x00
#define CODEC_B0_P1_REG57_CM2_TO_RIGHTMIC_SEL_10KR_VAL  0x01
#define CODEC_B0_P1_REG57_CM2_TO_RIGHTMIC_SEL_20KR_VAL  0x02
#define CODEC_B0_P1_REG57_CM2_TO_RIGHTMIC_SEL_40KR_VAL  0x03
#define CODEC_B0_P1_REG57_CM2_TO_RIGHTMIC_SEL_MASK  0x03

/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
#define CODEC_B0_P1_REG58_IN1L_CMCTRL_MASK  0x80
#define CODEC_B0_P1_REG58_IN1R_CMCTRL_MASK  0x40
#define CODEC_B0_P1_REG58_IN2L_CMCTRL_MASK  0x20
#define CODEC_B0_P1_REG58_IN2R_CMCTRL_MASK  0x10
#define CODEC_B0_P1_REG58_IN3L_CMCTRL_MASK  0x08
#define CODEC_B0_P1_REG58_IN3R_CMCTRL_MASK  0x04
#define CODEC_B0_P1_REG58_IN4L_CMCTRL_MASK  0x02
#define CODEC_B0_P1_REG58_IN4R_CMCTRL_MASK  0x01

/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_VAL  0x00
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_SET_TO_0DB_VAL  0x00
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_CTRL_MASK  0x80
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_47_5DB_VAL  0x5F
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_20DB_VAL  0x28
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_10DB_VAL  0x14
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_40DB_VAL  0x50
#define CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_VAL  0x00
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_SET_TO_0DB_VAL  0x00
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_CTRL_MASK  0x80
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_47_5DB_VAL  0x5F
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_20DB_VAL  0x28
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_10DB_VAL  0x14
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_40DB_VAL  0x50
#define CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
#define CODEC_B0_P0_REG81_LEFT_ADC_PUP_VAL  0x80
#define CODEC_B0_P0_REG81_LEFT_ADC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG81_LEFT_PWCTRL_MASK  0x80

#define CODEC_B0_P0_REG81_RIGHT_ADC_PUP_VAL  0x40
#define CODEC_B0_P0_REG81_RIGHT_ADC_PDOWN_VAL  0x00
#define CODEC_B0_P0_REG81_RIGHT_PWCTRL_MASK  0x40

#define CODEC_B0_P0_REG81_LEFT_DMIC_PWCTRL_MASK 0x30
#define CODEC_B0_P0_REG81_RIGHT_DMIC_PWCTRL_MASK 0x0C

#define CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_1FS_VAL 0x00//ADC channel volume control soft-stepping is enabled for one step per sample period.
#define CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_2FS_VAL 0x01//ADC channel volume control soft-stepping is enabled for one step per 2sample period.
#define CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_OFF_VAL  0x02
#define CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_CTRL_MASK 0x03

/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
#define CODEC_B0_P0_REG82_LEFT_ADC_MUTE_VAL  0x80
#define CODEC_B0_P0_REG82_LEFT_ADC_UNMUTE_VAL  0x00
#define CODEC_B0_P0_REG82_LEFT_ADC_MUTE_CTRL_MASK 0x80

#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL 0x00
#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MINUS_0_1DB_VAL 0x70
#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MINUS_0_2DB_VAL 0x60
#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MINUS_0_3DB_VAL 0x50
#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MINUS_0_4DB_VAL 0x40
#define CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MASK 0x70

#define CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_VAL  0x08
#define CODEC_B0_P0_REG82_RIGHT_ADC_UNMUTE_VAL  0x00
#define CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_CTRL_MASK 0x08

#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_0DB_VAL  0x00
#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MINUS_0_1DB_VAL  0x07
#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MINUS_0_2DB_VAL  0x06
#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MINUS_0_3DB_VAL  0x05
#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MINUS_0_4DB_VAL  0x04
#define CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MASK  0x07

/*Book 0 / Page 0 / Register 83 : Left ADC Volume Control Register*/
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MASK  0x7F
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MINUS_12DB_VAL  0x68
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MINUS_11_5DB_AL  0x69
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_0DB_VAL  0x00
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_10DB_VAL  0x14
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_19_5DB_VAL  0x27
#define CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_20DB_VAL  0x28

/*Book 0 / Page 0 / Register 84 : Right ADC Volume Control Register*/
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MASK  0x7F
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MINUS_12DB_VAL  0x68
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MINUS_11_5DB_AL  0x69
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_0DB_VAL  0x00
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_10DB_VAL  0x14
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_19_5DB_VAL  0x27
#define CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_20DB_VAL  0x28

/**************output path parameters*******************/
/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
#define CODEC_B0_P0_REG63_LDAC_PUP_VAL  0x80
#define CODEC_B0_P0_REG63_LDAC_PDOWN_VAL  0x0
#define CODEC_B0_P0_REG63_LDAC_PW_MASK  0x80

#define CODEC_B0_P0_REG63_RDAC_PUP_VAL  0x40
#define CODEC_B0_P0_REG63_RDAC_PDOWN_VAL  0x0
#define CODEC_B0_P0_REG63_RDAC_PW_MASK  0x40

#define CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL  0x00
#define CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_2FS_VA  0x01
#define CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_DIS_VAL  0x02
#define CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK  0x03

/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
#define CODEC_B0_P0_REG64_RMOD_OUTCTRL_MASK  0x80
#define CODEC_B0_P0_REG64_DAC_AUTO_MUTE_CTRL_MASK  0x70

#define CODEC_B0_P0_REG64_DAC_LCHN_MUTE_VAL  0x08
#define CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL  0x00
#define CODEC_B0_P0_REG64_DAC_LCHN_MUTE_CTRL_MASK  0x08
#define CODEC_B0_P0_REG64_DAC_RCHN_MUTE_VAL  0x04
#define CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL  0x00
#define CODEC_B0_P0_REG64_DAC_RCHN_MUTE_CTRL_MASK  0x04
/*DAC Master Volume Control*/
#define CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL  0x00
#define CODEC_B0_P0_REG64_DAC_LCHN_VOLCTRL_BYRCHN_VAL  0x01
#define CODEC_B0_P0_REG64_DAC_RCHN_VOLCTRL_BYLCHN_VAL  0x02
#define CODEC_B0_P0_REG64_DAC_VOLCTRL_MASK  0x03

/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_24DB_VAL  0x30
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_12DB_VAL  0x18
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_0_5DB_VAL  0x01
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL  0x00
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_MINUS_0_5DB_VAL  0xFF
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_MINUS_16DB_VAL  0xE0
#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_MINUS_63_5DB_VAL  0x81

#define CODEC_B0_P0_REG65_DAC_LCHN_VOL_MASK  0xFF

/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_24DB_VAL  0x30
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_12DB_VAL  0x18
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_0_5DB_VAL  0x01
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL  0x00
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_MINUS_0_5DB_VAL  0xFF
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_MINUS_16DB_VAL  0xE0
#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_MINUS_63_5DB_VAL  0x81

#define CODEC_B0_P0_REG66_DAC_RCHN_VOL_MASK  0xFF

/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
#define CODEC_B0_P1_REG8_SSTEP_PGA_ENABLE_VAL 0x00
#define CODEC_B0_P1_REG8_SSTEP_PGA_DISABLE_VAL 0x80
#define CODEC_B0_P1_REG8_SSTEP_PGA_ENABLE_CTRL_MASK 0x80

#define CODEC_B0_P1_REG8_NORMAL_MODE_VAL 0x00
#define CODEC_B0_P1_REG8_SSTEP_TIME_DOUBLE_VAL 0x40
#define CODEC_B0_P1_REG8_SSTEP_TIME_CTRL_MASK 0x40

#define CODEC_B0_P1_REG8_HP_OUT_EQ_IN_VAL 0x00
#define CODEC_B0_P1_REG8_HP_OUT_1_25V_VAL    0x08
#define CODEC_B0_P1_REG8_HP_OUT_1_5V_VAL 0x10
#define CODEC_B0_P1_REG8_HP_OUT_1_65V_VAL  0x18
#define CODEC_B0_P1_REG8_HP_OUT_VOL_MASK 0x18

#define CODEC_B0_P1_REG8_FULLCHIP_IN_0_9V_VAL 0x00
#define CODEC_B0_P1_REG8_FULLCHIP_IN_0_75V_VAL  0x04
#define CODEC_B0_P1_REG8_FULLCHIP_IN_VOL_MASK 0x04

#define CODEC_B0_P1_REG8_REC_OUT_EQ_IN_VAL 0x00
#define CODEC_B0_P1_REG8_REC_OUT_1_25V_VAL    0x01
#define CODEC_B0_P1_REG8_REC_OUT_1_5V_VAL 0x02
#define CODEC_B0_P1_REG8_REC_OUT_1_65V_VAL  0x03
#define CODEC_B0_P1_REG8_REC_OUT_VOL_MASK 0x03

/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_0US_VAL    0x00
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_8US_VAL    0x02
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_16US_VAL    0x04
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_32US_VAL    0x06
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_64US_VAL    0x08
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_128US_VAL    0x0A
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_256US_VAL    0x0C
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_512US_VAL    0x0E
#define CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_US_CTRL_MASK    0x0E

/*Book 0 / Page 1 / Register 35 : Charge Pump Control Register*/
#define CODEC_B0_P1_REG35_DYN_OFFSET_CALI_MASK  0x20
#define CODEC_B0_P1_REG35_WRITE_ONLY_VAL  0x10
#define CODEC_B0_P1_REG35_WRITE_ONLY_VAL_MASK  0x1C
#define CODEC_B0_P1_REG35_CHARGE_PUMP_AUTO_PUP_VAL  0x00
#define CODEC_B0_P1_REG35_CHARGE_PUMP_FORCED_PUP_VAL  0x01
#define CODEC_B0_P1_REG35_CHARGE_PUMP_FORCED_PDOWN_VAL  0x02
#define CODEC_B0_P1_REG35_CHARGE_PUMP_PCTRL_MASK  0x03

/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
#define CODEC_B0_P1_REG45_MAL_ROUTE_NOT_TO_SPKL_VAL 0x00
#define CODEC_B0_P1_REG45_MAL_ROUTE_TO_SPKL_VAL 0x80
#define CODEC_B0_P1_REG45_MAL_ROUTE_MASK 0x80
#define CODEC_B0_P1_REG45_MAR_ROUTE_NOT_TO_SPKR_VAL 0x00
#define CODEC_B0_P1_REG45_MAR_ROUTE_TO_SPKR_VAL 0x40
#define CODEC_B0_P1_REG45_MAR_ROUTE_MASK 0x40
#define CODEC_B0_P1_REG45_STEREO_SPK_MODE_VAL 0x00
#define CODEC_B0_P1_REG45_MONO_SPK_MODE_VAL 0x04
#define CODEC_B0_P1_REG45_STEREO_MONO_CTRL_MASK 0x04
#define CODEC_B0_P1_REG45_SPKL_PUP_VAL  0x02
#define CODEC_B0_P1_REG45_SPKL_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG45_SPKL_PW_MASK  0x02
#define CODEC_B0_P1_REG45_SPKR_PUP_VAL  0x01
#define CODEC_B0_P1_REG45_SPKR_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG45_SPKR_PW_MASK  0x01

/*Book 0 / Page 1 / Register 122 : Reference Powerup Delay Register*/
#define CODEC_B0_P1_REG122_FINE_VREF_VAL  0x00
#define CODEC_B0_P1_REG122_COARSE_VREF_VAL  0x08
#define CODEC_B0_P1_REG122_VREF_CTRL_MASK  0x08

#define CODEC_B0_P1_REG122_CHIP_REF_PCTRL_BASEON_OTHER_VAL  0x00
#define CODEC_B0_P1_REG122_CHIP_REF_FORCE_FULLLY_PUP_VAL  0x04
#define CODEC_B0_P1_REG122_CHIP_REF_PUP_CTRL_MASK  0x04

#define CODEC_B0_P1_REG122_VREF_FAST_CHARGE_DISABLED_VAL 0x00
#define CODEC_B0_P1_REG122_VREF_FAST_CHARGE_COR_10MS_FINE_30MS_VAL 0x01
#define CODEC_B0_P1_REG122_VREF_FAST_CHARGE_COR_20MS_FINE_60MS_VAL 0x02
#define CODEC_B0_P1_REG122_VREF_FAST_CHARGE_COR_30MS_FINE_90MS_VAL 0x03
#define CODEC_B0_P1_REG122_VREF_FAST_CHARGE_TIME_MASK 0x03

/*Book 0 / Page 1 / Register 17 : Mixer Amplifier Control Register*/
#define CODEC_B0_P1_REG17_IN1L_ROUTE_NOT_TO_MAL_VAL  0x00
#define CODEC_B0_P1_REG17_IN1L_ROUTE_TO_MAL_VAL  0x20
#define CODEC_B0_P1_REG17_IN1L_ROUTE_CTRL_MASK  0x20

#define CODEC_B0_P1_REG17_IN1R_ROUTE_NOT_TO_MAR_VAL  0x00
#define CODEC_B0_P1_REG17_IN1R_ROUTE_TO_MAR_VAL  0x10
#define CODEC_B0_P1_REG17_IN1R_ROUTE_CTRL_MASK  0x10

#define CODEC_B0_P1_REG17_MAL_PUP_VAL  0x08
#define CODEC_B0_P1_REG17_MAL_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG17_MAL_PWCTRL_MASK  0x08

#define CODEC_B0_P1_REG17_MAR_PUP_VAL  0x04
#define CODEC_B0_P1_REG17_MAR_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG17_MAR_PWCTRL_MASK  0x04

/*Book 0 / Page 1 / Register 18 : Left ADC PGA to Left Mixer Amplifier Volume Control Register*/
#define CODEC_B0_P1_REG18_ADCL_PGA_ROUTE_TO_MAL_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG18_ADCL_PGA_ROUTE_TO_MAL_VOL_CTRL_MINUS_0_4DB_VAL  0x01
#define CODEC_B0_P1_REG18_ADCL_PGA_ROUTE_TO_MAL_VOL_CTRL_MINUS_36_1DB_VAL  0x28
#define CODEC_B0_P1_REG18_ADCL_PGA_NOT_ROUTE_TO_MAL_VAL  0x3F
#define CODEC_B0_P1_REG18_ADCL_PGA_ROUTE_TO_MAL_VOL_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 19 : Right ADC PGA to Right Mixer Amplifier Volume Control Register*/
#define CODEC_B0_P1_REG19_ADCR_PGA_ROUTE_TO_MAR_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG19_ADCR_PGA_ROUTE_TO_MAR_VOL_CTRL_MINUS_0_4DB_VAL  0x01
#define CODEC_B0_P1_REG19_ADCR_PGA_ROUTE_TO_MAR_VOL_CTRL_MINUS_36_1DB_VAL  0x28
#define CODEC_B0_P1_REG19_ADCR_PGA_NOT_ROUTE_TO_MAR_VAL  0x3F
#define CODEC_B0_P1_REG19_ADCR_PGA_ROUTE_TO_MAR_VOL_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 22 : Lineout Amplifier Control 1 Register*/
#define CODEC_B0_P1_REG22_DACL_ROUTE_NOT_TO_LOL_VAL  0x00
#define CODEC_B0_P1_REG22_DACL_ROUTE_TO_LOL_VAL  0x80
#define CODEC_B0_P1_REG22_DACL_ROUTE_CTRL_MASK  0x80

#define CODEC_B0_P1_REG22_DACR_ROUTE_NOT_TO_LOR_VAL  0x00
#define CODEC_B0_P1_REG22_DACR_ROUTE_TO_LOR_VAL  0x40
#define CODEC_B0_P1_REG22_DACR_ROUTE_TO_LOR_CTRL_MASK  0x40

#define CODEC_B0_P1_REG22_DACR_ROUTE_NOT_TO_LOL_VAL  0x00
#define CODEC_B0_P1_REG22_DACR_ROUTE_TO_LOL_VAL  0x20
#define CODEC_B0_P1_REG22_DACR_ROUTE_TO_LOL_CTRL_MASK  0x20

#define CODEC_B0_P1_REG22_LOL_ROUTE_NOT_TO_LOR_VAL  0x00
#define CODEC_B0_P1_REG22_LOL_ROUTE_TO_LOR_VAL  0x04
#define CODEC_B0_P1_REG22_LOL_ROUTE_CTRL_MASK  0x04

#define CODEC_B0_P1_REG22_LOL_PUP_VAL  0x02
#define CODEC_B0_P1_REG22_LOL_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG22_LOL_PWCTRL_MASK  0x02

#define CODEC_B0_P1_REG22_LOR_PUP_VAL  0x01
#define CODEC_B0_P1_REG22_LOR_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG22_LOR_PWCTRL_MASK  0x01

/*Book 0 / Page 1 / Register 23 : Lineout Amplifier Control 2 Register*/
#define CODEC_B0_P1_REG23_MAL_ROUTE_NOT_TO_LOL_VAL  0x00
#define CODEC_B0_P1_REG23_MAL_ROUTE_TO_LOL_VAL  0x80
#define CODEC_B0_P1_REG23_MAL_ROUTE_CTRL_MASK  0x80

#define CODEC_B0_P1_REG23_MAR_ROUTE_NOT_TO_LOR_VAL  0x00
#define CODEC_B0_P1_REG23_MAR_ROUTE_TO_LOR_VAL  0x40
#define CODEC_B0_P1_REG23_MAR_ROUTE_CTRL_MASK  0x40

#define CODEC_B0_P1_REG23_IN1L_ROUTE_NOT_TO_LOL_VAL  0x00
#define CODEC_B0_P1_REG23_IN1L_ROUTE_TO_LOL_0DB_VAL  0x08
#define CODEC_B0_P1_REG23_IN1L_ROUTE_TO_LOL_MINUS_6DB_VAL  0x10
#define CODEC_B0_P1_REG23_IN1L_ROUTE_TO_LOL_MINUS_12DB_VAL  0x18
#define CODEC_B0_P1_REG23_IN1L_ROUTE_CTRL_MASK  0x18

#define CODEC_B0_P1_REG23_IN1R_ROUTE_NOT_TO_LOR_VAL  0x00
#define CODEC_B0_P1_REG23_IN1R_ROUTE_TO_LOR_0DB_VAL  0x01
#define CODEC_B0_P1_REG23_IN1R_ROUTE_TO_LOR_MINUS_6DB_VAL  0x02
#define CODEC_B0_P1_REG23_IN1R_ROUTE_TO_LOR_MINUS_12DB_VAL  0x03
#define CODEC_B0_P1_REG23_IN1R_ROUTE_CTRL_MASK  0x03

/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
#define CODEC_B0_P1_REG27_MAL_ROUTE_NOT_TO_HPL_VAL  0x00
#define CODEC_B0_P1_REG27_MAL_ROUTE_TO_HPL_VAL  0x80
#define CODEC_B0_P1_REG27_MAL_ROUTE_CTRL_MASK  0x80

#define CODEC_B0_P1_REG27_MAR_ROUTE_NOT_TO_HPR_VAL  0x00
#define CODEC_B0_P1_REG27_MAR_ROUTE_TO_HPR_VAL  0x40
#define CODEC_B0_P1_REG27_MAR_ROUTE_CTRL_MASK  0x40

#define CODEC_B0_P1_REG27_DACL_ROUTE_NOT_TO_HPL_VAL  0x00
#define CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPL_VAL  0x20
#define CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPL_CTRL_MASK  0x20

#define CODEC_B0_P1_REG27_DACR_ROUTE_NOT_TO_HPR_VAL  0x00
#define CODEC_B0_P1_REG27_DACR_ROUTE_TO_HPR_VAL  0x10
#define CODEC_B0_P1_REG27_DACR_ROUTE_CTRL_MASK  0x10

#define CODEC_B0_P1_REG27_DACL_ROUTE_NOT_TO_HPR_VAL  0x00
#define CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPR_VAL  0x04
#define CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPR_CTRL_MASK  0x04

#define CODEC_B0_P1_REG27_HPL_PUP_VAL  0x02
#define CODEC_B0_P1_REG27_HPL_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG27_HPL_PWCTRL_MASK  0x02

#define CODEC_B0_P1_REG27_HPR_PUP_VAL  0x01
#define CODEC_B0_P1_REG27_HPR_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG27_HPR_PWCTRL_MASK  0x01

/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
#define CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG28_LOL_NOT_ROUTE_TO_HPL_VAL  0x7F
#define CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
#define CODEC_B0_P1_REG29_LOL_TO_HPL_LOR_TO_HPR_VOL_INDEPENDENT_VAL  0x00
#define CODEC_B0_P1_REG29_LOL_TO_HPL_LOR_TO_HPR_VOL_CTRLBY_REG28_VAL  0x80
#define CODEC_B0_P1_REG29_LOL_TO_HPL_LOR_TO_HPR_CTRL_MASK  0x80

#define CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG29_LOR_NOT_ROUTE_TO_HPR_VAL  0x7F
#define CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
#define CODEC_B0_P1_REG31_HP_CONFIG_UNI_MOD_VAL 0x00
#define CODEC_B0_P1_REG31_HP_CONFIG_G_CENTER_VAL 0x80
#define CODEC_B0_P1_REG31_HPDRV_CONFIG_MASK  0x80

#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_1DB_VAL  0x01
#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_14DB_VAL  0x0E
#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_MINUS_1DB_VAL  0x3F
#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_MINUS_6DB_VAL  0x3A
#define CODEC_B0_P1_REG31_HPL_DRV_MUTE_VAL  0x39
#define CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
#define CODEC_B0_P1_REG32_HPR_SET_AS_D5_0_VAL 0x00
#define CODEC_B0_P1_REG32_HPR_SET_AS_HPL_VAL 0x80
#define CODEC_B0_P1_REG32_HPR_DRV_CONFIG_MASK  0x80

#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_1DB_VAL  0x01
#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_14DB_VAL  0x0E
#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_MINUS_1DB_VAL  0x3F
#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_MINUS_6DB_VAL  0x3A
#define CODEC_B0_P1_REG32_HPR_DRV_MUTE_VAL  0x39
#define CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 36 : Receiver Amplifier Control 1 Register*/
#define CODEC_B0_P1_REG36_LOL_ROUTE_TO_RECP_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG36_LOL_ROUTE_TO_RECP_DRV_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG36_LOL_ROUTE_TO_RECP_DRV_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG36_LOL_NOT_ROUTE_TO_RECP_VAL  0x7F
#define CODEC_B0_P1_REG36_LOL_ROUTE_TO_RECP_DRV_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 37 : Receiver Amplifier Control 2 Register*/
#define CODEC_B0_P1_REG37_LOR_OUTPUT_RECM_DRV_VOL_CTRL_MASK  0x80

#define CODEC_B0_P1_REG37_LOR_ROUTE_TO_RECM_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG37_LOR_ROUTE_TO_RECM_DRV_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG37_LOR_ROUTE_TO_RECM_DRV_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG37_LOR_NOT_ROUTE_TO_RECM_VAL  0x7F
#define CODEC_B0_P1_REG37_LOR_ROUTE_TO_RECM_DRV_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 38 : Receiver Amplifier Control 3 Register*/
#define CODEC_B0_P1_REG38_IN1L_ROUTE_TO_RECP_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG38_IN1L_ROUTE_TO_RECP_DRV_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG38_IN1L_ROUTE_TO_RECP_DRV_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG38_IN1L_NOT_ROUTE_TO_RECP_VAL  0x7F
#define CODEC_B0_P1_REG38_IN1L_ROUTE_TO_RECP_DRV_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 39 : Receiver Amplifier Control 4 Register*/
#define CODEC_B0_P1_REG39_IN1L_INPUT_RECP_IN1R_INPUT_RECM_DRV_VOL_CTRL_MASK  0x80

#define CODEC_B0_P1_REG39_IN1R_ROUTE_TO_RECM_DRV_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG39_IN1R_ROUTE_TO_RECM_DRV_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG39_IN1R_ROUTE_TO_RECM_DRV_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG39_IN1R_NOT_ROUTE_TO_RECM_VAL  0x7F
#define CODEC_B0_P1_REG39_IN1R_ROUTE_TO_RECM_DRV_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 40 : Receiver Amplifier Control 5 Register*/
#define CODEC_B0_P1_REG40_RECP_OUTPUT_DRV_PUP_VAL  0x80
#define CODEC_B0_P1_REG40_RECP_OUTPUT_DRV_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG40_RECP_OUTPUT_DRV_PWCTRL_MASK  0x80

#define CODEC_B0_P1_REG40_RECM_OUTPUT_DRV_PUP_VAL  0x40
#define CODEC_B0_P1_REG40_RECM_OUTPUT_DRV_PDOWN_VAL  0x00
#define CODEC_B0_P1_REG40_RECM_OUTPUT_DRV_PWCTRL_MASK  0x40

#define CODEC_B0_P1_REG40_RECP_DRV_CTRL_MUTE_VAL  0x39
#define CODEC_B0_P1_REG40_RECP_DRV_CTRL_MINUS_6DB_VAL  0x3A
#define CODEC_B0_P1_REG40_RECP_DRV_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG40_RECP_DRV_CTRL_29DB_VAL  0x1D
#define CODEC_B0_P1_REG40_RECP_DRV_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 41 : Receiver Amplifier Control 6 Register*/
#define CODEC_B0_P1_REG41_RECEIVER_MASTER_VOL_CTRL_MASK  0x80

#define CODEC_B0_P1_REG41_RECM_DRV_CTRL_MUTE_VAL  0x39
#define CODEC_B0_P1_REG41_RECM_DRV_CTRL_MINUS_6DB_VAL  0x3A
#define CODEC_B0_P1_REG41_RECM_DRV_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG41_RECM_DRV_CTRL_29DB_VAL  0x1D
#define CODEC_B0_P1_REG41_RECM_DRV_CTRL_MASK  0x3F

/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
#define CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG46_LOL_NOT_ROUTE_TO_SPKL_VAL  0x7F
#define CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
#define CODEC_B0_P1_REG47_LOL_TO_SPKL_LOR_TO_SPKR_VOL_INDEPENDENT_VAL  0x00
#define CODEC_B0_P1_REG47_LOL_TO_SPKL_LOR_TO_SPKR_VOL_CTRLBY_REG28_VAL  0x80
#define CODEC_B0_P1_REG47_LOL_TO_SPKL_LOR_TO_SPKR_CTRL_MASK  0x80

#define CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKR_VOL_CTRL_0DB_VAL  0x00
#define CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKR_VOL_CTRL_MINUS_0_5DB_VAL  0x01
#define CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKRR_VOL_CTRL_MINUS_78_3DB_VAL  0x75
#define CODEC_B0_P1_REG47_LOR_NOT_ROUTE_TO_SPKR_VAL  0x7F
#define CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKR_VOL_CTRL_MASK  0x7F

/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_MUTE_VAL 0x00
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_6DB_VAL  0x10
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_12DB_VAL 0x20
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_18DB_VAL 0x30
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_24DB_VAL 0x40
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_30DB_VAL 0x50
#define CODEC_B0_P1_REG48_SPKL_VOL_CTRL_MASK  0x70

#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_MUTE_VAL 0x00
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_6DB_VAL  0x01
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_12DB_VAL 0x02
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_18DB_VAL 0x03
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_24DB_VAL 0x04
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_30DB_VAL 0x05
#define CODEC_B0_P1_REG48_SPKR_VOL_CTRL_MASK  0x07

/**************agc parameters*******************/
/*Book 0 / Page 1 / Register 86 : Left AGC Control 1 Register*/
#define CODEC_B0_P0_REG86_AGCL_DISABLED_VAL  0x00
#define CODEC_B0_P0_REG86_AGCL_ENABLED_VAL  0x80
#define CODEC_B0_P0_REG86_AGCL_ABLED_MASK  0x80

#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_5_5DB_VAL  0x00
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_8DB_VAL  0x10
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_10DB_VAL  0x20
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_12DB_VAL  0x30
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_14DB_VAL  0x40
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_17DB_VAL  0x50
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_20DB_VAL  0x60
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_24DB_VAL  0x70
#define CODEC_B0_P0_REG86_AGCL_TARLVEL_MASK  0x70

#define CODEC_B0_P0_REG86_AGCL_GAIN_HYST_SET_0_5DB_VAL  0x00
#define CODEC_B0_P0_REG86_AGCL_GAIN_HYST_SET_1DB_VAL  0x01
#define CODEC_B0_P0_REG86_AGCL_GAIN_HYST_SET_1_5DB_VAL  0x02
#define CODEC_B0_P0_REG86_AGCL_GAIN_HYST_SET_DISABLED_VAL  0x03
#define CODEC_B0_P0_REG86_AGCL_GAIN_HYST_SET_MASK  0x03

/*Book 0 / Page 1 / Register 87 : Left AGC Control 2 Register*/
#define CODEC_B0_P0_REG87_AGCL_HYST_SET_1DB_VAL    0x00
#define CODEC_B0_P0_REG87_AGCL_HYST_SET_2DB_VAL    0x40
#define CODEC_B0_P0_REG87_AGCL_HYST_SET_4DB_VAL    0x80
#define CODEC_B0_P0_REG87_AGCL_HYST_SET_DISABLED_VAL    0xC0
#define CODEC_B0_P0_REG87_AGCL_HYST_SET_MASK 0xC0

#define CODEC_B0_P0_REG87_AGCL_NOISE_THOLD_DIS_VAL    0x00
#define AGCL_NOISE_THRESHOLD(value)     (((0-(value+30))/2 +1)<<1)&0x3e
#define CODEC_B0_P0_REG87_AGCL_NOISE_THOLD_MASK 0x3E

/*Book 0 / Page 1 / Register 88 : Left AGC Control 3 Register*/
#define CODEC_B0_P0_REG88_AGCL_MAX_GAIN_0DB_VAL    0x00
#define AGCL_MAX_GAIN(value)     (value*2<<1)&0x7F
#define CODEC_B0_P0_REG88_AGCL_MAX_GAIN_MASK 0x7F

/*Book 0 / Page 1 / Register 89 : Left AGC Attack Time Register*/
#define AGCL_ATTACK_TIME(value)     (((value-1)/2)<<3)&0xF8
#define CODEC_B0_P0_REG89_AGCL_ATTACK_TIME_MASK 0xF8

/*Book 0 / Page 1 / Register 90 : Left AGC Decay Time Register*/
#define AGCL_DECAY_TIME(value)     (((value-1)/2)<<3)&0xF8
#define CODEC_B0_P0_REG90_AGCL_DECAY_TIME_MASK 0xF8

/*Page 0 / Register 91: Left AGC Noise Debounce*/
#define CODEC_B0_P0_REG91_AGCL_NOISE_DEBOUNCE_MASK 0x1F

/*Page 0 / Register 92: Left AGC Signal Debounce*/
#define CODEC_B0_P0_REG92_AGCL_SIGNAL_DEBOUNCE_MASK 0x0F

/*Book 0 / Page 1 / Register 94 : Right AGC Control 1 Register*/
#define CODEC_B0_P0_REG94_AGCR_DISABLED_VAL  0x00
#define CODEC_B0_P0_REG94_AGCR_ENABLED_VAL  0x80
#define CODEC_B0_P0_REG94_AGCR_ABLED_MASK  0x80

#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_5_5DB_VAL  0x00
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_8DB_VAL  0x10
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_10DB_VAL  0x20
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_12DB_VAL  0x30
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_14DB_VAL  0x40
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_17DB_VAL  0x50
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_20DB_VAL  0x60
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_24DB_VAL  0x70
#define CODEC_B0_P0_REG94_AGCR_TARLVEL_MASK  0x70

#define CODEC_B0_P0_REG94_AGCR_GAIN_HYST_SET_0_5DB_VAL  0x00
#define CODEC_B0_P0_REG94_AGCR_GAIN_HYST_SET_1DB_VAL  0x01
#define CODEC_B0_P0_REG94_AGCR_GAIN_HYST_SET_1_5DB_VAL  0x02
#define CODEC_B0_P0_REG94_AGCR_GAIN_HYST_SET_DISABLED_VAL  0x03
#define CODEC_B0_P0_REG94_AGCR_GAIN_HYST_SET_MASK  0x03

/*Book 0 / Page 1 / Register 95 : Right AGC Control 2 Register*/
#define CODEC_B0_P0_REG95_AGCR_HYST_SET_1DB_VAL    0x00
#define CODEC_B0_P0_REG95_AGCR_HYST_SET_2DB_VAL    0x40
#define CODEC_B0_P0_REG95_AGCR_HYST_SET_4DB_VAL    0x80
#define CODEC_B0_P0_REG95_AGCR_HYST_SET_DISABLED_VAL    0xC0
#define CODEC_B0_P0_REG95_AGCR_HYST_SET_MASK  0xC0

#define CODEC_B0_P0_REG95_AGCR_NOISE_THOLD_DIS_VAL    0x00
#define AGCR_NOISE_THRESHOLD(value)     (((0-(value+30))/2 +1)<<1)&0x3e
#define CODEC_B0_P0_REG95_AGCR_NOISE_THOLD_MASK  0x3E

/*Book 0 / Page 1 / Register 96 : Right AGC Control 3 Register*/
#define CODEC_B0_P0_REG96_AGCR_MAX_GAIN_0DB_VAL    0x00
#define AGCR_MAX_GAIN(value)     (value*2<<1)&0x7F
#define CODEC_B0_P0_REG96_AGCR_MAX_GAIN_MASK  0x7F

/*Book 0 / Page 1 / Register 97 : Right AGC Attack Time Register*/
#define AGCR_ATTACK_TIME(value)     (((value-1)/2)<<3)&0xF8
#define CODEC_B0_P0_REG97_AGCR_ATTACK_TIME_MASK 0xF8

/*Book 0 / Page 1 / Register 98 : Right AGC Decay Time Register*/
#define AGCR_DECAY_TIME(value)     (((value-1)/2)<<3)&0xF8
#define CODEC_B0_P0_REG98_AGCR_DECAY_TIME_MASK  0xF8

/*Page 0 / Register 99: Right AGC Noise Debounce*/
#define CODEC_B0_P0_REG99_AGCR_NOISE_DEBOUNCE_MASK  0x1F

/*Page 0 / Register 100: Right AGC Signal Debounce*/
#define CODEC_B0_P0_REG100_AGCR_SIGNAL_DEBOUNCE_MASK  0x0F


/**************drc parameters*******************/
/*Page 0 / Register 68: DRC Control 1*/
#define CODEC_B0_P0_REG68_DRC_DIS_LCHN_VAL  0x00
#define CODEC_B0_P0_REG68_DRC_EN_LCHN_VAL  0x40
#define CODEC_B0_P0_REG68_DRC_EN_LCHN_MASK  0x40

#define CODEC_B0_P0_REG68_DRC_DIS_RCHN_VAL    0x00
#define CODEC_B0_P0_REG68_DRC_EN_RCHN_VAL    0x20
#define CODEC_B0_P0_REG68_DRC_EN_RCHN_MASK  0x20

#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_3DB_VAL    0x00
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_6DB_VAL    0x04
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_9DB_VAL    0x08
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_12DB_VAL    0x0C
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_15DB_VAL    0x10
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_18DB_VAL    0x14
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_21DB_VAL    0x18
#define CODEC_B0_P0_REG68_DRC_THOLD_MINUS_24DB_VAL    0x1C

#define CODEC_B0_P0_REG68_DRC_HYST_0DB_VAL    0x00
#define CODEC_B0_P0_REG68_DRC_HYST_1DB_VAL    0x01
#define CODEC_B0_P0_REG68_DRC_HYST_2DB_VAL    0x02
#define CODEC_B0_P0_REG68_DRC_HYST_3DB_VAL    0x03

/*Page 0 / Register 69: DRC Control 2*/
#define CODEC_B0_P0_REG69_DRC_HOLD_TIME_MASK    0x38
#define CODEC_B0_P0_REG69_MAX_RATE_OF_CHANGE_OF_GAIN_MASK  0x07

/*Page 0 / Register 70: DRC Control 3*/
#define CODEC_B0_P0_REG70_DRC_ATTACK_RATE_MASK    0xF0
#define CODEC_B0_P0_REG70_DRC_DECAY_RATE_MASK    0x0F

/**************power ctrl parameters*******************/
/*Book 0 / Page 1 / Register 1 : Power Configuration Register*/
#define CODEC_B0_P1_REG1_DISABLE_AVDD_TO_DVDD_VAL 0x00
#define CODEC_B0_P1_REG1_AVDD_CONNECT_TO_DVDD_VAL 0x08
#define CODEC_B0_P1_REG1_AVDD_TO_DVDD_CTRL_MASK 0x08

#define CODEC_B0_P1_REG1_EXT_ANA_AVAILABLE_VAL 0x00
#define CODEC_B0_P1_REG1_EXT_ANA_NOT_AVAILABLE_VAL  0x40
#define CODEC_B0_P1_REG1_EXT_ANA_AVAILABLE_CTRL_MASK 0x40

/*Book 0 / Page 1 / Register 3 : Left DAC PowerTune Configuration Register*/
#define CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_P3_PTM_P4_VAL 0x00
#define CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_P2_VAL 0x04
#define CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_P1_VAL 0x08
#define CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_CTRL_MASK 0x1C

/*Book 0 / Page 1 / Register 4 : Right DAC PowerTune Configuration Register*/
#define CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_P3_PTM_P4_VAL 0x00
#define CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_P2_VAL 0x04
#define CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_P1_VAL 0x08
#define CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_CTRL_MASK 0x1C

/*Book 0 / Page 1 / Register 33 : Charge Pump Control Register*/
#define CODEC_B0_P1_REG33_WRITE_ONLY_VAL 0x20
#define CODEC_B0_P1_REG33_WRITE_ONLY_VAL_MASK 0xE0

#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_16_VAL 0x00
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_1_VAL 0x01
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_2_VAL 0x02
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_3_VAL 0x03
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_4_VAL 0x04
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_5_VAL 0x05
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_6_VAL 0x06
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_7_VAL 0x07
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_8_VAL 0x08
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_9_VAL 0x09
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_10_VAL 0x0A
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_11_VAL 0x0B
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_12_VAL 0x0C
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_13_VAL 0x0D
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_14_VAL 0x0E
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_15_VAL 0x0F
#define CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_VAL_CTRL_MASK 0x1E



/****************************************************************************
* 	                               Local Types
****************************************************************************/

typedef enum
{
	CODEC_CLKIN_MCLK,
	CODEC_CLKIN_BCLK,
	CODEC_CLKIN_GPIO1,
	CODEC_CLKIN_PLLCLK,
	CODEC_CLKIN_MAX
}T_ZDrvCodec_AudioClockIn;

typedef enum
{
	CODEC_IDLE,
	CODEC_OPEN,
	CODEC_ENABLE,
	CODEC_DISABLE,
	CODEC_RESET,
	CODEC_STATUS_MAX
}T_AudCodec_UseStatus;

typedef enum
{
    HANDLE_FREE,  
    HANDLE_IN_USE,
    HANDLE_USE_MAX
}T_AudCodec_HandleStatus;

typedef enum
{
	CODEC_BUS_I2S,
	CODEC_BUS_RJF,   //Right-Justified Mode
	CODEC_BUS_LJF,   //Left-Justified Mode
	CODEC_BUS_DSP,
	CODEC_BUS_MAX
}T_AudCodec_BusMode;

typedef struct _T_Codec_UseInfo
{
    T_ZDrvCodec_Handle handle;  
    T_AudCodec_HandleStatus handleState;
	T_ZDrvCodec_AudioI2SChannel audI2SChannel;
	T_ZDrvCodec_AudioI2SMode masterSlave;
	T_ZDrvCodec_AudioSample sampleRate;		   
	T_ZDrvCodec_AudioClockIn clockIn;
    T_AudCodec_UseStatus useState;	
	T_AudCodec_BusMode  busMode; 
    T_ZDrvCodec_InDevice	inDev;	
    T_ZDrvCodec_OutDevice	outDev;			   
}T_Codec_UseInfo;

typedef struct _T_CLK_DIV
{
	UINT32 fs;  
	UINT8 ndiv;
	UINT8 mdiv;		
	UINT16 sordiv;		   
}T_CLK_DIV;

typedef struct _T_PLL_CLK_DIV
{
	UINT32 fs;  
	UINT8 pll_pdiv;
	UINT8 pll_rmulti;
	UINT8  pll_jmulti;
	UINT16 pll_dval;
	UINT8 pll_clkin_div;
	UINT8 nda_div;
	UINT8 mda_div;		
	UINT16 dsor_div;			
	UINT8 nad_div;
	UINT8 mad_div;		
	UINT8 asor_div;
}T_PLL_CLK_DIV;


/****************************************************************************
* 	                               Local Constants
****************************************************************************/


/****************************************************************************
*                                             Local Variables
****************************************************************************/

static BOOL s_mutex_FirstUse = FALSE;
//static BOOL codec_FirstUse = TRUE;
//static BOOL clk_FirstUse = TRUE;
static ZOSS_MUTEX_ID s_codecMutexID = NULL;
#if 0
static T_CLK_DIV clkDiv[]=
{
	{8000 ,	5,	13,	50},
	{16000,	5,	5 ,	61},
	{44100,	2,	5 ,	59},
	{48000,	2,	5 ,	54}
};
#endif
#if 1/*modified by miaolin 20130901 MCLK1=26MHz*/
static T_PLL_CLK_DIV pll_clkDiv[]=
{
	{8000 ,	2, 1, 6, 3803, 1, 3, 54, 64, 3, 54,	64},
	//{8000 , 1, 2,40,    0, 1, 5,125, 16, 5,125, 16},//test for pcm 8k arm i2s as master		
	{16000,	2, 1, 6, 6166, 1, 3,  7,256, 3,  7,256},
	{44100,	2, 1, 6, 5132, 1, 3, 10, 64, 3, 10,	64},
	{48000,	2, 1, 6, 3803, 1, 3,  9, 64, 3, 54,	64}
};
#else/*modified by miaolin 20130901 MCLK1=5. 6448MHz*/
static T_PLL_CLK_DIV pll_clkDiv[]=
{
	{8000 ,	1,	1,	6,	9977   ,	1,	3,	14,	256 ,   	3,  	14,	256 },
       /*{8000 ,	7,	2,	60,	0   ,	1,	3,	63,	64 ,   	3	,  	63,	64 },*/
	{16000,	7,	2,	60, 0   ,   1,	3,	63,	32 ,   	3	,  	63,	32 },
	{44100,	1,	3,	 5,	0	,	1,	3,	 5, 128,  	3 	,	5,	128},
	{48000,	7,	2,	60,	0   ,   1,	3,	21,	32,   	3	,  	21,	32}
};
#endif
/**************/
static T_ZDrvI2c_Device s_codecI2CDev =
{
	I2C_BUS_1,/*modified by miaolin 20130906 change to i2c1*/
	TLV3212_I2C_SADD,
	100*1000,/*100*1000*/
	100,
	1,
	I2C_REG_DEV|I2C_M_COMBINE,
	NULL
};

static T_Codec_UseInfo  voiceUseInfo=
{
	NULL,
	HANDLE_FREE,	
	AUDIO_I2S0,
	I2S_SLAVE_MODE,
	AUDIO_SAMPLE_8K,	
	CODEC_CLKIN_MCLK,//26MHZ
	CODEC_IDLE,
	CODEC_BUS_I2S,
	AUDIO_INPUT_MAX,
	AUDIO_OUTPUT_MAX      
};

static T_Codec_UseInfo  audioUseInfo=
{
	NULL,
	HANDLE_FREE,		   	
	AUDIO_I2S0,
	I2S_SLAVE_MODE,
	AUDIO_SAMPLE_44_1K,	  
	CODEC_CLKIN_MCLK,//26MHZ
	CODEC_IDLE,
	CODEC_BUS_I2S,
	AUDIO_INPUT_MAX,
	AUDIO_OUTPUT_MAX         
};

static T_Codec_UseInfo  fmUseInfo=
{
	NULL,
	HANDLE_FREE,		   	
	AUDIO_I2S0,
	I2S_SLAVE_MODE,
	AUDIO_SAMPLE_8K,
	CODEC_CLKIN_MCLK,//26MHZ
	CODEC_IDLE,
	CODEC_BUS_I2S,
	AUDIO_INPUT_MAX,
	AUDIO_OUTPUT_MAX
};

static  UINT8 handsetInPathPara[]=
{
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//{CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL},
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	{0x11},
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x11},
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	{0x01},
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG60_RIGHT_MIC_PGA_SET_TO_0DB_VAL},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	{CODEC_B0_P0_REG81_LEFT_ADC_PUP_VAL|CODEC_B0_P0_REG81_RIGHT_ADC_PUP_VAL|CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	{CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_0DB_VAL},
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	{CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MINUS_12DB_VAL},
	/*Book 0 / Page 0 / Register 84 : RIGHT ADC Volume Control Register*/
	{CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MINUS_12DB_VAL}
};

static  UINT8 inPathParaMask[]=
{
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//{CODEC_B0_P1_REG51_MICBIAS_PW_INSERT_CTRL_MASK} ,
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	//{0xff},
	 {CODEC_B0_P1_REG52_IN2L_TO_LEFTMIC_SEL_MASK},
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{0xFF},
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	{0xFF},
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0xFF},
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0xFF},
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	{0xFF},
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_CTRL_MASK|CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_MASK},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_CTRL_MASK|CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_MASK},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	{CODEC_B0_P0_REG81_LEFT_PWCTRL_MASK|CODEC_B0_P0_REG81_RIGHT_PWCTRL_MASK|CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_CTRL_MASK},
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	{CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MASK|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MASK},
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	{CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MASK},
	/*Book 0 / Page 0 / Register 84 : Right ADC Volume Control Register*/
	{CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MASK}
};

#if 0 //never used
//fm  analog loop input channel
static  UINT8 handsetFMAnalogInPathPara[]=
{ 
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	{CODEC_B0_P1_REG51_MICBIAS_OUT_PW2_5V_VAL|CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL} ,
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	0x00,
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_SET_TO_0DB_VAL},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_SET_TO_0DB_VAL},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	0x00, 
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	0x88, 	
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	0x00, 	
	/*Book 0 / Page 0 / Register 84 : RIGHT ADC Volume Control Register*/
	0x00	
};
#endif

//fm  digital loop input channel
static  UINT8 handsetFMDigitalInPathPara[]=
{
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//{CODEC_B0_P1_REG51_MICBIAS_PDOWN_VAL|CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL} ,
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	{CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	{CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_20DB_VAL},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_20DB_VAL},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	{CODEC_B0_P0_REG81_LEFT_ADC_PUP_VAL|CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	{CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL },
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	{CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_0DB_VAL},
	/*Book 0 / Page 0 / Register 84 : Right ADC Volume Control Register*/
	{CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_0DB_VAL}
	
};

static UINT8 speakerInPathPara[]=
{
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//{CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL },
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	{CODEC_B0_P1_REG54_CM1_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	{CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_47_5DB_VAL},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_47_5DB_VAL},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	{CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_1FS_VAL },
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	{CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_0DB_VAL},
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	{CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_0DB_VAL},
	/*Book 0 / Page 0 / Register 84 : RIGHT ADC Volume Control Register*/
	{CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_0DB_VAL}	
};

static  UINT8 headsetInPathPara[]=
{
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//{CODEC_B0_P1_REG51_MICBIAS_PUP_INSERT_CTRL2_VAL},
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_10KR_VAL},//{CODEC_B0_P1_REG52_IN1L_TO_LEFTMIC_SEL_10KR_VAL|CODEC_B0_P1_REG52_IN1R_TO_LEFTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	{0x0},
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	{0x40},
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x0},//{CODEC_B0_P1_REG55_IN1R_TO_RIGHTMIC_SEL_10KR_VAL},
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	{0x0},
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	{0x0},//{CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_10KR_VAL},//{CODEC_B0_P1_REG57_CM1_TO_RIGHTMIC_SEL_10KR_VAL|CODEC_B0_P1_REG57_IN1L_TO_RIGHTMIC_SEL_10KR_VAL },
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	{0x0},
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	{CODEC_B0_P1_REG59_LEFT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	{CODEC_B0_P1_REG60_RIGHT_MIC_PGA_ENABLE_VAL|CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	{CODEC_B0_P0_REG81_LEFT_ADC_PUP_VAL|CODEC_B0_P0_REG81_RIGHT_ADC_PUP_VAL|CODEC_B0_P0_REG81_ADC_VOLCTRL_STEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	{CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_0DB_VAL},
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	{CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_0DB_VAL},
	/*Book 0 / Page 0 / Register 84 : RIGHT ADC Volume Control Register*/
	{CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_0DB_VAL}	
};

static  UINT8 inPathResetPara[]=
{	
	/*Book 0 / Page 1 / Register 51 : MICBIAS CONTROL Register*/
	//0x00,
	/*Book 0 / Page 1 / Register 52 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 53 : Input Select 1 for Left Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 54 : Input Select for Left Microphone PGA M-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 55 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 56 : Input Select 1 for Right Microphone PGA P-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 57 : Input Select for Right Microphone PGA M-Terminal Register*/
	0x00,
	/*Book 0 / Page 1 / Register 58 : Input Common Mode Control Register*/
	0x00,
	/*Book 0 / Page 1 / Register 59 : Left Microphone PGA Control Register*/
	0x80,
	/*Book 0 / Page 1 / Register 60 : Right Microphone PGA Control Register*/
	0x80,
	/*Book 0 / Page 0 / Register 81 : ADC Channel Power Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 82 : ADC Fine Gain Volume Control Register*/
	0x88, 	
	/*Book 0 / Page 0 / Register 83 : LEFT ADC Volume Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 84 : RIGHT ADC Volume Control Register*/
	0x00,
};

static UINT8 receiverOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_RDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
	/*Book 0 / Page 0 / Register 66 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x00,
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PDOWN_VAL|CODEC_B0_P1_REG27_HPR_PDOWN_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_NOT_TO_HPR_VAL| \
	CODEC_B0_P1_REG27_DACR_ROUTE_NOT_TO_HPR_VAL|CODEC_B0_P1_REG27_MAL_ROUTE_NOT_TO_HPL_VAL|CODEC_B0_P1_REG27_MAR_ROUTE_NOT_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x0}
};

static UINT8 outPathParaMask[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PW_MASK|CODEC_B0_P0_REG63_RDAC_PW_MASK|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_LCHN_MUTE_CTRL_MASK|CODEC_B0_P0_REG64_DAC_RCHN_MUTE_CTRL_MASK|CODEC_B0_P0_REG64_DAC_VOLCTRL_MASK},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_MASK},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_MASK},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x18,
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{CODEC_B0_P1_REG9_HP_DRV_DEBOUNCE_US_CTRL_MASK},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG29_LOL_TO_HPL_LOR_TO_HPR_CTRL_MASK|CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MASK},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0xFF},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0xff},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0xff}
};

static  UINT8 speakerOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_RDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL | CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_12DB_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_12DB_VAL},
	/*Book 0 / Page 1 / Register 8: Headphone Output Driver Control Register*/
	{0x04},
	/*Book 0 / Page 1 / Register 9 : Common Mode Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0xb9},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0xb9},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x03},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Volume Control Register*/
	{0x18},
       /*Book 0 / Page 1 / Register 47 : Speaker Amplifier Volume Control Register*/
	{0x18},
       /*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x11}
};

#if 0 //never used
//fm speaker analog loop output channel
static  UINT8 speakerFMAnalogOutPathPara[]=
{ 
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	0x0C,
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	0x00,
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x00,
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{CODEC_B0_P1_REG45_MAL_ROUTE_TO_SPKL_VAL|CODEC_B0_P1_REG45_MONO_SPK_MODE_VAL|CODEC_B0_P1_REG45_SPKL_PUP_VAL},
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 17 : Mixer Amplifier Control Register*/
	{CODEC_B0_P1_REG17_IN1L_ROUTE_TO_MAL_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x00}
};
#endif

//fm speaker digital loop output channel
static  UINT8 speakerFMDigitalOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x00,
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PDOWN_VAL|CODEC_B0_P1_REG27_HPR_PDOWN_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_NOT_TO_HPR_VAL| \
	CODEC_B0_P1_REG27_DACR_ROUTE_NOT_TO_HPR_VAL|CODEC_B0_P1_REG27_MAL_ROUTE_TO_HPL_VAL|CODEC_B0_P1_REG27_MAR_ROUTE_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{CODEC_B0_P1_REG45_MAL_ROUTE_TO_SPKL_VAL|CODEC_B0_P1_REG45_MONO_SPK_MODE_VAL|CODEC_B0_P1_REG45_SPKL_PUP_VAL},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{CODEC_B0_P1_REG48_SPKL_VOL_CTRL_6DB_VAL}
};

static  UINT8 bluetoothOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_RCHN_MUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x00,
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PDOWN_VAL|CODEC_B0_P1_REG27_HPR_PDOWN_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_NOT_TO_HPR_VAL| \
	CODEC_B0_P1_REG27_DACR_ROUTE_NOT_TO_HPR_VAL|CODEC_B0_P1_REG27_MAL_ROUTE_TO_HPL_VAL|CODEC_B0_P1_REG27_MAR_ROUTE_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{CODEC_B0_P1_REG48_SPKL_VOL_CTRL_6DB_VAL}
};

#if 0
static  UINT8 headsetOutPathPara[]=
{
		//page0 reg63: DAC Data-Path Setup
        {CODEC_P0_REG63_LDAC_PWON_VAL|CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL| \
		CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
		//page0 reg64:DAC VOLUME CONTROL
        {CODEC_P0_REG64_DAC_RCHN_MUTE_VAL|\
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
		//page0 reg65:DAC Left Volume Control
		{CODEC_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
		//page0 reg66:DAC Right Volume Control
		{CODEC_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
		//page1 reg31:  Headphone Drivers
        {CODEC_P1_REG31_HP_OUT_1_35V_VAL|CODEC_P1_REG31_WRITE_ONLY_VAL|CODEC_P1_REG31_HPL_PWON_VAL },
		//page1 reg32:   Class-D Speaker Amplifier
		{0x06},
		//page1 reg33:  HP Output Drivers POP Removal Settings
        {CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL|CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL|CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL },
		//page1 reg34:  Output Driver PGA Ramp-Down Period Control
		{CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL},
		//page1 reg35:  DAC_L and DAC_R Output Mixer Routing
		{CODEC_P1_REG35_DACL_ROUTE_HPL_DRV_VAL|  CODEC_P1_REG35_DACR_ROUTE_HPR_DRV_VAL},
		//page1 reg36: Left Analog Vol to HPL
		{CODEC_P1_REG36_LAVOL_TO_HPL_VAL|CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL},
		//page1 reg37: Right Analog Vol to HPR
		{CODEC_P1_REG37_RAVOL_TO_HPR_VAL|CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL},
		//page1 reg38: Left Analog Vol to SPK
		{0x7f},
		//page1 reg39: Reserved
		{0x7f},
		//page1 reg40: HPL Driver
        {CODEC_P1_REG40_HPL_DRV_PGA_3DB_VAL},
		//page1 reg41: HPR Driver
        {CODEC_P1_REG41_HPR_DRV_PGA_3DB_VAL},
		//page1 reg42: SPK Driver
		{0x00},
		//page1 reg43: Reserved
		{0x00},
		//page1 reg44: HP Driver Control
		{CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL|CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL| \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL}

};
#else
static  UINT8 headsetOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_RDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_12DB_VAL},
	/*Book 0 / Page 0 / Register 66 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_12DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	{CODEC_B0_P1_REG8_HP_OUT_1_5V_VAL},
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x10},//HP Sizing=100%
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PUP_VAL|CODEC_B0_P1_REG27_HPR_PUP_VAL| \
	CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPL_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x3A},//0dB
	/*Book 0 / Page 1 / Register 32 : HPR Driver Volume Control Register*/
	{0xba},//0dB
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x00}
};
#endif

#if 0 //never used
//fm headset analog loop output channel
static  UINT8 headsetFMAnalogOutPathPara[]=
{ 
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	0x0C,
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	0x00,
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	{CODEC_B0_P1_REG8_HP_OUT_1_5V_VAL},
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PUP_VAL|CODEC_B0_P1_REG27_HPR_PUP_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x00}
};
#endif

//fm headset digital loop output channel
static  UINT8 headsetFMDigitalOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	{CODEC_B0_P1_REG8_HP_OUT_1_5V_VAL},
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PUP_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPR_VAL|CODEC_B0_P1_REG27_DACR_ROUTE_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x00}
};

static  UINT8 headsetSpkOutPathPara[]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	{CODEC_B0_P0_REG63_LDAC_PUP_VAL|CODEC_B0_P0_REG63_RDAC_PUP_VAL|CODEC_B0_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL},
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	{CODEC_B0_P0_REG64_DAC_RCHN_MUTE_VAL|CODEC_B0_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	{CODEC_B0_P0_REG65_DAC_LCHN_VOL_0DB_VAL},
	/*Book 0 / Page 0 / Register 65 : Primary DAC Right Volume Control Register*/
	{CODEC_B0_P0_REG66_DAC_RCHN_VOL_0DB_VAL},
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	{CODEC_B0_P1_REG8_HP_OUT_1_5V_VAL},
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{CODEC_B0_P1_REG27_HPL_PUP_VAL|CODEC_B0_P1_REG27_HPR_PUP_VAL|CODEC_B0_P1_REG27_DACL_ROUTE_TO_HPL_VAL| \
	CODEC_B0_P1_REG27_DACR_ROUTE_TO_HPR_VAL},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_0DB_VAL},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{CODEC_B0_P1_REG48_SPKL_VOL_CTRL_6DB_VAL}
};

static  UINT8 outPathResetPara[18]=
{
	/*Book 0 / Page 0 / Register 63 : Primary DAC Power and Soft-Stepping Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 64 : Primary DAC Master Volume Configuration Register*/
	0x0C,
	/*Book 0 / Page 0 / Register 65 : Primary DAC Left Volume Control Register*/
	0x00,
	/*Book 0 / Page 0 / Register 66 : Primary DAC Right Volume Control Register*/
	0x00,
	/*Book 0 / Page 1 / Register 8 : Common Mode Register*/
	0x00,
	/*Book 0 / Page 1 / Register 9 : Headphone Output Driver Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 27 : Headphone Amplifier Control 1 Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 28 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 29 : Headphone Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 30 : Reserved*/
	{0x00},
	/*Book 0 / Page 1 / Register 31 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 32 : HPL Driver Volume Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 45 : Speaker Amplifier Control Register*/
	{0x00},
	/*Book 0 / Page 1 / Register 46 : Speaker Amplifier Control 2 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 47 : Speaker Amplifier Control 3 Register*/
	{0x7f},
	/*Book 0 / Page 1 / Register 48 : Speaker Amplifier Volume Control Register*/
	{0x00}
};

/****************************************************************************
* 	                               Local Function Prototypes
****************************************************************************/
SINT32 aud_SetCodecPWOnOff(BOOL onOff);
SINT32 codec_SetFmInPath(T_ZDrvCodec_Handle handle, BOOL onoff);

/****************************************************************************
* 	                               Global Constants
****************************************************************************/



/****************************************************************************
* 	                               Global Variables
****************************************************************************/



/****************************************************************************
* 	                               Function Definitions
****************************************************************************/



/******************************************************************************
 * Function: codec_Claim_Mutex
 * Description: init mutex and get mutex
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *  
 *
 * Others:
 ******************************************************************************/
VOID codec_Claim_Mutex(void)
{
	if (FALSE == s_mutex_FirstUse)
	{
		s_codecMutexID = zOss_CreateMutex("codecMutex",  ZOSS_INHERIT);   /*create mutex*/
		s_mutex_FirstUse=TRUE;
	}
	zOss_GetMutex(s_codecMutexID, ZOSS_WAIT_FOREVER);
}

/******************************************************************************
 * Function: codec_Release_Mutex
 * Description: release mutex
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   
 *
 * Others:
 ******************************************************************************/
void codec_Release_Mutex(void)
{
	zOss_PutMutex(s_codecMutexID);
}

/******************************************************************************
 * Function: codec_I2CWrite
 * Description: write data to codec
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_I2CWrite(UINT8 regBook, UINT8 regPage, UINT8 regAddress, UINT8 regValue, UINT8 regMask)
{
	SINT32 halRet = DRV_ERROR;
	UINT8 regTempValue = 0;
	UINT8 regRead = 0;
    
	if((regBook == 0)||(regBook == 40)||(regBook == 80))
	{
		/*switch to reg book*/
		regTempValue = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &regTempValue, 1);	/*B0_P0_R0: set to page 0*/
		
		regTempValue = regBook;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 127, &regTempValue, 1);	/*B0_P0_R127: set to book0*/
		
		/*switch to reg page*/
		regTempValue = regPage;	
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &regTempValue, 1);	
		
		//zOss_Sleep(2);
		/*write value to reg*/ 
		regTempValue = 0;
		halRet += zDrvI2c_DevRead(&s_codecI2CDev, (UINT16)regAddress, &regTempValue, 1);
		if (halRet == DRV_SUCCESS)
		{
			regTempValue = regTempValue & (~regMask);
			regTempValue |= (regValue & regMask);
			halRet += zDrvI2c_DevWrite(&s_codecI2CDev, (UINT16)regAddress, &regTempValue, 1);
			
			halRet += zDrvI2c_DevRead(&s_codecI2CDev, (UINT16)regAddress, &regRead, 1);
			
			if (halRet == DRV_SUCCESS)
			{
				return DRV_SUCCESS;
			}
			else
			{
				return DRV_ERR_DATA_TRANSFER;
			}
		}
	}
	else
	{
		return halRet;
	}

	return halRet;
}

/******************************************************************************
 * Function: codec_I2CRead
 * Description: read data to codec
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_I2CRead(UINT8 regBook, UINT8 regPage, UINT8 regAddress, UINT8 *regValue)
{
	SINT32 halRet = DRV_ERROR;
	UINT8 regTempValue = 0;

	//zOss_Printf(1,1,"codec codec_I2CRead start regBook=%d ,regPage=%d ,regAddress=%d ,regValue=%x!\n",  \
	//	regBook,regPage,regAddress,*regValue);
	   
	if((regBook == 0)||(regBook == 40)||(regBook == 80))
	{	
		/*switch to reg book*/
		regTempValue = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &regTempValue, 1);	/*B0_P0_R0: set to page 0*/
		
		regTempValue = regBook;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 127, &regTempValue, 1);	/*B0_P0_R127: set to book*/

		/*switch to reg page*/
		regTempValue = regPage;	
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &regTempValue, 1);	
			  
		zOss_Sleep(5);
		/*read val from reg*/
		halRet += zDrvI2c_DevRead(&s_codecI2CDev, (UINT16)regAddress, regValue, 1);
	}
	else
	{
		return halRet;
	}
	//zOss_Printf(1,1,"codec codec_I2CRead end! halRet=%d!\n", halRet);

	return halRet;
}

/******************************************************************************
 * Function: zDrvCodec_Open
 * Description: open codec, set parameters.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Open(T_ZDrvCodec_Handle *handle,T_ZDrvCodec_SourceType srcType)
{
	SINT32 halRet = DRV_SUCCESS; 
//	UINT8 reg_write = 0;
//	UINT8 reg_mask = 0;	
//	T_Codec_UseInfo *codec_info;	
		   
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec open start srcType=%d !\n",srcType);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec open, voice state=%x,audio state=%x,fm state=%x !\n",voiceUseInfo.useState,audioUseInfo.useState,fmUseInfo.useState);

    codec_Claim_Mutex();
		
	if( srcType== VOICE_SOURCE&&voiceUseInfo.handleState==HANDLE_FREE)
	{
		//halRet=aud_SetCodecPWOnOff(TRUE);	
		if (halRet == DRV_SUCCESS)
		{
			voiceUseInfo.handle= (T_ZDrvCodec_Handle)(&voiceUseInfo);
			voiceUseInfo.useState=CODEC_OPEN;
			voiceUseInfo.handleState = HANDLE_IN_USE;		
			*handle =voiceUseInfo.handle;
			voiceUseInfo.inDev=AUDIO_INPUT_MAX;
			voiceUseInfo.outDev=AUDIO_OUTPUT_MAX;						
		}
	}
	else if( srcType==AUDIO_SOURCE&&audioUseInfo.handleState==HANDLE_FREE)
	{
		//halRet=aud_SetCodecPWOnOff(TRUE);	
		if (halRet == DRV_SUCCESS)
		{
			audioUseInfo.handle= (T_ZDrvCodec_Handle)(&audioUseInfo);
			audioUseInfo.useState=CODEC_OPEN;
			audioUseInfo.handleState = HANDLE_IN_USE;						
			*handle =audioUseInfo.handle;						
			audioUseInfo.inDev=AUDIO_INPUT_MAX;
			audioUseInfo.outDev=AUDIO_OUTPUT_MAX;			            
		}
	}
	else if( srcType==EXTERN_AUDIO&&fmUseInfo.handleState==HANDLE_FREE)
	{
		//halRet=aud_SetCodecPWOnOff(TRUE);	
		if (halRet == DRV_SUCCESS)
		{
			fmUseInfo.handle= (T_ZDrvCodec_Handle)(&fmUseInfo);
			fmUseInfo.useState=CODEC_OPEN;
			fmUseInfo.handleState = HANDLE_IN_USE;						
			*handle =fmUseInfo.handle;
			fmUseInfo.inDev=AUDIO_INPUT_MAX;
			fmUseInfo.outDev=AUDIO_OUTPUT_MAX;							
		}
	}
	else
	{
		halRet = DRV_ERROR;  
		*handle = NULL;	
	}

	codec_Release_Mutex();
		
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec open end handle=%x, srcType=%x,,halRet=%d !\n",*handle,srcType,halRet);
	zOss_Printf(1,1,"codec zDrvCodec_Open end *handle=%x ,srcType = %d,halRet= %d!\n",*handle,srcType,halRet);
	return  halRet;

}

/******************************************************************************
 * Function: zDrvCodec_Close
 * Description: open codec, set parameters.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Close(T_ZDrvCodec_Handle *handle)
{

	SINT32 halRet = DRV_SUCCESS; 
//	UINT8 reg_write = 0;
//	UINT8 reg_mask = 0;	
	T_Codec_UseInfo *codec_info;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec close start *handle=%x !\n",*handle);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec close start voiceUseInfo.handle=%x !\n",voiceUseInfo.handle);
	zOss_Printf(1,1,"codec close start *handle=%x !\n",*handle);
		 
	codec_Claim_Mutex();
	codec_info=(T_Codec_UseInfo *)*handle;

	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if (codec_info->handle==voiceUseInfo.handle&&fmUseInfo.useState == CODEC_IDLE&&audioUseInfo.useState == CODEC_IDLE)
		{
			halRet=aud_SetCodecPWOnOff(FALSE);    
		}
		else if(codec_info->handle==audioUseInfo.handle&&fmUseInfo.useState == CODEC_IDLE&&voiceUseInfo.useState == CODEC_IDLE)
		{
			halRet=aud_SetCodecPWOnOff(FALSE);    
		}
		else if(codec_info->handle==fmUseInfo.handle&&audioUseInfo.useState == CODEC_IDLE&&voiceUseInfo.useState == CODEC_IDLE)
		{
			halRet=aud_SetCodecPWOnOff(FALSE);    
		}		
	}
	else
	{
		codec_Release_Mutex();
		return  DRV_ERROR;
	}
	if (halRet == DRV_SUCCESS)
	{
		codec_info->handle=NULL;
		codec_info->handleState = HANDLE_FREE;
		codec_info->inDev=AUDIO_INPUT_MAX;
		codec_info->outDev=AUDIO_OUTPUT_MAX;				  
	}
	codec_Release_Mutex();

	//*handle=NULL;
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec close end  halRet=%x !\n",halRet);	
	zOss_Printf(1,1,"codec close end  halRet=%x !\n",halRet);
	return  halRet;
}


/******************************************************************************
 * Function: aud_SetCodecPWOnOff
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 aud_SetCodecPWOnOff(BOOL onOff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
    UINT8 regVal[8]={0};
#ifdef CODEC_TEST	
    UINT8 reg_readval[8] = {0};
    UINT8 i = 0;
#endif

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec aud_SetCodecPW OnOff=%x !\n",onOff);
	zOss_Printf(1,1,"codec aud_SetCodecPW OnOff=%x !\n",onOff);
    codec_Claim_Mutex();
	if(onOff)
	{
		/*switch to reg book*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		/*switch to reg page1*/
		reg_write=1;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);    

        *(regVal + 0) = (CODEC_B0_P1_REG1_DISABLE_AVDD_TO_DVDD_VAL&CODEC_B0_P1_REG1_AVDD_TO_DVDD_CTRL_MASK)| \
			(CODEC_B0_P1_REG1_EXT_ANA_AVAILABLE_VAL&CODEC_B0_P1_REG1_EXT_ANA_AVAILABLE_CTRL_MASK);//0x00;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 1, regVal, 1);	

      	*(regVal + 1) = (CODEC_B0_P1_REG122_FINE_VREF_VAL&CODEC_B0_P1_REG122_VREF_CTRL_MASK)| \
			(CODEC_B0_P1_REG122_CHIP_REF_PCTRL_BASEON_OTHER_VAL&CODEC_B0_P1_REG122_CHIP_REF_PUP_CTRL_MASK) |\
			(CODEC_B0_P1_REG122_VREF_FAST_CHARGE_COR_10MS_FINE_30MS_VAL&CODEC_B0_P1_REG122_VREF_FAST_CHARGE_TIME_MASK);//0x01;
     	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 122, regVal+1, 1);

   		*(regVal + 2) = (CODEC_B0_P1_REG33_WRITE_ONLY_VAL&CODEC_B0_P1_REG33_WRITE_ONLY_VAL_MASK)| \
			(CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_EQ_8_VAL&CODEC_B0_P1_REG33_CHARGE_PUMP_CLK_DIV_VAL_CTRL_MASK);//0x28;
     	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 33, regVal+2, 1);

      	*(regVal + 3) = (CODEC_B0_P1_REG35_WRITE_ONLY_VAL&CODEC_B0_P1_REG35_WRITE_ONLY_VAL_MASK)| \
			(CODEC_B0_P1_REG35_CHARGE_PUMP_AUTO_PUP_VAL&CODEC_B0_P1_REG35_CHARGE_PUMP_PCTRL_MASK);//0x10;
     	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 35, regVal+3, 1);

         #if 0
        *(regVal + 4) = (CODEC_B0_P1_REG8_SSTEP_PGA_ENABLE_VAL&CODEC_B0_P1_REG8_SSTEP_PGA_ENABLE_CTRL_MASK)| \
			(CODEC_B0_P1_REG8_NORMAL_MODE_VAL&CODEC_B0_P1_REG8_SSTEP_TIME_CTRL_MASK)| \
			(CODEC_B0_P1_REG8_HP_OUT_EQ_IN_VAL&CODEC_B0_P1_REG8_HP_OUT_VOL_MASK)| \
			(CODEC_B0_P1_REG8_FULLCHIP_IN_0_9V_VAL&CODEC_B0_P1_REG8_FULLCHIP_IN_VOL_MASK)| \
			(CODEC_B0_P1_REG8_REC_OUT_EQ_IN_VAL&CODEC_B0_P1_REG8_REC_OUT_VOL_MASK);//0x00;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 8, regVal+4, 1);

       	*(regVal + 5) = (CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_P3_PTM_P4_VAL&CODEC_B0_P1_REG3_LDAC_MODE_EQ_PTM_CTRL_MASK);//0x00;
       	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 3, regVal+5,1);

       	*(regVal + 6) = (CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_P3_PTM_P4_VAL&CODEC_B0_P1_REG4_RDAC_MODE_EQ_PTM_CTRL_MASK);//0x00;
     	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 4, regVal+6, 1);
        #endif

        reg_write =0x3e;
        codec_I2CWrite(0,1,34,reg_write,0xff);

        reg_write =0x33;
        codec_I2CWrite(0,1,121,reg_write,0x33);

#if 0
#ifdef CODEC_TEST	
		halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 0x21, reg_readval, 1);
		for(i=0;i<1;i++)
		{
		    zOss_Printf(1,1,"codec aud_SetCodecPWOnOff read *(reg_readval+%d (0x21 != 0x28))=%x !\n",i,*(reg_readval+i));
		}
#endif
#endif
              
	}
	else
	{
        //software reset to close power
        reg_write= CODEC_B0_P0_REG1_RESET_VAL;
        reg_mask= CODEC_B0_P0_REG1_RESET_MASK  ;
        halRet =codec_I2CWrite(0, 0, 1,reg_write , reg_mask); 
		zOss_Sleep(1);
	}

	codec_Release_Mutex();
	zOss_Printf(1,1,"codec aud_SetCodecPW OnOff end  halRet=%d !\n",halRet);
	
	return  halRet;
}

/******************************************************************************
 * Function:zDrvCodec_SetProtocal
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetProtocal (T_ZDrvCodec_Handle handle, T_ZDrvCodec_AudioI2SChannel channel, T_ZDrvCodec_AudioI2SMode masterSlave)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_read =0;

//	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;	 
	UINT8 regVal[18]={0};
	UINT8 i = 0;

#ifdef CODEC_TEST	
	UINT8  reg_readval[18]={0};
#endif	

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec zDrvCodec_SetProtocal handle=%x,channel=%x,masterSlave=%x !\n",handle,channel,masterSlave);
	
	codec_Claim_Mutex();
	codec_info=(T_Codec_UseInfo*)  handle;	

	if (codec_info->handleState == HANDLE_IN_USE)
	{
		/*set codec interface control*/
		if(masterSlave==I2S_SLAVE_MODE)
		{

			 // *regVal= CODEC_B0_P4_REG1_ASI1_BUS_I2S_VAL|CODEC_B0_P4_REG1_ASI1_BUS_WORD_16BIT_VAL;/*b0_p4_reg1  i2s mode*/
			*regVal= CODEC_B0_P4_REG1_ASI1_BUS_MONO_PCM_VAL|CODEC_B0_P4_REG1_ASI1_BUS_WORD_16BIT_VAL;/*b0_p4_reg1  pcm mode*/
			*(regVal+1)= CODEC_B0_P4_REG2_ASI1L_DATASLOT_OFFSET_VAL;/*b0_p4_reg2*/
			*(regVal+2)= CODEC_B0_P4_REG3_ASI1R_DATASLOT_OFFSET_VAL;/*b0_p4_reg3*/
			*(regVal+3)= 0x00;//0x00;/*b0_p4_reg4*/
			*(regVal+4)= 0x00;/*b0_p4_reg5*/
			*(regVal+5)= 0x00;/*b0_p4_reg6*/
			*(regVal+6)= 0x01;/*b0_p4_reg7*/
			*(regVal+7)= 0x51;/*b0_p4_reg8*/
			*(regVal+8)= 0x00;/*b0_p4_reg9*/
			*(regVal+9)= CODEC_B0_P4_REG10_WCLK1_INPUT_TO_ASI1_VAL| \
				CODEC_B0_P4_REG10_BCLK1_INPUT_TO_ASI1_VAL;/*b0_p4_reg10*/
			*(regVal+10)=CODEC_B0_P4_REG67_DOUT1_ADO_OUT_VAL| \
				CODEC_B0_P4_REG67_DOUT1_KEEP_DIS_VAL;/*b0_p4_reg67*/
			*(regVal+11)=CODEC_B0_P4_REG68_DIN1_EN_VAL;/*b0_p4_reg68*/

			/*switch to reg book*/
			reg_write = 0;
			halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
			reg_write = 0;
			halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
			/*switch to reg page4*/
			reg_write=4;
			halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);     
			
			halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 1, regVal, 10);

			halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 67, regVal+10, 2);	
		    if (halRet == DRV_SUCCESS)
		    {
				codec_info->masterSlave=I2S_SLAVE_MODE;		 
		    }
				 
		}
		else if(masterSlave==I2S_MASTER_MODE)
		{
			//*regVal= CODEC_B0_P4_REG1_ASI1_BUS_I2S_VAL|CODEC_B0_P4_REG1_ASI1_BUS_WORD_16BIT_VAL;/*b0_p4_reg1*/
			*regVal= CODEC_B0_P4_REG1_ASI1_BUS_MONO_PCM_VAL|CODEC_B0_P4_REG1_ASI1_BUS_WORD_16BIT_VAL;/*b0_p4_reg1  pcm mode*/
			*(regVal+1)= CODEC_B0_P4_REG2_ASI1L_DATASLOT_OFFSET_VAL;/*b0_p4_reg2*/
			*(regVal+2)= CODEC_B0_P4_REG3_ASI1R_DATASLOT_OFFSET_VAL;/*b0_p4_reg3*/
			*(regVal+3)= 0x00;/*b0_p4_reg4*/
			*(regVal+4)= 0x00;/*b0_p4_reg5*/
			*(regVal+5)= 0x00;/*b0_p4_reg6*/
			*(regVal+6)= 0x01;/*b0_p4_reg7*/
			*(regVal+7)= 0x51;/*b0_p4_reg8*/
			*(regVal+8)= 0x00;/*b0_p4_reg9*/
			*(regVal+9)= CODEC_B0_P4_REG10_WCLK1_OUTPUT_FROM_ASI1_VAL|CODEC_B0_P4_REG10_BCLK1_OUTPUT_FROM_ASI1_VAL| \
				CODEC_B0_P4_REG10_PRI_BCLK_WCLK_PDOWN_VAL;/*b0_p4_reg10*/
			*(regVal+10)=CODEC_B0_P4_REG11_ASI1_BDIV_CLKIN_EQ_DAC_MOD_CLK_VAL;/*b0_p4_reg11*/
			//*(regVal+11)=CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_4_VAL|CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_PUP_VAL;/*b0_p4_reg12*//*for pcm fs=8k codec as master*/
			*(regVal+11)=CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_EQ_2_VAL|CODEC_B0_P4_REG12_ASI1_BCLK_NDIV_PUP_VAL;/*b0_p4_reg12*//*for i2s codec as master*/
#if 1
			*(regVal+12)=0xa0;/*b0_p4_reg13*/
			*(regVal+13)=CODEC_B0_P4_REG14_ASI1_BCLK_EQ_ASI1_BCLK_OUTPUT_VAL| \
				CODEC_B0_P4_REG14_ASI1_WCLK_EQ_ASI1_WCLK_OUTPUT_VAL;/*b0_p4_reg14*/
			*(regVal+14)=0x00;/*b0_p4_reg15*/
			*(regVal+15)=0x00;/*b0_p4_reg16*/
#endif
			*(regVal+16)=CODEC_B0_P4_REG67_DOUT1_ADO_OUT_VAL|CODEC_B0_P4_REG67_DOUT1_KEEP_DIS_VAL;/*b0_p4_reg67*/
			*(regVal+17)=CODEC_B0_P4_REG68_DIN1_EN_VAL&CODEC_B0_P4_REG68_DIN1_CTRL_MASK;/*b0_p4_reg68*/

			/*switch to reg book*/
			reg_write = 0;
			halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
			reg_write = 0;
			halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
			/*switch to reg page4*/
			reg_write=4;
			halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1); 

			halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 1, regVal, 16);

		
			halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 67, regVal+16, 2);


			if (halRet == DRV_SUCCESS)
		    {
				codec_info->masterSlave=I2S_MASTER_MODE;	
			}
		}
		else
		{
          	halRet =DRV_ERR_INVALID_PARAM;
	 	}
	}
    else
    {
		halRet =DRV_ERROR;
    }

	codec_Release_Mutex();	
	//zOss_Sleep(50);	


//add by xuxinqiang  

       halRet+=codec_I2CRead(0,4,1,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p4reg1=%x.",reg_read);
       halRet+=codec_I2CRead(0,4,10,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p4reg10=%x.",reg_read);
       halRet+=codec_I2CRead(0,4,12,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p4reg12=%x.",reg_read);

//#ifdef CODEC_TEST
			halRet+=codec_I2CRead(0,4,1,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg1 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,2,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg2 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,3,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg3 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,4,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg4 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,5,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg5 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,6,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg6 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,7,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg7 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,8,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg8 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,9,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg9 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,10,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg10 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,11,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg11 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,12,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg12 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,13,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg13 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,14,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg14 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,15,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg15 reg_read=%x,halRet=%d",reg_read,halRet);
			halRet+=codec_I2CRead(0,4,16,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg16 reg_read=%x,halRet=%d",reg_read,halRet);



			halRet+=codec_I2CRead(0,4,67,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg67 reg_read=%x,halRet=%d",reg_read,halRet);

			halRet+=codec_I2CRead(0,4,68,&reg_read);
                     zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetProtocal  b0_p4_reg68 reg_read=%x,halRet=%d",reg_read,halRet);
//#endif


    
	return  halRet;

}

/******************************************************************************
 * Function:zDrvCodec_SetClock
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetClock (T_ZDrvCodec_Handle handle,   T_ZDrvCodec_AudioSample sample)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_read = 0;
//	UINT8 reg_mask = 0;
	UINT32 tempfs;
	UINT8 i,cur_row=0;
	UINT8 regVal[12]={0};
	UINT8 reg_Val[3]={0};
	UINT8 j=0;
       UINT8 clkset_size=0;
	UINT8 clkreg_Val[]={0x00,0x00,0x21,0x06,0x18,0x16,0x00,0x03,0x0e,0x00,0x00,0x00,0x00,0x00,0x03,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};


        
	T_Codec_UseInfo *codec_info;	 		
    //T_ZDrvCodec_AudioClockIn clkin=CODEC_CLKIN_PLLCLK;
	//T_ZDrvCodec_AudioClockIn clkin=CODEC_CLKIN_MCLK;
		
#ifdef CODEC_TEST	
	UINT8  reg_readval[12]={0};
#endif	

      clkset_size=sizeof(clkreg_Val)/sizeof(UINT8);


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock start Set clk=%x !\n",sample);
	codec_Claim_Mutex();	
	codec_info=(T_Codec_UseInfo*)  handle;
	if (codec_info->handleState == HANDLE_IN_USE)
	{			   
		if(sample==AUDIO_SAMPLE_8K)
		{
			tempfs=8000;
		}
		else if(sample==AUDIO_SAMPLE_16K)
		{
			tempfs=16000;
		}
		else if(sample== AUDIO_SAMPLE_44_1K)
		{
			tempfs=44100;
		}
		else if(sample==AUDIO_SAMPLE_48K)
		{
			tempfs=48000;
		}		
		else
		{
			codec_Release_Mutex();	  
            return  DRV_ERR_INVALID_PARAM;
		}
		//PLLCLK  ref clk

		for(i=0;i<4;i++)
		{
			if(pll_clkDiv[i].fs==tempfs)
			{
				cur_row=i;  
				break;
			}
			if(i>=4)
			{
				codec_Release_Mutex();	  
				return  DRV_ERROR;
			}
		}

		/****************pll clk set****************************/					
		/*Book 0/ Page 0 / Register 6: PLL P_VAL R_VAL*/
		if(pll_clkDiv[cur_row].pll_pdiv==8)
		{
			*regVal=(0& CODEC_B0_P0_REG6_PLL_PDIV_MASK);
		}
		else  
		{
			*regVal=((pll_clkDiv[cur_row].pll_pdiv<<4)& CODEC_B0_P0_REG6_PLL_PDIV_MASK);
		}
		
		if(pll_clkDiv[cur_row].pll_rmulti==16)
		{
			*regVal |=(0& CODEC_B0_P0_REG6_PLL_RMULTI_MASK);
		}
		else
		{
			*regVal |=(pll_clkDiv[cur_row].pll_rmulti& CODEC_B0_P0_REG6_PLL_RMULTI_MASK);
		}
		*regVal |=CODEC_B0_P0_REG6_PLL_PUP_VAL;
		//*regVal |=CODEC_B0_P0_REG6_PLL_PDOWN_VAL;//test for pcm 8k arm i2s as master

		/*Book 0/ Page 0 / Register 7: PLL J_VAL*/
		*(regVal+1)=pll_clkDiv[cur_row].pll_jmulti& CODEC_B0_P0_REG7_PLL_JMULTI_MASK;

		/*Book 0/ Page 0 / Register 8: PLL D_VAL*/
		*(regVal+2)=((pll_clkDiv[cur_row].pll_dval&0xff00)>>8)& CODEC_B0_P0_REG8_PLL_DVAL_MSB_MASK ;

		/*Book 0/ Page 0 / Register 9: PLL D_VAL*/
		*(regVal+3)=(pll_clkDiv[cur_row].pll_dval&0xff)& CODEC_B0_P0_REG9_PLL_DVAL_LSB_MASK ;

		/*Book 0/ Page 0 / Register 10: PLL_CLKIN DIV*/
		if(pll_clkDiv[cur_row].pll_clkin_div==128)		
		{
			*(regVal+4)=0x00&CODEC_B0_P0_REG10_PLL_CLKIN_DIV_MASK;
		}
		else
		{
			*(regVal+4)=pll_clkDiv[cur_row].pll_clkin_div&CODEC_B0_P0_REG10_PLL_CLKIN_DIV_MASK;
		}  

		/*************set dac fs*********************
		*                  start reg P0,reg11
		*******************************************/
		
		/*Book 0/ Page 0 / Register 11: DAC NDAC_VAL*/
		if(pll_clkDiv[cur_row].nda_div==128)		
		{
			*(regVal+5)=(0x00&CODEC_B0_P0_REG11_NDAC_MASK)|CODEC_B0_P0_REG11_NDAC_PUP_VAL;
		}
		else
		{
			*(regVal+5)=(pll_clkDiv[cur_row].nda_div&CODEC_B0_P0_REG11_NDAC_MASK)|CODEC_B0_P0_REG11_NDAC_PUP_VAL;
		}  

		/*Book 0/ Page 0 / Register 12: DAC MDAC_VAL*/
		if(pll_clkDiv[cur_row].mda_div==128)		
		{
			*(regVal+6)=(0x00&CODEC_B0_P0_REG12_MDAC_MASK)|CODEC_B0_P0_REG12_MDAC_PUP_VAL;
		}
		else
		{
			*(regVal+6)=(pll_clkDiv[cur_row].mda_div&CODEC_B0_P0_REG12_MDAC_MASK)|CODEC_B0_P0_REG12_MDAC_PUP_VAL;
		} 

		/*Book 0/ Page 0 / Register 13/14: DAC DOSR_VAL MSB/LSB*/
		if(pll_clkDiv[cur_row].dsor_div==1024)		
		{
			*(regVal+7)=0;//MSB				   
			*(regVal+8)=0;//LSB                    
		}
		else
		{
			*(regVal+7)=((pll_clkDiv[cur_row].dsor_div&0x0300)>>8)&CODEC_B0_P0_REG13_DOSR_MSB_MASK;//MSB				   
			*(regVal+8)=(pll_clkDiv[cur_row].dsor_div&0x00ff)&CODEC_B0_P0_REG14_DOSR_LSB_MASK;//LSB    
		} 

		/**********adc clk********/
		/*Book 0/ Page 0 / Register 18: NADC_VAL*/
		if(pll_clkDiv[cur_row].nad_div==128)		
		{
			*(regVal+9)=(0x00&CODEC_B0_P0_REG18_NADC_MASK)|CODEC_B0_P0_REG18_NADC_PUP_VAL;
		}
		else
		{
			*(regVal+9)=(pll_clkDiv[cur_row].nad_div&CODEC_B0_P0_REG18_NADC_MASK)|CODEC_B0_P0_REG18_NADC_PUP_VAL;
	    }  
		/*Book 0/ Page 0 / Register 19: MADC_VAL*/
		if(pll_clkDiv[cur_row].mad_div==128)		
		{
			*(regVal+10)=(0x00&CODEC_B0_P0_REG19_MADC_MASK)|CODEC_B0_P0_REG19_MADC_PUP_VAL;
		}
		else
		{
			*(regVal+10)=(pll_clkDiv[cur_row].mad_div&CODEC_B0_P0_REG19_MADC_MASK)|CODEC_B0_P0_REG19_MADC_PUP_VAL;
		} 
		/*Book 0/ Page 0 / Register 20: ADC AOSR_VAL*/
		if(pll_clkDiv[cur_row].asor_div==256)		
		{
			*(regVal+11)=0;			   
              }
		else
		{
			*(regVal+11)=(pll_clkDiv[cur_row].asor_div&CODEC_B0_P0_REG20_AOSR_MASK);		   
	    }    

//set pll
		/*switch to reg book*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		/*switch to reg page0*/
		reg_write=0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);     


		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 6, regVal, 1);
		//zOss_Sleep(500);
		
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 7, regVal+1, 4);
		//zOss_Sleep(10);
//#ifdef CODEC_TEST
		#if 0
		halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 6, reg_readval, 5);
		for(j=0;j<5;j++)
		{
			zOss_Printf(1,1,"codec zDrvCodec_SetClock read  *(reg_readval+%d)=%x !\n",j,*(reg_readval+j));
		}
		#else
		halRet+=codec_I2CRead(0,0,6,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg6 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,7,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg7 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,8,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg8 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,9,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg9 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,10,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg10 reg_read=%x,halRet=%d",reg_read,halRet);
		#endif
//#endif	

//set dac 
		/*switch to reg book*/
		//reg_write = 0;
		//halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		//reg_write = 0;
		//halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		reg_write = 0;   
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  	/*B0_P0_R0: set to page 0*/ 
		
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 11, regVal+5, 1);
		//zOss_Sleep(10);
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 12, regVal+6, 1);
		//zOss_Sleep(10);
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 13, regVal+7, 2);
		//zOss_Sleep(10);
//set dac 
		/*switch to reg book*/
		//reg_write = 0;
		//halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		//reg_write = 0;
		//halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		reg_write = 0;   
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  	/*B0_P0_R0: set to page 0*/ 

		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 18, regVal+9, 1);
		//zOss_Sleep(10);
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 19, regVal+10, 1);
		//zOss_Sleep(10);		
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 20, regVal+11, 1);	



		*reg_Val=(CODEC_B0_P0_REG4_ADC_CLKIN_PLL_CLK_VAL& CODEC_B0_P0_REG4_ADC_CLKIN_MASK)| \
		(CODEC_B0_P0_REG4_DAC_CLKIN_PLL_CLK_VAL& CODEC_B0_P0_REG4_DAC_CLKIN_MASK);

		//*reg_Val=(CODEC_B0_P0_REG4_ADC_CLKIN_BCLK1_VAL& CODEC_B0_P0_REG4_ADC_CLKIN_MASK)| \
		//(CODEC_B0_P0_REG4_DAC_CLKIN_BCLK1_VAL& CODEC_B0_P0_REG4_DAC_CLKIN_MASK);//test for pcm 8k arm i2s as master
		*(reg_Val+1)=((CODEC_B0_P0_REG5_PLL_CLKRANGE_LOW_VAL&CODEC_B0_P0_REG5_PLL_CLKRANGE_MASK) | \
			(CODEC_B0_P0_REG5_PLL_CLKIN_MCLK1_VAL&CODEC_B0_P0_REG5_PLL_CLKIN_MASK));
		//*(reg_Val+1)=((CODEC_B0_P0_REG5_PLL_CLKRANGE_LOW_VAL&CODEC_B0_P0_REG5_PLL_CLKRANGE_MASK) | \
			//(CODEC_B0_P0_REG5_PLL_CLKIN_BCLK1_VAL&CODEC_B0_P0_REG5_PLL_CLKIN_MASK));
				

		/*switch to reg page0*/
		reg_write=0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);     

		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 4, reg_Val, 2);

        reg_write = 0x04;
		halRet += codec_I2CWrite(0,4,65,reg_write,0x3c); 
        
//	#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,11,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg11 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,0,12,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg12 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,0,13,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg13 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,0,14,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg14 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,18,&reg_read);
	        //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg18 reg_read=%x,halRet=%d",reg_read,halRet);
	        	zOss_Printf(1,1,"codec zDrvCodec_SetClock  b0_p0_reg18 reg_read=%x,halRet=%d",reg_read,halRet);

				
		halRet+=codec_I2CRead(0,0,19,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg19 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,0,20,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg20 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,4,65,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p4_reg65 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,4,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg4 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,5,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock  b0_p0_reg5 reg_read=%x,halRet=%d",reg_read,halRet);
//	#endif

        if (halRet == DRV_SUCCESS)
		{
			codec_info->sampleRate=sample;	
		}
		
	}	
    else
    {
		halRet =DRV_ERROR;
    }	
	codec_Release_Mutex();	  
	//zOss_Sleep(50);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetClock end halRet=%d !\n",halRet);


#if 0
//add by xuxinqiang  
       halRet+=codec_I2CRead(0,0,5,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg5=%d.",reg_read);


       reg_write=0x40;
       halRet=codec_I2CWrite(0,0,5,reg_write,0xff);
       
       halRet+=codec_I2CRead(0,0,5,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg5 end=%d.",reg_read);
    


	reg_write = 0;
      halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/

      //8kfs
      halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 4, clkreg_Val, clkset_size);

       halRet+=codec_I2CRead(0,0,5,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg5 end2=%d,clkset_size=%d.",reg_read,clkset_size);
  #endif   


//add by xuxinqiang  

       halRet+=codec_I2CRead(0,0,4,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg4=%x.",reg_read);
       halRet+=codec_I2CRead(0,0,5,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg5=%x.",reg_read);
           halRet+=codec_I2CRead(0,0,6,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg6=%x.",reg_read);
               halRet+=codec_I2CRead(0,0,7,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg7=%x.",reg_read);
           halRet+=codec_I2CRead(0,0,8,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg8=%x.",reg_read);
           halRet+=codec_I2CRead(0,0,9,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg9=%x.",reg_read);
           halRet+=codec_I2CRead(0,0,10,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk b0p0reg10=%x.",reg_read);

       reg_write=0x33;
       halRet=codec_I2CWrite(0,0,4,reg_write,0xff);

    

       halRet+=codec_I2CRead(0,0,4,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set clk 2 b0p0reg4=%x.",reg_read);

  
	return  halRet;

}

/******************************************************************************
 * Function:zDrvCodec_Reset 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Reset (T_ZDrvCodec_Handle handle)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	UINT8 reg_read = 0;
	UINT8 regVal[2]={0};
	UINT8  reg_readval[2]={0};
	T_Codec_UseInfo *codec_info;
	
	codec_Claim_Mutex();
	codec_info=(T_Codec_UseInfo*)  handle;

	if (codec_info->handleState == HANDLE_IN_USE)
	{
		#if 0
		
		#else
		//soft reset
		reg_write = CODEC_B0_P0_REG1_RESET_VAL;
		reg_mask = CODEC_B0_P0_REG1_RESET_MASK;

		halRet=codec_I2CWrite(0,0,1,reg_write,reg_mask);
		zOss_Printf(1,1,"codec zDrvCodec_Reset halRet=%d,reg_write=%d!\n",halRet,reg_write);

		halRet+=codec_I2CRead(0,0,1,&reg_read);
		zOss_Printf(1,1,"codec zDrvCodec_Reset halRet=%d,reg_read=%d!\n",halRet,reg_read);
		
		#endif
		if (halRet == DRV_SUCCESS)
              {	
		    codec_info->useState=CODEC_RESET;
			codec_info->inDev=AUDIO_INPUT_MAX;
			codec_info->outDev=AUDIO_OUTPUT_MAX;		
	       }
    }
    else
    {
    	halRet =DRV_ERROR;
    }	
	codec_Release_Mutex();	

	return  halRet;				
}

/******************************************************************************
 * Function:zDrvCodec_SetInPath 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInPath (T_ZDrvCodec_Handle handle,  T_ZDrvCodec_InDevice dev, BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write=0,i=0;
    UINT8 reg_mask =0;
    UINT8 reg_read = 0;
	UINT8  *reg_val,*reg_valmask;
	UINT8  reg_oldval[14]={0};
	#ifdef CODEC_TEST	
	UINT8  reg_readval[8]={0};
	#endif	
	T_Codec_UseInfo *codec_info;
	    
	codec_Claim_Mutex();

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath dev=%x,onoff=%x  !\n",dev,onoff);

    
	codec_info=(T_Codec_UseInfo*)  handle;
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if (codec_info->inDev==dev)
		{
			codec_info->inDev=dev;
			codec_Release_Mutex();
			return  halRet;
		}
		if(onoff)
		{
		    if(dev==AUDIO_INPUT_HANDSET)
   			{
				reg_val=handsetInPathPara;
                //reg_val=headsetInPathPara;
			}
			else if(dev==AUDIO_INPUT_SPEAKER)
			{
		    	reg_val=speakerInPathPara;
			}
			else if(dev==AUDIO_INPUT_HEADSET)
			{
		    	reg_val=headsetInPathPara;
			}
			else
			{
				codec_Release_Mutex();		
				return  DRV_ERR_INVALID_PARAM;
			}	
//add by xuxinqiang for test
		    	//reg_val=headsetInPathPara;
		    	reg_val=handsetInPathPara;

            
		}
		else
		{
			reg_val=inPathResetPara;
		}
		reg_valmask=inPathParaMask;

		/*switch to reg book*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		/*switch to reg page1*/
		reg_write = 1;	
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	
		//zOss_Printf(1,1,"codec SetInPath dev=%x !\n",dev);

		/*write next 9 reg, page1 start reg52*/
	    if (onoff)
	    {
           	halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 52, reg_oldval, 9);	
	        if (halRet==DRV_SUCCESS)
	        {		   
			   	for(i=0;i<9;i++)
			   	{
			   		reg_val[i]&=reg_valmask[i];
	                            reg_val[i]|= reg_oldval[i]&(~reg_valmask[i]);
			   	}
	        }
		}
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 52, reg_val, 9);

		/*write next 3 reg,page0  start reg81*/
		reg_write=0;
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 0  
	    if (onoff)
	    {
                halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 81, reg_oldval+9, 4);	
	         if (halRet==DRV_SUCCESS)
	         {		   
        		   for(i=0;i<4;i++)
        		   {
    		   	       reg_val[i+9]&=reg_valmask[i+9];
                            reg_val[i+9]|= reg_oldval[i+9]&(~reg_valmask[i+9]);
    		          }
	         }
	     }
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 81, reg_val+9, 4);
       
		/*B0_P0_R61 ADC Processing Block Control: set to PRB_R1*/
		reg_write = 0x01;
          	reg_mask = 0x1f;
          	halRet +=codec_I2CWrite(0,0,61,reg_write,reg_mask);
            
              zOss_ASSERT(halRet == DRV_SUCCESS);

		if(halRet==DRV_SUCCESS)
		{
			if(onoff)
			{	
				codec_info->inDev=dev;
			}
			else
			{
				codec_info->inDev= AUDIO_INPUT_MAX;		
			}
		}
	}
    else
    {
		halRet =DRV_ERROR;
    }	


		halRet+=codec_I2CRead(0,1,52,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg52 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,53,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg53 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,54,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg54 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,55,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg55 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,56,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg56 reg_read=%x,halRet=%d",reg_read,halRet);
            
		halRet+=codec_I2CRead(0,1,57,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg57 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,58,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg58 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,59,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg59 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,1,60,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p1_reg60 reg_read=%x,halRet=%d",reg_read,halRet);


		halRet+=codec_I2CRead(0,0,81,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p0_reg81 reg_read=%x,halRet=%d",reg_read,halRet);
            
		halRet+=codec_I2CRead(0,0,82,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p0_reg82 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,83,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p0_reg83 reg_read=%x,halRet=%d",reg_read,halRet);
		
		halRet+=codec_I2CRead(0,0,84,&reg_read);
	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetInPath  b0_p0_reg84 reg_read=%x,halRet=%d",reg_read,halRet);
		



    
	codec_Release_Mutex();
   

	return  halRet;		
}

/******************************************************************************
 * Function:zDrvCodec_SetOutPath 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOutPath (T_ZDrvCodec_Handle handle,  T_ZDrvCodec_OutDevice dev, BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
    UINT8 reg_write = 0,i=0;
    UINT8 reg_mask = 0;
	UINT8 reg_read = 0;	
	UINT8 j=0;
    UINT8  *reg_val,*reg_valmask;
    UINT8  reg_oldval[18]={0};
	T_Codec_UseInfo *codec_info;	
//    T_ZDrvCodec_Handle handleTemp=handle;
	#ifdef CODEC_TEST	
	UINT8  reg_readval[20]={0};
	#endif	

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec SetOutPath handle=%x,dev=%x,onoff=%x !\n",handle,dev,onoff);
			   
	codec_Claim_Mutex();	
	codec_info=(T_Codec_UseInfo*)  handle;			 
	if (codec_info->handleState == HANDLE_IN_USE)
	{
            if (codec_info->outDev==dev)
            {
                codec_info->outDev=dev;
                codec_Release_Mutex();
                return  halRet;
            }
            if (onoff)
            {
	              if(dev==AUDIO_OUTPUT_RECEIVER )
			{
                            reg_val=receiverOutPathPara;
                            //reg_val=receiverOutPathPara; 
				//reg_val=headsetOutPathPara; 			
				//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath receiver switch to headset!\n");
			}
			else if(dev==AUDIO_OUTPUT_SPEAKER)
			{                   	
            	reg_val=speakerOutPathPara;
                            //reg_val=headsetOutPathPara; 	
			}
			else if(dev==AUDIO_OUTPUT_HEADSET)
			{
				reg_val=headsetOutPathPara; 
			}
			else if(dev==AUDIO_OUTPUT_HEADSET_SPEAKER)
			{
				reg_val=headsetSpkOutPathPara; 
			}
			else if(dev==AUDIO_OUTPUT_HEADSET_SPEAKER)
			{
				reg_val=bluetoothOutPathPara; 
			}
			else if(dev==AUDIO_OUTPUT_FM_ANATODIG_SPEAKER)
			{
				reg_val=speakerFMDigitalOutPathPara;		                      
			}
			else if(dev==AUDIO_OUTPUT_FM_ANATODIG_HEADSET)
			{						  
				reg_val=headsetFMDigitalOutPathPara;	
                     }
			else
			{
				codec_Release_Mutex();		
                            return  DRV_ERR_INVALID_PARAM;
			}
//add by xuxinqiang for test
				reg_val=headsetOutPathPara; 
				//reg_val=speakerOutPathPara;


            
		}
		else
		{
			reg_val=outPathResetPara;
		}	
		reg_valmask=outPathParaMask;
		//write first 4 reg, page0 start reg63
		/*switch to reg book*/
		reg_write = 0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
		reg_write = 0;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
		/*switch to reg page0*/
		reg_write=0;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);     
		if (onoff)
		{
			halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 63, reg_oldval, 4);	
			if (halRet==DRV_SUCCESS)
			{		   
				for(i=0;i<4;i++)
				{
					reg_val[i]&=reg_valmask[i];			   	
					reg_val[i]|= reg_oldval[i]&(~reg_valmask[i]);
				}
			}
		}
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 63, reg_val, 4);	

		//write next 2 reg,page1  start reg8
		reg_write=1;
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 1  
		if (onoff)
		{
			halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 8, reg_oldval+4, 2);	
			if (halRet==DRV_SUCCESS)
			{		   
				for(i=0;i<2;i++)
				{
					reg_val[i+4]&=reg_valmask[i+4];			   	
					reg_val[i+4]|= reg_oldval[i+4]&(~reg_valmask[i+4]);
				}
			}
		}
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 8, reg_val+4, 2);		

		//write next 6 reg,page1  start reg27
		reg_write=1;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 1  
		if (onoff)
		{
			halRet += zDrvI2c_DevRead(&s_codecI2CDev, 27, reg_oldval+6, 6);	
			if (halRet==DRV_SUCCESS)
			{		   
				for(i=0;i<6;i++)
				{
					reg_val[i+6]&=reg_valmask[i+6];			   	
					reg_val[i+6]|= reg_oldval[i+6]&(~reg_valmask[i+6]);
				}
			}
		}
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 27, reg_val+6, 6);

		//write next 4 reg,page1  start reg45
		reg_write=1;
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 1  
		if (onoff)
		{
			halRet += zDrvI2c_DevRead(&s_codecI2CDev, 45, reg_oldval+12, 4);	
			if (halRet==DRV_SUCCESS)
			{		   
				for(i=0;i<4;i++)
				{
					reg_val[i+12]&=reg_valmask[i+12];			   	
					reg_val[i+12]|= reg_oldval[i+12]&(~reg_valmask[i+12]);
				}
			}
		}
		halRet += zDrvI2c_DevWrite(&s_codecI2CDev, 45, reg_val+12, 4);

		/*B0_P0_R60 DAC Processing Block Control: set to PRB_P1*/
      	reg_write = 0x01;
      	reg_mask = 0x1f;
     	halRet +=codec_I2CWrite(0,0,60,reg_write,reg_mask);	 //B0_P0_R60

       	zOss_ASSERT(halRet == DRV_SUCCESS);

        
	//#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,63,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p0_reg63 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,64,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p0_reg64 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,65,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p0_reg65 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,66,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p0_reg66 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,1,8,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg8 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,1,9,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg9 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,1,27,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg27 reg_read=%x,halRet=%d",reg_read,halRet);
				
		halRet+=codec_I2CRead(0,1,28,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg28 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,29,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg29 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,30,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg30 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,31,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg31 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,32,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg32 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,45,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg45 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,46,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg46 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,47,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg47 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,1,48,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p1_reg48 reg_read=%x,halRet=%d",reg_read,halRet);

		halRet+=codec_I2CRead(0,0,60,&reg_read);
	       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetOutPath  b0_p0_reg60 reg_read=%x,halRet=%d",reg_read,halRet);
	//#endif	
	
		if(halRet==DRV_SUCCESS)
		{
			if(onoff)
			{	
				codec_info->outDev=dev;
			}
			else
			{
				codec_info->outDev= AUDIO_OUTPUT_MAX;		
			}
		}
#if 0
        if(dev==AUDIO_OUTPUT_RECEIVER )
	    {
            reg_write = 0x47;
            reg_mask = 0xff;
            halRet +=codec_I2CWrite(0,1,22,reg_write,reg_mask);	 //B0_P1_R22
            			
            //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath receiver additional register!\n");

            reg_write = 0x0;
            reg_mask = 0xff;
            halRet +=codec_I2CWrite(0,1,27,reg_write,reg_mask);	 //B0_P1_R27

            reg_write = 0x0;
            reg_mask = 0x3F;
            halRet +=codec_I2CWrite(0,1,36,reg_write,reg_mask);	 //B0_P1_R36

            reg_write = 0x0;
            reg_mask = 0x3F;
            halRet +=codec_I2CWrite(0,1,37,reg_write,reg_mask);	 //B0_P1_R37

            reg_write = 0xdd;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,40,reg_write,reg_mask);	 //B0_P1_R40

            reg_write = 0x80;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,41,reg_write,reg_mask);	 //B0_P1_R41

            reg_write = 0x0;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,42,reg_write,reg_mask);	 //B0_P1_R42
		}

        if(dev == AUDIO_OUTPUT_SPEAKER)
        {
            reg_write = 0xe3;
            reg_mask = 0xff;
            halRet +=codec_I2CWrite(0,1,22,reg_write,reg_mask);	 //B0_P1_R22

            reg_write = 0x0;
            reg_mask = 0xff;
            halRet +=codec_I2CWrite(0,1,27,reg_write,reg_mask);	 //B0_P1_R27

            reg_write = 0x7f;
            reg_mask = 0x3F;
            halRet +=codec_I2CWrite(0,1,36,reg_write,reg_mask);	 //B0_P1_R36

            reg_write = 0x7f;
            reg_mask = 0x3F;
            halRet +=codec_I2CWrite(0,1,37,reg_write,reg_mask);	 //B0_P1_R37

            reg_write = 0x39;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,40,reg_write,reg_mask);	 //B0_P1_R40

            reg_write = 0x80;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,41,reg_write,reg_mask);	 //B0_P1_R41

            reg_write = 0x0;
            reg_mask = 0xFF;
            halRet +=codec_I2CWrite(0,1,42,reg_write,reg_mask);	 //B0_P1_R42
        }
#endif
#if 0
	//set fm input channel
	if(dev==AUDIO_OUTPUT_FM_ANATODIG_HEADSET||dev==AUDIO_OUTPUT_FM_ANATODIG_SPEAKER)
	{
		halRet+=codec_SetFmInPath(handleTemp,onoff);		
	}
#endif
    }
    else
    {
		halRet =DRV_ERROR;
    }	

	codec_Release_Mutex();
	
    return  halRet;		
}

/******************************************************************************
 * Function: zDrvCodec_AudioEnable 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_AudioEnable(T_ZDrvCodec_Handle handle)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	UINT8 reg_read =0;

#ifdef CODEC_TEST	
	UINT8  reg_readval[3]={0};
#endif	
		
	T_Codec_UseInfo *codec_info;	   
   
	codec_Claim_Mutex();

   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_AudioEnable !\n");
 
	codec_info=(T_Codec_UseInfo*)  handle;			

	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if (codec_info->useState==CODEC_ENABLE)
		{
			codec_info->useState=CODEC_ENABLE;
                     codec_Release_Mutex();
                     return  halRet;
              }
		if(codec_info->inDev!=AUDIO_INPUT_MAX)   
		{
			//input path	
            
              	reg_write=CODEC_B0_P0_REG82_LEFT_ADC_UNMUTE_VAL|CODEC_B0_P0_REG82_RIGHT_ADC_UNMUTE_VAL;
             	       reg_mask=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_CTRL_MASK|CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_CTRL_MASK;
               	halRet +=codec_I2CWrite(0,0,82,reg_write,reg_mask);	
        	       #ifdef CODEC_TEST

        		halRet+=codec_I2CRead(0,1,51,&reg_read);
	              zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_AudioEnable indev  b0_p1_reg51 reg_read=%x,halRet=%d",reg_read,halRet);

                   
        		halRet+=codec_I2CRead(0,0,82,&reg_read);
	              zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_AudioEnable indev  b0_p0_reg82 reg_read=%x,halRet=%d",reg_read,halRet);
                   
        		#endif

                	if (halRet != DRV_SUCCESS)
                	{
        		    codec_Release_Mutex(); 		  
          	           return  DRV_ERROR;
       	       }
		}
		if(codec_info->outDev!=AUDIO_OUTPUT_MAX)   
		{
        	    	//output path
        	    	/*B0_P0_R118 ADC/DAC Data Port Control*/
                	reg_write = CODEC_B0_P4_REG118_DAC_ASI1_OUTPUT_VAL|CODEC_B0_P4_REG118_WRITE_ONLY_VAL|CODEC_B0_P4_REG118_ADC_DATA_OUTPUT_LANDR_INDEP_VAL;/*0x06;*/
                  	reg_mask = CODEC_B0_P4_REG118_DAC_DATA_INPUT_CONFIG_CTRL_MASK|CODEC_B0_P4_REG118_WRITE_ONLY_MASK|CODEC_B0_P4_REG118_ADC_DATA_OUTPUT_CONFIG_CTRL_MASK;/*0x3f;*/
                  	halRet +=codec_I2CWrite(0,4,118,reg_write,reg_mask);
                    
                 	reg_write=CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL;
                	reg_mask=CODEC_B0_P0_REG64_DAC_LCHN_MUTE_CTRL_MASK|CODEC_B0_P0_REG64_DAC_RCHN_MUTE_CTRL_MASK;
                	halRet=codec_I2CWrite(0,0,64,reg_write,reg_mask);
    			
        		#ifdef CODEC_TEST
        			halRet+=codec_I2CRead(0,0,64,&reg_read);
	              zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_AudioEnable outdev b0_p0_reg64 reg_read=%x,halRet=%d",reg_read,halRet);
        		#endif
			
			if(halRet!=DRV_SUCCESS)
			{				   
				codec_Release_Mutex();
                            zOss_ASSERT(halRet == DRV_SUCCESS);
				return  DRV_ERROR;
			}
		}
		codec_info->useState= CODEC_ENABLE;	
    }
    else
    {
		halRet =DRV_ERROR;
    }	
	codec_Release_Mutex();


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_AudioEnable end.");

#if 0
       halRet+=codec_I2CRead(0,1,51,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable micbias before set reg value=%x.",reg_read);
       reg_write=0x06;
       halRet=codec_I2CWrite(0,1,51,reg_write,0xff);
       
       halRet+=codec_I2CRead(0,1,51,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable micbias after set reg value=%x.",reg_read);
#endif


#if 1
       halRet+=codec_I2CRead(0,4,4,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable read b0_p4_reg4 value=%x.",reg_read);

       
       halRet+=codec_I2CRead(0,4,7,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable read b0_p4_reg7 value=%x.",reg_read);

           halRet+=codec_I2CRead(0,0,81,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable read b0_p0_reg81 value=%x.",reg_read);


           halRet+=codec_I2CRead(0,1,27,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable read b0_p1_reg27 value=%x.",reg_read);

       //reg_write=0x33;
       //halRet=codec_I2CWrite(0,1,27,reg_write,0xff);//set headset ok
       
       //halRet+=codec_I2CRead(0,1,27,&reg_read);
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable  after b0_p1_reg27 value value=%x.",reg_read);




    
       halRet+=codec_I2CRead(0,1,32,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec enable read b0_p1_reg32 value=%x.",reg_read);
    
#endif

    
	
	return  halRet;	
}

/******************************************************************************
 * Function: zDrvCodec_AudioDisable 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_AudioDisable(T_ZDrvCodec_Handle handle)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
#ifdef CODEC_TEST	
	UINT8  reg_readval[3]={0};
#endif	
#if 1	
	T_Codec_UseInfo *codec_info;	   

    zOss_Printf(1,1,"codec zDrvCodec_Audiodisable start  handle=%x !\n",handle);
	   
    codec_Claim_Mutex();
	codec_info=(T_Codec_UseInfo*)  handle;			
#if 0
    if(codec_info->useState!= CODEC_ENABLE)
    {
          codec_Release_Mutex();   
          return  halRet;
	}
#endif	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if (codec_info->useState==CODEC_DISABLE)
		{
			codec_info->useState=CODEC_DISABLE;
            codec_Release_Mutex();
            return  halRet;
        }
		if(codec_info->inDev!=NULL)   
		{
			//input path
			reg_write=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_VAL ;
			reg_mask=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_CTRL_MASK;
			halRet +=codec_I2CWrite(0,0,82,reg_write,reg_mask);	

			reg_write=CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_VAL ;
			reg_mask=CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_CTRL_MASK;
			halRet +=codec_I2CWrite(0,0,82,reg_write,reg_mask);	

			reg_write=CODEC_B0_P1_REG51_MICBIAS_PDOWN_VAL;
			reg_mask=CODEC_B0_P1_REG51_MICBIAS_OUT_CTRL_MASK;
			halRet =codec_I2CWrite(0,1,46,reg_write,reg_mask);

			if (halRet != DRV_SUCCESS)
			{
				codec_Release_Mutex();
				return  DRV_ERROR;
			}
		}
        if (codec_info->outDev!=NULL)
        {
			//output path
			reg_write=CODEC_B0_P0_REG64_DAC_LCHN_MUTE_VAL;
			reg_mask=CODEC_B0_P0_REG64_DAC_LCHN_MUTE_CTRL_MASK;
            halRet=codec_I2CWrite(0,0,64,reg_write,reg_mask);
		#ifdef CODEC_TEST
            halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 64, reg_readval, 1);
	    #endif
			
            reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_MUTE_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_MUTE_VAL;
            reg_mask=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_MASK|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_MASK;
            halRet=codec_I2CWrite(0,1,48,reg_write,reg_mask);
            reg_write=CODEC_B0_P1_REG31_HPL_DRV_MUTE_VAL;
            reg_mask=CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_MASK;
            halRet=codec_I2CWrite(0,1,31,reg_write,reg_mask);

			if (halRet != DRV_SUCCESS)
			{
				codec_Release_Mutex(); 		  
                return  DRV_ERROR;
		    }
		}
      	codec_info->useState= CODEC_DISABLE;
    }
    else
    {
		halRet =DRV_ERROR;
    }	
		codec_Release_Mutex();
#endif
    zOss_Printf(1,1,"codec zDrvCodec_Audiodisable end  !\n");
		  
	return  halRet;	
}	

/******************************************************************************
 * Function: zDrvCodec_Set_ClsD_Vol
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_ClsD_Vol (T_ZDrvCodec_Handle handle,  T_ZDrvCodec_ClsD_Vol vol) 
{
	SINT32 halRet =DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	codec_Claim_Mutex();
	//Page 1 / Register 42: SPK Driver
	/*B0_P1_REG48*/  
	if(vol==CLSD_GAIN_PLUS_6DB)
	{
		reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_6DB_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_6DB_VAL;
	}
	else if(vol==CLSD_GAIN_PLUS_12DB)
	{
		reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_12DB_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_12DB_VAL;
	}		 	
	else if(vol==CLSD_GAIN_PLUS_18DB)
	{
		reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_18DB_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_18DB_VAL;
	}		 	
	else if(vol==CLSD_GAIN_PLUS_24DB)	 	
	{
		reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_24DB_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_24DB_VAL;
	}  
	else if(vol==CLSD_GAIN_PLUS_30DB)	 	
	{
		reg_write=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_30DB_VAL|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_30DB_VAL;
	}  
	else
	{
		codec_Release_Mutex();		  
        return  DRV_ERROR;
	}		  	
	reg_mask=CODEC_B0_P1_REG48_SPKL_VOL_CTRL_MASK|CODEC_B0_P1_REG48_SPKR_VOL_CTRL_MASK;

	halRet=codec_I2CWrite(0,1,48,reg_write,reg_mask);					
			
	codec_Release_Mutex();
		  
	return  halRet;	
}	

/******************************************************************************
 * Function: zDrvCodec_Set_ClsAB_Vol
 * Description: 
 * Parameters:
 *   Input:
 *    vol: nuit db
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_ClsAB_Vol (T_ZDrvCodec_Handle handle,  UINT8 vol) 
{
	SINT32 halRet =DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	codec_Claim_Mutex();
	if(vol<=9)
	{
		reg_write =vol;
	}
	else
	{
		codec_Release_Mutex();		  
        return  DRV_ERROR;
	}
    reg_mask=CODEC_B0_P1_REG31_HPL_DRV_VOL_CTRL_MASK;
	halRet=codec_I2CWrite(0,1,31,reg_write,reg_mask);				 

    reg_mask=CODEC_B0_P1_REG32_HPR_DRV_VOL_CTRL_MASK;
	halRet=codec_I2CWrite(0,1,32,reg_write,reg_mask);	
		  
	codec_Release_Mutex();		  
	return  halRet;	
}	


/******************************************************************************
 * Function: zDrvCodec_Set_Outpath_Ana_Vol
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Outpath_Ana_Vol (T_ZDrvCodec_Handle handle,  SINT8 vol)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;	  

	codec_Claim_Mutex();
		 
	if(vol>127||vol<0)	  
	{
		codec_Release_Mutex();		 
        return  DRV_ERROR;
	}	
	codec_info=(T_Codec_UseInfo*)  handle;			 

	reg_write=vol;			   
	if(codec_info->outDev==AUDIO_OUTPUT_RECEIVER ||codec_info->outDev==AUDIO_OUTPUT_SPEAKER)
	{
        reg_mask=CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,46,reg_write,reg_mask);
		
        reg_mask=CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKR_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,47,reg_write,reg_mask);
	}
	else if(codec_info->outDev==AUDIO_OUTPUT_HEADSET)
	{
		reg_mask=CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,28,reg_write,reg_mask);
			   
        reg_mask=CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MASK;
		halRet+=codec_I2CWrite(0,1,29,reg_write,reg_mask);
	}
	else if(codec_info->outDev==AUDIO_OUTPUT_HEADSET_SPEAKER)
	{
        reg_mask=CODEC_B0_P1_REG46_LOL_ROUTE_TO_SPKL_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,46,reg_write,reg_mask);
		
        reg_mask=CODEC_B0_P1_REG47_LOR_ROUTE_TO_SPKR_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,47,reg_write,reg_mask);
			   
		reg_mask=CODEC_B0_P1_REG28_LOL_ROUTE_TO_HPL_VOL_CTRL_MASK;
		halRet+=codec_I2CWrite(0,1,28,reg_write,reg_mask);
			   
        reg_mask=CODEC_B0_P1_REG29_LOR_ROUTE_TO_HPR_VOL_CTRL_MASK;
		halRet+=codec_I2CWrite(0,1,29,reg_write,reg_mask);

    }
    else
    {
		halRet =DRV_ERROR;
    }
	codec_Release_Mutex();

	return  halRet;	
}	

/******************************************************************************
 * Function: zDrvCodec_Set_Inpath_Ana_Vol 
 * Description: 
 * Parameters:
 *   Input:Vol 0~59.5db
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Inpath_Ana_Vol (T_ZDrvCodec_Handle handle,  SINT8 vol) 

{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	   
	T_Codec_UseInfo *codec_info;		

	codec_Claim_Mutex();
	if(vol>59.5||vol<0)	  
	{
		codec_Release_Mutex();		 
		return  DRV_ERROR;
	}
	codec_info=(T_Codec_UseInfo*)  handle;	
	reg_write=vol*2;		   
	if(codec_info->inDev== AUDIO_INPUT_HANDSET ||codec_info->inDev==AUDIO_INPUT_SPEAKER||codec_info->inDev==AUDIO_OUTPUT_HEADSET)
	{
		reg_mask=CODEC_B0_P1_REG59_LEFT_MIC_PGA_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,59,reg_write,reg_mask);
		reg_mask=CODEC_B0_P1_REG60_RIGHT_MIC_PGA_VOL_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,60,reg_write,reg_mask);
	}
    else
    {
		halRet = DRV_ERROR;
    }	

	codec_Release_Mutex();		  
	return  halRet;	
}	

/******************************************************************************
 * Function: zDrvCodec_Set_Outpath_Dig_Vol
 * Description: 
 * Parameters:
 *   Input: 
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Outpath_Dig_Vol (T_ZDrvCodec_Handle handle,  T_ZDrvCodec_OutPath_Digital_Gain outvol) 
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	UINT8 reg_read = 0;
	SINT8 voltemp = 0;
    SINT8 vol=0;

   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Outpath_Dig_Vol start handle=%x,outvol=%d",handle,outvol);
	
	codec_Claim_Mutex();
		
	if(outvol!=CODEC_OUTPATH_DIG_GAIN_MAX)
	{
		vol=24-outvol*3;
	}

	//vol 24db~-63.5db.
    if (vol>24||vol<-63)
	{
		codec_Release_Mutex();		  
        return  DRV_ERR_INVALID_PARAM;
	}
		
	if(vol>=0)
	{
		voltemp=vol*2;          	
	}
	else 
	{
		voltemp=(0-vol)*2;    
		voltemp=((~voltemp)+1)|0x80;          	
	}	
			  
	reg_write=voltemp;
	reg_mask=CODEC_B0_P0_REG65_DAC_LCHN_VOL_MASK; 
	halRet=codec_I2CWrite(0,0,65,reg_write,reg_mask);
    
	//#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,65,&reg_read);
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Outpath_Dig_Vol read b0_p0_reg65 reg_read=%x,halRet=%d",reg_read,halRet);
	//#endif
	
			   
	reg_mask=CODEC_B0_P0_REG66_DAC_RCHN_VOL_MASK; 
	halRet+=codec_I2CWrite(0,0,66,reg_write,reg_mask);
	//#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,66,&reg_read);
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Outpath_Dig_Vol read b0_p0_reg66 reg_read=%x,halRet=%d",reg_read,halRet);
	//#endif
			
	codec_Release_Mutex();	
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Outpath_Dig_Vol end!");

	return  halRet;	
}	

/******************************************************************************
 * Function: zDrvCodec_Set_Inpath_Dig_Vol
 * Description: 
 * Parameters:
 *   Input:    
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Set_Inpath_Dig_Vol (T_ZDrvCodec_Handle handle, T_ZDrv_VpVol vol) 
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	UINT8 reg_read = 0;
    SINT8 coarsevol=0;
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Inpath_Dig_Vol start handle=%x,invol=%d",handle,vol);
	codec_Claim_Mutex();
 
	//set fine vol
    reg_write=CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_0DB_VAL|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_0DB_VAL;
	reg_mask =CODEC_B0_P0_REG82_LEFT_ADC_DIGVOL_FINE_MASK|CODEC_B0_P0_REG82_RIGHT_ADC_DIGVOL_FINE_MASK;
	halRet=codec_I2CWrite(0,0,82,reg_write,reg_mask);

	if(vol!=CODEC_INPATH_DIG_GAIN_MAX)
	{
		coarsevol=-12+vol*3;
	}

	//coarsevol -12~20db
	if( coarsevol<-12|| coarsevol>20)
	{
		codec_Release_Mutex();		
        return  DRV_ERR_INVALID_PARAM;
	}
			  
    //reg_write=ADC_COARSE_DIGVOL(coarsevol);
#if 0
	reg_write=(UINT8)(coarsevol+12)*2 ;
	reg_write=( reg_write +0x28)&0xff;
	reg_mask =CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK;
	halRet+=codec_I2CWrite(0,0,83,reg_write,reg_mask);		
#else
    reg_write=(UINT8)(20-coarsevol)*2 ;
    reg_write=(0x28-reg_write )&0xff;
    reg_mask =CODEC_B0_P0_REG83_LEFT_ADC_DIGVOL_COARSE_MASK;
    halRet+=codec_I2CWrite(0,0,83,reg_write,reg_mask);
	//#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,83,&reg_read);
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Inpath_Dig_Vol read b0_p0_reg83 reg_read=%x,halRet=%d",reg_read,halRet);
	//#endif

	reg_write=(UINT8)(20-coarsevol)*2 ;
    reg_write=(0x28-reg_write )&0xff;
    reg_mask =CODEC_B0_P0_REG84_RIGHT_ADC_DIGVOL_COARSE_MASK;
    halRet+=codec_I2CWrite(0,0,84,reg_write,reg_mask);
	//#ifdef CODEC_TEST
		halRet+=codec_I2CRead(0,0,84,&reg_read);
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Inpath_Dig_Vol read b0_p0_reg84 reg_read=%x,halRet=%d",reg_read,halRet);
	//#endif
#endif
   	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_Set_Inpath_Dig_Vol enfd!");

	codec_Release_Mutex();
	return  halRet;	
}

/******************************************************************************
 * Function: zDrvCodec_SetSideTone
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetSideTone (T_ZDrvCodec_Handle handle,BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;

	T_Codec_UseInfo *codec_info;	   
		   
	codec_Claim_Mutex();
				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(onoff)
		{
			if((codec_info->inDev==AUDIO_INPUT_HANDSET&&codec_info->outDev==AUDIO_OUTPUT_RECEIVER)||  \
				(codec_info->inDev==AUDIO_INPUT_SPEAKER&&codec_info->outDev==AUDIO_OUTPUT_SPEAKER))
			{
				reg_write=CODEC_B0_P1_REG17_IN1L_ROUTE_TO_MAL_VAL;
				reg_mask=CODEC_B0_P1_REG17_IN1L_ROUTE_CTRL_MASK;	
			}
			else if(codec_info->inDev==AUDIO_INPUT_HEADSET||codec_info->outDev==AUDIO_OUTPUT_HEADSET)
			{
				reg_write=CODEC_B0_P1_REG17_IN1R_ROUTE_TO_MAR_VAL; 
				reg_mask=CODEC_B0_P1_REG17_IN1R_ROUTE_CTRL_MASK;
			}
		}
		else
		{
			if((codec_info->inDev==AUDIO_INPUT_HANDSET&&codec_info->outDev==AUDIO_OUTPUT_RECEIVER)|| \
				(codec_info->inDev==AUDIO_INPUT_SPEAKER&&codec_info->outDev==AUDIO_OUTPUT_SPEAKER))
			{
				reg_write=CODEC_B0_P1_REG17_IN1L_ROUTE_NOT_TO_MAL_VAL;
				reg_mask=CODEC_B0_P1_REG17_IN1L_ROUTE_CTRL_MASK;	
			}
			else if(codec_info->inDev==AUDIO_INPUT_HEADSET||codec_info->outDev==AUDIO_OUTPUT_HEADSET)
			{
				reg_write=CODEC_B0_P1_REG17_IN1R_ROUTE_NOT_TO_MAR_VAL; 
				reg_mask=CODEC_B0_P1_REG17_IN1R_ROUTE_CTRL_MASK;
			}
		}
		halRet=codec_I2CWrite(0,1,17,reg_write,reg_mask);		
    }
    else
    {
		halRet =DRV_ERROR;
    }	

	codec_Release_Mutex();		  
	return  halRet;	
}

/******************************************************************************
 * Function:  zDrvCodec_SetMicBias
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetMicBias (T_ZDrvCodec_Handle handle, T_ZDrvCodec_InDevice dev, T_ZDrvMicBias_Ctrl micBiasCtrl)
{
	SINT32 halRet =DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_read = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;

	if (codec_info->handleState == HANDLE_IN_USE)
	{	
        if(AUDIO_INPUT_HEADSET == dev)
        {
			if(micBiasCtrl == MICBIAS_OUT_POWERDOWN)
			{
				reg_write = CODEC_B0_P1_REG51_MICBIAS_EXT_PDOWN_VAL;
			}
			else if(micBiasCtrl == MICBIAS_OUT_1_35V)
			{
	        	//reg_write=CODEC_B0_P1_REG51_MICBIAS_OUT_PW2V_VAL |CODEC_B0_P1_REG51_MICBIAS_PUP_VAL;
	        	reg_write = 0xc8 ;
			}	
			else if(micBiasCtrl == MICBIAS_OUT_2V)
			{
	        	//reg_write=CODEC_B0_P1_REG51_MICBIAS_OUT_PW2V_VAL |CODEC_B0_P1_REG51_MICBIAS_PUP_VAL;
	        	reg_write = 0xd8 ;
			}
			else if(micBiasCtrl == MICBIAS_OUT_2_5V)
			{
	        	//reg_write=CODEC_B0_P1_REG51_MICBIAS_OUT_PW2_5V_VAL|CODEC_B0_P1_REG51_MICBIAS_PUP_VAL;
	        	reg_write = 0xe8 ;
			}
			else if(micBiasCtrl == MICBIAS_OUT_AVDD)
			{
	        	//reg_write=CODEC_B0_P1_REG51_MICBIAS_OUT_PW3_3V_VAL|CODEC_B0_P1_REG51_MICBIAS_PUP_VAL;
	        	reg_write = 0xf8;
			}
			else
			{
	     		       codec_Release_Mutex();	 
		 		return DRV_ERR_INVALID_PARAM;
			}		

			//reg_mask=CODEC_B0_P1_REG51_MICBIAS_OUT_CTRL_MASK | CODEC_B0_P1_REG51_MICBIAS_PWCTRL_MASK;
			reg_mask= 0xf8;
			halRet=codec_I2CWrite(0,1,51,reg_write,reg_mask);


         	reg_write = 0x0;
          	reg_mask = 0x04;
          	halRet=codec_I2CWrite(0,1,8,reg_write,reg_mask);
		}
		else
		{
    		if(micBiasCtrl == MICBIAS_OUT_POWERDOWN)
    		{
    		    reg_write = 0x0;
    		}
    		else if(micBiasCtrl == MICBIAS_OUT_1_35V)
    		{
            	reg_write = 0x04 ;
    		}	
    		else if(micBiasCtrl == MICBIAS_OUT_2V)
    		{
            	reg_write = 0x05 ;
    		}
    		else if(micBiasCtrl == MICBIAS_OUT_2_5V)
    		{
            	reg_write = 0x06 ;
    		}
    		else if(micBiasCtrl == MICBIAS_OUT_AVDD)
    		{
            	reg_write = 0x07;
    		}
			else
			{
     			codec_Release_Mutex();	 
	 			return DRV_ERR_INVALID_PARAM;
			}

			reg_mask= 0x07;
			halRet=codec_I2CWrite(0,1,51,reg_write,reg_mask);

			reg_write = 0x0;
          	reg_mask = 0x04;
          	halRet=codec_I2CWrite(0,1,8,reg_write,reg_mask);
		}
           
    }
    else
    {
		halRet =DRV_ERROR;
    }	

	halRet+=codec_I2CRead(0,1,51,&reg_read);
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetMicBias read b0_p1_reg51 reg_read=%x,halRet=%d",reg_read,halRet);

	halRet+=codec_I2CRead(0,1,8,&reg_read);
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"codec zDrvCodec_SetMicBias read b0_p1_reg8 reg_read=%x,halRet=%d",reg_read,halRet);

	codec_Release_Mutex();
    return  halRet;
}
	
/******************************************************************************
 * Function:  zDrvCodec_SetInputLeftAgc
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInputLeftAgc (T_ZDrvCodec_Handle handle,T_ZDrvAudCodec_AGC_Parameter * AGCPara)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	//UINT8 reg_mask = 0;
	UINT8 regval[7];   
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(AGCPara->onOff==1)
		{
			*regval=CODEC_B0_P0_REG86_AGCL_DISABLED_VAL;

			//AGC target level		 
			if(AGCPara->targetLevel==-5.5)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_5_5DB_VAL;
			}
		    else if(AGCPara->targetLevel==-8)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_8DB_VAL;
			}
		    else if(AGCPara->targetLevel==-10)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_10DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-12)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_12DB_VAL;
			}
		    else if(AGCPara->targetLevel==-14)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_14DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-17)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_17DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-20)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_20DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-24)
			{
				*regval|=CODEC_B0_P0_REG86_AGCL_TARLVEL_MINUS_24DB_VAL;
			}	
			else
			{
				codec_Release_Mutex();		  
                return  DRV_ERR_INVALID_PARAM;
            }

            //AGC hysteresis setting  AGC noise threshold
            if (AGCPara->noiseThreshold<-90||AGCPara->noiseThreshold>-30)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+1)= CODEC_B0_P0_REG87_AGCL_HYST_SET_1DB_VAL|AGCL_NOISE_THRESHOLD(AGCPara->noiseThreshold);

            }

            //AGC Maximum Gain
            if (AGCPara->maxgain<0||AGCPara->maxgain>59.5)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+2)= AGCL_MAX_GAIN(AGCPara->maxgain) ;

            }

            //AGC Attack Time   n*(32/fs)
            if (AGCPara->attackTime<1||AGCPara->attackTime>63)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
            	*(regval+3)= AGCL_ATTACK_TIME(AGCPara->attackTime) ;
			}

            //AGC decay Time   n*(32/fs)
            if (AGCPara->decayTime<1||AGCPara->decayTime>63)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+4)= AGCL_DECAY_TIME(AGCPara->decayTime) ;
            }

            //AGC Noise Debounce  n/fs
            if (AGCPara->noiseDebounce<0||AGCPara->noiseDebounce>21*4096)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                if (AGCPara->noiseDebounce<=4096)
                {
                    *(regval+5)= log10(AGCPara->noiseDebounce)/log10(2)-1;
                }
                else
                {
                    *(regval+5)=(AGCPara->noiseDebounce/4096-1)+0x0b;
                }

            }
            //AGC Signal Debounce  n/fs
            if (AGCPara->signalDebounce<0||AGCPara->signalDebounce>6*2048)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                if (AGCPara->signalDebounce<=2048)
                {
                    *(regval+6)= log10(AGCPara->signalDebounce)/log10(2)-1;
                }
                else
                {
                    *(regval+6)=(AGCPara->signalDebounce/2048-1)+0x0A;
                }

            }
        }
        else
        {
            //*regval=CODEC_P0_REG86_AGC_ENABLED_VAL;
            *regval=0x00;
        	*(regval+1)=0x00;
        	*(regval+2)=0x7f;
        	*(regval+3)=0x00;
        	*(regval+4)=0x00;
        	*(regval+5)=0x00;					   
        	*(regval+6)=0x00;
		}
			
        //write  7 reg, page0 start reg86
        reg_write=0;
        halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 0
        halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 86, regval, 7);
	}
    else
    {
		halRet =DRV_ERROR;
    }	

	codec_Release_Mutex();		  
	return  halRet;	
}

/******************************************************************************
 * Function:  zDrvCodec_SetInputRightAgc
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInputRightAgc (T_ZDrvCodec_Handle handle,T_ZDrvAudCodec_AGC_Parameter * AGCPara)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	//UINT8 reg_mask = 0;
	UINT8 regval[7];   
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(AGCPara->onOff==1)
		{
			*regval=CODEC_B0_P0_REG94_AGCR_DISABLED_VAL;

			//AGC target level		 
			if(AGCPara->targetLevel==-5.5)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_5_5DB_VAL;
			}
		    else if(AGCPara->targetLevel==-8)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_8DB_VAL;
			}
		    else if(AGCPara->targetLevel==-10)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_10DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-12)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_12DB_VAL;
			}
		    else if(AGCPara->targetLevel==-14)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_14DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-17)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_17DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-20)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_20DB_VAL;
			}	
		    else if(AGCPara->targetLevel==-24)
			{
				*regval|=CODEC_B0_P0_REG94_AGCR_TARLVEL_MINUS_24DB_VAL;
			}	
			else
			{
				codec_Release_Mutex();		  
                return  DRV_ERR_INVALID_PARAM;
            }

            //AGC hysteresis setting  AGC noise threshold
            if (AGCPara->noiseThreshold<-90||AGCPara->noiseThreshold>-30)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+1)= CODEC_B0_P0_REG95_AGCR_HYST_SET_1DB_VAL|AGCL_NOISE_THRESHOLD(AGCPara->noiseThreshold);

            }

            //AGC Maximum Gain
            if (AGCPara->maxgain<0||AGCPara->maxgain>59.5)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+2)= AGCL_MAX_GAIN(AGCPara->maxgain) ;

            }

            //AGC Attack Time   n*(32/fs)
            if (AGCPara->attackTime<1||AGCPara->attackTime>63)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
            	*(regval+3)= AGCL_ATTACK_TIME(AGCPara->attackTime) ;
			}

            //AGC decay Time   n*(32/fs)
            if (AGCPara->decayTime<1||AGCPara->decayTime>63)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+4)= AGCL_DECAY_TIME(AGCPara->decayTime) ;
            }

            //AGC Noise Debounce  n/fs
            if (AGCPara->noiseDebounce<0||AGCPara->noiseDebounce>21*4096)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                if (AGCPara->noiseDebounce<=4096)
                {
                    *(regval+5)= log10(AGCPara->noiseDebounce)/log10(2)-1;
                }
                else
                {
                    *(regval+5)=(AGCPara->noiseDebounce/4096-1)+0x0b;
                }

            }
            //AGC Signal Debounce  n/fs
            if (AGCPara->signalDebounce<0||AGCPara->signalDebounce>6*2048)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                if (AGCPara->signalDebounce<=2048)
                {
                    *(regval+6)= log10(AGCPara->signalDebounce)/log10(2)-1;
                }
                else
                {
                    *(regval+6)=(AGCPara->signalDebounce/2048-1)+0x0A;
                }

            }
        }
        else
        {
            //*regval=CODEC_P0_REG86_AGC_ENABLED_VAL;
            *regval=0x00;
        	*(regval+1)=0x00;
        	*(regval+2)=0x7f;
        	*(regval+3)=0x00;
        	*(regval+4)=0x00;
        	*(regval+5)=0x00;					   
        	*(regval+6)=0x00;
		}
			
        //write  7 reg, page0 start reg86
        reg_write=0;
        halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 0
        halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 94, regval, 7);
	}
    else
    {
		halRet =DRV_ERROR;
    }	

	codec_Release_Mutex();		  
	return  halRet;	
}

/******************************************************************************
 * Function:  zDrvCodec_SetOutputDrc
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOutputDrc (T_ZDrvCodec_Handle handle,T_ZDrvAudCodec_DRC_Parameter * DRCPara)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	// UINT8 reg_mask = 0;
	UINT8 regval[3];   		   
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(DRCPara->onOff==1)
		{
			*regval=CODEC_B0_P0_REG68_DRC_EN_LCHN_VAL|CODEC_B0_P0_REG68_DRC_EN_RCHN_VAL;
					  
			if(DRCPara->threshold>-3||DRCPara->threshold<-24)
			{
				codec_Release_Mutex();		  
				return  DRV_ERR_INVALID_PARAM;
			}
			if(DRCPara->threshold==-3)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_3DB_VAL ;                     
			}
			else if(DRCPara->threshold==-6)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_6DB_VAL ;  
			}
			else if(DRCPara->threshold==-9)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_9DB_VAL ;  
			}
			else if(DRCPara->threshold==-12)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_12DB_VAL ;  
			}
			else if(DRCPara->threshold==-15)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_15DB_VAL ;  
			}
			else if(DRCPara->threshold==-18)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_18DB_VAL ;  
			}
			else if(DRCPara->threshold==-21)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_21DB_VAL ;  
			}
			else if(DRCPara->threshold==-24)
			{
				*regval|= CODEC_B0_P0_REG68_DRC_THOLD_MINUS_24DB_VAL ;  
			}					  
			else 
			{
				codec_Release_Mutex();		  
                return  DRV_ERR_INVALID_PARAM;
            }

            if (DRCPara->hysteresis<0||DRCPara->threshold>3)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            if (DRCPara->hysteresis==0)
            {
                *regval|= CODEC_B0_P0_REG68_DRC_HYST_0DB_VAL ;
            }
            else if (DRCPara->hysteresis==1)
            {
                *regval|= CODEC_B0_P0_REG68_DRC_HYST_1DB_VAL ;
            }
            else if (DRCPara->hysteresis==2)
            {
                *regval|= CODEC_B0_P0_REG68_DRC_HYST_2DB_VAL;
            }
            else if (DRCPara->hysteresis==3)
            {
                *regval|= CODEC_B0_P0_REG68_DRC_HYST_3DB_VAL;
            }
            else
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }

            //DRC Control 2
            if (DRCPara->holdTime<32||DRCPara->holdTime>5*32768)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            if (DRCPara->holdTime<32768)
            {
                *(regval+1)=log10(DRCPara->holdTime/32)/log10(2)+0x08;
            }
            else

            {
                *(regval+1)=(DRCPara->holdTime/32768-1)+0x50;
            }
            //DRC Control 3   reg value
            if (DRCPara->attackRate<0||DRCPara->attackRate>15)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+2)=DRCPara->attackRate<<4;
            }

            if (DRCPara->decayRate<0||DRCPara->decayRate>15)
            {
                codec_Release_Mutex();
                return  DRV_ERR_INVALID_PARAM;
            }
            else
            {
                *(regval+2)|=DRCPara->attackRate;
            }
		}
		else
		{
			*regval=0x0f;
			*(regval+1)=0x38;		
			*(regval+2)=0x00;
		}
		//write  3 reg, page0 start reg68
		reg_write=0;
		halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 0  
		halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 68, regval, 3);		
	}		
	else
	{
		halRet =DRV_ERROR;
	}

	codec_Release_Mutex();
    return  halRet;
}

/******************************************************************************
 * Function: zDrvCodec_SetLoopBack
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetLoopBack (T_ZDrvCodec_Handle handle,BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_read = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();

	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{			  
#if 0	//anadirection	  
		if(codec_info->inDev== AUDIO_INPUT_HANDSET&&codec_info->outDev==AUDIO_OUTPUT_RECEIVER)
		{
			reg_write=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL;
			reg_mask=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK;	   
		}
		else if(codec_info->inDev== AUDIO_INPUT_SPEAKER&&codec_info->outDev== AUDIO_OUTPUT_SPEAKER)
		{
 	    	reg_write=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL;
			reg_mask=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK;	   
		}
		else if(codec_info->inDev== AUDIO_INPUT_HEADSET&&codec_info->outDev== AUDIO_OUTPUT_HEADSET)
		{
 	    	reg_write=CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_LCHN_MIXER_VAL|CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_VAL ;
			reg_mask=CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_LCHN_MIXER_MASK|CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK;
		}
		else if(codec_info->inDev== AUDIO_INPUT_HANDSET&&codec_info->outDev== AUDIO_OUTPUT_HEADSET)
		{
			reg_write=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL;
			reg_mask=CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK;	   
		}		
		else 
		{
			codec_Release_Mutex();		  
            return  DRV_ERR_INVALID_PARAM;
        }
#endif
#if 0
		reg_write=CODEC_B0_P1_REG17_IN1L_ROUTE_TO_MAL_VAL|CODEC_B0_P1_REG17_IN1R_ROUTE_TO_MAR_VAL;
		reg_mask=CODEC_B0_P1_REG17_IN1L_ROUTE_CTRL_MASK|CODEC_B0_P1_REG17_IN1R_ROUTE_CTRL_MASK;
		halRet=codec_I2CWrite(0,1,17,reg_write,reg_mask);
        #endif

	//adb to dac
	
    #if 1
		//reg_write = 0x02;//B0_P4_REG7
		//reg_mask = 0x07;
		//halRet=codec_I2CWrite(0,4,7,reg_write,reg_mask);
        
        reg_write=CODEC_B0_P4_REG118_DAC_ADC_LOOPBACK_VAL;
        reg_mask=CODEC_B0_P4_REG118_DAC_DATA_INPUT_CONFIG_CTRL_MASK;
        halRet=codec_I2CWrite(0,4,118,reg_write,reg_mask);

       halRet+=codec_I2CRead(0,4,118,&reg_read);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec b0p4reg118 value=%d.",reg_read);


        
	#ifdef CODEC_TEST
		//halRet+=codec_I2CRead(0,4,118,&reg_read);
		//zOss_Printf(1,1,"codec zDrvCodec_SetLoopBack read b0_p4_reg118 reg_read=%x,halRet=%d",reg_read,halRet);
	#endif
		
        #else
        reg_write=0x3c; //B0_P1_R17
        reg_mask=0x3c;
        halRet=codec_I2CWrite(0,1,17,reg_write,reg_mask);

        reg_write=0x0; //B0_P1_R18
        reg_mask=0x3f;
        halRet=codec_I2CWrite(0,1,18,reg_write,reg_mask);

        reg_write=0x0; //B0_P1_R19
        reg_mask=0x3f;
        halRet=codec_I2CWrite(0,1,19,reg_write,reg_mask);

        reg_write=0xc0; //B0_P1_R27
        reg_mask=0xc0;
        halRet=codec_I2CWrite(0,1,27,reg_write,reg_mask);
        #endif

    }
    else
    {
		halRet =DRV_ERROR;
    }	
		codec_Release_Mutex();		  
		return  halRet;	
}

#if 0
/******************************************************************************
 * Function: zDrvCodec_TestGPIO1Fun
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_TestGPIO1Fun (T_ZDrvCodec_Handle handle)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		//GPO TEST
		reg_write=CODEC_P0_REG51_GPIO1_FUN_GPO_VAL|CODEC_P0_REG51_GPIO1_OUTHIGH_VAL;
		reg_mask=CODEC_P0_REG51_GPIO1_FUN_MASK|CODEC_P0_REG51_GPIO1_OUT_MASK;
		halRet=codec_I2CWrite(0,0,51,reg_write,reg_mask);	

		reg_write=CODEC_P0_REG51_GPIO1_OUTLOW_VAL;
		reg_mask=CODEC_P0_REG51_GPIO1_OUT_MASK;
		halRet=codec_I2CWrite(0,0,51,reg_write,reg_mask);	

		//CLK TEST
		reg_write=CODEC_P0_REG51_GPIO1_FUN_CLKOUT_VAL;
		reg_mask=CODEC_P0_REG51_GPIO1_FUN_MASK;
		halRet=codec_I2CWrite(0,0,51,reg_write,reg_mask);	
	}
    else
    {
		halRet =DRV_ERROR;
    }	

	codec_Release_Mutex();	
	return  halRet;
}
#endif
/******************************************************************************
 * Function:zDrvCodec_SetInpathMute 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetInpathMute (T_ZDrvCodec_Handle handle, BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(onoff)
		{	
			reg_write=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_VAL;		         
			reg_mask=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_CTRL_MASK;
			halRet=codec_I2CWrite(0,0,82,reg_write,reg_mask);			  
			reg_write=CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_VAL;		         
			reg_mask=CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_CTRL_MASK;
			halRet=codec_I2CWrite(0,0,82,reg_write,reg_mask);			  
		}
		else
		{
			reg_write=CODEC_B0_P0_REG82_LEFT_ADC_UNMUTE_VAL;		
			reg_mask=CODEC_B0_P0_REG82_LEFT_ADC_MUTE_CTRL_MASK;
			halRet=codec_I2CWrite(0,0,82,reg_write,reg_mask);			  
			reg_write=CODEC_B0_P0_REG82_RIGHT_ADC_UNMUTE_VAL;		         
			reg_mask=CODEC_B0_P0_REG82_RIGHT_ADC_MUTE_CTRL_MASK;
			halRet=codec_I2CWrite(0,0,82,reg_write,reg_mask);			  
		}
	}
    else
	{
		halRet =DRV_ERROR;
	}	
	codec_Release_Mutex();				
	return  halRet;		
}

/******************************************************************************
 * Function:zDrvCodec_SetOutpathMute 
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_SetOutpathMute (T_ZDrvCodec_Handle handle, BOOL onoff)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT8 reg_write = 0;
	UINT8 reg_mask = 0;
	T_Codec_UseInfo *codec_info;		   
	codec_Claim_Mutex();				
	codec_info=(T_Codec_UseInfo*)  handle;	
	if (codec_info->handleState == HANDLE_IN_USE)
	{
		if(onoff)
		{	
			reg_write=CODEC_B0_P0_REG64_DAC_LCHN_MUTE_VAL|CODEC_B0_P0_REG64_DAC_RCHN_MUTE_VAL;
		}
		else
		{
			reg_write=CODEC_B0_P0_REG64_DAC_LCHN_UNMUTE_VAL|CODEC_B0_P0_REG64_DAC_RCHN_UNMUTE_VAL;		  
		}
		halRet=codec_I2CWrite(0,0,64,reg_write,reg_mask);			  
	}
    else
    {
		halRet =DRV_ERROR;
    }	
	codec_Release_Mutex();				
	return  halRet;		
}

/******************************************************************************
 * Function:codec_SetFmInPath
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 codec_SetFmInPath(T_ZDrvCodec_Handle handle, BOOL onoff)
{
    SINT32 halRet = DRV_SUCCESS;
    UINT8 reg_write = 0;
    UINT8 reg_mask = 0;
	UINT8  *reg_val;
    T_Codec_UseInfo *codec_info;
    #ifdef CODEC_TEST
    UINT8  reg_readval[8]={0};
    #endif	
	codec_info=(T_Codec_UseInfo*)  handle;
	//add  fm input ctrl
	if (onoff)
	{
		reg_val=handsetFMDigitalInPathPara;
		//open digital loop channel
		reg_write= CODEC_B0_P4_REG118_DAC_ADC_LOOPBACK_VAL|CODEC_B0_P4_REG118_WRITE_ONLY_VAL ;
		reg_mask=CODEC_B0_P4_REG118_DAC_DATA_INPUT_CONFIG_CTRL_MASK|CODEC_B0_P4_REG118_WRITE_ONLY_MASK;
        halRet+=codec_I2CWrite(0,4,118,reg_write,reg_mask);

		reg_write=CODEC_B0_P4_REG15_DOUT1_ASI1_INPUT_LOOPBACK_VAL;
		reg_mask=CODEC_B0_P4_REG15_ASI1_DATA_OUTPUT_CTRL_MASK;
        halRet+=codec_I2CWrite(0,4,15,reg_write,reg_mask);
	}
	else
	{
		reg_val=inPathResetPara;
		//close  digital loop channel
		reg_write= CODEC_B0_P4_REG118_WRITE_ONLY_VAL;
		reg_mask=CODEC_B0_P4_REG118_WRITE_ONLY_MASK;
        halRet+=codec_I2CWrite(0,4,118,reg_write,reg_mask);

		reg_write= CODEC_B0_P4_REG15_DOUT1_ASI1_INPUT_LOOPBACK_VAL;
		reg_mask=CODEC_B0_P4_REG15_ASI1_DATA_OUTPUT_CTRL_MASK;
        halRet+=codec_I2CWrite(0,4,15,reg_write,reg_mask);
	}

	/*switch to reg book*/
	reg_write = 0;
	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	/*B0_P0_R0: set to page 0*/
	reg_write = 0;
	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 127, &reg_write, 1);	/*B0_P0_R127: set to book0*/
	/*switch to reg page1*/
	reg_write = 1;	
	halRet = zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);	
	//write first 10 reg, page1 start reg51
 	halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 51, reg_val, 10);
#ifdef CODEC_TEST
	halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 51, reg_readval, 10);
#endif

	//write next 4 reg,page0  start reg81
	reg_write=0;
	halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 0, &reg_write, 1);  //set page to 0
	halRet+= zDrvI2c_DevWrite(&s_codecI2CDev, 81, reg_val+4, 4);
#ifdef CODEC_TEST
	halRet+= zDrvI2c_DevRead(&s_codecI2CDev, 81, reg_readval+4, 4);
#endif

	if (halRet==DRV_SUCCESS)
	{
		if (onoff)
		{
			codec_info->inDev=AUDIO_INPUT_FM_ANATODIG;
		}
		else
		{
			codec_info->inDev= AUDIO_INPUT_MAX;
		}
	}
    return  halRet;	
}

