#include "drvs_general.h"
#include "drvs_voiceprocess.h"
#include "audio_ring_queue.h"
#include "hal_dtmf_detect.h"

#define RING_BUF_TX_DATA_WB_SIZE  640//640ֽڣһ16λ320(16K20msɼ320)
#define RING_BUF_TX_DATA_WB_COUNT 6

#define RING_BUF_TX_DATA_NB_SIZE  320//160㣬20ms(խ8KHz)
#define RING_BUF_TX_DATA_NB_COUNT 6

Dtmf_Info dtmfTxInfo = {.DTMFBuffer = {0}, .PreDTMFBuffer = {0}, .dtmfThreadFlag = 0, .vpDtmfFlag = 0, .lock = NULL};
Dtmf_Info dtmfRxInfo = {.DTMFBuffer = {0}, .PreDTMFBuffer = {0}, .dtmfThreadFlag = 0, .vpDtmfFlag = 0, .lock = NULL};

VOID audio_dtmfThreadEntryTx(void)
{
    dtmfTxInfo.dtmfThreadFlag = 1;

    while(dtmfTxInfo.vpDtmfFlag == 1)
    {
        while(queue_Empty(dtmfTxInfo.dtmfRing) == 1)
        {
            if(dtmfTxInfo.vpDtmfFlag == 0)//ûдʱ߳̿ѭ޷˳
            {
                dtmfTxInfo.dtmfThreadFlag = 0;
                return;
            }
            zOss_Sleep(40);
        }

        while(*(dtmfTxInfo.dtmfRing->unit_status + dtmfTxInfo.dtmfRing->unit_index_de) == UNIT_OLD)
        {
            if(dtmfTxInfo.vpDtmfFlag == 0)//ûдʱ߳̿ѭ޷˳
            {
                dtmfTxInfo.dtmfThreadFlag = 0;
                return;
            }
            
            dtmfTxInfo.dtmfRing->unit_index_de = (dtmfTxInfo.dtmfRing->read_pos + dtmfTxInfo.dtmfRing->unit_size) / dtmfTxInfo.dtmfRing->unit_size;
            if(dtmfTxInfo.dtmfRing->unit_index_de  == dtmfTxInfo.dtmfRing->unit_count)
                dtmfTxInfo.dtmfRing->unit_index_de = 0;
            
            //if ((dtmfTxInfo.dtmfRing->read_pos + dtmfTxInfo.dtmfRing->unit_size) >= dtmfTxInfo.dtmfRing->unit_buffer_size)
            if ((dtmfTxInfo.dtmfRing->read_pos + dtmfTxInfo.dtmfRing->unit_size) > dtmfTxInfo.dtmfRing->unit_buffer_size)
                dtmfTxInfo.dtmfRing->read_pos = 0;
            else
                dtmfTxInfo.dtmfRing->read_pos += dtmfTxInfo.dtmfRing->unit_size;
            zOss_Sleep(20);
        }
        queue_Dequeue(dtmfTxInfo.dtmfRing, dtmfTxInfo.DTMFBuffer);

        detectDTMF_tx(dtmfTxInfo.DTMFBuffer, dtmfTxInfo.PreDTMFBuffer);
    }
    
    dtmfTxInfo.dtmfThreadFlag = 0;
}

VOID audio_dtmfThreadEntryRx(void)
{
    dtmfRxInfo.dtmfThreadFlag = 1;
    
    while(dtmfRxInfo.vpDtmfFlag == 1)
    {
        while((queue_Empty(dtmfRxInfo.dtmfRing) == 1))
        {
            if(dtmfRxInfo.vpDtmfFlag == 0)//ûдʱ߳̿ѭ޷˳
            {
                dtmfRxInfo.dtmfThreadFlag = 0;
                return;
            }
            zOss_Sleep(40);
        }

        while(*(dtmfRxInfo.dtmfRing->unit_status + dtmfRxInfo.dtmfRing->unit_index_de) == UNIT_OLD)
        {
            if(dtmfRxInfo.vpDtmfFlag == 0)//ûдʱ߳̿ѭ޷˳
            {
                dtmfRxInfo.dtmfThreadFlag = 0;
                return;
            }
            
            dtmfRxInfo.dtmfRing->unit_index_de = (dtmfRxInfo.dtmfRing->read_pos + dtmfRxInfo.dtmfRing->unit_size) / dtmfRxInfo.dtmfRing->unit_size;
            if(dtmfRxInfo.dtmfRing->unit_index_de == dtmfRxInfo.dtmfRing->unit_count)
                dtmfRxInfo.dtmfRing->unit_index_de = 0;
            
            //if ((dtmfTxInfo.dtmfRing->read_pos + dtmfTxInfo.dtmfRing->unit_size) >= dtmfTxInfo.dtmfRing->unit_buffer_size)
            if ((dtmfRxInfo.dtmfRing->read_pos + dtmfRxInfo.dtmfRing->unit_size) > dtmfRxInfo.dtmfRing->unit_buffer_size)
                dtmfRxInfo.dtmfRing->read_pos = 0;
            else
                dtmfRxInfo.dtmfRing->read_pos += dtmfRxInfo.dtmfRing->unit_size;
            zOss_Sleep(20);
        }
        queue_Dequeue(dtmfRxInfo.dtmfRing, dtmfRxInfo.DTMFBuffer);
        
        detectDTMF_rx(dtmfRxInfo.DTMFBuffer, dtmfRxInfo.PreDTMFBuffer);
    }
    
    dtmfRxInfo.dtmfThreadFlag = 0;
}

SINT32 dtmfTx_RingWrite(UINT8 *pBuf)
{
    SINT32 ret = DRV_SUCCESS;
    
    if(pBuf == NULL)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dtmfTx_RingWrite tx point is NULL\n");
        return DRV_ERROR;
    }

    //zOss_GetSemaphore(dtmfTxInfo.lock , 2000);
	zOss_GetSemaphore(dtmfTxInfo.lock , ZOSS_WAIT_FOREVER);
    
    if(queue_Full(dtmfTxInfo.dtmfRing))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dtmfTx_RingWrite tx Buffer is full\n");
        return DRV_ERROR;
    }

    ret = queue_Enqueue(dtmfTxInfo.dtmfRing, pBuf);

    zOss_PutSemaphore(dtmfTxInfo.lock);
    
    return ret;
}

SINT32 dtmfRx_RingWrite(UINT8 *pBuf)
{
    SINT32 ret = DRV_SUCCESS;
    
    if(pBuf == NULL)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dtmfRx_RingWrite rx point is NULL\n");
        return DRV_ERROR;
    }

    zOss_GetSemaphore(dtmfRxInfo.lock , ZOSS_WAIT_FOREVER);
    
    if(queue_Full(dtmfRxInfo.dtmfRing))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dtmfRx_RingWrite rx Buffer is full\n");
        return DRV_ERROR;
    }

    ret = queue_Enqueue(dtmfRxInfo.dtmfRing, pBuf);

    zOss_PutSemaphore(dtmfRxInfo.lock);
    
    return ret;
}

SINT32 zDrvVp_dtmf_txsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(dtmfTxInfo.lock);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_dtmf_txsem_count_Init semCount=%d\n",  semCount);

	Count = semCount;
	if(Count > 1)  {
		for(i = 1; i < Count; i++) {
			zOss_GetSemaphore(dtmfTxInfo.lock, ZOSS_NO_WAIT);
		}
	}

	return DRV_SUCCESS;
}

SINT32 zDrvVp_dtmf_rxsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(dtmfRxInfo.lock);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_dtmf_rxsem_count_Init semCount=%d\n",  semCount);

	Count = semCount;
	if(Count > 1)  {
		for(i = 1; i < Count; i++) {
			zOss_GetSemaphore(dtmfRxInfo.lock, ZOSS_NO_WAIT);
		}
	}

	return DRV_SUCCESS;
}

SINT32 zDrvVp_DtmfSoftwareStart(UINT32 dtmf_dir, UINT32 fs)
{
	SINT32 ret = DRV_SUCCESS;

    if((dtmfTxInfo.vpDtmfFlag == 1) || (dtmfRxInfo.vpDtmfFlag == 1))
    {
        ret = DRV_ERR_START_TIMES;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart has been running! ret=%d\n", ret);
    }
    else
    {
        if(dtmfTxInfo.lock == NULL)
        {
            dtmfTxInfo.lock = zOss_CreateSemaphore("dtmf_tx_sem", 1);
            
            if(dtmfTxInfo.lock == NULL)
            {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zOss_CreateSemaphore fail, dtmfTxInfo.lock == NULL\n");
			    return DRV_ERROR;
		    }
        }
        if(dtmfRxInfo.lock == NULL)
        {
            dtmfRxInfo.lock = zOss_CreateSemaphore("dtmf_rx_sem", 1);
            
            if(dtmfRxInfo.lock == NULL)
            {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zOss_CreateSemaphore fail, dtmfRxInfo.lock == NULL\n");
                return DRV_ERROR;
			}
        }
        
        if(dtmf_dir == DTMF_TX)
        {
            if(fs == 8000)
                dtmfTxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_NB_COUNT, RING_BUF_TX_DATA_NB_SIZE, 1);
            else if(fs == 16000)
                dtmfTxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_WB_COUNT, RING_BUF_TX_DATA_WB_SIZE, 1);
            else 
            {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMF_TX error, sample rate=%d, not 8000 or 16000\n", fs);
                return DRV_ERR_INVALID_PARAM;
            }

            if(dtmfTxInfo.dtmfRing == NULL)
            {
                queue_Destroy(dtmfTxInfo.dtmfRing);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error! dtmfTxInfo.dtmfRing is NULL\n");
        		return DRV_ERROR;
            }
            
			dtmfTxInfo.vpDtmfFlag = 1;
            //߳
            dtmfTxInfo.dtmfThread = zOss_CreateThread("audio_dtmfThreadEntryTx", audio_dtmfThreadEntryTx, 0, 1024, 15, 0, 1);
            if(dtmfTxInfo.dtmfThread == NULL)
        	{
				dtmfTxInfo.vpDtmfFlag = 0;
                queue_Destroy(dtmfTxInfo.dtmfRing);
        		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error!dtmfTxInfo.dtmfThread is NULL\n");
        		return DRV_ERROR;
        	}
            
            dtmfTxInfo.fs = fs;

            //dtmfTxInfo.lock = zOss_CreateSemaphore("dtmf_tx_sem", 1);
            zDrvVp_dtmf_txsem_count_Init();
            
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart dtmfTxInfo.vpDtmfFlag = %d, fs = %d\n", dtmfTxInfo.vpDtmfFlag, fs);
        }
        else if(dtmf_dir == DTMF_RX)
        {
            if(fs == 8000)
                dtmfRxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_NB_COUNT, RING_BUF_TX_DATA_NB_SIZE, 1);
            else if(fs == 16000)
                dtmfRxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_WB_COUNT, RING_BUF_TX_DATA_WB_SIZE, 1);
            else 
            {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMF_RX error, sample rate=%d, not 8000 or 16000\n", fs);
                return DRV_ERR_INVALID_PARAM;
            }

            if(dtmfRxInfo.dtmfRing == NULL)
            {
                queue_Destroy(dtmfRxInfo.dtmfRing);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error! dtmfRxInfo.dtmfRing is NULL\n");
        		return DRV_ERROR;
            }

			dtmfRxInfo.vpDtmfFlag = 1;
            //߳
            dtmfRxInfo.dtmfThread = zOss_CreateThread("audio_dtmfThreadEntryRx", audio_dtmfThreadEntryRx, 0, 1024, 15, 0, 1);
            if(dtmfRxInfo.dtmfThread ==NULL)
        	{
				dtmfRxInfo.vpDtmfFlag = 0;
                queue_Destroy(dtmfRxInfo.dtmfRing);
        		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error! dtmfRxInfo.dtmfThread is NULL\n");
        		return DRV_ERROR;
        	}

            dtmfRxInfo.fs = fs;
            
            //dtmfRxInfo.lock = zOss_CreateSemaphore("dtmf_rx_sem", 1);
            zDrvVp_dtmf_rxsem_count_Init();
            
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart dtmfRxInfo.vpDtmfFlag = %d, fs = %d\n", dtmfRxInfo.vpDtmfFlag, fs);
        }
        else
        {
            if(fs == 8000)
            {
                dtmfTxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_NB_COUNT, RING_BUF_TX_DATA_NB_SIZE, 1);
                dtmfRxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_NB_COUNT, RING_BUF_TX_DATA_NB_SIZE, 1);
            }
            else if(fs == 16000)
            {
                dtmfTxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_WB_COUNT, RING_BUF_TX_DATA_WB_SIZE, 1);
                dtmfRxInfo.dtmfRing = queue_Create(RING_BUF_TX_DATA_WB_COUNT, RING_BUF_TX_DATA_WB_SIZE, 1);
            }
            else 
            {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"DTMF_TXRX error, sample rate=%d, not 8000 or 16000\n", fs);
                return DRV_ERR_INVALID_PARAM;
            }
            
            if((dtmfTxInfo.dtmfRing == NULL) || (dtmfRxInfo.dtmfRing == NULL))
            {
                queue_Destroy(dtmfTxInfo.dtmfRing);
                queue_Destroy(dtmfRxInfo.dtmfRing);
        		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error! dtmfRing create failed\n");
        		return DRV_ERROR;
            }

			dtmfTxInfo.vpDtmfFlag = 1;
            //߳audio_dtmfThreadEntryTx
            dtmfTxInfo.dtmfThread = zOss_CreateThread("audio_dtmfThreadEntryTx", audio_dtmfThreadEntryTx, 0, 1024, 15, 0, 1);
            if(dtmfTxInfo.dtmfThread == NULL)
            {
				dtmfTxInfo.vpDtmfFlag = 0;
                queue_Destroy(dtmfTxInfo.dtmfRing);
                queue_Destroy(dtmfRxInfo.dtmfRing);
        		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error! dtmfTxInfo.dtmfThread is NULL\n");
        		return DRV_ERROR;
            }

			dtmfRxInfo.vpDtmfFlag = 1;
            //߳audio_dtmfThreadEntryRx
            dtmfRxInfo.dtmfThread = zOss_CreateThread("audio_dtmfThreadEntryRx", audio_dtmfThreadEntryRx, 0, 1024, 15, 0, 1);
            if(dtmfRxInfo.dtmfThread == NULL)
        	{
				dtmfTxInfo.vpDtmfFlag = 0;
				dtmfRxInfo.vpDtmfFlag = 0;
                queue_Destroy(dtmfTxInfo.dtmfRing);
                queue_Destroy(dtmfRxInfo.dtmfRing);
        		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart error!  dtmfRxInfo.dtmfThread is NULL\n");
        		return DRV_ERROR;
        	}
            
            dtmfTxInfo.fs = fs;
            dtmfRxInfo.fs = fs;
            
            //dtmfTxInfo.lock = zOss_CreateSemaphore("dtmf_tx_sem", 1);
            zDrvVp_dtmf_txsem_count_Init();
            //dtmfRxInfo.lock = zOss_CreateSemaphore("dtmf_rx_sem", 1);
            zDrvVp_dtmf_rxsem_count_Init();
            
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStart dtmfTxInfo.vpDtmfFlag = %d, dtmfRxInfo.vpDtmfFlag = %d, fs = %d\n", dtmfTxInfo.vpDtmfFlag, dtmfRxInfo.vpDtmfFlag, fs);
        }
    }
    
	return ret;
}

SINT32 zDrvVp_DtmfSoftwareStop(void)
{
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Enter zDrvVp_DtmfSoftwareStop\n");
	SINT32  ret = DRV_SUCCESS;

    if((dtmfTxInfo.vpDtmfFlag == 0) && (dtmfRxInfo.vpDtmfFlag == 0))
    {
        ret = DRV_ERR_NOT_STARTED;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStop has stopped! ret=%d\n", ret);
        return ret;
    }
    else 
    {
        dtmfTxInfo.vpDtmfFlag = 0;
        dtmfRxInfo.vpDtmfFlag = 0;
        
        while((dtmfTxInfo.dtmfThreadFlag == 1) || (dtmfRxInfo.dtmfThreadFlag == 1)){
            zOss_Sleep(5);
        }
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "audio_dtmfThreadEntry work end\n");

        if(dtmfTxInfo.lock != NULL)
        {
            zOss_GetSemaphore(dtmfTxInfo.lock , ZOSS_WAIT_FOREVER);
        
            queue_Destroy(dtmfTxInfo.dtmfRing);
            dtmfTxInfo.dtmfThread = NULL;
            
            zOss_PutSemaphore(dtmfTxInfo.lock);
        }

        if(dtmfRxInfo.lock != NULL)
        {
            zOss_GetSemaphore(dtmfRxInfo.lock , ZOSS_WAIT_FOREVER);
            
            queue_Destroy(dtmfRxInfo.dtmfRing);
            dtmfRxInfo.dtmfThread = NULL;

            zOss_PutSemaphore(dtmfRxInfo.lock);
        }

        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfSoftwareStop success!\n");
    }
  
    return ret;
}

