/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_earpiece.c
 * File Mark:
 * Description:  This file contains the hal layer routines for earpiece driver.
 * Others:
 * Version:       V0.5
 * Author:        Zhouzhongyao
 * Date:           2009-5-12
 * History 1:
 *     Date:    2009-7-27
 *     Version: v1.4.3
 *     Author:  zhouzhongyao
 *     Modification: chang interrupt doing.Use thread and sem function,Because enable bias need 250 ms delay.
 * History 2:
 *     Date:    2009-8-03
 *     Version: v1.4.3
 *     Author:  zhouzhongyao
 *     Modification: checking pclint
 * History 3:
 *     Date:    2011-7-07
 *     Version: v1.4.3
 *     Author:  wangjun
 *     Modification: U560

  *******************************************************************************/

/****************************************************************************
*                                             Include files
****************************************************************************/
#include "pub.h"
//#include "drv_pub.h"
#include "earpiece_api.h"
#include "hal_earpiece.h"
#include "oss_api.h"
#include "drvs_ramlog.h"

#ifdef _CONFIG_USE_CODEC_ALC5672
#include "drvs_codec_alc5672.h"
#endif

#if defined _CONFIG_USE_CODEC
#include "drvs_codec.h"
#include "drvs_int.h"
#include "drvs_pcu.h"
#include "drvs_gpio.h"
#include "threadpriority.h"
#include "drvs_i2c.h"    /*added by yuerli,2011-12-16*/
#include "drvs_ramlog.h"   /*added by yuerli,2012-01-31*/
#include "drvs_i2s.h"
#endif

#ifdef _USE_PSM
#include "drvs_pwr.h"
#endif

/****************************************************************************
*                                             Local Macros
****************************************************************************/
/*version and the driver name*/
#define DRIVER_NAME                   "earpiece"
#define DRIVER_VERSION                1

#define IntLineNum   30     /* hook intline */   /* added by yuerli 2011-12-16 */
#define IntPrioNum   20     /* hook intprio */   /* added by yuerli 2011-12-16 */
#define TIMER_VALUE    500

#ifdef _CONFIG_USE_CODEC_ALC5672
#define EARP_INT_FUNC   GPIO48_EXT_INT1
#define EARP_INT   EX1_INT
#endif
#ifdef _CONFIG_USE_CODEC_TLV3100
#define EARP_INT_FUNC   GPIO52_EXT_INT2//GPIO52_EXT_INT2
#define EARP_INT   EX2_INT
#endif

#ifdef _CONFIG_USE_CODEC_TLV3100
#define CODEC_P0_REG44_HEADSET_FLAG_BTN_STATE_VAL    0x1<<5
#define CODEC_P0_REG44_HEADSET_FLAG_HEADSET_STATE_CHANGE_VAL    0x1<<4
#define CODEC_P0_REG46_HEADSET_FLAG_BTN_STATE_VAL    0x1<<5
#define CODEC_P0_REG46_HEADSET_FLAG_HEADSET_INSERT_VAL    0x1<<4
#endif
/****************************************************************************
*                                             Local Types
****************************************************************************/

/****************************************************************************
*                                             Local Constants
****************************************************************************/

/****************************************************************************
*                                             Local Function Prototypes
****************************************************************************/
static SINT32 earp_Init(VOID);
static SINT32 earp_Exit(VOID);
static SINT32 earp_GetPlugStatus(T_ZDrvEarp_State * plug_status);
static SINT32 earp_SetCallbackFunc(T_ZDrvEarp_CallbackFunc callbackFunc);
//static VOID earp_hookIsrCallbackThread(VOID);
static VOID earp_Isr(VOID);
//static VOID earp_hookIsr(VOID);
//static VOID earp_hookDealIsr(VOID);
static VOID earp_DealIsr(VOID);
//static SINT32 earp_HookEnable(VOID);
//static SINT32 earp_HookDisable(VOID);
//static SINT32 halHrdTstEarp_Initiate(VOID);

/****************************************************************************
*                                            Global Constants
****************************************************************************/

/****************************************************************************
*                                            Global Variables
****************************************************************************/
static T_ZDrvEarp_CallbackFunc s_earpCallback = NULL;       /* ûص ָ*/
static ZOSS_THREAD_ID s_earpIsrThreadID = NULL;
static ZOSS_SEMAPHORE_ID s_earpIsrSemID = NULL;
//static ZOSS_THREAD_ID s_hookIsrThreadID = NULL;
//static ZOSS_SEMAPHORE_ID s_hookIsrSemID = NULL;
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
static BOOL earpDetectWakeupFlag = FALSE;
static UINT8 s_earpStatus = EARPIECE_TAKEOFF;	 /*ǰĶ״̬ =0ʾû1ʾ϶*/
extern BOOL zDrvCodec_GetUsestate(VOID);

#endif
static BOOL earpInitFlag = FALSE;

static T_HalEarp_Opt s_earpObjOpt =
{
	earp_Init,
	earp_Exit,
	earp_GetPlugStatus,
	earp_SetCallbackFunc,
	NULL,
	NULL
};

T_ZDrvEarp_type jack_type = SND_JACK_NO_HEADSET;
ZOSS_TIMER_ID      hookTimerId;

extern BOOL codecInitFlag;
/****************************************************************************
*                                            Global Function Prototypes
****************************************************************************/
extern SINT32 codec_EarpieceDetectEnable(BOOL onoff);
extern SINT32 zDrvCodec_EarpieceDetectWakeup(VOID);
extern SINT32 zDrvCodec_EarpieceDetectSleep(VOID);
extern BOOL zDrvCodec_EarpieceGetUsestate(VOID);
extern SINT32 zDrvCodec_EarpieceDetectEnable( BOOL onoff);

/****************************************************************************
*                                            Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: earp_IsrCallbackThread
 * Description: This function is running while earp running.
 * Parameters:
 *   Input:param reserved
 *   Output:None
 *
 * Returns: None
 *
 * Others:
 ********************************************************************************/
static VOID earp_IsrCallbackThread(SINT32 param)
{
	while (1)
	{
		if (zOss_GetSemaphore(s_earpIsrSemID, ZOSS_WAIT_FOREVER) == ZOSS_SUCCESS)
		{
			earp_DealIsr();
		}
	}
}

/*******************************************************************************
 * Function: earp_CreateSemAndThread
 * Description: This function is used to create SemID and the thread which waiting the SemID.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 * Others:
 ********************************************************************************/
static SINT32  earp_CreateSemAndThread(VOID)
{
	s_earpIsrSemID = zOss_CreateSemaphore("EARP_ISR_CALLBACK_SEMPID", 0);
	if (s_earpIsrSemID == NULL)
	{
		return DRV_ERROR;
	}

	s_earpIsrThreadID = zOss_CreateThread("EARP_ISR_CALLBACK_THREAD", earp_IsrCallbackThread, 0, 1024, 14, 1, 1);
	if (NULL == s_earpIsrThreadID)
	{
		if (NULL != s_earpIsrSemID)
		{
			zOss_DeleteSemaphore(s_earpIsrSemID);
			s_earpIsrSemID = NULL;
		}
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}
#if 0
/*******************************************************************************
 * Function: earp_RemoveSemAndThread
 * Description: This function is used to delete SemID and the thread which waiting the SemID.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32  earp_RemoveSemAndThread(VOID)
{
	UINT32 halRet = ZOSS_SUCCESS ;
	if (NULL != s_earpIsrThreadID)
	{
		halRet += zOss_DeleteThread(s_earpIsrThreadID);
	}

	if (s_earpIsrSemID != NULL)
	{
		halRet += zOss_DeleteSemaphore(s_earpIsrSemID);
	}

	if (halRet != ZOSS_SUCCESS)
	{
		return DRV_ERROR;
	}
	s_earpIsrSemID = NULL;
	s_earpIsrThreadID = NULL;

	return DRV_SUCCESS;
}
#endif
/*******************************************************************************
 * Function: hook_TimerCallBack
 * Description: This function is used to start earpiece timer function
 * Parameters:
 *	 Input:None
 *	 Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *				DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
#ifdef _CONFIG_USE_CODEC_TLV3100
static VOID hook_TimerCallBack(SINT32 para)
{
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hook_TimerCallBack tick: %d\n", zOss_GetTickCount());

	if (s_earpStatus == EARPIECE_TAKEON)
	{

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earpiece hook key current status is pressed !\n");
		if (NULL != s_earpCallback)
		{
			(*s_earpCallback)(EARP_INFO_HOOK_SWITCH);
		}

	}
}
#endif

/*******************************************************************************
 * Function: earp_Init
 * Description: This function is used to init earpiece device
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_Init(VOID)
{
	//SINT32 i;
	SINT32 audioGpioIntHandle;
	SINT32 halRet = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC_TLV3100
	UINT8 earpState = 0;
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_Init!\n");

	zDrvCodec_EarpieceDetectEnable(TRUE);
#ifdef _CONFIG_USE_CODEC_TLV3100
	halRet = codec_I2CRead(0, 46, &earpState);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_Init earpState regvalue = 0x%x !\n", halRet);

	if (earpState & CODEC_P0_REG46_HEADSET_FLAG_HEADSET_INSERT_VAL)
	{
		s_earpStatus = EARPIECE_TAKEON;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_Init    earp on!\n");
	}
	else
	{
		s_earpStatus = EARPIECE_TAKEOFF;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_Init    earp off!\n");
	}
#endif
	audioGpioIntHandle = zDrvGpio_Request("codec_int");
	zDrvGpio_SetDirection(audioGpioIntHandle, GPIO_IN);
	zDrvGpio_SetFunc(audioGpioIntHandle, EARP_INT_FUNC);

#ifdef _CONFIG_USE_CODEC_ALC5672
	zDrvInt_InstallIsr(EARP_INT, (VOID *)earp_Isr, "Earp_Int", INT_NEGEDGE);
	zDrvInt_DelayUnmaskAdd(EARP_INT);
	halRet += codec_I2CWrite(RT5672_PWR_ANLG2,  RT5672_PWR_BST1_P | RT5672_PWR_BST1 | RT5672_PWR_MB1 | (0x1 << 14) | (0x1 << 10) | (0x1 << 5), \
	                         (0x1 << RT5672_PWR_BST1_P_BIT) | (0x1 << RT5672_PWR_BST1_BIT) | (0x1 << RT5672_PWR_MB1_BIT) | (0x1 << 14) | (0x1 << 10) | (0x1 << 5));
	halRet += codec_I2CWrite(RT5672_PWR_VOL, RT5672_PWR_MB2,  0x1 << RT5672_PWR_MB2_BIT);
#endif
#ifdef _CONFIG_USE_CODEC_TLV3100

	//	zDrvPcu_SetWakeInt(EX5_INT_PCU,0);//headset is wakeup interrupt
	halRet = zDrvInt_InstallIsr(EARP_INT, (VOID *)earp_Isr, "Earp_Int", INT_POSEDGE);

	hookTimerId = zOss_CreateTimer("hookTimer", hook_TimerCallBack, 0, FALSE);
	if (!hookTimerId)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "hookTimerId is NULL!\n");
		return DRV_ERROR;
	}
#endif

	earpInitFlag = TRUE;

	return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: earp_Exit
 * Description: This function is used to exit earpiece device
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_Exit(VOID)
{
	SINT32 halRet = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_Exit!\n");

	//earp_HookDisable();
	zDrvCodec_EarpieceDetectEnable(FALSE);
	halRet = zDrvInt_UninstallIsr(EARP_INT);
	if (halRet != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvInt_UninstallIsr failed halRet:%d\n", halRet);
		return DRV_ERROR;
	}

#ifdef _CONFIG_USE_CODEC_TLV3100
	if (hookTimerId != NULL)
	{
		zOss_KillTimer(hookTimerId);
	}
#endif
	earpInitFlag = FALSE;
	return DRV_SUCCESS;

}
#if 0
/*******************************************************************************
 * Function: earp_HookEnable
 * Description: This function is used to open micbias power on and install hook int
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_HookEnable(VOID)
{
	//UINT8 reg_write = 0;
	//UINT8 reg_mask = 0;
	SINT32 halRet = DRV_ERROR;

	halRet = earp_SetMicBias(MICBIAS_OUT_2_5V);
	if (halRet == DRV_ERROR)
	{
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}
/*******************************************************************************
 * Function: earp_HookDisable
 * Description: This function is used to close micbias power on and unstall hook int
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_HookDisable(VOID)
{
	//UINT8 reg_write = 0;
	//UINT8 reg_mask = 0;
	//SINT32 returnValue = ZOSS_SUCCESS ;
	SINT32 halRet = DRV_ERROR;

	/*close VMic power off */
	halRet =  earp_SetMicBias(MICBIAS_OUT_POWERDOWN);

	if (halRet == DRV_ERROR)
	{
		return DRV_ERROR;
	}
	return DRV_SUCCESS;
}
#endif
#ifdef _CONFIG_USE_CODEC_ALC5672
/******************************************************************************
* Function: earp_detect
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
******************************************************************************/
static int rt5672_button_detect(VOID)
{
	UINT16 btn_type = 0;
	UINT16 val;
	//SINT32 halRet = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_button_detect \n");
#ifdef _CONFIG_USE_CODEC_ALC5672
	codec_I2CRead16(RT5672_IL_CMD, &val);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_button_detect val:0x%x \n", val);
	btn_type = val & 0xff80;
	codec_I2CWrite_Nomask(RT5672_IL_CMD, val);

	if (btn_type != 0)
	{
		zOss_Sleep(20);
		codec_I2CRead16(RT5672_IL_CMD, &val);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_button_detect1 val:0x%x \n", val);
		codec_I2CWrite_Nomask(RT5672_IL_CMD, val);
	}
#endif
	return btn_type;
}


/******************************************************************************
* Function: earp_detect
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*   0 if success, not 0 if fail
*
* Others:
******************************************************************************/
int rt5672_headset_detect(int jack_insert)
{
	SINT32 halRet = DRV_SUCCESS;
	UINT16 val = 0;
	if (jack_insert == 1)
	{
		halRet += codec_I2CWrite(RT5672_PWR_VOL, RT5672_PWR_MIC_DET, 0x1 << RT5672_PWR_MIC_DET_BIT);
		halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_VREF1 | RT5672_PWR_MB | RT5672_PWR_BG | RT5672_PWR_VREF2,
		                         RT5672_PWR_VREF1 | RT5672_PWR_MB | RT5672_PWR_BG | RT5672_PWR_VREF2);
		zOss_Sleep(10);
		halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_FV1 | RT5672_PWR_FV2, RT5672_PWR_FV1 | RT5672_PWR_FV2);
		halRet += codec_I2CWrite(RT5672_CHARGE_PUMP, RT5672_OSW_L_MASK | RT5672_OSW_R_MASK, RT5672_OSW_L_DIS | RT5672_OSW_R_DIS);
		halRet += codec_I2CWrite(RT5672_GEN_CTRL1, 0x1, 0x1);
		halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_LDO_SEL_MASK, 0x5);

		halRet += codec_I2CWrite(RT5672_GEN_CTRL3, 0x4, 0x0);
		halRet += codec_I2CWrite(RT5672_CJ_CTRL2, RT5672_CBJ_DET_MODE | RT5672_CBJ_MN_JD, RT5672_CBJ_MN_JD);
		halRet += codec_I2CWrite_Nomask(RT5672_GPIO_CTRL2, 0x0004);
		halRet += codec_I2CWrite(RT5672_GPIO_CTRL1, RT5672_GP1_PIN_MASK, RT5672_GP1_PIN_IRQ);
		halRet += codec_I2CWrite(RT5672_CJ_CTRL1, RT5672_CBJ_BST1_EN, RT5672_CBJ_BST1_EN);//in1 port enable
		halRet += codec_I2CWrite_Nomask(RT5672_JD_CTRL3, 0x00f0);
		halRet += codec_I2CWrite(RT5672_CJ_CTRL2, RT5672_CBJ_MN_JD, RT5672_CBJ_MN_JD);
		halRet += codec_I2CWrite(RT5672_CJ_CTRL2, RT5672_CBJ_MN_JD, 0);//clear the IN1 STATUE

		zOss_Sleep(300);
		halRet += codec_I2CRead16(RT5672_CJ_CTRL3, &val);
		val &= 0x7;
		if (val == 0x1 || val == 0x2)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "headset detect \n");
			//halRet += codec_I2CWrite(RT5672_IRQ_CTRL3, 0x8, 0x8);//enable btn irq
			//halRet += codec_I2CWrite(RT5672_IL_CMD, 0x40, 0x40);//enable inline command
			//halRet += codec_I2CRead16(RT5672_IL_CMD, &val);
			jack_type = SND_JACK_HEADSET;
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "headphone detect \n");
			halRet += codec_I2CWrite(RT5672_GEN_CTRL3, 0x4, 0x4);//powr down micbias;
			jack_type = SND_JACK_HEADPHONE;
		}
	}
	else
	{
		halRet += codec_I2CWrite(RT5672_IRQ_CTRL3, 0x8, 0x0);
		halRet += codec_I2CWrite(RT5672_GEN_CTRL3, 0x4, 0x4);
		halRet += codec_I2CWrite(RT5672_PWR_VOL, RT5672_PWR_MIC_DET, 0x0 << RT5672_PWR_MIC_DET_BIT);
		halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_PWR_VREF1 | RT5672_PWR_VREF2 | RT5672_PWR_FV1 | RT5672_PWR_FV2, 0);
		halRet += codec_I2CWrite(RT5672_PWR_ANLG1, RT5672_LDO_SEL_MASK, 0x3);
		jack_type = SND_JACK_NO_HEADSET;
	}

	return halRet;
}
#endif
/*******************************************************************************
 * Function: earp_GetPlugStatus
 * Description: This function is used to get earpiece status.
 * Parameters:
 *   Input:
 *      plug_status:T_ZDrvEarp_State type pointer.
 *   Output:
 *      plug_status:T_ZDrvEarp_State type, earpiece plug status.
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_GetPlugStatus(T_ZDrvEarp_State * plug_status)
{
#ifdef _CONFIG_USE_CODEC_TLV3100
	UINT8 earpState = 0;
#endif
	SINT32 halRet = DRV_SUCCESS;

	if (plug_status == NULL)
	{
		return DRV_ERR_INVALID_PARAM;
	}
#ifdef _CONFIG_USE_CODEC_TLV3100
	halRet = codec_I2CRead(0, 46, &earpState);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_GetPlugStatus earpState regvalue = 0x%x !\n", earpState);

	if (halRet != DRV_SUCCESS)
	{
		return DRV_ERROR;
	}

	if (earpState & CODEC_P0_REG46_HEADSET_FLAG_HEADSET_INSERT_VAL)
	{
		*plug_status = EARP_STATE_PLUG;
		s_earpStatus = EARPIECE_TAKEON;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_GetPlugStatus earp on!\n");
	}
	else
	{
		*plug_status = EARP_STATE_UNPLUG;
		s_earpStatus = EARPIECE_TAKEOFF;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_GetPlugStatus earp off!\n");
	}
#endif
	halRet = DRV_SUCCESS;
	return halRet;
}

/*******************************************************************************
 * Function: earp_SetCallbackFunc
 * Description: This function is set callback function.
 * Parameters:
 *   Input:
 *      callbackFunc:call back function  pointer.
 *
 * Returns: DRV_SUCCESS: operate success
 *
 * Others:
 ********************************************************************************/
static SINT32 earp_SetCallbackFunc(T_ZDrvEarp_CallbackFunc callbackFunc)
{
	s_earpCallback = callbackFunc;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_SetCallbackFunc = %d !\n", s_earpCallback);
#if 0
	if (s_earpStatus == EARPIECE_TAKEON)
	{
		(*s_earpCallback)(EARP_INFO_PLUG);

	}
#endif
	return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: earp_DealIsr
 * Description: This function is used to deal with isr.
 * Parameters:
 *   Input:
 *      nint1:interrupt status
 *   Output:
 *      None
 *
 * Returns:none
 *
 * Others:
 ********************************************************************************/
static VOID earp_DealIsr(VOID)
{
#ifdef _CONFIG_USE_CODEC_ALC5672
	UINT16 earstate = 0;
	//UINT16 val = 0;
	UINT16 hookstate = 0;
	UINT16 btn_type = 0;
#endif
	SINT32 halRet = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC_TLV3100
	UINT8 earpState = 0;
	UINT8 isearpchange = 0;
	UINT8 earpType = 0;
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr tick: %d\n", zOss_GetTickCount());
#ifdef _CONFIG_USE_CODEC_ALC5672
	zOss_Sleep(150);

	halRet =  codec_I2CRead16(RT5672_A_JD_CTRL1, &earstate);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr reg94 is earpchange regvalue = 0x%x !\n", earstate);

	earstate = earstate & 0x0020;
	switch (earstate)
	{
		/*jack insert*/
	case 0x0:
		if (jack_type == SND_JACK_NO_HEADSET)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp is inserted \n");
			zDrvInt_SetLineLevel(EARP_INT, INT_POSEDGE);

			halRet = rt5672_headset_detect(1);
			if (halRet != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_headset_detect insert error:%d.\n", halRet);
			}

			if (NULL != s_earpCallback)
			{
				(*s_earpCallback)(EARP_INFO_PLUG);
			}
			break;
		}
		halRet =  codec_I2CRead16(RT5672_IRQ_CTRL3, &hookstate);
		if (hookstate & 0x4)
		{
			btn_type = rt5672_button_detect();
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr  is hookchange regvalue = 0x%x, btn_type:0x%x !\n", hookstate, btn_type);
		}
		break;
		/*jack out*/
	case 0x20:
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp is removed \n");
		zDrvInt_SetLineLevel(EX1_INT, INT_NEGEDGE);
		halRet += codec_I2CWrite(RT5672_IRQ_CTRL3, 0x1, 0x0);
		halRet += rt5672_headset_detect(0);
		if (halRet != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "rt5672_headset_detect remove error:%d.\n", halRet);
		}

		if (NULL != s_earpCallback)
		{
			(*s_earpCallback)(EARP_INFO_UNPLUG);
		}
		break;
	default:
		break;
	}
#endif
#ifdef _CONFIG_USE_CODEC_TLV3100
	halRet = codec_I2CRead(0, 44, &isearpchange);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr reg44 isearpchange regvalue = 0x%x !\n", isearpchange);
	halRet = codec_I2CRead(0, 46, &earpState);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr reg46 earpState regvalue = 0x%x !\n", earpState);
	halRet = codec_I2CRead(0, 67, &earpType);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr reg67 earpType regvalue = 0x%x halRet = %d!\n", earpType,halRet);

	if (isearpchange & CODEC_P0_REG44_HEADSET_FLAG_HEADSET_STATE_CHANGE_VAL)  /*жжǷȷcodec״̬Ƿĸı*/
	{
		if (earpState & CODEC_P0_REG46_HEADSET_FLAG_HEADSET_INSERT_VAL)  /*жϲ*/
		{
			//earp_SetMicBias(MICBIAS_OUT_2_5V);
			s_earpStatus = EARPIECE_TAKEON;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp is inserted !\n");

			if (NULL != s_earpCallback)
			{
				(*s_earpCallback)(EARP_INFO_PLUG);
			}
		}
		else                             /*γ*/
		{
			//earp_SetMicBias(MICBIAS_OUT_POWERDOWN);
			s_earpStatus = EARPIECE_TAKEOFF;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp is removed tick: %d\n", zOss_GetTickCount());
			zOss_StopTimer(hookTimerId);

			if (NULL != s_earpCallback)
			{
				(*s_earpCallback)(EARP_INFO_UNPLUG);
			}
		}
	}
	else if (isearpchange & CODEC_P0_REG44_HEADSET_FLAG_BTN_STATE_VAL) /*жжǷȷcodec״̬Ƿĸı*/
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earpiece hook key has be pressed tick: %d\n", zOss_GetTickCount());

		zOss_StartTimer(hookTimerId, TIMER_VALUE, hook_TimerCallBack, 0);
	}
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "earp_DealIsr over, tick: %d\n", zOss_GetTickCount());
	zDrvInt_UnmaskIrq(EARP_INT);
}

/*******************************************************************************
 * Function: earp_Isr
 * Description: This function is used to get earpiece status.
 * Parameters:
 *   Input:
 *      nInt0:interrupt status value.
 *      nInt1:interrupt status value
 *   Output:
 *     None
 *
 * Returns: None
 *
 * Others:
 ********************************************************************************/
static VOID earp_Isr(VOID)
{
	//  zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"earp_Isr\n");
	zDrvInt_MaskIrq(EARP_INT);
	//zDrvInt_ClearInt(EARP_INT);
	zOss_PutSemaphore(s_earpIsrSemID);
}

/*******************************************************************************
 * Function: zDrvEarp_Init
 * Description: This function is used to init earp driver.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: None
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvEarp_Initiate(VOID)
{
	SINT32 halRet = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvEarp_Initiate start!");

	halRet = earp_CreateSemAndThread();
	zDrvEarp_Init();
	if (halRet == DRV_SUCCESS)
	{
		zDrvEarp_SetOperations(&s_earpObjOpt);
	}

	return halRet;
}

/*******************************************************************************
 * Function: zDrvEarp_DetectWakeup
 * Description: This function is used to wakeup earp driver.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: None
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvEarp_DetectWakeup(VOID)
{
	SINT32 halRet = DRV_SUCCESS;
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
	//T_ZDrvEarp_State  plug_status = MAX_EARP_STATE;
	//UINT8 earpState = 0;
	//UINT8 isearpchange = 0;
	//UINT8 earpType = 0;

//	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_DEBUG, "%s", __FUNCTION__);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvEarp_DetectWakeup !\n");
	if (earpInitFlag == FALSE)
	{
		return DRV_SUCCESS;
	}


    if (codecInitFlag == FALSE)
    {
        return DRV_SUCCESS;
    }

	if (earpDetectWakeupFlag == TRUE)
	{
		return DRV_SUCCESS;
	}

	//zDrvPcu_ClearInt(EARP_INT);
	zDrvInt_UnmaskIrq(EARP_INT);

	halRet = zDrvCodec_EarpieceDetectWakeup();
	if (halRet != DRV_SUCCESS)
	{
		return halRet;
	}

	if (s_earpCallback != NULL)
	{
		(*s_earpCallback)(EARP_INFO_UNPLUG);
	}
	earpDetectWakeupFlag = TRUE;
#endif
	return halRet;
}

/*******************************************************************************
 * Function: zDrvEarp_DetectSleep
 * Description: This function is used to sleep earp driver.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: None
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvEarp_DetectSleep(VOID)
{
	SINT32 halRet = DRV_SUCCESS;
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)

//	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_DEBUG, "%s", __FUNCTION__);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvEarp_DetectSleep !\n");
	if (earpInitFlag == FALSE)
	{
		return DRV_SUCCESS;
	}

    if (codecInitFlag == FALSE)
    {
        return DRV_SUCCESS;
 	}

	if (earpDetectWakeupFlag == TRUE)
	{
		if (zDrvCodec_GetUsestate() == TRUE)
		{
			return DRV_SUCCESS;
		}

		zDrvInt_MaskIrq(EARP_INT);
		//zDrvPcu_ClearInt(EARP_INT);
		halRet = zDrvCodec_EarpieceDetectSleep();

		earpDetectWakeupFlag = FALSE;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvEarp_DetectSleep really !\n");
	}
#endif
	return halRet;
}
