/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:   aud_ext_intf.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0.
 * Author:        zhouzhongyao
 * Date:          2009-7-23
  ******************************************************************************/
#ifndef _AUD_EXT_INTF_H
#define _AUD_EXT_INTF_H
/****************************************************************************
*                          Include files
****************************************************************************/
#include "tone_api.h"
/****************************************************************************
*                           Macros
****************************************************************************/
typedef VOID(*T_Voice_RecordCallBack)(VOID);
typedef VOID(*T_Voice_RateCallBack)(UINT32 rate);
typedef VOID(*T_Tone_CallbackFunc) (T_ZDrvTone_Info);

/****************************************************************************
*                           Types
****************************************************************************/

/****************************************************************************
*                           Constants
****************************************************************************/

/****************************************************************************
*                           Global  Variables
****************************************************************************/

/****************************************************************************
*                           Function Prototypes
****************************************************************************/

void umac_amr_sync(ubyte mode, ubyte sync, ushort start_ul_offset, ubyte hysteresis);

/*------------------------------------------------------------------------------
* Function...: AUD_ringer_start_user_tone_ext
* Return.....: return code
* Description: Start playback of a user-defined tune.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
S8 AUD_ringer_start_user_tone_ext(
    U8 handle,                      /* handle to the ringer/midi player resource */
    U8 DWD_HUGE *p_ringer_data,     /* pointer to the tune to be played */
    U32 size,                       /* size of the data to be played */
    aud_format_enum format,         /* format of the tune */
    U16 nof_repeats,                /* how many times the tune should be repeated (0 means forever) */
    aud_ringer_device_enum device,  /* the device to play the tune on */
    U8 channel,                     /* used for smaf-phrase format (channel 1-4 available) */
    U8 channel_volume, /* the volume level for the specified channel */
    UINT32 PlayEndCallBack);

/*------------------------------------------------------------------------------
* Function...: AUD_ringer_get_total_playtime_ext
* Return.....: return code
* Description: Returns the total playtime for the selected data.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
S8 AUD_ringer_get_total_playtime_ext(
    U8 handle,                          /* not used */
    U8 DWD_HUGE *p_data,                /* pointer to the melody data */
    U32 data_size,                      /* size of the melody data */
    aud_format_enum format,             /* format of the melody */
    aud_ringer_tone_id_enum tone_id,
    UINT32 TotalTimeCallBack
);    /* id of the melody  */

/*------------------------------------------------------------------------------
* Function...: AUD_ringer_get_playposition_ext
* Return.....: return code
* Description: Returns the elapsed time of the melody currently played.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
S8 AUD_ringer_get_playposition_ext(
    U8 handle,/* handle to the ringer/midi player resource */
    UINT32 PlayPositionCallBack);

/*------------------------------------------------------------------------------
* Function...: AUD_vm_start_recording_def
* Return.....: return code
* Description: Setup and start voice memo recording.
* Modified...: 27.07.2009 by wangjun
------------------------------------------------------------------------------*/
S8 AUD_vm_start_recording_def(
    U8 handle,                                    /* handle to the voice memo recorder */
    aud_vm_mode_enum vm_mode,    /* choose beween standby and tch mode */
    aud_media_enum media_type,      /* where to store the recording */
    aud_dsp_format_enum format,       /* which speech codec to use for recording */
    U8 rate,                                         /* sample rate if AMR is chosen af format */
    UINT32 callbackRec,                     /* used for vm callback */
    UINT32 callbackRate,                     /* used for byte per frame callback*/
    U32 offset);                                    /* the number of bytes to be left blank at the beginning of the buffer */


/*------------------------------------------------------------------------------
* Function...: AUD_tone_start_user_tone_def
* Return.....: return code
* Description: Start playing a used defined tone.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
S8 AUD_tone_start_user_tone_def(
    U8 handle,                            /* handle to the tone generator */
    void *p_tone_data,              /* pointer to the tone to be played */
    aud_tone_type_enum type,    /* single, dual or triple tone */
    U32 nof_tones,                    /* the number of tones to be played */
    U16 nof_repeats,                 /* how many times the tone should be repeated (0 means forever) */
    S16 mix_factor,                   /* not used */
    UINT32 callback);                 /*used for callback*/


/*------------------------------------------------------------------------------
* Function...: AUD_tone_start_def
* Return.....: return code
* Description: Start playing the specified tone.
* Modified...: 18.03.2009 by wangjun
------------------------------------------------------------------------------*/
S8 AUD_tone_start_def(
    U8 handle,                            /* handle to the tone generator */
    aud_tone_id_enum tone_id,   /* ID of the tone to be played */
    U16 nof_repeats,                 /* how many times the tone should be repeated (0 means forever) */
    S16 mix_factor,                   /* not used */
    UINT32 callback);                 /*used for callback*/


#endif

