/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Interface header file for the audio driver
 *
 * Revision Information:
 *   File name: \dwddrvif\inc\aud_opcodes.h
 *   Version: \main\67
 *   Date: 2007-08-06 10:19:02
 *   Responsible: johansek
 *   Comment:
 *     Added test case support for firmware K12 version 1.3 and 1.4 additions.
 */

#if !defined (_INC_AUD_OPCODESH)
#define _INC_AUD_OPCODESH

#if !defined (_WIN32)
 #if !defined (int16)
   #define int16  short
 #endif
 #if !defined (int32)
   #define int32  long
 #endif
#else /* _WIN32 */
 #if !defined (int16)
   #define int16  short int
 #endif
 #if !defined (int32)
   #define int32  int
 #endif
#endif /* _WIN32 */

#if defined (_WIN32)
#include "aud_drv.h"
#endif

#define AUD_TST_NOF_RESOURCE_INFO 8

/*******************************************************************************
*
*                                  Opcodes
*
*******************************************************************************/
typedef enum {
    atctst_AUD_vms_record,
    atctst_AUD_vms_play,
    atctst_AUD_vms_stop,
    atctst_AUD_vms_check_status,
    atctst_AUD_set_uplink_path,
    atctst_AUD_get_uplink_path,
    atctst_AUD_set_downlink_path,
    atctst_AUD_get_downlink_path,
    atctst_AUD_set_I2Sx_config,
    atctst_AUD_get_I2Sx_config,
    atctst_AUD_set_audio_mixing, /* 10 */
    atctst_AUD_get_audio_mixing,
    atctst_AUD_set_pcm_channel,
    atctst_AUD_get_pcm_channel,
    atctst_AUD_set_dsp_parameters,
    atctst_AUD_get_dsp_parameters,
    atctst_AUD_set_afe_parameters,
    atctst_AUD_get_afe_parameters,
    atctst_AUD_vm_stop_recording,
    atctst_AUD_vm_stop_playback,
    atctst_AUD_allocate_resource, /* 20 */
    atctst_AUD_release_resource,
    atctst_AUD_key_tone,
    atctst_AUD_speech_enable,
    atctst_AUD_speech_disable,
    atctst_AUD_speech_set_volume,
    atctst_AUD_speech_mute,
    atctst_AUD_vibrator_start,
    atctst_AUD_vibrator_stop,
    atctst_AUD_amp_enable,
    atctst_AUD_amp_disable, /* 30 */
    atctst_AUD_tone_start,
    atctst_AUD_tone_start_user_tone,
    atctst_AUD_tone_stop,
    atctst_AUD_ringer_start,
    atctst_AUD_ringer_start_user_tone,
    atctst_AUD_ringer_stop,
    atctst_AUD_ringer_suspend,
    atctst_AUD_ringer_stop_suspend,
    atctst_AUD_ringer_resume,
    atctst_AUD_ringer_set_volume , /* 40 */
    atctst_AUD_ringer_set_channel_volume,
    atctst_AUD_info_driver_status,
    atctst_AUD_info_hw_available,
    atctst_AUD_misc_set_accessory,
    atctst_AUD_init_resource_table,
    atctst_AUD_fetch_EGOLD_variables1,
    atctst_AUD_fetch_SGOLD_variables1,
    atctst_AUD_fetch_dsp_buf,
    atctst_AUD_ringer_start_user_tone2,
    atctst_AUD_create_fr_FFS,   /* 50 */
    atctst_AUD_open_read_DS_FFS,
    atctst_AUD_open_write_DS_FFS,
    atctst_AUD_create_AMR_FFS,
    atctst_AUD_delete_FFS_file,
    atctst_AUD_close_FFS,
    atctst_AUD_vms_record_mtest,
    atctst_AUD_vms_play_mtest,
    atctst_AUD_vms_stop_mtest,
    atctst_AUD_vms_check_status_mtest,
    atctst_AUD_vm_stop_recording_mtest, /* 60 */
    atctst_AUD_vm_stop_playback_mtest,
    atctst_AUD_set_dai_mode,
    atctst_AUD_get_dai_mode,
    atctst_AUD_set_pcm_routing,
    atctst_AUD_get_pcm_routing,
    atctst_AUD_update_paths,
    atctst_AUD_mp3_play,
    atctst_AUD_mp3_stop,
    atctst_AUD_mp3_pause,
    atctst_AUD_mp3_fastforward, /* 70 */
    atctst_AUD_mp3_backward,
    atctst_AUD_mp3_set_volume,
    atctst_AUD_get_mute_status,
    atctst_AUD_tty_enable,
    atctst_AUD_tty_disable,
    atctst_AUD_ringer_start_user_tone_emb,
    atctst_AUD_fetch_SGOLD_variables2,
    atctst_AUD_int_midi_start,
    atctst_AUD_int_midi_start_user_tone,
    atctst_AUD_int_midi_stop, /* 80 */
    atctst_AUD_int_midi_suspend,
    atctst_AUD_int_midi_stop_suspend,
    atctst_AUD_int_midi_resume,
    atctst_AUD_int_midi_set_volume,
    atctst_AUD_int_midi_generic,
    atctst_AUD_log_from_MMI_start,
    atctst_AUD_log_from_MMI_stop,
    atctst_AUD_log_from_MMI_read,
    atctst_AUD_log_from_MMI_flush,
    atctst_AUD_log_to_MMI_start, /* 90 */
    atctst_AUD_log_to_MMI_stop,
    atctst_AUD_log_to_MMI_read,
    atctst_AUD_log_to_MMI_flush,
    atctst_AUD_set_volume,
    atctst_AUD_vibrator_enable,
    atctst_AUD_vibrator_pause,
    atctst_AUD_vibrator_disable,
    atctst_AUD_set_afe,
    atctst_AUD_get_afe,
    atctst_AUD_ringer_get_total_playtime_emb, /* 100 */
    atctst_AUD_ringer_get_playposition,
    atctst_AUD_ringer_set_playposition,
    atctst_AUD_set_master_volume,
    atctst_AUD_set_resource_volume,
    atctst_AUD_mute_resource,
    atctst_AUD_mute_master,
    atctst_AUD_mp3_resume,
    atctst_AUD_vms_suspend,
    atctst_AUD_vms_resume,
    atctst_AUD_vms_get_total_playtime,  /* 110 */
    atctst_AUD_vms_set_play_position,
    atctst_AUD_vms_get_play_position,
    atctst_AUD_pcm_intern_start_playback,
    atctst_AUD_pcm_intern_stop_playback,
    atctst_AUD_pcm_intern_start_recording,
    atctst_AUD_pcm_intern_stop_recording,
    atctst_AUD_pcm_intern_suspend,
    atctst_AUD_pcm_intern_resume,
    atctst_AUD_pcm_intern_getbuffer_function,
    atctst_AUD_pcm_intern_get_total_playtime, /* 120 */
    atctst_AUD_pcm_intern_get_play_position,
    atctst_AUD_pcm_intern_set_play_position,
    atctst_AUD_ringer_get_total_playtime,
    atctst_AUD_tone_suspend,
    atctst_AUD_tone_resume,
    atctst_AUD_tone_get_play_position,
    atctst_AUD_tone_set_play_position,
    atctst_AUD_tone_get_total_playtime,
    atctst_AUD_get_volume_concept,               /* 129*/
    atctst_AUD_get_tonegenerator_state, /* 129 -> 130, implemented for SMS00041308 SMS00041309 */
    atctst_AUD_mapi,
    atctst_Aud_get_downlnk_parallel_path_configuration,
    atctst_Aud_get_uplink_parallel_path_configuration,
    atctst_Aud_get_resource_capability,
    atctst_AUD_mp3_set_playposition,
    atctst_AUD_mp3_get_playposition,
    atctst_AUD_mp3_get_totalplaytime,
    atctst_AUD_mp3_get_current_frame,
    atctst_AUD_mp3_stop_suspend,
    atctst_AUD_general_debug, /* 140 */
    atctst_AUD_add_uplinkpath,
    atctst_AUD_remove_uplinkpath,
    atctst_AUD_add_downlinkpath,
    atctst_AUD_remove_downlinkpath,
    atctst_AUD_get_power_saving_state,
    atctst_AUD_misc_layer1_info,
    atctst_AUD_download_internal_midi_instruments,
    atctst_AUD_update_audio_post_processor,
    atctst_AUD_dai_mode,
    atctst_AUD_bluetooth_config, /* 150 */
    atctst_AUD_configure_pcm_channel,
    atctst_AUD_pcm_channel_routing,
    atctst_AUD_pcm_channel_enable,
    atctst_AUD_pcm_channel_disable,
    atctst_AUD_radio_init,
    atctst_AUD_radio_enable,
    atctst_AUD_radio_disable,
    atctst_AUD_radio_read_current_status,
    atctst_AUD_radio_config,
    atctst_AUD_radio_mute, /* 160 */
    atctst_AUD_radio_set_station,
    atctst_AUD_misc_set_vmic,
    atctst_AUD_drv_restart_hf,
    atctst_AUD_set_EC_NR,
    atctst_AUD_set_ext_ringer_spreg,
    atctst_AUD_bluetooth_production_test,
    atctst_AUD_pcm_intern_stop_suspend,
    atctst_AUD_get_power_save_enabled,
    atctst_AUD_dsp_idle_event,
    atctst_AUD_3D_mode_enable, /* 170 */
    atctst_AUD_3D_mode_disable,
    atctst_AUD_get_tone_generator_parm,
    atctst_AUD_get_ringer_parm,
    atctst_AUD_get_volume_and_mute_parm,
    atctst_AUD_get_path_setting_parm,
    atctst_AUD_get_dsp_log,
    atctst_AUD_start_tone_phtest,
    atctst_AUD_fetch_EGOLDRADIO_path_variables ,
    atctst_AUD_get_speech_parm,
    atctst_AUD_epower_enable, /* 180 */
    atctst_AUD_epower_disable,
    atctst_AUD_fetch_AFE_register_values,
    atctst_AUD_radio_rssi_subscribe,
    atctst_AUD_radio_rds_subscribe,
    atctst_AUD_get_volume_parameters, /* deprecated - use atctst_AUD_get_volume_parameters_new */
    atctst_AUD_get_path_parameters,
    atctst_AUD_vms_stop_suspend,
    atctst_AUD_radio_read_hw_registers,
    atctst_AUD_set_postproc,
    atctst_AUD_get_postproc, /* 190 */
    atctst_AUD_uplink_paths_available,  /* deprecated - use atctst_AUD_uplink_paths_available_new */
    atctst_AUD_downlink_paths_available,/* deprecated - use atctst_AUD_downlink_paths_available_new */
    atctst_AUD_uplink_paths_status,     /* deprecated - use atctst_AUD_uplink_paths_status_new */
    atctst_AUD_downlink_paths_status,   /* deprecated - use atctst_AUD_downlink_paths_status_new */
    atctst_AUD_activate_hw,
    atctst_AUD_set_region,
    atctst_AUD_radio_get_frequency,
    atctst_AUD_set_media_to_uplink,
    atctst_AUD_get_media_to_uplink,
    atctst_AUD_set_media_to_downlink, /* 200 */
    atctst_AUD_get_media_to_downlink,
    atctst_AUD_ext_backspeaker_amp_control,
    atctst_AUD_Pathupdate_Enable,
    atctst_AUD_Pathupdate_Disable,
    atctst_AUD_ringer_start_SMW,
    atctst_AUD_manage_test_vector_SMW,
    atctst_AUD_ringer_get_total_playtime_SMW,
    atctst_AUD_clean_target,
    atctst_AUD_interface_SMW,
    atctst_AUD_module_test_state, /* 210 */
    atctst_AUD_start_FFT,
    atctst_AUD_read_out_FFT_result,
    atctst_AUD_sbc_encoder_start,
    atctst_AUD_sbc_encoder_stop,
    atctst_AUD_sbc_encoder_suspend,
    atctst_AUD_sbc_encoder_resume,
    atctst_AUD_sbc_encoder_set_getinputbuffer_function,
    atctst_AUD_get_available_melodies,
    atctst_AUD_get_resources,
    atctst_AUD_Start_ToneGenAndFFT_Req, /* 220 */
    atctst_AUD_get_uplink_path_names,
    atctst_AUD_get_downlink_path_names,
    atctst_AUD_get_volume_parameters_new,
    atctst_AUD_uplink_paths_status_new,
    atctst_AUD_downlink_paths_status_new,
    atctst_AUD_start_Ext_FFT,
    atctst_AUD_read_out_Ext_FFT_result,
    atctst_AUD_I2S_enable_resource,
    atctst_AUD_I2S_disable_resource,
    atctst_AUD_I2S_setup_clock, /* 230 */
    atctst_AUD_I2S_setup_resource,
    atctst_AUD_allocate_rambuffer,
    atctst_AUD_copy_rambuffer,
    atctst_AUD_deallocate_rambuffer,
    atctst_AUD_getstatus_rambuffer,
    atctst_AUD_pop_noise_ringer_start,
    atctst_AUD_pop_noise_ringer_stop,
    atctst_AUD_pop_noise_ringer_mute,
    atctst_AUD_pop_noise_ringer_unmute,
    atctst_AUD_non_baseband_resource_start, /* 240 */
    atctst_AUD_non_baseband_resource_stop,
    atctst_AUD_tty_set_neg,
    atctst_AUD_comp_ctrl_ext_amp,
    atctst_AUD_comp_ctrl_fm_radio,
    atctst_AUD_comp_ctrl_ext_switch,
    atctst_AUD_comp_ctrl_trig_conf,
    atctst_AUD_set_fir_filter,
    atctst_AUD_get_fir_filter,
    atctst_AUD_set_filter_switch,
    atctst_AUD_get_filter_switch,
    atctst_AUD_set_asp_ul,
    atctst_AUD_get_asp_ul,
    atctst_AUD_set_dl_nr,
    atctst_AUD_get_dl_nr,
    atctst_AUD_enum_end
} aud_opcode;
/*******************************************************************************
*                         Note to usage of aud_opcode enum:
*
*  ALWAYS add entries DIRECTLY to main branch in Clearcase and ALWAYS add
*  to the end of already existing entries.
*  Other procedures might result in problems with either testscripts or/and
*  Phonetool/production testing
*
*******************************************************************************/

/*******************************************************************************
*
*                          General opcode structures
*
*******************************************************************************/
typedef enum {
    DRIVER_TO_MMI,
    MMI_TO_DRIVER,
    DRIVER_TO_DSP,
    AUD_interface_enum_end
} AUD_interface_enum;

typedef struct {
    S16 status; /* FAIL = 0, OK = 1, NOT_SUPPORTED = 2, Custom codes */
} atctst_AUD_status;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 dummy;
    U32 rc32;   /* FAIL = 0, OK = 1, NOT_SUPPORTED = 2, Custom codes */
} atctst_aud_test_con_type;

typedef struct {
    U32 rc32;   /* FAIL = 0, OK = 1, NOT_SUPPORTED = 2, Custom codes */
} atctst_aud_test_req_type;

typedef struct {
    U8 handle;
} aud_opcode_handle_type; /* generic type commonly used in this file */

typedef struct {
    atctst_AUD_status result;
    S8 rc;
} aud_opcode_result_rc_type; /* generic type commonly used in this file */

typedef aud_opcode_result_rc_type atctst_AUD_dummy_con_type; /* first example of the use of aud_opcode_result_rc_type */

typedef struct {
    atctst_AUD_status result;
    char rc;
} atctst_AUD_epower_con;

typedef aud_opcode_result_rc_type atctst_AUD_info_driver_status_con_type;

typedef struct {
    U32 rc;
    U16 info_part1;
    U16 info_part2;
    atctst_AUD_status result;
} atctst_AUD_info_hw_available_con_type;

typedef struct {
    U8 accessory;
} atctst_AUD_misc_set_accessory_type;

typedef struct {
    atctst_AUD_status result;
    U8 aud_mode;
} atctst_AUD_misc_set_accessory_con_type;

typedef struct {
    U8 state;
} atctst_AUD_epower_req;

/* atctst_AUD_activate_hw_req is empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_activate_hw_con;

typedef struct {
    S16 power_saving_state;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_get_power_saving_state_con;

typedef struct {
    U8 status;
} atctst_AUD_misc_set_vmic_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_misc_set_vmic_con_type;

typedef struct {
    U8 none;
} atctst_AUD_get_power_save_enabled_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 enabled;
} atctst_AUD_get_power_save_enabled_con_type;

typedef struct {
    S8 CommandId;
} atctst_AUD_general_debug_type;

/* for testing region specific supervisory tones */
typedef struct {
    U16 region;
} atctst_AUD_set_region_type;

typedef struct {
    atctst_AUD_status result;
} atctst_AUD_set_region_con_type;

/*******************************************************************************
*
*                       MMI log related opcode structures
*
*******************************************************************************/
typedef union {
    U16 AllLogLevels;      /* everything together */
    struct LogLevelBits {
        unsigned Stuffing   :8; /* Stuffing LSByte */
        unsigned Parameter7 :1; /* bit 0 */
        unsigned Parameter6 :1; /* bit 1 */
        unsigned Parameter5 :1; /* bit 2 */
        unsigned Parameter4 :1; /* bit 3 */
        unsigned Parameter3 :1; /* bit 4 */
        unsigned Parameter2 :1; /* bit 5 */
        unsigned Parameter1 :1; /* bit 6 */
        unsigned Enabled    :1; /* bit 7 MSB */
    } Level; /* structure variable */
} LogLevels;

#define AUD_LOG_BUFSIZE 0x20
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 dummy_stuffing;
    U32 LogValues[AUD_LOG_BUFSIZE];
    LogLevels LogLevel;
    U16 Cntr; /* number of words written into buffer */
} atctst_AUD_log_from_MMI_read_con;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 dummy_stuffing;
    U32 LogValues[AUD_LOG_BUFSIZE];
    LogLevels LogLevel; /* 0 = off, 1 = all on */
    U16 Cntr; /* number of words written into buffer */
} atctst_AUD_log_to_MMI_read_con;

typedef struct {
    LogLevels LogLevel;
} atctst_AUD_log_from_MMI_start_req;

/* atctst_AUD_log_from_MMI_start_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_from_MMI_start_con_type;

/* atctst_AUD_log_from_MMI_stop_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_from_MMI_stop_con_type;

/* atctst_AUD_log_from_MMI_flush_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_from_MMI_flush_con_type;

/* atctst_AUD_log_to_MMI_start_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_to_MMI_start_con_type;

/* atctst_AUD_log_to_MMI_stop_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_to_MMI_stop_con_type;

/* atctst_AUD_log_to_MMI_flush_req is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_log_to_MMI_flush_con_type;

typedef struct {
    LogLevels LogLevel;
} atctst_AUD_log_to_MMI_start_req;

#if defined (AUD_MODULE_TEST_IFWD)
extern atctst_AUD_log_from_MMI_read_con AUD_from_MMI_log_buf;
extern atctst_AUD_log_from_MMI_read_con AUD_to_MMI_log_buf;
#endif

/*******************************************************************************
*
*                       Path related opcode structures
*
*******************************************************************************/
typedef struct {
    S16 uplink_path;
    S16 command; /* enable=1, disable=0 */
} atctst_AUD_set_uplink_path_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_uplink_path_con;

/* atctst_AUD_get_uplink_path_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S16 no_of_paths;
    S16 path[50];
    S8 rc;
} atctst_AUD_get_uplink_path_con;

typedef struct {
    S16 downlink_path;
    S16 command; /* enable=1, disable=0 */
} atctst_AUD_set_downlink_path_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_downlink_path_con;

/* atctst_AUD_get_uplink_path_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S16 no_of_paths;
    S16 path[50];
    S8 rc;
} atctst_AUD_get_downlink_path_con;

/* atctst_AUD_update_paths_req is empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_update_paths_con;

typedef struct {
    U8 path;
} atctst_AUD_path_req;

typedef atctst_AUD_path_req atctst_AUD_remove_downlinkpath_req_type;
typedef atctst_AUD_path_req atctst_AUD_remove_uplinkpath_req_type;
typedef atctst_AUD_path_req atctst_AUD_add_downlinkpath_req_type;
typedef atctst_AUD_path_req atctst_AUD_add_uplinkpath_req_type;
/* atctst_AUD_AUD_Pathupdate_Enable_req_type is empty, hence no declaration of this type */
/* atctst_AUD_AUD_Pathupdate_Disable_req_type is empty, hence no declaration of this type */

typedef aud_opcode_result_rc_type atctst_AUD_path_con;

typedef atctst_AUD_path_con atctst_AUD_remove_downlinkpath_con_type;
typedef atctst_AUD_path_con atctst_AUD_remove_uplinkpath_con_type;
typedef atctst_AUD_path_con atctst_AUD_add_downlinkpath_con_type;
typedef atctst_AUD_path_con atctst_AUD_add_uplinkpath_con_type;
typedef atctst_AUD_path_con atctst_AUD_Pathupdate_Enable_con_type;
typedef atctst_AUD_path_con atctst_AUD_Pathupdate_Disable_con_type;

/* atctst_AUD_uplink_paths_available_req is ,empty, hence no declaration of this type */
typedef struct { /* deprecated - use atctst_AUD_get_uplink_path_names */
    atctst_AUD_status result;
    S8 rc;
    U8 aud_handset_mic;
    U8 aud_headset_mic;
    U8 aud_I2S1_rx;
    U8 aud_tty_uplink;
    U8 aud_hfcarkit_mic;
    U8 aud_I2S1_inband_rx;
    U8 aud_handset_mic_42dB;
    U8 aud_handset_dthf_uplink;
    U8 aud_mic_mute;
    U8 aud_handset_mic_slidedown;
    U8 aud_handset_mic_loopback;
    U8 aud_I2S1_rx_loopback;
    U8 aud_media_to_uplink;
    U8 aud_media_to_uplink_hifi;
    U8 aud_hifi_stereo_mic;
} atctst_AUD_uplink_paths_available_con; /* deprecated */

/* atctst_AUD_downlink_paths_available_req is ,empty, hence no declaration of this type */
typedef struct { /* deprecated - use atctst_AUD_get_downlink_path_names */
    atctst_AUD_status result;
    S8 rc;
    U8 aud_normal_earpiece;
    U8 aud_mono_headset;
    U8 aud_stereo_headset;
    U8 aud_backspeaker;
    U8 aud_I2S1_tx;
    U8 aud_tty_downlink;
    U8 aud_mono_headset_external_ringer;
    U8 aud_stereo_headset_external_ringer;
    U8 aud_backspeaker_path_downlink;
    U8 aud_earpiece_path_downlink;
    U8 aud_backspeaker_external_ringer;
    U8 aud_hfcarkit_speaker;
    U8 aud_I2S1_inband_tx;  /* Special path used for routing inband audio (like ringtones) to the bt headset */
    U8 aud_backspeaker_stereo;
    U8 aud_fmradio_backspeaker;
    U8 aud_fmradio_headset;
    U8 aud_companion_mono_headset;
    U8 aud_companion_stereo_headset;
    U8 aud_companion_mono_backspeaker;
    U8 aud_companion_stereo_backspeaker;
    U8 aud_smpower_backspeaker;
    U8 aud_normal_earpiece_loopback;
    U8 aud_I2S1_tx_loopback;
    U8 aud_media_to_downlink_mute;
} atctst_AUD_downlink_paths_available_con; /* deprecated */

/* atctst_AUD_uplink_paths_status_req is empty, hence no declaration of this type */
typedef atctst_AUD_uplink_paths_available_con atctst_AUD_uplink_paths_status_con; /* deprecated - use atctst_AUD_uplink_paths_status_new_con */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 path[aud_uplink_source_end];
} atctst_AUD_uplink_paths_status_new_con;

/* atctst_AUD_downlink_paths_status_req is empty, hence no declaration of this type */
typedef atctst_AUD_downlink_paths_available_con atctst_AUD_downlink_paths_status_con; /* deprecated - use atctst_AUD_downlink_paths_status_new_con */
typedef struct {
    atctst_AUD_status  result;
    S8 rc;
    U8 path[aud_downlink_source_end];
} atctst_AUD_downlink_paths_status_new_con;

/* Functions from aud_phonetool_al.c used for communication with PhoneTool */
void aud_phonetool_downlink_paths_available(atctst_AUD_downlink_paths_available_con *p_con_data);  /* deprecated */
void aud_phonetool_uplink_paths_available(atctst_AUD_uplink_paths_available_con* p_con_data);      /* deprecated */
void AUD_uplink_paths_status(atctst_AUD_uplink_paths_status_con* p_con_data);                      /* deprecated */
void AUD_downlink_paths_status(atctst_AUD_downlink_paths_status_con* p_con_data);                  /* deprecated */
void AUD_uplink_paths_status_new(atctst_AUD_uplink_paths_status_new_con* p_con_data);
void AUD_downlink_paths_status_new(atctst_AUD_downlink_paths_status_new_con* p_con_data);

typedef struct {
    U8 path;
} atctst_AUD_path_configuration_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 dummy_stuffing;
    U32 path_configuration;
} atctst_AUD_path_configuration_con_type;

typedef struct {
    U8 start_index;     /* the path names do not fit in a single packet - where should we start from? */
} atctst_AUD_get_path_name_req_type;

typedef struct {
    U8 enum_value;
    U8 available;
    char name[22];
} aud_path_name_table_type;

typedef struct {
    atctst_AUD_status result;
    U8 nof_paths; /* number of paths in the packet */
    aud_path_name_table_type paths[(200-1-sizeof(atctst_AUD_status))/sizeof(aud_path_name_table_type)];
} atctst_AUD_get_path_name_con_type;

typedef struct {
    aud_path_name_table_type paths[aud_downlink_source_end];
} aud_downlink_path_name_array_type;

typedef struct {
    aud_path_name_table_type paths[aud_uplink_source_end];
} aud_uplink_path_name_array_type;

/*******************************************************************************
*
*                     Resource related opcode structures
*
*******************************************************************************/
typedef struct {
    U16 id;
    S8 resource;
    S8 priority;
} atctst_AUD_allocate_resource_type;

typedef aud_opcode_result_rc_type atctst_AUD_allocate_resource_con_type;

typedef aud_opcode_handle_type atctst_AUD_release_resource_type;

typedef aud_opcode_result_rc_type atctst_AUD_release_resource_con_type;

/* atctst_AUD_init_resource_table_req_type is ,empty, hence no declaration of this type */
typedef aud_opcode_result_rc_type atctst_AUD_init_resource_table_con_type;

typedef struct {
    U8 resource;
    U8 capability;
} atctst_AUD_resource_capability_req_type;

typedef struct {
    U32 uplink_paths_supported;
    U32 downlink_paths_supported;
    U32 resource_conflict;
    U32 features_supported;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_resource_capability_con_type;

typedef struct {
    U8 group;  /* 0: gives the 8 first resources,  1: gives the next 8 resources,  etc */
}atctst_AUD_get_resources_req_type;

typedef struct {
    S8 resource_text[15];
    U8 resource;
    U8 allocation;     /* 1: Free,  all other: Allocated */
    U8 main_state;     /* 0: Idle,  1: Active */
    U8 local_state;    /* 0xFA: State not available */
    U8 resource_volume;
    U8 mute;           /* enum: aud_mute_enum i aud_drv.h */
    U8 mute_direction; /* enum: aud_ul_dl_direction_enum i aud_drv.h */
} aud_resource_info_table_type;

typedef struct {
    atctst_AUD_status result;
    U8 nof_resources;
    U8 master_volume;
    U8 master_mute;
    aud_resource_info_table_type table[AUD_TST_NOF_RESOURCE_INFO];
} atctst_AUD_get_resources_con_type;

/*******************************************************************************
*
*                      Volume related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 volume;
} atctst_AUD_set_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_volume_con_type;

typedef struct {
    U8 volume;
} atctst_AUD_set_master_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_master_volume_con_type;

typedef struct {
    U8 handle;
    U8 enable_disable;
    U8 direction;
} atctst_AUD_mute_resource_type;

typedef aud_opcode_result_rc_type atctst_AUD_mute_resource_con_type;

typedef struct {
    U8 enable_disable;
} atctst_AUD_mute_master_type;

typedef aud_opcode_result_rc_type atctst_AUD_mute_master_con_type;

typedef struct {
    U8 handle;
    U8 volume;
} atctst_AUD_set_resource_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_resource_volume_con_type;
typedef aud_opcode_result_rc_type atctst_AUD_speech_mute_con_type;

typedef struct {
    atctst_AUD_status result;
    U8 Uplink_status;
    U8 Downlink_status;
    U8 UpDownlink_status;
    U8 Dowlink_left_dac_status;
    U8 Downlink_right_dac_status;
    S8 rc;
} atctst_AUD_get_mute_status_con;

typedef struct {
    S16  volume_concept_used;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_get_volume_concept_con;

#if defined(DWD_HW_ULC)
typedef struct {
    aud_volume_and_mute_glob_type volume;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_get_volume_and_mute_para_con;       /* cw_new */
#endif /* defined(DWD_HW_ULC) */

typedef struct { /* deprecated - use atctst_AUD_get_volume_parameters_new_con_type */
    atctst_AUD_status result;
    S8 rc;
    U8 master_volume;
    U8 resource0_volume;
    U8 resource1_volume;
    U8 resource2_volume;
    U8 resource3_volume;
    U8 resource4_volume;
    U8 resource5_volume;
    U8 resource6_volume;
    U8 resource7_volume;
    U8 resource8_volume;
    U8 resource9_volume;
    U8 resource10_volume;
    U8 resource11_volume;
    U8 resource12_volume;
    U8 resource13_volume;
    U8 resource14_volume;
    U8 resource15_volume;
    U8 resource16_volume;
    U8 resource17_volume;
    U8 resource18_volume;
    U8 resource19_volume;
    U8 resource20_volume;
} atctst_AUD_get_volume_parameters_con_type; /* deprecated */

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 master_volume;
    U8 resource_volume[aud_resource_end];
} atctst_AUD_get_volume_parameters_new_con_type;

/*******************************************************************************
*
*                      Speech related opcode structures
*
*******************************************************************************/
typedef aud_opcode_handle_type atctst_AUD_speech_enable_type;
typedef aud_opcode_result_rc_type atctst_AUD_speech_enable_con_type;
typedef aud_opcode_handle_type atctst_AUD_speech_disable_type;
typedef aud_opcode_result_rc_type atctst_AUD_speech_disable_con_type;

typedef struct {
    U8 handle;
    U8 volume;
} atctst_AUD_speech_set_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_speech_set_volume_con_type;
typedef aud_opcode_result_rc_type atctst_aud_drv_restart_hf_con_type;

typedef struct {
    U8 EC_state;
    U8 NR_state;
} atctst_AUD_set_EC_NR_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_EC_NR_con_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 speech_base_state;
    U8 volume_level_speech;
    U8 resource_muted_speech_UL;
    U8 resource_muted_speech_DL;
    U8 mute_direction_speech;
} atctst_AUD_get_speech_para_con; /* cw_new */

/*******************************************************************************
*
*                  Tone generator related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 tone_id;
    U16 nof_repeats;
    S16 mix_factor;
} atctst_AUD_tone_start_type;

typedef aud_opcode_result_rc_type atctst_AUD_tone_start_con_type;

typedef struct {
    U32 nof_tones;
    void *tone_data;
    U16 nof_repeats;
    S16 mix_factor;
    U8 handle;
    U8 type;
} atctst_AUD_tone_start_user_tone_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_tone_suspend_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_tone_suspend_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_tone_resume_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_tone_resume_con_type;

typedef struct {
    U32 nof_tones;
    void *tone_data;
    U8 type;
    U8 tone_id;
    U8 handle;
} atctst_AUD_tone_get_total_playtime_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_tone_get_total_playtime_con_type;
typedef aud_opcode_handle_type atctst_AUD_tone_get_play_position_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_tone_get_play_position_con_type;

typedef struct {
    U32 pos;
    U8 handle;
} atctst_AUD_tone_set_play_position_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_tone_set_play_position_con_type;
typedef aud_opcode_result_rc_type atctst_AUD_tone_start_user_tone_con_type;
typedef aud_opcode_handle_type atctst_AUD_tone_stop_type;
typedef aud_opcode_result_rc_type atctst_AUD_tone_stop_con_type;

typedef struct {
    U16 duration;
    U16 frequency1;
    U16 amplitude1;
    U16 frequency2;
    U16 amplitude2;
    U16 frequency3;
    U16 amplitude3;
    U8 handle;
} atctst_AUD_start_tone_phtest_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_start_tone_phtest_con_type;

typedef struct {
    U8 none;
} atctst_AUD_get_tonegenerator_state_type;

typedef struct {
    U8 tonegenerator_state;
    S8 rc;
    atctst_AUD_status result;
} atctst_AUD_get_tonegenerator_state_con_type;

/*******************************************************************************
*
*                      Ringer related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 tone_id;
    U16 nof_repeats;
    U8 device;
} atctst_AUD_ringer_start_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_start_con_type;

typedef struct {
    U8* data;
    U32 size;
    U16 nof_repeats;
    U8 handle;
    U8 format;
    U8 device;
    U8 channel;
    U8 channel_volume;
    U8 dummy_stuff;
} atctst_AUD_ringer_start_user_tone_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_start_user_tone_con_type;

typedef struct {
    U8 handle;
    U8 device;
    U8 channel;
    U8 channel_volume;
    U8 TestMelody;
    U8 DUMMY;
    U16 nof_repeats;
} atctst_AUD_ringer_start_user_tone_emb_type;

typedef struct {
    U8 handle;
    U8 channel;
} atctst_AUD_ringer_stop_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_stop_con_type;

typedef struct {
    U8 handle;
    U8 SlotID;
    U8 channel;
} atctst_AUD_ringer_suspend_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_suspend_con_type;

typedef struct {
    U8 handle;
    U8 SlotID;
    U8 channel;
} atctst_AUD_ringer_stop_suspend_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_stop_suspend_con_type;

typedef struct {
    U8 handle;
    U8 SlotID;
    U8 channel;
} atctst_AUD_ringer_resume_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_resume_con_type;

typedef struct {
    U8 handle;
    U8 volume;
} atctst_AUD_ringer_set_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_set_volume_con_type;

typedef struct {
    U8 handle;
    U8 channel_volume;
    U8 channel;
} atctst_AUD_ringer_set_channel_volume_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_set_channel_volume_con_type;

typedef struct {
    U32 offset;
    U8 handle;
    U8 channel;
} atctst_AUD_ringer_set_playposition_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_set_playposition_con_type;
typedef aud_opcode_handle_type atctst_AUD_ringer_get_playposition_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 err_code;
} atctst_AUD_ringer_get_playposition_con_type;

typedef struct {
    U8 handle;
    U8 TestMelodyId;
    U8 DWD_HUGE *data ;
    U32 data_size;
    U8 format;
    U8 tone_id;
} atctst_AUD_ringer_get_total_playtime_type;

typedef struct {
    U8 TestMelodyId;
    U8 handle;
} atctst_AUD_ringer_get_total_playtime_emb_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 err_code;
} atctst_AUD_ringer_get_total_playtime_con_type;

typedef struct {
    U32 FFS_handle;
    U8 handle;
} atctst_AUD_ringer_start_SMW_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_ringer_start_SMW_con_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 midi_player_state;
    U8 ringer_format;
    U8 ringer_nof_repeats;
} atctst_AUD_get_ringer_para_con; /* cw_new */

typedef aud_opcode_handle_type atctst_AUD_get_available_melodies_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    S8 dummy;
    U16 No_available_melodies;
    U8 midi_id[190];
} atctst_AUD_get_available_melodies_con_type;

typedef struct {
    U8 instrument_set_to_use;
} atctst_AUD_download_internal_midi_instruments_type;

typedef aud_opcode_result_rc_type atctst_AUD_download_internal_midi_instruments_con_type;

/*******************************************************************************
*
*                     Postproc related opcode structures
*
*******************************************************************************/
typedef aud_opcode_result_rc_type atctst_AUD_update_audio_post_processor_con_type;

typedef struct {
    U16 AudioPostProcSwitch;
    S16 b_exp;
    S16 b1;
    S16 b0;
    S16 a1;
    S16 INITDATA_mono_flag;
    S16 INITDATA_m_bufflen;
    S16 INITDATA_m_inv_bufflen;
    S16 INITDATA_m_hp_coef_exp;
    S16 INITDATA_m_lp1_coef;
    S16 INITDATA_m_lp2_coef;
    S16 INITDATA_m_lp4_coef;
    S16 INITDATA_m_lp3_coef;
    S16 INITDATA_m_L_A;
    S16 INITDATA_m_L_Bf;
    S16 INITDATA_m_G_Comp;
    S16 INITDATA_um_R_infA;
    S16 INITDATA_um_R_AB;
    S16 INITDATA_um_R_B0;
} atctst_AUD_set_postproc_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_postproc_con;

/* atctst_AUD_get_postproc_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    atctst_AUD_set_postproc_req dsp;
} atctst_AUD_get_postproc_con;

/*******************************************************************************
*
*                     Vibrator related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 mode;
    U8 on;
    U8 off;
} atctst_AUD_vibrator_start_type;

typedef aud_opcode_result_rc_type atctst_AUD_vibrator_start_con_type;
typedef aud_opcode_handle_type atctst_AUD_vibrator_stop_type;
typedef aud_opcode_result_rc_type atctst_AUD_vibrator_stop_con_type;

typedef struct {
    U8 mode;
    U8 ch;
} atctst_AUD_vibrator_enable_type;

typedef aud_opcode_result_rc_type atctst_AUD_vibrator_enable_con_type;
/* atctst_AUD_vibrator_pause_req_type is not defined */
typedef aud_opcode_result_rc_type atctst_AUD_vibrator_pause_con_type;
/* atctst_AUD_vibrator_disable_req_type is not defined */
typedef aud_opcode_result_rc_type atctst_AUD_vibrator_disable_con_type;

/*******************************************************************************
*
*                    Amplifier related opcode structures
*
*******************************************************************************/
typedef aud_opcode_handle_type    atctst_AUD_amp_enable_type;
typedef aud_opcode_result_rc_type atctst_AUD_amp_enable_con_type;
typedef aud_opcode_handle_type    atctst_AUD_amp_disable_type;
typedef aud_opcode_result_rc_type atctst_AUD_amp_disable_con_type;

/*******************************************************************************
*
*                     FM radio related opcode structures
*
*******************************************************************************/
typedef aud_opcode_handle_type atctst_AUD_radio_enable_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_radio_enable_con_type;
typedef aud_opcode_handle_type atctst_AUD_radio_disable_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_radio_disable_con_type;

typedef struct {
    U8 handle;
    U8 lower_threshold;
    U8 upper_threshold;
} atctst_AUD_radio_rssi_subscribe_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_radio_rssi_subscribe_con_type;

typedef struct {
    U32 pCbFunc;
    U8 handle;
} atctst_AUD_radio_rds_subscribe_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_radio_rds_subscribe_con_type;

typedef struct {
    U32 frequency;
    U8 handle;
    U8 seekmode;
    U8 detect_level;
    U8 force_mono;
} atctst_AUD_radio_set_station_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_radio_set_station_con_type;
typedef aud_opcode_handle_type atctst_AUD_radio_get_frequency_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_radio_get_frequency_con_type;
typedef aud_opcode_handle_type atctst_AUD_radio_read_current_status_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    /* -- 1 filler byte -- */
    struct {
        U8 result_code;
        /* -- 3 filler bytes -- */
        U32 frequency;
    } seek_result;
    struct {
        U8 stereo;
        U8 level;
    } rssi_result;
    /* -- 2 filler bytes -- */
    struct {
        U8 program_station[8];
        U8 radio_text[64];
    } rds_result;
} atctst_AUD_radio_read_current_status_con_type;

typedef aud_opcode_handle_type atctst_AUD_radio_read_hw_registers_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U16 contents[16];
} atctst_AUD_radio_read_hw_registers_con_type;

/*******************************************************************************
*
*                    Voice memo related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 vm_mode;
    U8 media;
    U8 format;
    U8 rate;
    U32*fileHandle;
    U32 buffer_size;
    U32 offset;
    U8 handle;
} atctst_AUD_vms_start_recording_req;

typedef struct {
    S8 rc;
    S8 Dummy;
    atctst_AUD_status  result;
} atctst_AUD_vms_start_recording_con;

typedef struct {
    S16 vm_mode;
    S16 alpha0;
    S16 alpha1;
    S16 beta0;
    S16 beta1;
    S16 gamma0;
    S16 gamma1;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_fetch_SGOLD_variables1_con;

typedef struct {
    U8 handle;
    U8 vm_mode;
    U8 media;
    U8 format;
    U32 fileHandle;
    U32 buffer_size;
    U32 offset;
    U16 nof_repeats;
} atctst_AUD_vms_start_playback_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_start_playback_con;
typedef aud_opcode_result_rc_type atctst_AUD_vms_stop_voicememo_con;
typedef aud_opcode_result_rc_type atctst_AUD_vm_stop_recording_con;
typedef aud_opcode_result_rc_type atctst_AUD_vm_stop_playback_con;

typedef struct {
    U8 slot_id;
    U8 handle;
} atctst_AUD_vms_stop_suspend_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_stop_suspend_con;

typedef struct {
    U8 slot_id;
    U8 handle;
} atctst_AUD_vms_suspend_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_suspend_con;

typedef struct {
    U8 slot_id;
    U8 handle;
} atctst_AUD_vms_resume_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_resume_con;

/* atctst_AUD_vms_check_status_req is not defined */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    S8 Dummy;
    S16 vms_status;
} atctst_AUD_vms_check_status_con;

typedef struct {
    U8 media;
    U8 format;
    U32 *fileHandle;
    U32 buffer_size;
    U32 offset;
    U8 handle;
    U8 vm_mode;
} atctst_AUD_vms_get_total_playtime_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_get_total_playtime_con;

typedef struct {
    U8 dummy;
    U8 handle;
    U32 *fileHandle;
    U32 pos;
    U32 buffer_size;
} atctst_AUD_vms_set_play_position_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_set_play_position_con;

typedef aud_opcode_handle_type atctst_AUD_vms_get_play_position_req;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_vms_get_play_position_con;

typedef struct {
    U8 vm_mode;
    U8 media;
    U8 format;
    U8 rate;
    U32 *fileHandle;
} atctst_AUD_vms_start_recording_mtest_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_start_recording_mtest_con;

typedef struct {
    U8 vm_mode;
    U8 media;
    U8 format;
    U32 *fileHandle;
} atctst_AUD_vms_start_playback_mtest_req;

typedef aud_opcode_result_rc_type atctst_AUD_vms_start_playback_mtest_con;
typedef aud_opcode_result_rc_type atctst_AUD_vms_stop_voicememo_mtest_con;
typedef aud_opcode_result_rc_type atctst_AUD_vm_stop_recording_mtest_con;
typedef aud_opcode_result_rc_type atctst_AUD_vm_stop_playback_mtest_con;

/*******************************************************************************
*
*                        MP3 related opcode structures
*
*******************************************************************************/
typedef struct {
    U16 nof_repeats;
    U16 media;
    U32 fileHandle;
    U32 id3v2_offset;
    U32 start_frame;
    U16 buffer_size;
    U16 handle;
} atctst_AUD_mp3_play_req;

typedef struct {
    S8 rc;
} atctst_AUD_mp3_play_con;

typedef struct {
    U16 slot_id;
    U32 frame_no;
    U8  handle;
} atctst_AUD_mp3_fastforward_req;

typedef struct {
    U16 slot_id;
    U32 frame_no;
    U8 handle;
} atctst_AUD_mp3_backward_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_stop_con;

typedef struct {
    U16 slot_id;
    U8 handle;
} atctst_AUD_mp3_pause_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_pause_con;

typedef struct {
    U16 slot_id;
    U8 handle;
} atctst_AUD_mp3_resume_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_resume_con;
typedef aud_opcode_result_rc_type atctst_AUD_mp3_fastforward_con;
typedef aud_opcode_result_rc_type atctst_AUD_mp3_backward_con;

typedef struct {
    U8 dummy;
    U8 handle;
    U32 position;
    U32 file_handle;
    U32 buffer_size;
} atctst_AUD_mp3_set_playposition_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_setposition_con;
typedef aud_opcode_result_rc_type atctst_AUD_mp3_getplayposition_con;

typedef struct {
    U16 media;
    U32 fileHandle;
    U32 id3v2_offset;
    U16 buffer_size;
    U16 handle;
} atctst_AUD_mp3_get_totalplaytime_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_get_totalplaytime_con;

typedef struct {
    U16 slot_id;
    U8 handle;
} atctst_AUD_mp3_get_currentframe_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_get_currentframe_con;

typedef struct {
    U16 slot_id;
    U8 handle;
} atctst_AUD_mp3_stop_suspend_req;

typedef aud_opcode_result_rc_type atctst_AUD_mp3_stop_suspend_con;

/*******************************************************************************
*
*                    PCM channel related opcode structures
*
*******************************************************************************/
typedef struct {
    S16 enable;
    S16 pcm_direction;
} atctst_AUD_set_pcm_channel_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_pcm_channel_con;
/* atctst_AUD_get_pcm_channel_req is empty, hence no declaration of this type */

typedef struct {
    atctst_AUD_status result;
    S16 pcm_direction;
    S8 rc;
} atctst_AUD_get_pcm_channel_con;

typedef struct {
    U16 input_to_uplink;
    U16 input_to_downlink;
    U16 output_from_uplink;
    U16 output_from_downlink;
} atctst_AUD_set_pcm_routing_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_pcm_routing_con;
/* atctst_AUD_get_pcm_routing_req is empty, hence no declaration of this type */

typedef struct {
    atctst_AUD_status result;
    U16 input_to_uplink;
    U16 input_to_downlink;
    U16 output_from_uplink;
    U16 output_from_downlink;
    U16 pcm_direction;
    S8 rc;
} atctst_AUD_get_pcm_routing_con;

typedef struct {
    U8 handle;
    U8 mode;
} atctst_AUD_configure_pcm_channel_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_configure_pcm_channel_con_type;

typedef struct {
    U8 handle;
    U8 input_to_uplink;
    U8 input_to_downlink;
    U8 output_from_uplink;
    U8 output_from_downlink;
} atctst_AUD_pcm_channel_routing_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_channel_routing_con_type;

typedef struct {
    U8 handle;
    U8 direction;
} atctst_AUD_pcm_channel_enable_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_channel_enable_con_type;
typedef aud_opcode_handle_type atctst_AUD_pcm_channel_disable_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_pcm_channel_disable_con_type;

/*******************************************************************************
*
*                        DAI related opcode structures
*
*******************************************************************************/
typedef struct {
    U16 dai_mode;
} atctst_AUD_set_dai_mode_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_dai_mode_con;

/* atctst_AUD_get_dai_mode_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    U16 dai_mode;
    S8 rc;
} atctst_AUD_get_dai_mode_con;

typedef atctst_AUD_set_dai_mode_req atctst_AUD_dai_mode_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U16 dai_mode;
} atctst_AUD_dai_mode_con_type;

/*******************************************************************************
*
*                        TTY related opcode structures
*
*******************************************************************************/
typedef aud_opcode_handle_type atctst_AUD_tty_enable_type;
typedef aud_opcode_handle_type atctst_AUD_tty_disable_type;
typedef aud_opcode_handle_type atctst_AUD_tty_enable_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_tty_enable_con_type;
typedef aud_opcode_handle_type atctst_AUD_tty_disable_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_tty_disable_con_type;
typedef aud_opcode_result_rc_type atctst_AUD_tty_set_neg_con_type;

typedef struct {
UINT8 req;
UINT8 handle;
}
atctst_AUD_tty_set_neg_req_type;

/*******************************************************************************
*
*                PCM player/recorder related opcode structures
*
*******************************************************************************/
typedef struct {
    U32 start_offset;
    U32 buffer_size;
    U16 *file_handle;
    U16 nof_repeats;
    U8 handle;
    U8 bit_rate;
    U8 mode;
    U8 sample_rate;
    U8 media_type;
    U8 format;
} atctst_AUD_pcm_intern_start_playback_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_start_playback_con_type;
typedef aud_opcode_handle_type atctst_AUD_pcm_intern_stop_playback_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_stop_playback_con_type;

typedef struct {
    U32 start_offset;
    U32 buffer_size;
    U16 *file_handle;
    U8 handle;
    U8 bit_rate;
    U8 mode;
    U8 sample_rate;
    U8 media_type;
    U8 format;
} atctst_AUD_pcm_intern_start_recording_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_start_recording_con_type;

typedef struct {
    U8 handle;
} atctst_AUD_pcm_intern_stop_recording_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_stop_recording_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_pcm_intern_suspend_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_suspend_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_pcm_intern_stop_suspend_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_stop_suspend_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_pcm_intern_resume_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_resume_con_type;

typedef struct {
    U8 *file_handle;
    void *user_data;
    U8 handle;
} atctst_AUD_pcm_intern_getbuffer_function_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_getbuffer_function_con_type;

typedef struct {
    U8 mode;
    U8 bit_rate;
    U32 buffer_size;
    U16 *file_handle;
    U8 sample_rate;
    U8 media_type;
    U8 format;
    U8 handle;
    U32 offset;
} atctst_AUD_pcm_intern_get_total_playtime_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_get_total_playtime_con_type;

typedef struct {
    U8 handle;
} atctst_AUD_pcm_intern_get_play_position_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_get_play_position_con_type;

typedef struct {
    U32 pos;
    U32 buffer_size;
    U16 *file_handle;
    U8 handle;
} atctst_AUD_pcm_intern_set_play_position_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_pcm_intern_set_play_position_con_type;

/*******************************************************************************
*
*                       MAPI related opcode structures
*
*******************************************************************************/
typedef struct {
    U32 handle;
    U32 func_id;
    U32 parm1;
    U32 parm2;
    U32 parm3;
    U32 parm4;
    U32 parm5;
    U32 parm6;
    U32 parm7;
} atctst_AUD_mapi_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_mapi_con_type;

/*******************************************************************************
*
*          Non-baseband (inband) resource related opcode structures
*
*******************************************************************************/
typedef aud_opcode_handle_type    atctst_AUD_non_baseband_resource_start_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_non_baseband_resource_start_con_type;
typedef aud_opcode_handle_type    atctst_AUD_non_baseband_resource_stop_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_non_baseband_resource_stop_con_type;

/*******************************************************************************
*
*                   SBC Encoder related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 data_mode;
    U8 channel_mode;
    U8 sample_rate;
    U8 no_of_blocks;
    U8 bitpool;
} atctst_AUD_sbc_encoder_start_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_sbc_encoder_start_con_type;
typedef aud_opcode_handle_type atctst_AUD_sbc_encoder_stop_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_sbc_encoder_stop_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_sbc_encoder_suspend_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_sbc_encoder_suspend_con_type;

typedef struct {
    U8 handle;
    U8 slot_id;
} atctst_AUD_sbc_encoder_resume_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_sbc_encoder_resume_con_type;

typedef struct {
    U8 *ptr;
    void *user_data;
    U8 handle;
} atctst_AUD_sbc_encoder_set_getinputbuffer_function_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 compare_result;
} atctst_AUD_sbc_encoder_set_getinputbuffer_function_con_type;

/*******************************************************************************
*
*                       I2S2 related opcode structures
*
*******************************************************************************/
typedef struct {
    S16 I2Sx_device;
    S16 I2Sx_mode;
} atctst_AUD_set_I2Sx_config_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_I2Sx_config_con;

typedef struct {
    S16 I2Sx_device;
} atctst_AUD_get_I2Sx_config_req;

typedef struct {
    atctst_AUD_status result;
    S16 I2Sx_device;
    S16 I2Sx_mode;
    S8 rc;
} atctst_AUD_get_I2Sx_config_con;

typedef aud_opcode_handle_type atctst_AUD_I2S_enable_resource_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_I2S_enable_resource_con_type;
typedef aud_opcode_handle_type atctst_AUD_I2S_disable_resource_req_type;
typedef aud_opcode_result_rc_type atctst_AUD_I2S_disable_resource_con_type;

typedef struct {
    U8 clock;
    U8 Master_Slave;
    U8 samplerate;
    U8 sample_width;
    U8 transmission_mode;
    U8 settings;
    U8 I2S_mode;
} atctst_AUD_I2S_setup_clock_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_I2S_setup_clock_con_type;

typedef struct {
    U8 handle;
    U8 clock;
    U8 entry_point;
} atctst_AUD_I2S_setup_resource_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_I2S_setup_resource_con_type;

/*******************************************************************************
*
*                     Bluetooth related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 handle;
    U8 mode;
} atctst_AUD_bluetooth_config_type;

typedef aud_opcode_result_rc_type atctst_AUD_bluetooth_config_con_type;

typedef struct {
    U8 bt_test_state;
    U8 data;
} atctst_AUD_bluetooth_production_test_type;

typedef aud_opcode_result_rc_type atctst_AUD_bluetooth_production_test_con_type;

/*******************************************************************************
*
*                        FFS related opcode structures
*
*******************************************************************************/
typedef struct {
    S8 rc;
    U8 Dummy;
    atctst_AUD_status result;
} atctst_AUD_create_fr_FFS_con;

typedef atctst_AUD_create_fr_FFS_con atctst_AUD_create_AMR_FFS_con;
typedef atctst_AUD_create_fr_FFS_con atctst_AUD_delete_FFS_file_con;
typedef atctst_AUD_create_fr_FFS_con atctst_AUD_open_readDS_FFS_con;
typedef atctst_AUD_create_fr_FFS_con atctst_AUD_open_writeDS_FFS_con;
typedef atctst_AUD_create_fr_FFS_con atctst_AUD_close_FFS_con;

/*******************************************************************************
*
*        Media to up-/downlink related opcode structures - deprecated
*
*******************************************************************************/
typedef struct {
    U8 enable_disable;
} atctst_AUD_set_media_to_uplink_req_type; /* deprecated */

typedef struct {
    atctst_AUD_status result;
} atctst_AUD_set_media_to_uplink_con_type; /* deprecated */

/* atctst_AUD_get_media_to_uplink_req_type is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    U8 enable_disable;
} atctst_AUD_get_media_to_uplink_con_type; /* deprecated */

typedef struct {
    U8 enable_disable;
} atctst_AUD_set_media_to_downlink_req_type; /* deprecated */

typedef struct {
    atctst_AUD_status  result;
} atctst_AUD_set_media_to_downlink_con_type; /* deprecated */

/* atctst_AUD_get_media_to_downlink_req_type is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    U8 enable_disable;
} atctst_AUD_get_media_to_downlink_con_type; /* deprecated */

/*******************************************************************************
*
*                       Miscellaneous opcode structures
*
*******************************************************************************/
typedef struct {
    U16 key_tone;
    S16 mix_factor;
} atctst_AUD_key_tone_type;

typedef aud_opcode_result_rc_type atctst_AUD_key_tone_con_type;

typedef struct {
    U8 RegValue;
} atctst_AUD_set_ext_ringer_spreg_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_3D_mode_con_type;

typedef struct {
    U16 on;
} atctst_AUD_ext_backspeaker_amp_control_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_ext_backspeaker_amp_control_con_type;

/*******************************************************************************
*
*                   FFT analysis related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 runtime; /* not used currently */
    U16 FFT_PosF1;
    U16 FFT_UpLimF1;
    U16 FFT_LowLimF1;
} atctst_AUD_start_FFT_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U16 FFT_result;
} atctst_AUD_read_out_FFT_result_con_type;

#if defined SGOLD2
#define AUD_MAX_TONE_FREQ_NUM		3

typedef struct {
    U16	freq;			/* Hz */
    U16	amplitude;		/* 0x0000~0x7FFF */
} InputToneVal_Type;

typedef struct {
    U16 NoOfFrames;
    U16 AverageExponent;
    InputMicVal_Type MicVal[AUD_MAX_MIC_FREQ_NUM];
    U16 RefLevel;
    U16 QFormat;
    U8 aud_uplink_path;
    U8 aud_downlink_path;
    U16 MasterVolume_Level;
    U16 RefScalIn;
    U16 RefScalOut;
    U16 Tone_duration;
    InputToneVal_Type TonVal[AUD_MAX_TONE_FREQ_NUM];
} atctst_AUD_Start_ToneGenAndFFT_Req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U16 NoOfFs;
    U16 NoOfLim;
    U16 ScalIn_Ref;
    U16 Ppeak;
    U16 Npeak;
    U16 Levelfx[6];
} atctst_AUD_Start_ToneGenAndFFT_Cnf_type;

typedef struct {
	U16 NoOfFrames;
	U16 AverageExponent;
	InputMicVal_Type MicVal[AUD_MAX_MIC_FREQ_NUM];
	U16 RefLevel;
	U16 QFormat;
} atctst_AUD_StartFFT_type;

typedef aud_opcode_result_rc_type atctst_AUD_StartFFT_Con_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    T_DSP_CMD_ACOUSTIC_TEST_RESULT_PAR FFT_MeasResult;
} atctst_AUD_Get_FFT_Ext_Cnf_type;
#endif /* SGOLD2 */

/*******************************************************************************
*
*                    RAM buffer related opcode structures
*
*******************************************************************************/
typedef struct {
    aud_format_enum format;
    U32 size;
} atctst_AUD_allocate_rambuffer_type;

typedef struct {
    atctst_AUD_status result;
} atctst_AUD_allocate_rambuffer_con_type;

typedef struct {
    U8 data[196];
    U32 size;
} atctst_AUD_copy_rambuffer_type;

typedef struct {
    atctst_AUD_status result;
    U32 datawritten;
} atctst_AUD_copy_rambuffer_con_type;

typedef struct {
    atctst_AUD_status result;
} atctst_AUD_deallocate_rambuffer_con_type;

typedef struct{
    atctst_AUD_status result;
    aud_testrambuffer_status_enum rambufstatus;
} atctst_AUD_getstatus_rambuffer_con_type;

/*******************************************************************************
*
*                      SGoldX related opcode structures
*
*******************************************************************************/
typedef struct {
    U8 none;
} atctst_AUD_fetch_EGOLD_variables1_type;

typedef struct {
    U8 base_state;
    U32 longinttest;
    U8 tone_duration;
    U8 speech_vol;
    U8 resumed;
    U8 aud_mode;
    U8 ringer_state;
    U8 ringer_vol;
    U8 resumeoffset0;
    U8 resumeoffset1;
    U8 resumeoffset2;
    U8 resumeoffset3;
    U8 MA2_Ch0Active;
    U8 MA2_Ch1Active;
    U8 MA2_Ch2Active;
    U8 MA2_Ch3Active;
    U8 midi_player_state;    /* 16 */
    U8 melody_format;
    U8 melody_volume;
    U16 melody_nof_repeats;
    U8 melody_conv_error;
    U8 tone_id;
    U8 alignement_byte1;
    U8 ffs_error_code;
    U32 ffs_handle;
    S16 *ffs_handle2;
    U8 vms_state;
    U8 alignement_byte2;
    U8 alignement_byte3;
    U8 MA_status_cntr;
    U32 TestTimerCh1;
    U32 TestTimerCh2;
    U32 TestTimerCh3;
    U32 TestTimerCh4;
    U32 aud_ma_error_cntr;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_fetch_EGOLD_variables1_con_type;

typedef struct {
    U8 none;
} atctst_AUD_fetch_SGOLD_variables2_type;

typedef struct {
    S8 status;
} atctst_AUD_fetch_EGOLDRADIO_path_variables_req_type;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    U8 dummy_stuffing;
    U8 uplink_path_array[4];
    U8 downlink_path_array[4];
} atctst_AUD_fetch_EGOLDRADIO_path_variables_con_type;

typedef struct {
    U8 base_state;
    U8 tone_duration;
    U8 speech_vol;
    U8 resumed;
    U8 aud_mode;
    U8 ringer_state;
    U8 ringer_vol;
    U8 resumeoffset0;
    U8 resumeoffset1;
    U8 resumeoffset2;
    U8 resumeoffset3;
    U8 MA_Ch0Active;
    U8 MA_Ch1Active;
    U8 MA_Ch2Active;
    U8 MA_Ch3Active;
    U8 midi_player_state;    /* 16 */
    U8 melody_format;
    U8 melody_volume;
    U16 melody_nof_repeats;
    U8 melody_conv_error;
    U8 tone_id;
    U8 alignement_byte1; /* 23 */
    U8 ffs_error_code;
    U32 ffs_handle;
    U32* ffs_handle2;
    U8 vms_state;
    U8 alignement_byte2;
    U8 alignement_byte3;
    U8 MA_status_cntr;
    U32 TestTimerCh1;
    U32 TestTimerCh2;
    U32 TestTimerCh3;
    U32 TestTimerCh4;
    U32 aud_ma_error_cntr;
    U8 speech_base_state; /* 57 */
    U8 tone_base_state;
    U8 amplifier_base_state;
    U8 ringer_base_state;
    U8 fm_radio_base_state;
    U8 playback_vm_base_state;
    U8 playback_mp3_base_state;
    U8 tty_base_state;
    U8 vibrator_base_state;
    U8 midi_player_base_state;
    U8 pcm_channel_base_state;
    U8 tty_mode;
    U8 tty_no_neg;
    U8 speech_volume; /* 70 */
    U8 master_volume_store;
    U8 master_mute_store;
    U8 volume_level_speech;
    U8 resource_muted_speech_UL;
    U8 resource_muted_speech_DL;
    U8 mute_direction_speech;
    U8 volume_level_tone;
    U8 resource_muted_tone_UL;
    U8 resource_muted_tone_DL;
    U8 mute_direction_tone;
    U8 volume_level_vm;
    U8 resource_muted_vm_UL;
    U8 resource_muted_vm_DL;
    U8 mute_direction_vm;
    U8 volume_level_mp3;
    U8 resource_muted_mp3_UL;
    U8 resource_muted_mp3_DL;
    U8 mute_direction_mp3;
    U8 volume_level_pcm;
    U8 resource_muted_pcm_UL;
    U8 resource_muted_pcm_DL;
    U8 mute_direction_pcm;
    U8 volume_level_midi;
    U8 resource_muted_midi_UL;
    U8 resource_muted_midi_DL;
    U8 mute_direction_midi;
    U8 volume_level_playback_pcm;
    U8 resource_muted_playback_pcm_UL;
    U8 resource_muted_playback_pcm_DL;
    U8 mute_direction_playback_pcm;
    U8 mp3_state;
    U8 DownLinkPathsConfig[aud_downlink_source_end];
    U8 UpLinkPathsConfig[aud_uplink_source_end];
    U8 pcm_base_state;
    U8 bluetooth_mode;
    U8 Handsfree_state;
    S16 AUD_EC_NR_mask_value;
    atctst_AUD_status result;
    S8 rc;
} atctst_AUD_fetch_SGOLD_variables2_con_type;

/*******************************************************************************
*
*                        DSP related opcode structures
*
*******************************************************************************/
typedef struct {
    S16 alpha0; /* 0 */
    S16 alpha1;
    S16 beta0;
    S16 beta1;
    S16 gamma0;
    S16 gamma1; /* 5 */
    S16 delta0;
    S16 delta1;
    S16 kappa0;
    S16 kappa1;
    S16 lambda0; /* 10 */
    S16 lambda1;
    S16 biquad_in_1_a0;
    S16 biquad_in_1_a1;
    S16 biquad_in_1_a2;
    S16 biquad_in_1_b1; /* 15 */
    S16 biquad_in_1_b2;
    S16 biquad_in_2_a0;
    S16 biquad_in_2_a1;
    S16 biquad_in_2_a2;
    S16 biquad_in_2_b1; /* 20 */
    S16 biquad_in_2_b2;
    S16 biquad_out_1_a0;
    S16 biquad_out_1_a1;
    S16 biquad_out_1_a2;
    S16 biquad_out_1_b1; /* 25 */
    S16 biquad_out_1_b2;
    S16 biquad_out_2_a0;
    S16 biquad_out_2_a1;
    S16 biquad_out_2_a2;
    S16 biquad_out_2_b1; /* 30 */
    S16 biquad_out_2_b2;
    S16 mic_mute;
    S16 speech_mix;
    S16 ton_mix;
    S16 gain_out;
    S16 side_ton; /* 35 */
    S16 scal_mic;
    S16 scal_in;
    S16 scal_rec;
    S16 scal_out; /* 40 */
    S16 mix_I2S1;
    S16 mix_afe;
    S16 scal_SAPP;
    S16 scal_ext;
    S16 gain_analog; /* 45 */
    S16 step_width;
    S16 LMS_length;
    S16 LMS_offset;
    S16 block_length;
    S16 rxtx_relation; /* 50 */
    S16 add_atten;
    S16 min_atten;
    S16 max_atten;
    S16 hands_free;
    S16 NR_SW2; /* 55 */
    S16 NR_U_Fak;
    S16 NR_U_Fak_0;
    S16 scal_afe;
    S16 scal_mic2;
    S16 afe_tone; /* 60 */
    S16 mic_gain;
    S16 tx_dither;
    S16 scal_pcm;
    S16 ton_mix_ul;
    S16 ton_mix_dl; /* 65 */
    S16 speech_mix_ul; /* parameter 66 => total number of parameters = 67 */
    S16 mix_pcmrec;
    S16 biquad_cbuf1_a0;
    S16 biquad_cbuf1_a1;
    S16 biquad_cbuf1_a2; /* 70 */
    S16 biquad_cbuf1_b1;
    S16 biquad_cbuf1_b2;
    S16 biquad_cbuf2_a0;
    S16 biquad_cbuf2_a1;
    S16 biquad_cbuf2_a2; /* 75 */
    S16 biquad_cbuf2_b1;
    S16 biquad_cbuf2_b2;
    S16 a3d_mode;
    S16 a3d_scenario;
} atctst_AUD_set_dsp_parameters_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_dsp_parameters_con;

/* atctst_AUD_get_dsp_parameters_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    S8 dummy;
    atctst_AUD_set_dsp_parameters_req dsp;
} atctst_AUD_get_dsp_parameters_con;

#if defined SGOLD3
typedef struct
{
    U16 SAFE_AFE_RX_ANA1;
    U16 SAFE_AFE_RX_ANA2;
    U16 SAFE_AFE_RX_ANA3;
    U16 SAFE_AFE_RX_EPREF;
    U16 SAFE_AFE_RX_GAIN_DIGITAL;
    U16 SAFE_AFE_EXT_INPUT_CTRL;
    U16 SAFE_AFE_TX_CTRL1;
    U16 SAFE_AFE_TX_CTRL2;
} atctst_AUD_set_afe_parameters_req;
#else
typedef struct
{
    U16 SAFE_VRXCTRL1;
    U16 SAFE_VRXCTRL2;
    U16 SAFE_VTXCTRL;
} atctst_AUD_set_afe_parameters_req;
#endif

typedef aud_opcode_result_rc_type atctst_AUD_set_afe_parameters_con;

typedef struct {
    U8 afe_switch;
    U8 inputgain;
    U8 eppa_gain;
    U8 eppn_gain;
} atctst_AUD_set_afe_req;

typedef aud_opcode_result_rc_type atctst_AUD_set_afe_con;

/* atctst_AUD_get_afe_parameters_req is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    S8 Dummy;
    atctst_AUD_set_afe_parameters_req afe;
} atctst_AUD_get_afe_parameters_con;

typedef struct {
    atctst_AUD_status result;
    S8 rc;
    S8 Dummy;
    atctst_AUD_set_afe_req afe;
} atctst_AUD_get_afe_con;

typedef struct {
    U8 eventlist;
} atctst_AUD_dsp_idle_event_type;

typedef aud_opcode_result_rc_type atctst_AUD_dsp_idle_event_con_type;

typedef struct {
    U8 layer1_info;
} atctst_AUD_misc_layer1_info_type;

typedef aud_opcode_result_rc_type atctst_AUD_misc_layer1_info_con_type;

/*** FIR filters ***/
typedef struct {
    U16 ul_dl_select;
    U16 h[65]; /* filter coefficients */
} atctst_AUD_set_fir_filter_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_fir_filter_con_type;

typedef struct {
    U16 ul_dl_select; /* which filter to read */
} atctst_AUD_get_fir_filter_req_type;

typedef struct {
    atctst_AUD_status result;
    S8  rc;
    U16 ul_dl_select; /* the filter that has been read */
    U16 h[65]; /* filter coefficients */
} atctst_AUD_get_fir_filter_con_type;

/*** Filter switch for (de)activating BiQuad and/or FIR filters and/or downlink noise reduction ***/
typedef struct {
    U16 dl_enable;
    U16 ul_enable;
    U16 cbuf_enable;
} atctst_AUD_set_filter_switch_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_filter_switch_con_type;

/* atctst_AUD_get_filter_switch_req_type is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    atctst_AUD_set_filter_switch_req_type data;
} atctst_AUD_get_filter_switch_con_type;

/*** Acoustic Shock Protection in the uplink path ***/
typedef struct {
    U16 operation;
    S16 attennuation_dbfs;
    U16 attack_time;
    U16 release_time;
    U16 mode;           /* VB_ASP_EP mode */
    U16 ul_speech_gain; /* VB_HF_SET_GAIN mode */
} atctst_AUD_set_asp_ul_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_asp_ul_con_type;

/* atctst_AUD_get_asp_ul_req_type is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    atctst_AUD_set_asp_ul_req_type data;
} atctst_AUD_get_asp_ul_con_type;

/*** Noise Reduction in the downlink path ***/
typedef struct {
    U16 Switch;
    U16 nr_sw_2;
    U16 nr_u_fak_0;
    U16 nr_u_fak;
} atctst_AUD_set_dl_nr_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_set_dl_nr_con_type;

/* atctst_AUD_get_dl_nr_req_type is empty, hence no declaration of this type */
typedef struct {
    atctst_AUD_status result;
    S8 rc;
    atctst_AUD_set_dl_nr_req_type data;
} atctst_AUD_get_dl_nr_con_type;

/*******************************************************************************
*
* Component control - absolute value or bit pattern (see project/HW variant for details)
*
*******************************************************************************/
typedef struct {
    U16 on_off;       /* control on off for blocks */
    U16 input_conf;   /* input configuration */
    U16 output_conf;  /* output configuration */
    U16 mute_setting; /* mute control */
    U16 gain_setting; /* gain setting */
    U16 order;        /* order for the internal blocks to be called - 32bit = |4bit|4bit|... = |1st parm|2nd parm|....
                           e.g. |2|1|4|0|0|... = |0010|0001|0100|0|...=first input conf, then on/off, then mute, rest is N/A ('0') */
    U16 multi_purpose;
} atctst_AUD_comp_ctrl_ext_amp_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_comp_ctrl_ext_amp_con_type;

typedef struct {
    U16 on_off;       /* control on/off for blocks */
    U16 gain_setting; /* gain setting */
    U16 mute_setting; /* mute setting */
    U16 order;        /* order for the internal blocks to be called - 32bit = |4bit|4bit|... = |1st parm|2nd parm|....
                              e.g. |2|1|4|0|0|... = |0010|0001|0100|0|...=first input conf, then on/off, then mute, rest is N/A ('0') */
    U16 multi_purpose;
} atctst_AUD_comp_ctrl_fm_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_comp_ctrl_fm_con_type;

typedef struct {
    U16 order; /* which function to trig on - only one. First on will trig - succeeding "on's" will not do anything */
    U16 multi_purpose;
} atctst_AUD_comp_ctrl_trig_conf_req_type;

typedef aud_opcode_result_rc_type atctst_AUD_comp_ctrl_trig_conf_con_type;

#endif /* _INC_AUD_OPCODESH */

