/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    aud_pmic.h
 * File Mark:    
 * Description:  This file contains the pmic interface  for audio driver.
 * Others:        
 * Version:       V0.1
 * Author:        ZhouZhongyao
 * Date:          2008-12-15
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#ifndef __AUD_PMIC_H__
#define __AUD_PMIC_H__

#ifdef INFX_AUD_PMIC_VERSION

#include "Bastypes.h"
#if 0
#include "drvs_pmic_audio.h"
#endif
//#include "drvs_pmic.h"
#include "aud_drv.h"

/******************************************************************************
*                             Type defines
******************************************************************************/

/****************************************************************************
*                                                  struct
****************************************************************************/
typedef enum {
  idle_status,
  open_status,
  use_status
} aud_resource_use_status;

/* Resources */
typedef enum {
    aud_pmic_resource_speech, /* 0 */
    aud_pmic_resource_tone_generator,
    aud_pmic_internal_midi_player,
    aud_pmic_record_vm,
    aud_pmic_playback_vm,
    aud_pmic_resource_end
} aud_pmic_resource_enum;

/****************************************************************************
* 	                                         External function declaration. Interface.
****************************************************************************/
extern S8 aud_pmic_release_resource(aud_resource_enum resource,BOOL isCheckStatus);
extern S8 aud_pmic_allocate_resource(aud_resource_enum resource,BOOL isCheckStatus);
extern S8 aud_pmic_resource_enable(aud_resource_enum resource,BOOL isCheckStatus);
extern S8 aud_pmic_resource_disable(aud_resource_enum resource,BOOL isCheckStatus);
extern S8 aud_pmic_set_master_volumn(aud_volume_enum volume);
extern S8 aud_pmic_add_unlinkpath(aud_uplink_source_enum path);
extern S8 aud_pmic_remove_unlinkpath(aud_uplink_source_enum path);
extern S8 aud_pmic_add_downlinkpath(aud_uplink_source_enum path);
extern S8 aud_pmic_remove_downlinkpath(aud_uplink_source_enum path);
extern UINT8 getAudioPmicResourceUseStatus(aud_resource_use_status useStatus);
extern PMIC_AUDIO_HANDLE aud_pmic_gethandle(void);
#endif

#endif
