/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_voice.h
 * File Mark:    
* Description:  Provide voice hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V0.5
 * Author:        LvWenhua
 * Date:          2007-11-12
 * History 1:      
 *     Date: 2008-06-30
 *     Version:
 *     Author: dangmaochang
 *     Modification:  add mute/read/write/loopback.
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_VOICE_H
#define _HAL_VOICE_H


/****************************************************************************
*                                             Include files
****************************************************************************/


/****************************************************************************
*                                             Macros
****************************************************************************/


/****************************************************************************
*                                             Types
****************************************************************************/

typedef struct 
{
    T_ZDrvVoice_Sample         sample;    /* voice sample rate selection. */
    T_ZDrv_VoiceInputPath      pathin;    /* Voice input channel selection. */
    T_ZDrv_VoiceOutputPath     pathout;   /* Voice output channel selection. */
    T_ZDrvVoice_InputVolLevel  volin;     /* Voice input channel volum level selection.*/
    T_ZDrvVoice_OutputVolLevel volout;    /* Audio output channel volum level selection.*/
    T_ZDrvVoice_MuteInfo       muteInfo;  /* voice mute control information */
}T_HalVoice_Block;

typedef struct 
{
    SINT32 (*hal_voice_init_codec)(VOID);   /*voice Device init codec Handler*/
    SINT32 (*hal_voice_Open)(VOID);             /*voice Device hal layer open Handler*/
    SINT32 (*hal_voice_Close)(VOID);            /*voice Device hal layer close Handler*/   
    SINT32 (*hal_voice_read)( VOID * pDataBuf, UINT32 count);   /*voice Device read AMR data from DSP Handler*/
    SINT32 (*hal_voice_write)(VOID * pDataBuf, UINT32 count);    /*voice Device write AMR data to DSP Handler*/
    SINT32 (*hal_voice_set_sample)(T_HalVoice_Block* pVoiceBlock);

 /*voice Device set codec sampling rate Handler*/
    SINT32 (*hal_voice_set_path_in)(T_HalVoice_Block* pVoiceBlock);   /*voice Device set codec input path Handler*/
    SINT32 (*hal_voice_set_path_out)(T_HalVoice_Block* pVoiceBlock);   /*voice Device set codec output path Handler*/
    SINT32 (*hal_voice_set_vol_in)(T_HalVoice_Block * pVoiceBlock);  /*voice Device set codec input volume Handler*/
    SINT32 (*hal_voice_set_vol_out)(T_HalVoice_Block* pVoiceBlock); /*voice Device sset codec output volume Handler*/
    SINT32 (*hal_voice_loopback)(T_ZDrvVoice_Switch enable);            /*voice Device enable/disable voice loop function Handler*/
    SINT32 (*hal_voice_set_mute)(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo); /*voice Device enable/disable voice mute function Handler*/
    SINT32 (*hal_voice_enable)(VOID);         /*enable voice channel*/
    SINT32 (*hal_voice_disable)(VOID);        /*disable voice channel*/
    SINT32 (*hal_voice_vt_start)(T_ZDrvVoice_AmrInfoPtr amrInfo);  /*voice Device open the amr for starting the VTHandler*/
    SINT32 (*hal_voice_vt_stop)(VOID);  /*voice Device close the amr for starting the VT Handler*/
    SINT32 (*hal_voice_RecordDataRead)( T_ZDrvVoice_BufInfo * pVoiceDataInfo);  
    SINT32 (*hal_voice_RCDStart )( T_ZDrvRcd_InfoParam* pParam);
    SINT32 (*hal_voice_RCDStop)(VOID);
 //   SINT32 (*halVoice_SetMute)(T_ZDrvVoice_MuteSwitch* pVoiceMuteInfo);
    SINT32 (*halVoice_FreeRcdBuf)(VOID *pBuf);    
        
    SINT32 (*vsersion)(VOID);
    VOID   (*exit)(VOID);
} T_HalVoice_Opt;

/****************************************************************************
*                                             Constants
****************************************************************************/

/****************************************************************************
*                                             Global  Variables
****************************************************************************/

/****************************************************************************
*                                             Function Prototypes
****************************************************************************/
/*******************************************************************************
* Function: halVoice_InitCodec
* Description: This function is used to init codec.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_InitCodec(VOID);

/*******************************************************************************
* Function: halVoice_Open
* Description: This function is used to init hardware.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Open(VOID);

/*******************************************************************************
* Function: halVoice_Close
* Description: This function is used to exit codec
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Close(VOID);

/*******************************************************************************
* Function: halVoice_RCDStart
* Description: This function is used to start record.
* Parameters: 
*   Input:
*      pParam:the info of record.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RCDStart(T_ZDrvRcd_InfoParam *pParam);

/*******************************************************************************
* Function: halVoice_RCDStop
* Description: This function is used to stop record.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RCDStop(VOID);

/*******************************************************************************
* Function: halVoice_SetSample
* Description: This function is used to set sample
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetSample(T_HalVoice_Block* pVoiceBlock);

/*******************************************************************************
* Function: halVoice_SetPathIn
* Description: This function is used to set codec input path.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetPathIn(T_HalVoice_Block* pVoiceBlock);

/*******************************************************************************
* Function: halVoice_SetPathOut
* Description: This function is used to set codec output path.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including output path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetPathOut(T_HalVoice_Block* pVoiceBlock);

/*******************************************************************************
* Function: halVoice_SetVolIn
* Description: This function is used to set codec input volume.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input volume information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetVolIn(T_HalVoice_Block* pVoiceBlock);

/*******************************************************************************
* Function: halVoice_SetVolOut
* Description: This function is used to set codec output volume.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including output volume information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetVolOut(T_HalVoice_Block* pVoiceBlock);

/*******************************************************************************
* Function: halVoice_Read
* Description: This function is used to read AMR data from DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the buffer for read AMR data;
*       count:the size of read data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Read(VOID *pDataBuf, UINT32 count);

/*******************************************************************************
* Function: halVoice_Write
* Description: This function is used to write AMR data to DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the written data;
*       count:the size of written data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Write(VOID *pDataBuf, UINT32 count);

/*******************************************************************************
* Function: halVoice_RecordDataRead
* Description: This function is used to read record data.
* Parameters: 
*   Input:
*      pVoiceDataInfo:the info of voice data.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RecordDataRead(T_ZDrvVoice_BufInfo * pVoiceDataInfo);

/*******************************************************************************
* Function: halVoice_SetMute
* Description: This function is used to enable/disable voice mute function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable mute function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo);

/*******************************************************************************
* Function: halVoice_Loopback
* Description: This function is used to enable/disable voice loopback function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable loop function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Loopback(T_ZDrvVoice_Switch enable);

/*******************************************************************************
* Function: halVoice_Enable
* Description: This function is used to enable the voice channel
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Enable(VOID);

/*******************************************************************************
* Function: halVoice_Disable
* Description: This function is used to disable the voice channel
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Disable(VOID);

/*******************************************************************************
* Function: halVoice_VtStart
* Description: This function is used to open the amr for starting the VT
* Parameters: 
*   Input: 
*           amrInfo: the information of AMR's frame type and frame formate.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_VtStart(T_ZDrvVoice_AmrInfoPtr amrInfo);

/*******************************************************************************
* Function: halVoice_VtSop
* Description: This function is used to close the amr for stopping the VT
* Parameters: 
*   Input: None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_VtStop(VOID);

/*******************************************************************************
* Function: halVoice_FreeRcdBuf
* Description: This function is used to relese the buffer of record.
* Parameters: 
*   Input:
*      pBuf:the buffer of record.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_FreeRcdBuf(VOID *pBuf);
    
/*******************************************************************************
* Function: zDrvVoice_SetOperations
* Description: This function is used to set the audio instance of hal layer.
* Parameters: 
*   Input:VoiceObjPtr:The pointer to audio function block of hal layer
*   Output:None
*
* Returns: none
*
* Others: 
********************************************************************************/
VOID zDrvVoice_SetOperations(T_HalVoice_Opt* VoiceObjPtr);


#endif/*_HAL_VOICE_H*/

