/*******************************************************************************
 * Copyright (C) 2016, ZTE Corporation.
 *
 * File Name:    hal_volte.h
 * File Mark:    
* Description:  Provide volte hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V1.0
 * Author:        xuxinqiang
 * Date:          2016-02-16
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_VOLTE_H
#define _HAL_VOLTE_H


/****************************************************************************
*                                             Include files
****************************************************************************/

#include "hal_voice.h"
#include "drvs_volte.h"
/****************************************************************************
*                                             Macros
****************************************************************************/


/****************************************************************************
*                                             Types
****************************************************************************/



typedef struct 
{
    SINT32 (*hal_volte_open)(VOID);             /*volte Device hal layer open Handler*/
    SINT32 (*hal_volte_close)(VOID);            /*volte Device hal layer close Handler*/   
    SINT32 (*hal_volte_read)( VOID * pDataBuf, UINT32 count);   /*volte Device read PCM data from VOLTE protocol stack*/
    SINT32 (*hal_volte_write)(VOID * pDataBuf, UINT32 count);    /*volte Device write PCM data to VOLTE protocol stack*/
    SINT32 (*hal_volte_set_sample)(T_HalVoice_Block* pVoiceBlock);

 /*voice Device set codec sampling rate Handler*/
    SINT32 (*hal_volte_loopback)(T_ZDrvVoice_Switch enable);            /*volte Device enable/disable volte loop function Handler*/
    SINT32 (*hal_volte_set_mute)(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo); /*volte Device enable/disable volte mute function Handler*/
 
    SINT32 (*hal_volte_cfgParam)(T_ZDrvVp_Cfg* pCfgParam);        /*config volte parameter*/  
    SINT32 (*hal_volte_readStart)(VOID); 
    SINT32 (*hal_volte_readStop)(VOID); 	
    SINT32 (*hal_volte_writeStart)(VOID); 	
    SINT32 (*hal_volte_writeStop)(VOID); 		
} T_HalVolte_Opt;

/****************************************************************************
*                                             Constants
****************************************************************************/

/****************************************************************************
*                                             Global  Variables
****************************************************************************/

/****************************************************************************
*                                             Function Prototypes
****************************************************************************/

/*******************************************************************************
* Function: halVolte_Open
* Description: This function is used to init hardware.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_Open(VOID);

/*******************************************************************************
* Function: halVolte_Close
* Description: This function is used to exit codec
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_Close(VOID);



/*******************************************************************************
* Function: halVolte_SetSample
* Description: This function is used to set sample
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_SetSample(T_HalVoice_Block* pVoiceBlock);





/*******************************************************************************
* Function: halVolte_Read
* Description: This function is used to read AMR data from DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the buffer for read AMR data;
*       count:the size of read data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_Read(VOID *pDataBuf, UINT32 count);

/*******************************************************************************
* Function: halVolte_Write
* Description: This function is used to write AMR data to DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the written data;
*       count:the size of written data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_Write(VOID *pDataBuf, UINT32 count);


/*******************************************************************************
* Function: halVolte_SetMute
* Description: This function is used to enable/disable volte mute function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable mute function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo);

/*******************************************************************************
* Function: halVoice_Loopback
* Description: This function is used to enable/disable voice loopback function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable loop function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_Loopback(T_ZDrvVoice_Switch enable);

/*******************************************************************************
* Function: halVolte_CfgParam
* Description: This function is used to config the Volte Parameter
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_CfgParam(T_ZDrvVp_Cfg* pCfgParam);


/*******************************************************************************
* Function: halVolte_ReadStart
* Description: This function is used to read start
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_ReadStart(VOID);

/*******************************************************************************
* Function: halVolte_ReadStop
* Description: This function is used to read stop
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_ReadStop(VOID);

/*******************************************************************************
* Function: halVolte_WriteStart
* Description: This function is used to Write start
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_WriteStart(VOID);

/*******************************************************************************
* Function: halVolte_WriteStop
* Description: This function is used to Write stop
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVolte_WriteStop(VOID);


    
/*******************************************************************************
* Function: zDrvVoice_SetOperations
* Description: This function is used to set the audio instance of hal layer.
* Parameters: 
*   Input:VoiceObjPtr:The pointer to audio function block of hal layer
*   Output:None
*
* Returns: none
*
* Others: 
********************************************************************************/
VOID zDrvVolte_SetOperations(T_HalVolte_Opt* VoiceObjPtr);


#endif/*_HAL_VOICE_H*/

