/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	midi_api.h
* File Mark:  	
* Description:  Provide midi module function prototype declaration and type declaration.
* Others:  	
* Version:  	v0.5
* Author:  	wangshiyong
* Date:  	      2009-06-4
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
**********************************************************************/

#ifndef _MIDI_API_H
#define _MIDI_API_H



/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/



/**************************************************************************
 *                                  Macro                                                                                      *
 **************************************************************************/
#define ZDRV_DEV_MIDI  "midi"  /*The device name of midi driver.*/

/**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/

/*Information from driver to upper application.*/
typedef enum {
    MIDI_INFO_FILE_INVALID     = 0,
    MIDI_INFO_PLAY_END               ,
    MIDI_INFO_PLAY_ERR               ,


    MAX_MIDI_INFO
} T_ZDrvMidi_Info;



typedef enum{
    MIDI_OUTPUT_VOL_LEVEL_0 = 0,
    MIDI_OUTPUT_VOL_LEVEL_1,
    MIDI_OUTPUT_VOL_LEVEL_2,
    MIDI_OUTPUT_VOL_LEVEL_3,
    MIDI_OUTPUT_VOL_LEVEL_4,
    MIDI_OUTPUT_VOL_LEVEL_5,
    MIDI_OUTPUT_VOL_LEVEL_6,
    MIDI_OUTPUT_VOL_LEVEL_7,
    MIDI_OUTPUT_VOL_LEVEL_8,
    MIDI_OUTPUT_VOL_LEVEL_9,
    MIDI_OUTPUT_VOL_LEVEL_10,
    MIDI_OUTPUT_VOL_LEVEL_11,

    MAX_MIDI_OUTPUT_VOL_LEVEL     
} T_ZDrvMidi_OutputVolLevel;

typedef void (*T_ZDrvMidi_CallbackFunc) (T_ZDrvMidi_Info);

typedef enum {
    MIDI_aud_format_smaf,            /* MA2/MA3 NB: SMAF is not just SMAF. With the MA3 came extentions 
                                   to the SMAF, which cannot be played on a MA2 */
    MIDI_aud_format_midi,            /* MA2/MA3 NB: Be aware that MIDI is many different formats, 
                                   only following formats are supported: SP-MIDI, SMF format 0 and 1 */
    MIDI_aud_format_smaf_phrase_l1,  /* MA3/MA2 */
    MIDI_aud_format_rmd,             /* MA3 */
    MIDI_aud_format_imelody,         /* MA2/MA3 */
    MIDI_aud_format_buzzer,          /* Buzzer */
    MIDI_aud_format_wav,             /* wav */
    MIDI_aud_format_mp3,             /* mp3 */
    MIDI_aud_format_smafaudio,       /* pcm data in smaf header container*/
    MIDI_aud_format_end
} T_ZDrvMidi_AudFormatEnum;


typedef struct
{
    VOID   *pData_buf;
    UINT32 datasize;    /*the play data size.*/
    UINT32 totalTime;  /*Total play time(Millisecond).*/
    T_ZDrvMidi_AudFormatEnum format;
} T_ZDrvMidi_PlayInfo;



typedef struct
{
    VOID   *pData_buf;
    UINT32 datasize;    /*the play data size.*/
    UINT16 repeat_times;
    T_ZDrvMidi_CallbackFunc callback; /*Callback function which will be called when playing is finished or error.*/
    T_ZDrvMidi_AudFormatEnum format;
} T_ZDrvMidi_PlayParam;


typedef enum 
{
    IOCTL_MIDI_PLAY_START           = 0,       /*Start play param :T_ZDrvMidi_PlayParam*/
    IOCTL_MIDI_PLAY_STOP,                      /*Stop play.param:VOID */
    IOCTL_MIDI_PLAY_PAUSE,                     /*Pause play.param:VOID */
    IOCTL_MIDI_PLAY_RESUME,                    /*Resume play.param:VOID */
    IOCTL_MIDI_SET_OUTPUT_PATH,                /*Set play path param:T_ZDrv_CodecOutputPath*/
    IOCTL_MIDI_SET_OUTPUT_VOL,                 /*Set play volume param:T_ZDrvMidi_OutputVolLevel*/
    IOCTL_MIDI_SEEK,                                 /*Play seek param:UINT32* */
    IOCTL_MIDI_SET_MUTE,                       /*Set audio mute or not .param:BOOL*/
    IOCTL_MIDI_GET_PLAY_TOTALTIME,                  /*Get play info,  total play time param:T_ZDrvMidi_PlayInfo*/
    IOCTL_MIDI_GET_PLAY_POSITON,                  /*Get play position,  param:UINT32*.*/
    MAX_IOCTL_MIDI
}T_ZDrvMidi_IoCtl;


/**************************************************************************
 *                           Global  Variable                                                                              *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/


/**************************************************************************
* Function: zDrv_Open
* Description: This function is used to open device according to device name.
* Parameters: 
*   Input:
            pathname:device name, ZDRV_DEV_MIDI in audio 
*	     flags: no use
*   Output: None
* Returns:   
*       device file descriptor if successed. [1, ZDRV_MAX_DEV_FILE_NUM), please refer to dal_api.h
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
*       DRV_ERR_FD_OVERFLOW: no free fd entry
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       DRV_ERR_OPEN_TIMES: has been opened already. 
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Open (const CHAR *pathname, SINT32 flags)*/


/**************************************************************************
* Function: zDrv_Close
* Description: This function is used to close a device according to device file descriptor.
* Parameters: 
*   Input:
*              fd :device file descriptor 
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support close operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Close(UINT32 fd)*/

/**************************************************************************
* Function: zDrv_Ioctl
* Description:  This function is used to control device according to fd(device file descriptor).
* Parameters: 
*   Input:
*           fd:device file descriptor
*           cmd:command code
*           arg:command parameters
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_IOCTL_CMD: this command has not been supported yet.
*       others: for detailed information, please refer to the header file of hal layer
* Others: 	None

**************************************************************************/
/*SINT32 zDrv_Ioctl(UINT32 fd, UINT32 cmd, VOID* arg)*/

/**************************************************************************
* Function: zDrvMidi_Init
* Description: This function is used to install midi driver.
* Parameters:
*   Input:None
*   Output:None
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_OVERFLOW: no free device driver entry in table
*       DRV_ERR_MEM_ALLOC: failed to alloc memory
* Others: None
**************************************************************************/
SINT32 zDrvMidi_Init(VOID);

/**************************************************************************
* Function: zDrvMidi_Exit
* Description: This function is used to uninstall midi driver.
* Parameters:
*   Input:None
*   Output:None
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_TABLE: device driver table has been invalid.
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
* Others: None
**************************************************************************/
SINT32 zDrvMidi_Exit(VOID);


#endif  /* _MIDI_API_H */

