/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Interface header file to the audio dispatcher. The file is also used as a
 *   common interface file between the aud_xxx.c files.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_com.h
 *   Version: \main\291
 *   Date: 2007-10-01 15:58:32
 *   Comment:
 *     Added Steon2 changes under project define.
 */

//#define AUD_MODULE_TEST_IFWD

#if !defined (_AUD_COMMON)
#define _AUD_COMMON

/*******************************************************************************
*
*                                Include files
*
*******************************************************************************/
#if 0
/* in order to include aud_com.h, the following files must be included first  */
#include "scttypes.h" /* necessary to process ms.h                            */
#include "ms.h"       /* contains the type 'word'                             */
#include "dsp.h"      /* DSP-related types such as T_DSP_CMD_VM_SET_COEFF_PAR */
#include "aud_drv.h"  /* defines, types and enums related to audio            */
#endif
//#include "dsp.h"      /* DSP-related types such as T_DSP_CMD_VM_SET_COEFF_PAR */
#include "drvs_teak.h"

typedef unsigned char llt_groups_enum;
typedef unsigned char llt_types_aud_enum;

/*******************************************************************************
*
*                                   Defines
*
*******************************************************************************/
/* Defines/includes for PC/target builds */
#if defined (_WIN32)
#define SDL_Pid U8
#define SDL_boolean BOOL
#endif /* _WIN32 */

/* Defines for mail correspondence */
#define AUD_STOPPED_BY_APP      0
#define AUD_STOPPED_BY_DRV      1
/* Defines for players */
#define AUD_NOF_SUSPEND_SLOTS   5
#define AUD_MAX_NOF_CHANNELS    4
#define AUD_NOF_SUSPENDNEST     5

/* Defines for build-mode dependant exception and trap handling.
    When in release mode, exceptions and traps will not be reported */
#if defined(AUD_MODULE_TEST_IFWD)
    #define AUD_ERR_REPORT_LVL_MODIFIER (2)
#else
    #define AUD_ERR_REPORT_LVL_MODIFIER (0)
#endif /* AUD_MODULE_TEST_IFWD */

#define AUD_ERR_REPORT_LVL (MS_ERROR_SEVERITY + AUD_ERR_REPORT_LVL_MODIFIER) /* the compile-time error level */
#define AUD_ERR_REPORT_LVL_LOWEST (0)

#ifdef __GNUC__ 
#define __MODULE__  __FILE__
#endif

/*[Begin]resolve the problem of no sound when using speech/midi/tone.  [lvwenhua-2012/4/11]*/
#if 0
#if !defined (__BORLANDC__) && !defined (_MSC_VER) /* used because the use of "..." in macros is not ANSI-C */
    #if (AUD_ERR_REPORT_LVL > AUD_ERR_REPORT_LVL_LOWEST)
        #define AUD_ERROR_REPORTING(SEVERITY, TRAP_ID, _FORMAT, ...) \
            aud_trap_printf(__MODULE__,__LINE__, SEVERITY, TRAP_ID, _FORMAT, ##__VA_ARGS__);
    #else /* don't report errors if AUD_ERR_REPORT_LVL is too small (i.e. SW is in release mode) */
        #define AUD_ERROR_REPORTING(SEVERITY, TRAP_ID, _FORMAT, ...) ;
    #endif /* AUD_ERR_REPORT_LVL > 0 */
#endif /* __BORLANDC__ */
#endif
#define AUD_ERROR_REPORTING(SEVERITY, TRAP_ID, _FORMAT, ...) ;
/*[End] [lvwenhua-2012/4/11]*/

#define AUD_ERROR_SEV_TRIGGER_TRAP (aud_error_grade1)      /* the severity that is considered a trap */
#define AUD_ERROR_REP_TRIGGER_TRAP (2)                     /* the error level needed for an error to cause a trap */
#define AUD_ERROR_SEV_TRIGGER_EXCEPTION (aud_error_grade2) /* the severity that is considered an exception */
#define AUD_ERROR_REP_TRIGGER_EXCEPTION (2)                /* the error level needed for an error to cause an exception */

/*******************************************************************************
*
*                                   Events
*
*******************************************************************************/
typedef enum {
    E_speech_enable, /* 0 */
    E_speech_disable,
    E_set_volume,
    E_speech_mute,
    E_amp_enable,
    E_amp_disable,
    E_tone_start,
    E_tone_start_user_tone,
    E_tone_stop,
    E_key_tone,
    E_ringer_start, /* 10 */
    E_ringer_start_user_tone,
    E_ringer_set_volume,
    E_ringer_set_channel_volume,
    E_ringer_stop,
    E_ringer_suspend,
    E_ringer_resume,
    E_ringer_stop_suspend,
    E_ringer_mute_amplifier,
    E_ringer_unmute_amplifier,
    E_vms_start_voice_recording, /* 20 */
    E_vms_stop_voice_recording,
    E_vms_start_playback,
    E_vms_stop_playback,
    E_misc_mode, 
    E_misc_restart_hf,
    E_timer_tone_ctrl_timeout,
    E_timer_ptc_timeout,
    E_timer_vms_timeout,
    E_generic_dsp_cmd,
    E_misc_pdch_mode, /* 30 */
    E_midi_start,
    E_midi_start_user_melody,
    E_midi_stop,
    E_midi_set_volume,
    E_midi_suspend,
    E_midi_resume,
    E_midi_stop_suspend,
    E_genric_dsp_cmd,
    E_pcm_ch_configure,
    E_pcm_ch_routing, /* 40 */
    E_pcm_enable,
    E_pcm_disable,
    E_bluetooth_configure, /* do not use - obsolete (use "E_I2S1_configure") */
    E_tty_enable,
    E_tty_disable,
    E_set_uplinkpath,
    E_set_downlinkpath,
    E_clear_uplinkpath,
    E_clear_downlinkpath,
    E_mp3_start, /* 50 */
    E_mp3_fastforward,
    E_mp3_backward,
    E_mp3_pause,
    E_mp3_stop,
    E_mp3_resume,
    E_mp3_handle_callback,
    E_mp3_set_getbuffer_function,
    E_mp3_get_current_frame,
    E_mp3_get_total_playtime,
    E_mp3_get_play_position, /* 60 */
    E_mp3_stop_suspend,
    E_mp3_set_play_position,
    E_mp3_repeat_req,
    E_vms_set_getbuffer_function,
    E_vms_get_total_playtime,
    E_vms_suspend,
    E_vms_resume,
    E_vms_set_play_position,
    E_vms_get_play_position,
    E_speech_set_volume, /* 70 */
    E_vib_start,
    E_vib_stop,
    E_disable_afe,
    E_vibrator_enable,
    E_vibrator_pause,
    E_vibrator_disable,
    E_ringer_get_total_playtime,
    E_ringer_get_position,
    E_ringer_set_position,
    E_vms_set_cb_func, /* 80 */
    E_ringer_finish,
    E_idle_command,
    E_set_vb_on_function,
    E_radio_initialize,
    E_radio_config,
    E_radio_start,
    E_radio_stop,
    E_radio_set_station,
    E_radio_read_current_status,
    E_radio_timer, /* 90 */
    E_radio_mute,
    E_pcm_start_recording,
    E_pcm_stop_recording,
    E_pcm_start_playback,
    E_pcm_stop_playback,
    E_pcm_suspend,
    E_pcm_resume,
    E_pcm_get_total_playtime,
    E_pcm_get_play_position,
    E_pcm_set_play_position, /* 100 */
    E_pcm_data_ready,
    E_pcm_interrupt,
    E_pcm_rec_interrupt,
    E_pcm_set_cb_func,
    E_set_resource_volume,  /* set resource volume - Master volume concept */
    E_set_master_volume,    /* set master volume - Master volume concept */
    E_mute_resource,        /* mute individual resource - Master volume concept */
    E_mute_master,          /* mute master - Master volume concept */
    E_ext_ringer_init_timeout,
    E_midi_get_total_playtime, /* 110 */
    E_midi_get_play_position,
    E_midi_set_play_position,
    E_vms_handle_interrupt,
    E_mp3_interrupt_handle,
    E_tone_suspend,
    E_tone_resume,
    E_tone_get_total_playtime,
    E_tone_get_play_position,
    E_tone_set_play_position,
    E_aud_mapi_allocate, /* 120 */
    E_aud_mapi_terminate,
    E_aud_mapi_msg,
    E_tone_ended,
    E_clear_all_downlinkpaths,
    E_clear_all_uplinkpaths,
    E_pcm_ffs_repeat_req,
    E_pcm_ram_repeat_req,
    E_vms_repeatevent, 
    E_control_EC_NR,
    E_tone_force_stop, /* 130 */
    E_hal_startup_timer,
    E_hal_timeout_timer,
    E_hal_req_ma3_poweroff,
    E_pcm_stop_suspend,  
    E_inband_start, /* used for non-baseband (i.e. inband) resource */
    E_inband_stop,  /* used for non-baseband (i.e. inband) resource */
    E_timer_vms_rec_timeout,
    E_timer_vms_playback_timeout,
    E_idle_command_resume_delay,     /* Not used anymore 25/01/2007 */
    E_bb_off_command, /* 140 */
    E_bb_off_tch_26_command,
    E_vms_pb_set_getbuffer_function,
    E_vms_rec_set_putbuffer_function,
    E_3D_mode_enable,
    E_3D_mode_disable,
    E_inband_play_start, /* not used */
    E_inband_play_stop, /* not used */
    E_radio_rssi_subscribe,
    E_radio_rssi_unsubscribe,
    E_radio_rds_subscribe, /* 150 */
    E_radio_rds_unsubscribe,
    E_radio_unmute,
    E_radio_set_volume,
    E_resource_allocate,
    E_resource_release,
    E_get_resource_capability,
    E_get_downlnk_parallel_path_configuration,
    E_get_uplink_parallel_path_configuration,
    E_info_hw_available,
    E_configure_bluetooth, /* 160 -  do not use - obsolete (use "E_I2S1_configure") */ 
    E_radio_end_seektune,
    E_vms_stop_suspend,
    E_volume_ramping,
    E_pcm_play_set_cb_func,
    E_pcm_rec_set_cb_func,
    E_radio_interrupt,
    E_radio_get_frequency,
    E_update_downlinkpath,
    E_update_uplinkpath,
    E_ext_amp_timeout_timer, /* 170 - used for external amp on VenusU */
    E_media_to_uplink,
    E_media_to_downlink,
    E_Pathupdate_Enable,
    E_Pathupdate_Disable,
    E_smpower_enable,
    E_smpower_disable,
    E_I2S1_enable,
    E_I2S1_disable,
    E_I2S1_configure,
    E_pcm_write_to_ffs, /* 180 */
    E_vm_write_to_ffs,
    E_sbc_start_encoder,
    E_sbc_stop_encoder,
    E_sbc_suspend_encoder,
    E_sbc_resume_encoder,
    E_sbc_set_getinputbuffer_function,
    E_sbc_set_getoutputbuffer_function,
    E_sbc_start_encoding_process,
    E_speech_release_disable,
    E_tone_release_stop, /* 190 */
    E_ringer_release_stop,
    E_vibrator_release_disable,
    E_amp_release_disable,
    E_radio_release_stop,
    E_vms_release_stop_voice_recording,
    E_vms_release_stop_playback,
    E_mp3_release_stop,
    E_pcm_release_disable,
    E_midi_release_stop,
    E_tty_release_disable, /* 200 */
    E_pcm_release_stop_playback,
    E_pcm_release_stop_recording,
    E_aud_mapi_release_terminate,
    E_inband_release_stop,
    E_smpower_release_disable,
    E_sbc_release_stop_encoder,
    E_interface_request_error,
    E_FFT_Start_Measure,
    E_FFT_GetResult,
    E_I2S_enable, /* 210 */
    E_I2S_disable,
    E_I2S_release_disable,
    E_I2S_setup_clk,
    E_I2S_setup_resource,
    E_pcm_playtime_data_ready,
    E_tty_set_negotiation,
    E_midi_data_copy,
    E_pcm_ram_data_ready,
    E_vms_pb_ram_data_ready,
    E_aud_eep_write_eq_vol_threshold, /* 220 */
    E_I2S_handle_slave_interrupt,
    E_AFEI2S_enable,
    E_AFEI2S_disable,
    E_AFEI2S_configure,
    /* !!! Please inform the MobileAnalyzer decoding maintainer (HHE) when adding new opcodes */
    /* When the number of events exceed 255,
            please make sure that functions which use the enum have more than one byte to store the enum value */
    E_event_end
} aud_event_enum;

/*******************************************************************************
*
*                              Type definitions
*
*******************************************************************************/
typedef enum {
    S_idle,
    S_active
} aud_SM_state_enum;

typedef struct {
    ptr_SetVbOnStatusFunction vb_on_status_function;
    U8  vb_on;
} aud_vb_on_status_type;

typedef struct {
    U8  status;
    U16 caller_id;
    U8  test_handle;
} aud_resource_table_type; /* contains handles and allocation status */

typedef struct {
    SDL_Pid sender;
    U16  caller_id;
    U32  parm1;
    U32  parm2;
    U32  parm3;
    U32  parm4;
    U32  parm5;
    U32  parm6;
    U32  parm7;
    U32  parm8;
    U8  *ptr1;
    U8  *ptr2;
} disp_to_SM_data_type; /* Used to pass parameters from dispatcher to state machines */

typedef struct {
    void DWD_HUGE   *ptrdata;
    U32          size;
    aud_format_enum format;
} aud_testrambuffer_type; /* Used as common RAM buffer for all players to download files to this */

/* Below enums used for Common trace functions */
typedef enum {
    aud_log_lis_display,
    aud_log_lis_raw_data, /* no "header" is forced onto data */
    aud_log_lis_trace_end
} aud_log_lis_trace_option_enum;

typedef enum {
    aud_log_lis_display_nodata,
    aud_log_lis_display_data,
    aud_log_lis_display_end
} aud_log_lis_display_option_enum;

typedef enum {
    aud_log_lis_trace,
    aud_log_llt_trace,
    aud_log_lis_llt_trace,
    aud_log_trace_end
} aud_log_trace_option_enum;

typedef enum {
    E_audio_llt_type_id_0,
    E_audio_llt_type_id_1,
    E_audio_llt_type_id_2,
    E_audio_llt_type_id_3,
    E_audio_llt_type_id_4,
    E_audio_llt_type_id_5,
    E_audio_llt_type_id_6,
    E_audio_llt_type_id_7,
    E_audio_llt_type_id_8,
    E_audio_llt_type_id_9,
    E_audio_llt_type_id_10,
    E_audio_llt_type_id_11,
    E_audio_llt_type_id_12,
    E_audio_llt_type_id_13,
    E_audio_llt_type_id_14,
    E_audio_llt_type_id_15
} aud_llt_type_ID_enum;

typedef struct {   
    U32 DataSize;
    union
    {   
        U8 fm_radio_shadowRegAddr[14];
        T_DSP_CMD_VB_SET_GAIN_PAR aud_dsp_gain_parms;
    } llt_struct;

    U32 LLT_Type_ID;
} aud_llt_struct_type;

typedef enum {
    aud_error_grade1, /* Very critical errors which can cause non-repairable HW/flash errors */
    aud_error_grade2, /* Potentially system critical errors causing noticeable performance degradation */
    aud_error_grade_end
} aud_error_grade_enum;

typedef enum {
    aud_hw_src_no_usage,
    aud_hw_src_MIDI,
    aud_hw_src_I2S2_rx3,
    aud_hw_src_PCM,
    aud_hw_src_end
} aud_HW_SRC_choice;

#if defined (AUD_HW_COMPONENT_EVALUATION)
typedef enum {
    aud_comp_ctrl_ext_amp_off, /* 0 */
    aud_comp_ctrl_ext_amp_on,
    aud_comp_ctrl_fm_off,
    aud_comp_ctrl_fm_on
} aud_comp_ctrl_power_enum;

typedef enum {
    aud_comp_ctrl_trig_on, /* 0 */
    aud_comp_ctrl_trig_off,
    aud_comp_ctrl_trig_end
} aud_comp_ctrl_trig_enum;

typedef enum {
    aud_comp_ctrl_ext_amp_in_off, /* 0 */
    aud_comp_ctrl_ext_amp_in_1,
    aud_comp_ctrl_ext_amp_in_2,
    aud_comp_ctrl_ext_amp_in_3
} aud_comp_ctrl_input_enum;

typedef enum {
    aud_comp_ctrl_muted, /* 0 */
    aud_comp_ctrl_unmuted
} aud_comp_ctrl_mute_enum;

/* FM radio - mapping into HW functions */
typedef enum {
/*    aud_comp_ctrl_map_fm_off,
    aud_comp_ctrl_map_fm_on,*/
    aud_comp_ctrl_map_fm_gain,
    aud_comp_ctrl_map_fm_mute,
    aud_comp_ctrl_map_fm_unmute
} aud_comp_ctrl_fm_map_enum;

#endif /* AUD_HW_COMPONENT_EVALUATION */

/*[Begin]add for change SDL to normal task [lvwenhua-2012/9/26]*/
typedef struct {
    U32  parm1;
    U32  parm2;
    U32  parm3;
    U32  parm4;
    U32  parm5;
    U32  parm6;
    U32  parm7;
    U32  parm8;
    U8 *  ptr1;
    U8 *  ptr2;
} T_AUD_DRV_REQ_PARAM;
/*[End] [lvwenhua-2012/9/26]*/
/*******************************************************************************
*
*                       External variable declarations
*
*******************************************************************************/
extern SDL_Pid                       aud_pid;           /* process ID for the audio process */
extern aud_vb_on_status_type         aud_vb_on_status;  /* contains paths that are active in the driver and VB_ON status */
extern aud_resource_table_type       aud_resource_table[aud_resource_end]; /* resource handles and allocation - used by interface */
extern T_DSP_CMD_A3D_PAR             aud_dsp_a3d_parms;
extern T_DSP_CMD_VM_SET_COEFF_PAR    aud_dsp_vm_parms;  /* ought to be moved to aud_volume.c but is also used from vm and pcm recorders */

//extern aud_testrambuffer_type        gAudTestRamBuffer;
//extern aud_testrambuffer_status_enum gAudTestRamBuffer_Status;

extern aud_HW_SRC_choice aud_HW_SRC_allocation;         /* allocation of HW sample rate converter */

/*******************************************************************************
*
*                       External function declarations
*
*******************************************************************************/
U8   aud_SM_active(const aud_resource_enum resource);
BOOL aud_one_SM_active(void);
BOOL aud_one_baseband_SM_active(void);
/*[Begin] [lvwenhua-2010/7/28]*/
BOOL aud_one_cbuf_SM_active(void);
/*[End] [lvwenhua-2010/7/28]*/
BOOL aud_smpower_SM(aud_event_enum event, void *p_data);
BOOL aud_non_baseband_resource_SM(aud_event_enum event, void *p_data);
void aud_init_SM(void);              /* initialise all state machines to idle. */
void aud_init_audio_irq(void);       /* initialise interrupts */
void aud_init_resource_table(void);  /* initialise resource table */
void aud_init_set_paths(void);       /* initialise active paths */
void aud_sleep_timer_init(void);     /* initialise sleep timer */
void aud_sleep_request(U32 time_ms);
void aud_send_response_signal(
    SDL_Pid sender,
    aud_resource_enum resource,
    S8   rc,
    U32  parm1, 
    U32  parm2,
    U32  parm3,
    U32  parm4,
    U8  *ptr1,
    U8  *ptr2);
void aud_send_mail(
    U8   event,
    U16  caller_id,
    U32  parm1,
    U32  parm2,
    U32  parm3, 
    U32  parm4,
    U32  parm5,
    U32  parm6,
    U32  parm7, 
    U32  parm8,
    U8  *ptr1,
    U8  *ptr2);
void aud_basic_tst(void); 
void aud_add_dsp_cmd_to_buffer(U8 cmd);
void aud_common_trace( 
    llt_groups_enum     llt_group_aud,                      /* LLT params */
    llt_types_aud_enum  llt_aud_type,                       /* LLT params */
    U8  NumOfParms,                                         /* LLT params */
    U16 struct_size,                                        /* LLT params */
    U8  lis_parm1,                                          /* LIS params */
    U8  lis_parm2,                                          /* LIS params */
    aud_log_lis_trace_option_enum   log_lis_option,         /* LIS params */
    aud_log_lis_display_option_enum log_lis_display_data,   /* LIS params */
    aud_log_trace_option_enum       log_option,             /* Defines the type of trace(LIS/LLT) */
    ... );                                                  /* Parameters */

/* For storing result of FFT analysis performed in DSP */
void aud_store_FFT_result(U16 fft_result);
/* aud_trap_printf is used to store exceptions and traps (dependant on AUD_MODULE_TEST_IFWD and MS_ERROR_SEVERITY) in exception store
    This function should not be called directly - use AUD_ERROR_REPORTING instead
    Usage example:
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Unhandled event: %d", event) */
void aud_trap_printf(
    const char* fileName,
    U16         line,
    U8          severity,
    U16         TrapID,
    const char* format,
    ...);

/* Power saving */
void aud_init_power_save(void);
U8   aud_ready_for_power_down(void);
void aud_enable_standby(aud_resource_enum resource);
void aud_disable_standby(aud_resource_enum resource);

/* Get and set the state of a resource's state machine */
aud_SM_state_enum aud_get_SM_state(aud_resource_enum resource);
void              aud_set_SM_state(aud_resource_enum resource, aud_SM_state_enum state);

/* Check whether the RAM data pointer is in NAND paging memory or not */
void aud_check_pageaddr_copy(U8 *src_addr, U32 buf_size, BOOL *ram_buffer_flag);

/* Get and set the allocation of the hardware sample rate converters */
aud_HW_SRC_choice aud_get_hw_src_allocation(void);
void              aud_set_hw_src_allocation(aud_HW_SRC_choice var);
#endif /* _AUD_COMMON */

